/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.model.EntityModel;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.SwingEntityModel;
import is.codion.swing.framework.model.SwingEntityTableModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SwingEntityModelBuilder
implements SwingEntityModel.Builder {
    private static final Logger LOG = LoggerFactory.getLogger(SwingEntityModelBuilder.class);
    private final EntityType entityType;
    private final List<SwingEntityModel.Builder> detailModelBuilders = new ArrayList<SwingEntityModel.Builder>();
    private Class<? extends SwingEntityModel> modelClass;
    private Class<? extends SwingEntityEditModel> editModelClass;
    private Class<? extends SwingEntityTableModel> tableModelClass;
    private Function<EntityConnectionProvider, SwingEntityModel> modelFactory;
    private Function<EntityConnectionProvider, SwingEntityEditModel> editModelFactory;
    private Function<EntityConnectionProvider, SwingEntityTableModel> tableModelFactory;
    private Consumer<SwingEntityModel> onBuildModel = new EmptyOnBuild<SwingEntityModel>();
    private Consumer<SwingEntityEditModel> onBuildEditModel = new EmptyOnBuild<SwingEntityEditModel>();
    private Consumer<SwingEntityTableModel> onBuildTableModel = new EmptyOnBuild<SwingEntityTableModel>();

    SwingEntityModelBuilder(EntityType entityType) {
        this.entityType = Objects.requireNonNull(entityType);
    }

    @Override
    public EntityType entityType() {
        return this.entityType;
    }

    @Override
    public SwingEntityModel.Builder model(Class<? extends SwingEntityModel> modelClass) {
        if (this.editModelClass != null || this.tableModelClass != null) {
            throw new IllegalStateException("Edit or table model class has been set");
        }
        this.modelClass = Objects.requireNonNull(modelClass);
        return this;
    }

    @Override
    public SwingEntityModel.Builder editModel(Class<? extends SwingEntityEditModel> editModelClass) {
        if (this.modelClass != null) {
            throw new IllegalStateException("Model class has been set");
        }
        if (this.tableModelClass != null) {
            throw new IllegalStateException("TableModel class has been set");
        }
        this.editModelClass = Objects.requireNonNull(editModelClass);
        return this;
    }

    @Override
    public SwingEntityModel.Builder tableModel(Class<? extends SwingEntityTableModel> tableModelClass) {
        if (this.modelClass != null) {
            throw new IllegalStateException("Model class has been set");
        }
        if (this.editModelClass != null) {
            throw new IllegalStateException("EditModel class has been set");
        }
        this.tableModelClass = Objects.requireNonNull(tableModelClass);
        return this;
    }

    @Override
    public SwingEntityModel.Builder model(Function<EntityConnectionProvider, SwingEntityModel> modelFactory) {
        this.modelFactory = Objects.requireNonNull(modelFactory);
        return this;
    }

    @Override
    public SwingEntityModel.Builder editModel(Function<EntityConnectionProvider, SwingEntityEditModel> editModelFactory) {
        this.editModelFactory = Objects.requireNonNull(editModelFactory);
        return this;
    }

    @Override
    public SwingEntityModel.Builder tableModel(Function<EntityConnectionProvider, SwingEntityTableModel> tableModelFactory) {
        this.tableModelFactory = Objects.requireNonNull(tableModelFactory);
        return this;
    }

    @Override
    public SwingEntityModel.Builder onBuildModel(Consumer<SwingEntityModel> onBuildModel) {
        this.onBuildModel = Objects.requireNonNull(onBuildModel);
        return this;
    }

    @Override
    public SwingEntityModel.Builder onBuildEditModel(Consumer<SwingEntityEditModel> onBuildEditModel) {
        this.onBuildEditModel = Objects.requireNonNull(onBuildEditModel);
        return this;
    }

    @Override
    public SwingEntityModel.Builder onBuildTableModel(Consumer<SwingEntityTableModel> onBuildTableModel) {
        this.onBuildTableModel = Objects.requireNonNull(onBuildTableModel);
        return this;
    }

    @Override
    public SwingEntityModel.Builder detailModel(SwingEntityModel.Builder detailModelBuilder) {
        if (!this.detailModelBuilders.contains(Objects.requireNonNull(detailModelBuilder))) {
            this.detailModelBuilders.add(detailModelBuilder);
        }
        return this;
    }

    @Override
    public SwingEntityModel build(EntityConnectionProvider connectionProvider) {
        Objects.requireNonNull(connectionProvider);
        try {
            SwingEntityModel model;
            if (this.modelFactory != null) {
                LOG.debug("{} modelBuilder initializing entity model", (Object)this);
                model = this.modelFactory.apply(connectionProvider);
            } else if (this.modelClass().equals(SwingEntityModel.class)) {
                LOG.debug("{} initializing a default entity model", (Object)this);
                model = new SwingEntityModel(this.buildTableModel(connectionProvider));
            } else {
                LOG.debug("{} initializing a custom entity model: {}", (Object)this, this.modelClass());
                model = this.modelClass().getConstructor(EntityConnectionProvider.class).newInstance(connectionProvider);
            }
            for (SwingEntityModel.Builder detailProvider : this.detailModelBuilders) {
                model.detailModels().add((EntityModel)detailProvider.build(connectionProvider));
            }
            this.onBuildModel.accept(model);
            return model;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SwingEntityModelBuilder) {
            SwingEntityModelBuilder that = (SwingEntityModelBuilder)obj;
            return Objects.equals(this.entityType, that.entityType) && Objects.equals(this.modelClass, that.modelClass) && Objects.equals(this.editModelClass, that.editModelClass) && Objects.equals(this.tableModelClass, that.tableModelClass);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.entityType, this.modelClass, this.editModelClass, this.tableModelClass);
    }

    private SwingEntityEditModel buildEditModel(EntityConnectionProvider connectionProvider) {
        try {
            SwingEntityEditModel editModel;
            if (this.editModelFactory != null) {
                LOG.debug("{} editModelBuilder initializing edit model", (Object)this);
                editModel = this.editModelFactory.apply(connectionProvider);
            } else if (this.editModelClass().equals(SwingEntityEditModel.class)) {
                LOG.debug("{} initializing a default edit model", (Object)this);
                editModel = new SwingEntityEditModel(this.entityType, connectionProvider);
            } else {
                LOG.debug("{} initializing a custom edit model: {}", (Object)this, this.editModelClass());
                editModel = this.editModelClass().getConstructor(EntityConnectionProvider.class).newInstance(connectionProvider);
            }
            this.onBuildEditModel.accept(editModel);
            return editModel;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SwingEntityTableModel buildTableModel(EntityConnectionProvider connectionProvider) {
        try {
            SwingEntityTableModel tableModel;
            if (this.tableModelFactory != null) {
                LOG.debug("{} tableModelBuilder initializing table model", (Object)this);
                tableModel = this.tableModelFactory.apply(connectionProvider);
            } else if (this.tableModelClass().equals(SwingEntityTableModel.class)) {
                LOG.debug("{} initializing a default table model", (Object)this);
                tableModel = new SwingEntityTableModel(this.buildEditModel(connectionProvider));
            } else {
                LOG.debug("{} initializing a custom table model: {}", (Object)this, this.tableModelClass());
                tableModel = this.tableModelClass().getConstructor(EntityConnectionProvider.class).newInstance(connectionProvider);
            }
            this.onBuildTableModel.accept(tableModel);
            return tableModel;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class<? extends SwingEntityModel> modelClass() {
        return this.modelClass == null ? SwingEntityModel.class : this.modelClass;
    }

    private Class<? extends SwingEntityEditModel> editModelClass() {
        return this.editModelClass == null ? SwingEntityEditModel.class : this.editModelClass;
    }

    private Class<? extends SwingEntityTableModel> tableModelClass() {
        return this.tableModelClass == null ? SwingEntityTableModel.class : this.tableModelClass;
    }

    private static final class EmptyOnBuild<T>
    implements Consumer<T> {
        private EmptyOnBuild() {
        }

        @Override
        public void accept(T panel) {
        }
    }
}

