/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.common.model.FilterModel;
import is.codion.common.model.condition.ConditionModel;
import is.codion.common.model.condition.TableConditionModel;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.AbstractEntityTableModel;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntityQueryModel;
import is.codion.framework.model.EntityTableConditionModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.model.component.table.FilterTableSortModel;
import is.codion.swing.framework.model.SwingEntityConditionModelFactory;
import is.codion.swing.framework.model.SwingEntityEditModel;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SwingEntityTableModel
extends AbstractEntityTableModel<SwingEntityEditModel>
implements EntityTableModel<SwingEntityEditModel>,
FilterTableModel<Entity, Attribute<?>> {
    public SwingEntityTableModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        this(new SwingEntityEditModel(entityType, connectionProvider));
    }

    public SwingEntityTableModel(Collection<Entity> entities, EntityConnectionProvider connectionProvider) {
        this(SwingEntityTableModel.entityType(entities), entities, connectionProvider);
    }

    public SwingEntityTableModel(EntityType entityType, Collection<Entity> entities, EntityConnectionProvider connectionProvider) {
        this(new SwingEntityEditModel(entityType, connectionProvider), Objects.requireNonNull(entities));
    }

    public SwingEntityTableModel(EntityTableConditionModel conditionModel) {
        this(EntityQueryModel.entityQueryModel((EntityTableConditionModel)conditionModel));
    }

    public SwingEntityTableModel(EntityQueryModel queryModel) {
        this(new SwingEntityEditModel(Objects.requireNonNull(queryModel).entityType(), queryModel.conditions().connectionProvider()), queryModel);
    }

    public SwingEntityTableModel(SwingEntityEditModel editModel) {
        this(editModel, EntityQueryModel.entityQueryModel((EntityTableConditionModel)EntityTableConditionModel.entityTableConditionModel((EntityType)editModel.entityType(), (EntityConnectionProvider)editModel.connectionProvider(), (Supplier)((Object)new SwingEntityConditionModelFactory(editModel.entityType(), editModel.connectionProvider())))));
    }

    public SwingEntityTableModel(SwingEntityEditModel editModel, EntityQueryModel queryModel) {
        super((EntityEditModel)Objects.requireNonNull(editModel), (FilterModel)SwingEntityTableModel.tableModelBuilder(editModel.entityDefinition()).supplier((Supplier)Objects.requireNonNull(queryModel)).build(), queryModel);
        this.addTableModelListener(this::onTableModelEvent);
    }

    private SwingEntityTableModel(SwingEntityEditModel editModel, Collection<Entity> items) {
        super((EntityEditModel)Objects.requireNonNull(editModel), (FilterModel)SwingEntityTableModel.tableModelBuilder(editModel.entityDefinition()).build());
        this.items().add(Objects.requireNonNull(items));
    }

    public boolean isCellEditable(int rowIndex, int modelColumnIndex) {
        if (!this.editable().get().booleanValue() || ((SwingEntityEditModel)this.editModel()).readOnly().get().booleanValue() || !((SwingEntityEditModel)this.editModel()).updateEnabled().get().booleanValue()) {
            return false;
        }
        Attribute attribute = (Attribute)this.columns().identifier(modelColumnIndex);
        if (attribute instanceof ForeignKey) {
            return this.entityDefinition().foreignKeys().updatable((ForeignKey)attribute);
        }
        AttributeDefinition attributeDefinition = this.entityDefinition().attributes().definition(attribute);
        return attributeDefinition instanceof ColumnDefinition && ((ColumnDefinition)attributeDefinition).updatable();
    }

    public final void setValueAt(Object value, int rowIndex, int modelColumnIndex) {
        if (!this.editable().get().booleanValue() || ((SwingEntityEditModel)this.editModel()).readOnly().get().booleanValue() || !((SwingEntityEditModel)this.editModel()).updateEnabled().get().booleanValue()) {
            throw new IllegalStateException("This table model is readOnly or has disabled update");
        }
        Entity entity = ((Entity)this.items().visible().get(rowIndex)).copy().mutable();
        entity.put((Attribute)this.columns().identifier(modelColumnIndex), value);
        try {
            if (entity.modified()) {
                ((SwingEntityEditModel)this.editModel()).update(Collections.singletonList(entity));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final int getRowCount() {
        return this.filterModel().getRowCount();
    }

    public final Object getValueAt(int rowIndex, int columnIndex) {
        return this.filterModel().getValueAt(rowIndex, columnIndex);
    }

    public final void fireTableDataChanged() {
        this.filterModel().fireTableDataChanged();
    }

    public final void fireTableRowsUpdated(int fromIndex, int toIndex) {
        this.filterModel().fireTableRowsUpdated(fromIndex, toIndex);
    }

    public final FilterTableModel.FilterTableModelItems<Entity> items() {
        return (FilterTableModel.FilterTableModelItems)super.filterModel().items();
    }

    public final FilterTableModel.ColumnValues<Attribute<?>> values() {
        return this.filterModel().values();
    }

    public final Class<?> getColumnClass(Attribute<?> attribute) {
        return this.filterModel().getColumnClass(attribute);
    }

    public final FilterTableModel.TableSelection<Entity> selection() {
        return this.filterModel().selection();
    }

    public final TableConditionModel<Attribute<?>> filters() {
        return this.filterModel().filters();
    }

    public final FilterTableSortModel<Entity, Attribute<?>> sort() {
        return this.filterModel().sort();
    }

    public final int getColumnCount() {
        return this.filterModel().getColumnCount();
    }

    public final String getColumnName(int columnIndex) {
        return this.filterModel().getColumnName(columnIndex);
    }

    public final Class<?> getColumnClass(int columnIndex) {
        return this.filterModel().getColumnClass(columnIndex);
    }

    public final void addTableModelListener(TableModelListener listener) {
        this.filterModel().addTableModelListener(listener);
    }

    public final void removeTableModelListener(TableModelListener listener) {
        this.filterModel().removeTableModelListener(listener);
    }

    public final FilterTableModel.TableColumns<Entity, Attribute<?>> columns() {
        return this.filterModel().columns();
    }

    protected final FilterTableModel<Entity, Attribute<?>> filterModel() {
        return (FilterTableModel)super.filterModel();
    }

    protected final void onRowsUpdated(int fromIndex, int toIndex) {
        this.fireTableRowsUpdated(fromIndex, toIndex);
    }

    private void onTableModelEvent(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() == ((Integer)this.selection().index().get()).intValue()) {
            ((SwingEntityEditModel)this.editModel()).editor().set((Entity)this.selection().item().get());
        }
    }

    private static FilterTableModel.Builder<Entity, Attribute<?>> tableModelBuilder(EntityDefinition definition) {
        return FilterTableModel.builder((FilterTableModel.TableColumns)new EntityTableColumns(definition)).filterModelFactory((Supplier)new EntityColumnFilterFactory(definition)).validator((Predicate)new EntityItemValidator(definition.type()));
    }

    private static EntityType entityType(Collection<Entity> entities) {
        if (Objects.requireNonNull(entities).isEmpty()) {
            throw new IllegalArgumentException("One or more entities is required to base a table model on");
        }
        return entities.iterator().next().type();
    }

    private static final class EntityTableColumns
    implements FilterTableModel.TableColumns<Entity, Attribute<?>> {
        private final EntityDefinition entityDefinition;
        private final List<Attribute<?>> identifiers;

        private EntityTableColumns(EntityDefinition entityDefinition) {
            this.entityDefinition = entityDefinition;
            this.identifiers = Collections.unmodifiableList(entityDefinition.attributes().definitions().stream().filter(attributeDefinition -> !attributeDefinition.hidden()).map(AttributeDefinition::attribute).collect(Collectors.toList()));
        }

        public List<Attribute<?>> identifiers() {
            return this.identifiers;
        }

        public Class<?> columnClass(Attribute<?> identifier) {
            return Objects.requireNonNull(identifier).type().valueClass();
        }

        public Object value(Entity entity, Attribute<?> attribute) {
            return Objects.requireNonNull(entity).get(attribute);
        }

        public String string(Entity entity, Attribute<?> attribute) {
            return Objects.requireNonNull(entity).string(attribute);
        }

        public Comparator<?> comparator(Attribute<?> attribute) {
            if (attribute instanceof ForeignKey) {
                return this.entityDefinition.foreignKeys().referencedBy((ForeignKey)attribute).comparator();
            }
            return this.entityDefinition.attributes().definition(attribute).comparator();
        }
    }

    private static final class EntityColumnFilterFactory
    implements Supplier<Map<Attribute<?>, ConditionModel<?>>> {
        private final EntityDefinition entityDefinition;

        private EntityColumnFilterFactory(EntityDefinition entityDefinition) {
            this.entityDefinition = Objects.requireNonNull(entityDefinition);
        }

        @Override
        public Map<Attribute<?>, ConditionModel<?>> get() {
            return this.entityDefinition.attributes().definitions().stream().filter(EntityColumnFilterFactory::include).collect(Collectors.toMap(AttributeDefinition::attribute, EntityColumnFilterFactory::conditionModel));
        }

        private static ConditionModel<?> conditionModel(AttributeDefinition<?> definition) {
            if (EntityColumnFilterFactory.useStringCondition(definition)) {
                return ConditionModel.builder(String.class).build();
            }
            return ConditionModel.builder((Class)definition.attribute().type().valueClass()).format(definition.format()).dateTimePattern(definition.dateTimePattern()).build();
        }

        private static boolean include(AttributeDefinition<?> definition) {
            return !definition.hidden();
        }

        private static boolean useStringCondition(AttributeDefinition<?> attributeDefinition) {
            return attributeDefinition.attribute().type().isEntity() || !attributeDefinition.items().isEmpty() || !Comparable.class.isAssignableFrom(attributeDefinition.attribute().type().valueClass());
        }
    }

    private static final class EntityItemValidator
    implements Predicate<Entity> {
        private final EntityType entityType;

        private EntityItemValidator(EntityType entityType) {
            this.entityType = Objects.requireNonNull(entityType);
        }

        @Override
        public boolean test(Entity entity) {
            return entity.type().equals(this.entityType);
        }
    }
}

