/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.component;

import is.codion.common.model.selection.SingleSelection;
import is.codion.common.proxy.ProxyBuilder;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.EntityEditEvents;
import is.codion.swing.common.model.component.combobox.FilterComboBoxModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.event.ListDataListener;

final class DefaultEntityComboBoxModel
implements EntityComboBoxModel {
    private final FilterComboBoxModel<Entity> comboBoxModel;
    private final EntityDefinition entityDefinition;
    private final EntityConnectionProvider connectionProvider;
    private final DefaultFilter filter;
    private final Value<Supplier<Condition>> condition;
    private final OrderBy orderBy;
    private final Collection<Attribute<?>> attributes;
    private final Consumer<Collection<Entity>> insertListener = new InsertListener();
    private final Consumer<Map<Entity.Key, Entity>> updateListener = new UpdateListener();
    private final Consumer<Collection<Entity>> deleteListener = new DeleteListener();

    DefaultEntityComboBoxModel(DefaultBuilder builder) {
        this.connectionProvider = builder.connectionProvider;
        this.entityDefinition = builder.entityDefinition;
        this.attributes = builder.attributes;
        this.comboBoxModel = FilterComboBoxModel.builder(this::performQuery).nullItem((Object)this.createNullItem(builder.nullCaption)).comparator(builder.orderBy == null ? builder.comparator : null).filterSelected(builder.filterSelected).build();
        this.filter = new DefaultFilter();
        this.comboBoxModel.items().visible().predicate().set((Object)this.filter);
        this.comboBoxModel.items().visible().predicate().addValidator(predicate -> {
            if (predicate != this.filter) {
                throw new UnsupportedOperationException("EntityComboBoxModel visible item predicate can only be set via filter().predicate().set()");
            }
        });
        this.condition = Value.nonNull(builder.condition);
        this.orderBy = builder.orderBy;
        if (builder.handleEditEvents) {
            this.addEditListeners();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [entityType: " + this.entityDefinition.type() + "]";
    }

    @Override
    public EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public EntityDefinition entityDefinition() {
        return this.entityDefinition;
    }

    @Override
    public Optional<Entity> find(Entity.Key primaryKey) {
        Objects.requireNonNull(primaryKey);
        return this.items().get().stream().filter(Objects::nonNull).filter(entity -> entity.primaryKey().equals(primaryKey)).findFirst();
    }

    @Override
    public void select(Entity.Key primaryKey) {
        Objects.requireNonNull(primaryKey);
        Optional<Entity> entity = this.find(primaryKey);
        if (entity.isPresent()) {
            this.setSelectedItem(entity.get());
        } else {
            this.filteredEntity(primaryKey).ifPresent(this::setSelectedItem);
        }
    }

    @Override
    public Value<Supplier<Condition>> condition() {
        return this.condition;
    }

    @Override
    public EntityComboBoxModel.Filter filter() {
        return this.filter;
    }

    @Override
    public <T> Value<T> createSelectorValue(Attribute<T> attribute) {
        if (!this.entityDefinition.attributes().contains(attribute)) {
            throw new IllegalArgumentException("Attribute " + attribute + " is not part of entity: " + this.entityDefinition.type());
        }
        return this.createSelectorValue(new EntityFinder<T>(attribute));
    }

    public SingleSelection<Entity> selection() {
        return this.comboBoxModel.selection();
    }

    public Entity getSelectedItem() {
        return (Entity)this.comboBoxModel.getSelectedItem();
    }

    public <V> Value<V> createSelectorValue(FilterComboBoxModel.ItemFinder<Entity, V> itemFinder) {
        return this.comboBoxModel.createSelectorValue(itemFinder);
    }

    public FilterComboBoxModel.ComboBoxItems<Entity> items() {
        return this.comboBoxModel.items();
    }

    public void setSelectedItem(Object selectedItem) {
        this.comboBoxModel.setSelectedItem(selectedItem);
    }

    public int getSize() {
        return this.comboBoxModel.getSize();
    }

    public Entity getElementAt(int index) {
        return (Entity)this.comboBoxModel.getElementAt(index);
    }

    public void addListDataListener(ListDataListener listener) {
        this.comboBoxModel.addListDataListener(listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.comboBoxModel.removeListDataListener(listener);
    }

    private Collection<Entity> performQuery() {
        return this.connectionProvider.connection().select(EntityConnection.Select.where((Condition)((Condition)((Supplier)this.condition.getOrThrow()).get())).attributes(this.attributes).orderBy(this.orderBy).build());
    }

    private Optional<Entity> filteredEntity(Entity.Key primaryKey) {
        return this.items().filtered().get().stream().filter(entity -> entity.primaryKey().equals(primaryKey)).findFirst();
    }

    private Entity createNullItem(String nullCaption) {
        return nullCaption == null ? null : (Entity)ProxyBuilder.builder(Entity.class).delegate((Object)this.entityDefinition.entity()).method("toString", parameters -> nullCaption).build();
    }

    private void addEditListeners() {
        EntityEditEvents.insertObserver((EntityType)this.entityDefinition.type()).addWeakConsumer(this.insertListener);
        EntityEditEvents.updateObserver((EntityType)this.entityDefinition.type()).addWeakConsumer(this.updateListener);
        EntityEditEvents.deleteObserver((EntityType)this.entityDefinition.type()).addWeakConsumer(this.deleteListener);
    }

    private final class InsertListener
    implements Consumer<Collection<Entity>> {
        private InsertListener() {
        }

        @Override
        public void accept(Collection<Entity> inserted) {
            inserted.forEach(arg_0 -> DefaultEntityComboBoxModel.this.items().add(arg_0));
        }
    }

    private final class UpdateListener
    implements Consumer<Map<Entity.Key, Entity>> {
        private UpdateListener() {
        }

        @Override
        public void accept(Map<Entity.Key, Entity> updated) {
            updated.forEach((key, entity) -> DefaultEntityComboBoxModel.this.items().replace((Object)Entity.entity((Entity.Key)key), entity));
        }
    }

    private final class DeleteListener
    implements Consumer<Collection<Entity>> {
        private DeleteListener() {
        }

        @Override
        public void accept(Collection<Entity> deleted) {
            DefaultEntityComboBoxModel.this.items().remove(deleted);
        }
    }

    static class DefaultBuilder
    implements EntityComboBoxModel.Builder {
        private final EntityDefinition entityDefinition;
        private final EntityConnectionProvider connectionProvider;
        private final EntityComboBoxModel filterModel;
        private final ForeignKey filterForeignKey;
        private OrderBy orderBy;
        private Supplier<Condition> condition;
        private Comparator<Entity> comparator;
        private Collection<Attribute<?>> attributes = Collections.emptyList();
        private boolean handleEditEvents = (Boolean)EntityComboBoxModel.HANDLE_EDIT_EVENTS.getOrThrow();
        private String nullCaption;
        private boolean filterSelected = false;

        DefaultBuilder(EntityType entityType, EntityConnectionProvider connectionProvider) {
            this(entityType, connectionProvider, null, null);
        }

        DefaultBuilder(EntityType entityType, EntityConnectionProvider connectionProvider, EntityComboBoxModel filterModel, ForeignKey filterForeignKey) {
            this.connectionProvider = Objects.requireNonNull(connectionProvider);
            this.entityDefinition = connectionProvider.entities().definition(entityType);
            this.condition = new DefaultConditionSupplier(entityType);
            this.comparator = connectionProvider.entities().definition(entityType).comparator();
            this.filterModel = filterModel;
            this.filterForeignKey = filterForeignKey;
        }

        @Override
        public EntityComboBoxModel.Builder orderBy(OrderBy orderBy) {
            this.orderBy = Objects.requireNonNull(orderBy);
            return this;
        }

        @Override
        public EntityComboBoxModel.Builder comparator(Comparator<Entity> comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        public EntityComboBoxModel.Builder condition(Supplier<Condition> condition) {
            this.condition = Objects.requireNonNull(condition);
            return this;
        }

        @Override
        public EntityComboBoxModel.Builder attributes(Collection<Attribute<?>> attributes) {
            for (Attribute<?> attribute : Objects.requireNonNull(attributes)) {
                if (attribute.entityType().equals(this.entityDefinition.type())) continue;
                throw new IllegalArgumentException("Attribute " + attribute + " is not part of entity: " + this.entityDefinition.type());
            }
            this.attributes = attributes;
            return this;
        }

        @Override
        public EntityComboBoxModel.Builder includeNull(boolean includeNull) {
            return this.nullCaption(includeNull ? (String)FilterComboBoxModel.NULL_CAPTION.get() : null);
        }

        @Override
        public EntityComboBoxModel.Builder nullCaption(String nullCaption) {
            this.nullCaption = nullCaption;
            return this;
        }

        @Override
        public EntityComboBoxModel.Builder handleEditEvents(boolean handleEditEvents) {
            this.handleEditEvents = handleEditEvents;
            return this;
        }

        @Override
        public EntityComboBoxModel.Builder filterSelected(boolean filterSelected) {
            this.filterSelected = filterSelected;
            return this;
        }

        @Override
        public EntityComboBoxModel build() {
            DefaultEntityComboBoxModel entityComboBoxModel = new DefaultEntityComboBoxModel(this);
            if (this.filterModel != null) {
                this.filterModel.filter().get(this.filterForeignKey).link(entityComboBoxModel);
            }
            return entityComboBoxModel;
        }
    }

    private final class DefaultFilter
    implements EntityComboBoxModel.Filter,
    Predicate<Entity> {
        private final Map<ForeignKey, DefaultForeignKeyFilter> foreignKeyFilters = new HashMap<ForeignKey, DefaultForeignKeyFilter>();
        private final Value<Predicate<Entity>> predicate = Value.builder().nullable().notify(Value.Notify.WHEN_SET).listener(() -> DefaultEntityComboBoxModel.this.items().filter()).build();

        private DefaultFilter() {
        }

        @Override
        public Value<Predicate<Entity>> predicate() {
            return this.predicate;
        }

        @Override
        public EntityComboBoxModel.ForeignKeyFilter get(ForeignKey foreignKey) {
            DefaultEntityComboBoxModel.this.entityDefinition.foreignKeys().definition(foreignKey);
            return this.foreignKeyFilters.computeIfAbsent(foreignKey, x$0 -> new DefaultForeignKeyFilter((ForeignKey)x$0));
        }

        @Override
        public boolean test(Entity entity) {
            for (Map.Entry<ForeignKey, DefaultForeignKeyFilter> entry : this.foreignKeyFilters.entrySet()) {
                if (entry.getValue().test(entity)) continue;
                return false;
            }
            return this.predicate.isNull() || ((Predicate)this.predicate.getOrThrow()).test(entity);
        }
    }

    private static final class EntityFinder<T>
    implements FilterComboBoxModel.ItemFinder<Entity, T> {
        private final Attribute<T> attribute;

        private EntityFinder(Attribute<T> attribute) {
            this.attribute = attribute;
        }

        public T value(Entity item) {
            return (T)item.get(this.attribute);
        }

        public Predicate<Entity> predicate(T value) {
            return entity -> Objects.equals(entity.get(this.attribute), value);
        }
    }

    private static final class DefaultConditionSupplier
    implements Supplier<Condition> {
        private final Condition condition;

        private DefaultConditionSupplier(EntityType entityType) {
            this.condition = Condition.all((EntityType)entityType);
        }

        @Override
        public Condition get() {
            return this.condition;
        }
    }

    private final class DefaultForeignKeyFilter
    implements EntityComboBoxModel.ForeignKeyFilter,
    Predicate<Entity> {
        private final ForeignKey foreignKey;
        private final State strict = ((State.Builder)State.builder((boolean)true).listener(() -> DefaultEntityComboBoxModel.this.items().filter())).build();
        private Set<Entity.Key> foreignKeys;

        private DefaultForeignKeyFilter(ForeignKey foreignKey) {
            this.foreignKey = foreignKey;
        }

        @Override
        public boolean test(Entity item) {
            if (this.foreignKeys == null) {
                return true;
            }
            Entity.Key key = item.key(this.foreignKey);
            if (key == null || this.foreignKeys.isEmpty()) {
                return this.strict.get() == false;
            }
            return this.foreignKeys.isEmpty() || this.foreignKeys.contains(key);
        }

        @Override
        public void set(Entity.Key key) {
            this.set(Collections.singleton(Objects.requireNonNull(key)));
        }

        @Override
        public void set(Collection<Entity.Key> keys) {
            this.foreignKeys = Collections.unmodifiableSet(new HashSet<Entity.Key>(this.validateKeys(keys)));
            DefaultEntityComboBoxModel.this.items().filter();
        }

        @Override
        public Collection<Entity.Key> get() {
            return this.foreignKeys == null ? Collections.emptySet() : this.foreignKeys;
        }

        @Override
        public void clear() {
            this.foreignKeys = null;
            DefaultEntityComboBoxModel.this.items().filter();
        }

        @Override
        public State strict() {
            return this.strict;
        }

        @Override
        public EntityComboBoxModel.Builder builder() {
            return new DefaultBuilder(this.foreignKey.referencedType(), DefaultEntityComboBoxModel.this.connectionProvider, DefaultEntityComboBoxModel.this, this.foreignKey).includeNull(DefaultEntityComboBoxModel.this.connectionProvider.entities().definition(this.foreignKey.entityType()).foreignKeys().definition(this.foreignKey).nullable());
        }

        @Override
        public void link(EntityComboBoxModel filterModel) {
            DefaultEntityComboBoxModel.this.entityDefinition.foreignKeys().definition(this.foreignKey);
            if (!this.foreignKey.referencedType().equals(filterModel.entityDefinition().type())) {
                throw new IllegalArgumentException("EntityComboBoxModel is of type: " + filterModel.entityDefinition().type() + ", should be: " + this.foreignKey.referencedType());
            }
            Collection<Entity.Key> filterKeys = this.get();
            if (!filterKeys.isEmpty()) {
                filterModel.select(filterKeys.iterator().next());
            }
            this.set((Entity)DefaultEntityComboBoxModel.this.selection().item().get());
            filterModel.selection().item().addConsumer(this::set);
            DefaultEntityComboBoxModel.this.selection().item().addConsumer(selected -> this.select(filterModel, (Entity)selected));
            DefaultEntityComboBoxModel.this.items().refresher().result().addListener(() -> ((FilterComboBoxModel.ComboBoxItems)filterModel.items()).refresh());
            filterModel.items().refresher().result().addListener(() -> this.select(filterModel, DefaultEntityComboBoxModel.this.getSelectedItem()));
        }

        private void select(EntityComboBoxModel filterModel, Entity selected) {
            if (selected != null && !selected.isNull((Attribute)this.foreignKey)) {
                filterModel.select(selected.key(this.foreignKey));
            }
        }

        private void set(Entity selected) {
            if (selected != null) {
                this.set(selected.primaryKey());
            } else if (this.strict.get().booleanValue()) {
                this.set(Collections.emptyList());
            } else {
                this.clear();
            }
        }

        private Collection<Entity.Key> validateKeys(Collection<Entity.Key> keys) {
            Objects.requireNonNull(keys);
            for (Entity.Key key : keys) {
                if (key.type().equals(this.foreignKey.referencedType())) continue;
                throw new IllegalArgumentException("Key " + key + " is not of the correct type (" + this.foreignKey.referencedType() + ")");
            }
            return keys;
        }
    }
}

