/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.test;

import is.codion.common.user.User;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.DomainType;
import is.codion.swing.framework.model.SwingEntityApplicationModel;
import is.codion.swing.framework.ui.EntityApplicationPanel;
import is.codion.swing.framework.ui.EntityPanel;
import java.util.Objects;
import javax.swing.UIManager;

public class EntityApplicationPanelTestUnit<M extends SwingEntityApplicationModel> {
    private static final String TEST_USER = "codion.test.user";
    private final Class<M> modelClass;
    private final Class<? extends EntityApplicationPanel<M>> panelClass;
    private final User user;
    private final DomainType domainType;

    protected EntityApplicationPanelTestUnit(Class<M> modelClass, Class<? extends EntityApplicationPanel<M>> panelClass) {
        this(modelClass, panelClass, EntityApplicationPanelTestUnit.testUser());
    }

    protected EntityApplicationPanelTestUnit(Class<M> modelClass, Class<? extends EntityApplicationPanel<M>> panelClass, User user) {
        this(modelClass, panelClass, user, (DomainType)EntityConnectionProvider.CLIENT_DOMAIN_TYPE.getOrThrow());
    }

    protected EntityApplicationPanelTestUnit(Class<M> modelClass, Class<? extends EntityApplicationPanel<M>> panelClass, User user, DomainType domainType) {
        this.modelClass = Objects.requireNonNull(modelClass);
        this.panelClass = Objects.requireNonNull(panelClass);
        this.user = Objects.requireNonNull(user);
        this.domainType = Objects.requireNonNull(domainType);
    }

    protected final void testInitialize() {
        EntityApplicationPanel.builder(this.modelClass, this.panelClass).lookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName()).domainType(this.domainType).automaticLoginUser(this.user).saveDefaultUsername(false).setUncaughtExceptionHandler(false).displayStartupDialog(false).displayFrame(false).onApplicationStarted(this::testApplicationPanel).start(false);
    }

    private void testApplicationPanel(EntityApplicationPanel<M> applicationPanel) {
        applicationPanel.entityPanels().forEach(this::initialize);
        applicationPanel.applicationModel().connectionProvider().close();
    }

    private void initialize(EntityPanel entityPanel) {
        entityPanel.initialize();
        entityPanel.detailPanels().get().forEach(this::initialize);
    }

    private static User testUser() {
        String testUser = System.getProperty(TEST_USER);
        if (testUser == null) {
            throw new IllegalStateException("Required property 'codion.test.user' not set");
        }
        return User.parse((String)testUser);
    }
}

