/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.model.table.ColumnConditionModel;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.EntitySearchConditionModel;
import is.codion.framework.model.EntitySearchModel;
import is.codion.swing.common.ui.Sizes;
import is.codion.swing.common.ui.component.combobox.Completion;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.text.TextComponents;
import is.codion.swing.framework.model.EntityComboBoxConditionModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import is.codion.swing.framework.ui.component.EntityComboBox;
import is.codion.swing.framework.ui.component.EntityComponents;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class EntityConditionPanelFactory
implements ColumnConditionPanel.Factory<Attribute<?>> {
    private final EntityComponents entityComponents;

    public EntityConditionPanelFactory(EntityDefinition entityDefinition) {
        this(new EntityComponents(entityDefinition));
    }

    public EntityConditionPanelFactory(EntityComponents entityComponents) {
        this.entityComponents = Objects.requireNonNull(entityComponents);
    }

    public <T> Optional<ColumnConditionPanel<Attribute<?>, T>> createConditionPanel(ColumnConditionModel<Attribute<?>, T> conditionModel) {
        Objects.requireNonNull(conditionModel);
        ColumnConditionPanel.BoundFieldFactory boundFieldFactory = this.createBoundFieldFactory(conditionModel);
        if (boundFieldFactory != null) {
            return ColumnConditionPanel.columnConditionPanel(conditionModel, (ColumnConditionPanel.BoundFieldFactory)boundFieldFactory);
        }
        return Optional.empty();
    }

    private <T> ColumnConditionPanel.BoundFieldFactory createBoundFieldFactory(ColumnConditionModel<? extends Attribute<?>, T> conditionModel) {
        if (conditionModel.columnIdentifier() instanceof ForeignKey) {
            return new ForeignKeyBoundFieldFactory(conditionModel, this.entityComponents);
        }
        if (this.entityComponents.supports((Attribute)conditionModel.columnIdentifier())) {
            return new AttributeBoundFieldFactory<T>(conditionModel, this.entityComponents, (Attribute)conditionModel.columnIdentifier());
        }
        return null;
    }

    private static final class ForeignKeyBoundFieldFactory
    implements ColumnConditionPanel.BoundFieldFactory {
        private final EntityComponents entityComponents;
        private final ColumnConditionModel<ForeignKey, Entity> model;

        private ForeignKeyBoundFieldFactory(ColumnConditionModel<ForeignKey, Entity> model, EntityComponents entityComponents) {
            this.model = model;
            this.entityComponents = entityComponents;
        }

        public boolean supportsType(Class<?> columnClass) {
            return Entity.class.isAssignableFrom(Objects.requireNonNull(columnClass));
        }

        public JComponent createEqualField() {
            return Sizes.setPreferredHeight((JComponent)this.createForeignKeyField(), (int)TextComponents.preferredTextFieldHeight());
        }

        public Optional<JComponent> createUpperBoundField() {
            return Optional.empty();
        }

        public Optional<JComponent> createLowerBoundField() {
            return Optional.empty();
        }

        private JComponent createForeignKeyField() {
            if (this.model instanceof EntitySearchConditionModel) {
                EntitySearchModel searchModel = ((EntitySearchConditionModel)this.model).searchModel();
                return this.entityComponents.foreignKeySearchField((ForeignKey)this.model.columnIdentifier(), searchModel).build();
            }
            if (this.model instanceof EntityComboBoxConditionModel) {
                EntityComboBoxModel comboBoxModel = ((EntityComboBoxConditionModel)this.model).comboBoxModel();
                return ((EntityComboBox.Builder)((EntityComboBox.Builder)this.entityComponents.foreignKeyComboBox((ForeignKey)this.model.columnIdentifier(), comboBoxModel).completionMode(Completion.Mode.MAXIMUM_MATCH)).onSetVisible(comboBox -> comboBoxModel.refresh())).build();
            }
            throw new IllegalArgumentException("Unknown foreign key condition model type: " + this.model);
        }
    }

    private static final class AttributeBoundFieldFactory<T>
    implements ColumnConditionPanel.BoundFieldFactory {
        private static final List<Class<?>> SUPPORTED_TYPES = Arrays.asList(Character.class, String.class, Boolean.class, Short.class, Integer.class, Double.class, BigDecimal.class, Long.class, LocalTime.class, LocalDate.class, LocalDateTime.class, OffsetDateTime.class);
        private final ColumnConditionModel<? extends Attribute<?>, T> conditionModel;
        private final EntityComponents inputComponents;
        private final Attribute<T> attribute;

        private AttributeBoundFieldFactory(ColumnConditionModel<? extends Attribute<?>, T> conditionModel, EntityComponents inputComponents, Attribute<T> attribute) {
            this.conditionModel = Objects.requireNonNull(conditionModel);
            this.inputComponents = inputComponents;
            this.attribute = Objects.requireNonNull(attribute);
        }

        public boolean supportsType(Class<?> columnClass) {
            return SUPPORTED_TYPES.contains(Objects.requireNonNull(columnClass));
        }

        public JComponent createEqualField() {
            return this.inputComponents.component(this.attribute).link(this.conditionModel.equalValues().value()).onBuild(AttributeBoundFieldFactory::configureComponent).build();
        }

        public Optional<JComponent> createUpperBoundField() {
            if (this.conditionModel.columnClass().equals(Boolean.class)) {
                return Optional.empty();
            }
            return Optional.of(this.inputComponents.component(this.attribute).link(this.conditionModel.upperBoundValue()).onBuild(AttributeBoundFieldFactory::configureComponent).build());
        }

        public Optional<JComponent> createLowerBoundField() {
            if (this.conditionModel.columnClass().equals(Boolean.class)) {
                return Optional.empty();
            }
            return Optional.of(this.inputComponents.component(this.attribute).link(this.conditionModel.lowerBoundValue()).onBuild(AttributeBoundFieldFactory::configureComponent).build());
        }

        private static JComponent configureComponent(JComponent component) {
            if (component instanceof JTextField) {
                ((JTextField)component).setColumns(0);
                ((JTextField)component).setHorizontalAlignment(0);
            } else if (component instanceof JCheckBox) {
                ((JCheckBox)component).setHorizontalAlignment(0);
            }
            return component;
        }
    }
}

