/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.ReferentialIntegrityException;
import is.codion.common.i18n.Messages;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.framework.model.EntityEditModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.ProgressWorkerDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.ui.EntityDependenciesPanel;
import is.codion.swing.framework.ui.EntityEditComponentPanel;
import is.codion.swing.framework.ui.EntityPanel;
import is.codion.swing.framework.ui.EntityPopupMenu;
import is.codion.swing.framework.ui.ReferentialIntegrityErrorHandling;
import is.codion.swing.framework.ui.component.EntityComponents;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityEditPanel
extends EntityEditComponentPanel {
    private static final Logger LOG = LoggerFactory.getLogger(EntityEditPanel.class);
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(EntityEditPanel.class.getName());
    private static final String ALT_PREFIX = " (ALT-";
    private static final State.Group ACTIVE_STATE_GROUP;
    private static final Consumer<Config> NO_CONFIGURATION;
    private final Config configuration;
    private final Map<EditControl, Value<Control>> controls;
    private final State active;
    private boolean initialized = false;

    public EntityEditPanel(SwingEntityEditModel editModel) {
        this(editModel, NO_CONFIGURATION);
    }

    public EntityEditPanel(SwingEntityEditModel editModel, EntityComponents entityComponents) {
        this(editModel, entityComponents, NO_CONFIGURATION);
    }

    public EntityEditPanel(SwingEntityEditModel editModel, Consumer<Config> configuration) {
        this(editModel, new EntityComponents(editModel.entityDefinition()), configuration);
    }

    public EntityEditPanel(SwingEntityEditModel editModel, EntityComponents entityComponents, Consumer<Config> configuration) {
        super(editModel, entityComponents);
        this.configuration = this.configure(configuration);
        this.active = State.state((!this.configuration.focusActivation ? 1 : 0) != 0);
        this.controls = this.createControlsMap();
        this.setupFocusActivation();
        this.setupKeyboardActions();
        if (((Boolean)editModel.exists().not().get()).booleanValue()) {
            editModel.defaults();
        }
    }

    @Override
    public final String toString() {
        return this.editModel().toString();
    }

    public final State active() {
        return this.active;
    }

    public final void clearAndRequestFocus() {
        this.editModel().defaults();
        this.requestInitialFocus();
    }

    public final Value<Control> control(EditControl editControl) {
        return this.controls.get((Object)Objects.requireNonNull(editControl));
    }

    public final Controls controls() {
        if (!this.initialized()) {
            throw new IllegalStateException("Method must be called after the panel is initialized");
        }
        return this.createControls();
    }

    public final EntityEditPanel initialize() {
        if (!this.initialized) {
            try {
                this.setupStandardControls();
                this.setupControls();
                this.bindEvents();
                this.initializeUI();
            }
            finally {
                this.initialized = true;
            }
        }
        return this;
    }

    public final boolean insertWithConfirmation() {
        if (this.confirmInsert()) {
            return this.insert();
        }
        return false;
    }

    public final boolean insert() {
        try {
            this.editModel().insert();
            if (this.configuration.clearAfterInsert) {
                this.editModel().defaults();
            }
            if (this.configuration.requestFocusAfterInsert) {
                this.requestAfterInsertFocus();
            }
            return true;
        }
        catch (ValidationException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.onException(e);
        }
        return false;
    }

    public final boolean deleteWithConfirmation() {
        if (this.confirmDelete()) {
            return this.delete();
        }
        return false;
    }

    public final boolean delete() {
        try {
            this.editModel().delete();
            this.requestInitialFocus();
            return true;
        }
        catch (ReferentialIntegrityException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            this.onException(ex);
        }
        return false;
    }

    public final boolean updateWithConfirmation() {
        if (this.confirmUpdate()) {
            return this.update();
        }
        return false;
    }

    public final boolean update() {
        try {
            this.editModel().update();
            this.requestAfterUpdateFocus();
            return true;
        }
        catch (ValidationException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            this.onException(ex);
        }
        return false;
    }

    public final boolean initialized() {
        return this.initialized;
    }

    protected final boolean confirmInsert() {
        return this.configuration.insertConfirmer.confirm(this);
    }

    protected final boolean confirmUpdate() {
        return this.configuration.updateConfirmer.confirm(this);
    }

    protected final boolean confirmDelete() {
        return this.configuration.deleteConfirmer.confirm(this);
    }

    protected final Control.Command insertCommand(boolean confirm) {
        return new InsertCommand(confirm);
    }

    protected final Control.Command updateCommand(boolean confirm) {
        return new UpdateCommand(confirm);
    }

    protected final Control.Command deleteCommand(boolean confirm) {
        return new DeleteCommand(confirm);
    }

    @Override
    protected void onException(Exception exception) {
        if (exception instanceof ValidationException) {
            this.onValidationException((ValidationException)((Object)exception));
        } else if (exception instanceof ReferentialIntegrityException) {
            this.onReferentialIntegrityException((ReferentialIntegrityException)((Object)exception));
        } else {
            super.onException(exception);
        }
    }

    protected void onReferentialIntegrityException(ReferentialIntegrityException exception) {
        Objects.requireNonNull(exception);
        if (exception.operation() == Database.Operation.DELETE && this.configuration.referentialIntegrityErrorHandling == ReferentialIntegrityErrorHandling.DISPLAY_DEPENDENCIES) {
            EntityDependenciesPanel.displayDependenciesDialog(Collections.singletonList(this.editModel().entity()), this.editModel().connectionProvider(), (JComponent)this, MESSAGES.getString("unknown_dependent_records"));
        } else {
            super.onException((Exception)((Object)exception));
        }
    }

    protected void onValidationException(ValidationException exception) {
        Objects.requireNonNull(exception);
        String title = this.editModel().entities().definition(exception.attribute().entityType()).attributes().definition(exception.attribute()).caption();
        JOptionPane.showMessageDialog(this, exception.getMessage(), title, 0);
        this.requestComponentFocus(exception.attribute());
    }

    protected Controls createControls() {
        return Controls.controls((Control[])((Control[])Stream.of(EditControl.values()).map(this.controls::get).map(ValueObserver::optional).filter(Optional::isPresent).map(Optional::get).toArray(Control[]::new)));
    }

    protected void setupControls() {
    }

    protected abstract void initializeUI();

    private void setupStandardControls() {
        if (!((Boolean)this.editModel().readOnly().get()).booleanValue()) {
            this.setupEditControls();
        }
        if (this.configuration.editControls.contains((Object)EditControl.CLEAR)) {
            this.controls.get((Object)EditControl.CLEAR).mapNull(this::createClearControl);
        }
    }

    private void setupEditControls() {
        if (((Boolean)this.editModel().insertEnabled().get()).booleanValue() && this.configuration.editControls.contains((Object)EditControl.INSERT)) {
            this.controls.get((Object)EditControl.INSERT).mapNull(this::createInsertControl);
        }
        if (((Boolean)this.editModel().updateEnabled().get()).booleanValue() && this.configuration.editControls.contains((Object)EditControl.UPDATE)) {
            this.controls.get((Object)EditControl.UPDATE).mapNull(this::createUpdateControl);
        }
        if (((Boolean)this.editModel().deleteEnabled().get()).booleanValue() && this.configuration.editControls.contains((Object)EditControl.DELETE)) {
            this.controls.get((Object)EditControl.DELETE).mapNull(this::createDeleteControl);
        }
    }

    private Control createDeleteControl() {
        return Control.builder((Control.Command)this.deleteCommand(true)).name(FrameworkMessages.delete()).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().deleteEnabled(), this.editModel().exists()})).description(FrameworkMessages.deleteCurrentTip() + ALT_PREFIX + FrameworkMessages.deleteMnemonic() + ")").mnemonic(FrameworkMessages.deleteMnemonic()).smallIcon((Icon)FrameworkIcons.instance().delete()).onException(this::onException).build();
    }

    private Control createClearControl() {
        return Control.builder(this::clearAndRequestFocus).name(Messages.clear()).enabled((StateObserver)this.active).description(Messages.clearTip() + ALT_PREFIX + Messages.clearMnemonic() + ")").mnemonic(Messages.clearMnemonic()).smallIcon((Icon)FrameworkIcons.instance().clear()).build();
    }

    private Control createUpdateControl() {
        return Control.builder((Control.Command)this.updateCommand(true)).name(FrameworkMessages.update()).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().updateEnabled(), this.editModel().exists(), this.editModel().modified()})).description(FrameworkMessages.updateTip() + ALT_PREFIX + FrameworkMessages.updateMnemonic() + ")").mnemonic(FrameworkMessages.updateMnemonic()).smallIcon((Icon)FrameworkIcons.instance().update()).onException(this::onException).build();
    }

    private Control createInsertControl() {
        boolean useSaveCaption = (Boolean)Config.USE_SAVE_CAPTION.get();
        char mnemonic = useSaveCaption ? FrameworkMessages.saveMnemonic() : FrameworkMessages.insertMnemonic();
        String caption = useSaveCaption ? FrameworkMessages.save() : FrameworkMessages.insert();
        return Control.builder((Control.Command)this.insertCommand(true)).name(caption).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().insertEnabled()})).description(FrameworkMessages.addTip() + ALT_PREFIX + mnemonic + ")").mnemonic(mnemonic).smallIcon((Icon)FrameworkIcons.instance().add()).onException(this::onException).build();
    }

    private void bindEvents() {
        if (this.configuration.includeEntityMenu) {
            KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.DISPLAY_ENTITY_MENU).get())).condition(1).action((Action)Control.control(this::showEntityMenu)).enable(new JComponent[]{this});
        }
        this.editModel().confirmOverwriteEvent().addConsumer(confirmationState -> {
            int result = JOptionPane.showConfirmDialog(Utilities.parentWindow((Component)this), FrameworkMessages.unsavedDataWarning(), FrameworkMessages.unsavedDataWarningTitle(), 0, 2);
            confirmationState.set((Object)(result == 0 ? 1 : 0));
        });
    }

    private void setupFocusActivation() {
        if (this.configuration.focusActivation) {
            ACTIVE_STATE_GROUP.add(this.active);
        }
    }

    private void setupKeyboardActions() {
        KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_INPUT_FIELD).get())).condition(1).action((Action)Control.control(this::selectInputComponent)).enable(new JComponent[]{this});
    }

    private void showEntityMenu() {
        new EntityPopupMenu(this.editModel().entity(), this.editModel().connection()).show(this, 0, 0);
    }

    private Map<EditControl, Value<Control>> createControlsMap() {
        Value.Validator controlValueValidator = control -> {
            if (this.initialized) {
                throw new IllegalStateException("Controls must be configured before the panel has been initialized");
            }
        };
        return Collections.unmodifiableMap(Stream.of(EditControl.values()).collect(Collectors.toMap(Function.identity(), controlCode -> Value.nullable().validator(controlValueValidator).build())));
    }

    private Config configure(Consumer<Config> configuration) {
        Config config = new Config(this);
        Objects.requireNonNull(configuration).accept(config);
        return new Config(config);
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new FocusActivationListener());
        ACTIVE_STATE_GROUP = State.group((State[])new State[0]);
        NO_CONFIGURATION = c -> {};
    }

    public static final class Config {
        public static final PropertyValue<Boolean> USE_SAVE_CAPTION = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityEditPanel.useSaveCaption", (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_ENTITY_MENU = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityEditPanel.includeEntityMenu", (boolean)true);
        public static final PropertyValue<Boolean> USE_FOCUS_ACTIVATION = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityEditPanel.useFocusActivation", (boolean)true);
        public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class);
        private static final Confirmer DEFAULT_INSERT_CONFIRMER = Confirmer.NONE;
        private static final Confirmer DEFAULT_UPDATE_CONFIRMER = new UpdateConfirmer();
        private static final Confirmer DEFAULT_DELETE_CONFIRMER = new DeleteConfirmer();
        private final EntityEditPanel editPanel;
        private final Set<EditControl> editControls;
        private final KeyboardShortcuts<KeyboardShortcut> shortcuts;
        private boolean clearAfterInsert = true;
        private boolean requestFocusAfterInsert = true;
        private boolean focusActivation = (Boolean)USE_FOCUS_ACTIVATION.get();
        private boolean includeEntityMenu = (Boolean)INCLUDE_ENTITY_MENU.get();
        private ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling = (ReferentialIntegrityErrorHandling)((Object)ReferentialIntegrityErrorHandling.REFERENTIAL_INTEGRITY_ERROR_HANDLING.get());
        private Confirmer insertConfirmer = DEFAULT_INSERT_CONFIRMER;
        private Confirmer deleteConfirmer = DEFAULT_DELETE_CONFIRMER;
        private Confirmer updateConfirmer = DEFAULT_UPDATE_CONFIRMER;

        private Config(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
            this.editControls = new HashSet<EditControl>(Arrays.asList(EditControl.values()));
            this.shortcuts = KEYBOARD_SHORTCUTS.copy();
        }

        private Config(Config config) {
            this.editPanel = config.editPanel;
            this.shortcuts = config.shortcuts.copy();
            this.editControls = new HashSet<EditControl>(config.editControls);
            this.clearAfterInsert = config.clearAfterInsert;
            this.requestFocusAfterInsert = config.requestFocusAfterInsert;
            this.referentialIntegrityErrorHandling = config.referentialIntegrityErrorHandling;
            this.focusActivation = config.focusActivation;
            this.insertConfirmer = config.insertConfirmer;
            this.updateConfirmer = config.updateConfirmer;
            this.deleteConfirmer = config.deleteConfirmer;
            this.includeEntityMenu = config.includeEntityMenu;
        }

        public EntityEditPanel editPanel() {
            return this.editPanel;
        }

        public Config editControls(EditControl ... editControls) {
            this.editControls.clear();
            this.editControls.addAll(Config.validateControlCodes(editControls));
            return this;
        }

        public Config clearAfterInsert(boolean clearAfterInsert) {
            this.clearAfterInsert = clearAfterInsert;
            return this;
        }

        public Config requestFocusAfterInsert(boolean requestFocusAfterInsert) {
            this.requestFocusAfterInsert = requestFocusAfterInsert;
            return this;
        }

        public Config referentialIntegrityErrorHandling(ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling) {
            this.referentialIntegrityErrorHandling = Objects.requireNonNull(referentialIntegrityErrorHandling);
            return this;
        }

        public Config focusActivation(boolean focusActivation) {
            this.focusActivation = focusActivation;
            return this;
        }

        public Config includeEntityMenu(boolean includeEntityMenu) {
            this.includeEntityMenu = includeEntityMenu;
            return this;
        }

        public Config insertConfirmer(Confirmer insertConfirmer) {
            this.insertConfirmer = Objects.requireNonNull(insertConfirmer);
            return this;
        }

        public Config deleteConfirmer(Confirmer deleteConfirmer) {
            this.deleteConfirmer = Objects.requireNonNull(deleteConfirmer);
            return this;
        }

        public Config updateConfirmer(Confirmer updateConfirmer) {
            this.updateConfirmer = Objects.requireNonNull(updateConfirmer);
            return this;
        }

        private static Set<EditControl> validateControlCodes(EditControl[] editControls) {
            if (editControls == null) {
                return Collections.emptySet();
            }
            for (EditControl editControl : editControls) {
                Objects.requireNonNull(editControl, "controlCode");
            }
            return new HashSet<EditControl>(Arrays.asList(editControls));
        }
    }

    public static interface Confirmer {
        public static final Confirmer NONE = dialogOwner -> true;

        public boolean confirm(JComponent var1);

        default public boolean confirm(JComponent dialogOwner, String message, String title) {
            return JOptionPane.showConfirmDialog(dialogOwner, message, title, 2) == 0;
        }
    }

    private final class InsertCommand
    implements Control.Command {
        private final boolean confirm;

        private InsertCommand(boolean confirm) {
            this.confirm = confirm;
        }

        public void execute() throws ValidationException {
            block3: {
                block2: {
                    if (!this.confirm) break block2;
                    if (!EntityEditPanel.this.confirmInsert()) break block3;
                }
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Insert.Task)EntityEditPanel.this.editModel().createInsert().prepare()).perform()).title(MESSAGES.getString("inserting"))).owner((Component)EntityEditPanel.this)).onResult(this::handleResult).onException(this::onException).execute();
            }
        }

        private void handleResult(EntityEditModel.Insert.Result result) {
            result.handle();
            if (EntityEditPanel.this.configuration.clearAfterInsert) {
                EntityEditPanel.this.editModel().defaults();
            }
            if (EntityEditPanel.this.configuration.requestFocusAfterInsert) {
                EntityEditPanel.this.requestAfterInsertFocus();
            }
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityEditPanel.this.onException(exception);
        }
    }

    private final class UpdateCommand
    implements Control.Command {
        private final boolean confirm;

        private UpdateCommand(boolean confirm) {
            this.confirm = confirm;
        }

        public void execute() throws ValidationException {
            block3: {
                block2: {
                    if (!this.confirm) break block2;
                    if (!EntityEditPanel.this.confirmUpdate()) break block3;
                }
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Update.Task)EntityEditPanel.this.editModel().createUpdate().prepare()).perform()).title(MESSAGES.getString("updating"))).owner((Component)EntityEditPanel.this)).onResult(this::handleResult).onException(this::onException).execute();
            }
        }

        private void handleResult(EntityEditModel.Update.Result result) {
            result.handle();
            EntityEditPanel.this.requestAfterUpdateFocus();
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityEditPanel.this.onException(exception);
        }
    }

    private final class DeleteCommand
    implements Control.Command {
        private final boolean confirm;

        private DeleteCommand(boolean confirm) {
            this.confirm = confirm;
        }

        public void execute() {
            block3: {
                block2: {
                    if (!this.confirm) break block2;
                    if (!EntityEditPanel.this.confirmDelete()) break block3;
                }
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Delete.Task)EntityEditPanel.this.editModel().createDelete().prepare()).perform()).title(MESSAGES.getString("deleting"))).owner((Component)EntityEditPanel.this)).onResult(this::handleResult).onException(this::onException).execute();
            }
        }

        private void handleResult(EntityEditModel.Delete.Result result) {
            result.handle();
            EntityEditPanel.this.requestInitialFocus();
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityEditPanel.this.onException(exception);
        }
    }

    public static enum EditControl {
        INSERT,
        UPDATE,
        DELETE,
        CLEAR;

    }

    public static enum KeyboardShortcut implements KeyboardShortcuts.Shortcut
    {
        SELECT_INPUT_FIELD(KeyboardShortcuts.keyStroke((int)73, (int)128)),
        DISPLAY_ENTITY_MENU(KeyboardShortcuts.keyStroke((int)86, (int)640));

        private final KeyStroke defaultKeystroke;

        private KeyboardShortcut(KeyStroke defaultKeystroke) {
            this.defaultKeystroke = defaultKeystroke;
        }

        public KeyStroke defaultKeystroke() {
            return this.defaultKeystroke;
        }
    }

    private static final class FocusActivationListener
    implements PropertyChangeListener {
        private FocusActivationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            Component focusedComponent = (Component)changeEvent.getNewValue();
            if (focusedComponent != null) {
                EntityEditPanel editPanel = null;
                EntityPanel entityPanel = FocusActivationListener.entityPanel(focusedComponent);
                if (entityPanel != null) {
                    if (entityPanel.containsEditPanel()) {
                        editPanel = entityPanel.editPanel();
                    }
                } else {
                    editPanel = (EntityEditPanel)Utilities.parentOfType(EntityEditPanel.class, (Component)focusedComponent);
                }
                if (editPanel != null && editPanel.configuration.focusActivation) {
                    editPanel.active.set((Object)true);
                }
            }
        }

        private static EntityPanel entityPanel(Component focusedComponent) {
            Component selectedComponent;
            if (focusedComponent instanceof JTabbedPane && (selectedComponent = ((JTabbedPane)focusedComponent).getSelectedComponent()) instanceof EntityPanel) {
                return (EntityPanel)selectedComponent;
            }
            return (EntityPanel)Utilities.parentOfType(EntityPanel.class, (Component)focusedComponent);
        }
    }

    private static final class DeleteConfirmer
    implements Confirmer {
        private DeleteConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmDelete((int)1), FrameworkMessages.delete());
        }
    }

    private static final class UpdateConfirmer
    implements Confirmer {
        private UpdateConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmUpdate(), FrameworkMessages.update());
        }
    }
}

