/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.i18n.Messages;
import is.codion.common.property.PropertyValue;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.EntityType;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ButtonPanelBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonType;
import is.codion.swing.common.ui.component.button.ToolBarBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.SwingEntityModel;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.EntityEditComponentPanel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityPanelBuilder;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.TabbedDetailLayout;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class EntityPanel
extends JPanel {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(EntityPanel.class.getName());
    private static final Consumer<Config> NO_CONFIGURATION = c -> {};
    static final Function<PanelState, PanelState> PANEL_STATE_MAPPER = new PanelStateMapper();
    private final SwingEntityModel entityModel;
    private final List<EntityPanel> detailPanels = new ArrayList<EntityPanel>();
    private final EntityEditPanel editPanel;
    private final EntityTablePanel tablePanel;
    private final JPanel editControlPanel;
    private final JPanel mainPanel;
    private final DetailLayout detailLayout;
    private final DetailController detailController;
    private final Event<EntityPanel> activateEvent = Event.event();
    private final Value<PanelState> editPanelState;
    private final Config configuration;
    private EntityPanel parentPanel;
    private EntityPanel previousSiblingPanel;
    private EntityPanel nextSiblingPanel;
    private boolean initialized = false;

    public EntityPanel(SwingEntityModel entityModel) {
        this(Objects.requireNonNull(entityModel), NO_CONFIGURATION);
    }

    public EntityPanel(SwingEntityModel entityModel, Consumer<Config> configuration) {
        this(Objects.requireNonNull(entityModel), null, entityModel.containsTableModel() ? new EntityTablePanel((SwingEntityTableModel)entityModel.tableModel()) : null, configuration);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel) {
        this(Objects.requireNonNull(entityModel), editPanel, NO_CONFIGURATION);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, Consumer<Config> configuration) {
        this(Objects.requireNonNull(entityModel), editPanel, entityModel.containsTableModel() ? new EntityTablePanel((SwingEntityTableModel)entityModel.tableModel()) : null, configuration);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityTablePanel tablePanel) {
        this(entityModel, tablePanel, NO_CONFIGURATION);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityTablePanel tablePanel, Consumer<Config> configuration) {
        this(entityModel, null, tablePanel, configuration);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, EntityTablePanel tablePanel) {
        this(entityModel, editPanel, tablePanel, NO_CONFIGURATION);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, EntityTablePanel tablePanel, Consumer<Config> configuration) {
        Objects.requireNonNull(entityModel, "entityModel");
        this.entityModel = entityModel;
        this.editPanel = editPanel;
        this.tablePanel = tablePanel;
        this.editControlPanel = this.createEditControlPanel();
        this.mainPanel = (JPanel)Components.borderLayoutPanel().build();
        this.configuration = this.configure(configuration);
        this.detailLayout = this.configuration.detailLayout.apply(this);
        this.detailController = this.detailLayout.controller().orElse(new DetailController(){});
        this.editPanelState = Value.nonNull((Object)((Object)PanelState.EMBEDDED)).initialValue((Object)this.configuration.editPanelState).listener(this::updateEditPanelState).build();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI((JComponent[])new JComponent[]{this.editControlPanel, this.mainPanel, this.tablePanel, this.editPanel});
        if (this.detailPanels != null) {
            Utilities.updateUI(this.detailPanels);
        }
        if (this.detailLayout != null) {
            this.detailLayout.updateUI();
        }
    }

    public final <T extends SwingEntityModel> T model() {
        return (T)this.entityModel;
    }

    public final <T extends SwingEntityEditModel> T editModel() {
        return (T)((SwingEntityEditModel)this.entityModel.editModel());
    }

    public final <T extends SwingEntityTableModel> T tableModel() {
        return (T)((SwingEntityTableModel)this.entityModel.tableModel());
    }

    public final Optional<EntityPanel> parentPanel() {
        return Optional.ofNullable(this.parentPanel);
    }

    public final void addDetailPanels(EntityPanel ... detailPanels) {
        Objects.requireNonNull(detailPanels, "detailPanels");
        for (EntityPanel detailPanel : detailPanels) {
            this.addDetailPanel(detailPanel);
        }
    }

    public final void addDetailPanel(EntityPanel detailPanel) {
        this.throwIfInitialized();
        if (this.detailPanels.contains(Objects.requireNonNull(detailPanel))) {
            throw new IllegalArgumentException("Panel already contains detail panel: " + detailPanel);
        }
        EntityPanel.addEntityPanelAndLinkSiblings(detailPanel, this.detailPanels);
        detailPanel.setParentPanel(this);
    }

    public final <T extends EntityPanel> T initialize() {
        if (!this.initialized) {
            try {
                this.setFocusCycleRoot(true);
                this.setupToggleEditPanelControl();
                this.initializeUI();
                this.initializeEditPanel();
                this.initializeTablePanel();
                this.setupKeyboardActions();
            }
            finally {
                this.initialized = true;
            }
        }
        return (T)this;
    }

    public final <T extends EntityEditPanel> T editPanel() {
        if (this.editPanel == null) {
            throw new IllegalStateException("No edit panel available");
        }
        return (T)this.editPanel;
    }

    public final boolean containsEditPanel() {
        return this.editPanel != null;
    }

    public final <T extends EntityTablePanel> T tablePanel() {
        if (this.tablePanel == null) {
            throw new IllegalStateException("No table panel available");
        }
        return (T)this.tablePanel;
    }

    public final boolean containsTablePanel() {
        return this.tablePanel != null;
    }

    public final void addKeyEvent(KeyEvents.Builder keyEventBuilder) {
        Objects.requireNonNull(keyEventBuilder);
        keyEventBuilder.enable(new JComponent[]{this});
        if (this.containsEditPanel()) {
            keyEventBuilder.enable(new JComponent[]{this.editControlPanel});
        }
    }

    public final void removeKeyEvent(KeyEvents.Builder keyEventBuilder) {
        Objects.requireNonNull(keyEventBuilder);
        keyEventBuilder.disable(new JComponent[]{this});
        if (this.containsEditPanel()) {
            keyEventBuilder.disable(new JComponent[]{this.editControlPanel});
        }
    }

    public final Collection<EntityPanel> activeDetailPanels() {
        return this.detailPanels.stream().filter(detailPanel -> this.entityModel.activeDetailModels().contains((Object)detailPanel.entityModel)).collect(Collectors.toList());
    }

    public final <T extends EntityPanel> T detailPanel(EntityType entityType) {
        Objects.requireNonNull(entityType);
        return (T)this.detailPanels.stream().filter(detailPanel -> detailPanel.model().entityType().equals(entityType)).findFirst().orElseThrow(() -> new IllegalArgumentException("Detail panel for entity: " + entityType + " not found in panel: " + this));
    }

    public final Collection<EntityPanel> detailPanels() {
        return Collections.unmodifiableCollection(this.detailPanels);
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.configuration.caption;
    }

    public final String caption() {
        return this.configuration.caption;
    }

    public final Optional<String> description() {
        return Optional.ofNullable(this.configuration.description);
    }

    public final Optional<ImageIcon> icon() {
        return Optional.ofNullable(this.configuration.icon);
    }

    public final EventObserver<EntityPanel> activateEvent() {
        return this.activateEvent.observer();
    }

    public final void activate() {
        Window editPanelWindow;
        this.activateEvent.accept((Object)this);
        this.initialize();
        Window parentWindow = Utilities.parentWindow((Component)this);
        if (parentWindow != null) {
            parentWindow.toFront();
        }
        if ((editPanelWindow = Utilities.parentWindow((Component)this.editControlPanel)) != null) {
            editPanelWindow.toFront();
        }
        this.requestInitialFocus();
    }

    public final void displayException(Exception exception) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            focusOwner = this;
        }
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
    }

    public final Value<PanelState> editPanelState() {
        return this.editPanelState;
    }

    public final void requestInitialFocus() {
        if (this.editPanel != null && this.editPanel.isShowing()) {
            this.editPanel.requestInitialFocus();
        } else if (this.tablePanel != null) {
            this.tablePanel.table().requestFocus();
        } else if (this.getComponentCount() > 0) {
            this.getComponents()[0].requestFocus();
        } else {
            this.requestFocus();
        }
    }

    public void savePreferences() {
        this.detailPanels.forEach(EntityPanel::savePreferences);
    }

    public static Builder builder(EntityType entityType) {
        return new EntityPanelBuilder(SwingEntityModel.builder((EntityType)entityType));
    }

    public static Builder builder(SwingEntityModel.Builder modelBuilder) {
        return new EntityPanelBuilder(modelBuilder);
    }

    public static Builder builder(SwingEntityModel model) {
        return new EntityPanelBuilder(model);
    }

    protected void initializeUI() {
        this.setLayout(Layouts.borderLayout());
        this.add((Component)this.createMainComponent(), "Center");
    }

    protected JPanel createEditBasePanel(EntityEditPanel editPanel) {
        return (JPanel)Components.panel((LayoutManager)new FlowLayout(this.configuration.horizontalControlLayout() ? 1 : 3, 0, 0)).add((JComponent)editPanel).build();
    }

    protected JComponent createControlComponent(Controls controls) {
        if (Objects.requireNonNull(controls).empty()) {
            return null;
        }
        return this.configuration.toolbarControls ? this.createControlToolBar(controls) : this.createControlPanel(controls);
    }

    protected Controls createControls() {
        Controls controls = Controls.controls();
        if (this.containsEditPanel()) {
            controls.addAll(((EntityEditPanel)this.editPanel()).controls());
        }
        if (this.containsTablePanel()) {
            controls.add((Action)this.createRefreshTableControl());
        }
        return controls;
    }

    protected final JComponent createMainComponent() {
        return this.detailPanels.isEmpty() ? this.mainPanel() : this.detailLayout().layout().orElse(this.mainPanel());
    }

    protected final JPanel mainPanel() {
        if (this.editPanel != null && this.editControlPanel.getComponents().length == 0) {
            this.editControlPanel.add((Component)this.createEditBasePanel(this.editPanel), "Center");
        }
        if (this.tablePanel != null && this.mainPanel.getComponents().length == 0) {
            this.mainPanel.add((Component)this.tablePanel, "Center");
        }
        this.mainPanel.setMinimumSize(new Dimension(0, 0));
        return this.mainPanel;
    }

    protected final void setupKeyboardActions() {
        if (this.containsTablePanel()) {
            this.tablePanel.control(EntityTablePanel.TableControl.REQUEST_TABLE_FOCUS).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.REQUEST_TABLE_FOCUS).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
            this.tablePanel.control(EntityTablePanel.TableControl.TOGGLE_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_CONDITION_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
            this.tablePanel.control(EntityTablePanel.TableControl.SELECT_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_CONDITION_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
            this.tablePanel.control(EntityTablePanel.TableControl.TOGGLE_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_FILTER_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
            this.tablePanel.control(EntityTablePanel.TableControl.SELECT_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_FILTER_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
            KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.REQUEST_SEARCH_FIELD_FOCUS).get())).action((Action)this.createRequestTableSearchFieldControl()).condition(1).enable(new JComponent[]{this});
            if (this.containsEditPanel()) {
                this.tablePanel.control(EntityTablePanel.TableControl.REQUEST_TABLE_FOCUS).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.REQUEST_TABLE_FOCUS).get())).condition(1).action((Action)control).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.control(EntityTablePanel.TableControl.TOGGLE_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_CONDITION_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.control(EntityTablePanel.TableControl.SELECT_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_CONDITION_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.control(EntityTablePanel.TableControl.TOGGLE_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_FILTER_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.control(EntityTablePanel.TableControl.SELECT_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_FILTER_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this.editControlPanel}));
            }
        }
        if (this.containsEditPanel()) {
            KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.REQUEST_EDIT_PANEL_FOCUS).get())).condition(1).action((Action)this.createRequestEditPanelFocusControl()).enable(new JComponent[]{this});
            KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_INPUT_FIELD).get())).condition(1).action((Action)this.createSelectInputComponentControl()).enable(new JComponent[]{this, this.editControlPanel});
            KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_EDIT_PANEL).get())).condition(1).action((Action)this.createToggleEditPanelControl()).enable(new JComponent[]{this, this.editControlPanel});
        }
        if (this.configuration.useKeyboardNavigation) {
            this.setupNavigation();
        }
    }

    protected final void setupNavigation() {
        KeyEvents.Builder navigateUp = KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.NAVIGATE_UP).get())).condition(1).action((Action)new Navigate(Direction.UP));
        KeyEvents.Builder navigateDown = KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.NAVIGATE_DOWN).get())).condition(1).action((Action)new Navigate(Direction.DOWN));
        KeyEvents.Builder navigateRight = KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.NAVIGATE_RIGHT).get())).condition(1).action((Action)new Navigate(Direction.RIGHT));
        KeyEvents.Builder navigateLeft = KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.NAVIGATE_LEFT).get())).condition(1).action((Action)new Navigate(Direction.LEFT));
        navigateUp.enable(new JComponent[]{this});
        navigateDown.enable(new JComponent[]{this});
        navigateRight.enable(new JComponent[]{this});
        navigateLeft.enable(new JComponent[]{this});
        if (this.containsEditPanel()) {
            navigateUp.enable(new JComponent[]{this.editControlPanel});
            navigateDown.enable(new JComponent[]{this.editControlPanel});
            navigateRight.enable(new JComponent[]{this.editControlPanel});
            navigateLeft.enable(new JComponent[]{this.editControlPanel});
        }
    }

    protected final Control createSelectInputComponentControl() {
        return Control.control(this::selectInputComponent);
    }

    protected final Control createRequestEditPanelFocusControl() {
        return Control.control(this::requestEditPanelFocus);
    }

    protected final Control createRequestTableSearchFieldControl() {
        return Control.control(this.tablePanel.table().searchField()::requestFocusInWindow);
    }

    protected final Control createToggleEditPanelControl() {
        return Control.builder(this::toggleEditPanelState).smallIcon((Icon)FrameworkIcons.instance().editPanel()).description(MESSAGES.getString("toggle_edit")).build();
    }

    protected final Control createRefreshTableControl() {
        return Control.builder(() -> this.tableModel().refresh()).name(Messages.refresh()).enabled(this.editPanel == null ? null : this.editPanel.active()).description(Messages.refreshTip() + " (ALT-" + Messages.refreshMnemonic() + ")").mnemonic(Messages.refreshMnemonic()).smallIcon((Icon)FrameworkIcons.instance().refresh()).build();
    }

    protected final void initializeEditPanel() {
        if (this.editPanel != null) {
            JComponent controlComponent;
            this.editPanel.initialize();
            if (this.configuration.includeControls && (controlComponent = this.createControlComponent(this.createControls())) != null) {
                this.editControlPanel.add((Component)controlComponent, this.configuration.controlComponentConstraints);
            }
            this.updateEditPanelState();
        }
    }

    protected final void initializeTablePanel() {
        if (this.tablePanel != null) {
            this.tablePanel.table().doubleClickAction().mapNull(() -> Control.control((Control.Command)new ShowHiddenEditPanel()));
            this.tablePanel.initialize();
        }
    }

    protected final <T extends DetailLayout> T detailLayout() {
        return (T)this.detailLayout;
    }

    protected final <T extends DetailController> T detailController() {
        return (T)this.detailController;
    }

    private JPanel createEditControlPanel() {
        if (this.editPanel == null) {
            return null;
        }
        return (JPanel)((BorderLayoutPanelBuilder)((BorderLayoutPanelBuilder)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().minimumSize(new Dimension(0, 0))).border(BorderFactory.createEmptyBorder((Integer)Layouts.GAP.get(), 0, (Integer)Layouts.GAP.get(), 0))).mouseListener((MouseListener)new ActivateOnMouseClickListener())).build();
    }

    final void setParentPanel(EntityPanel parentPanel) {
        if (this.parentPanel != null) {
            throw new IllegalStateException("Parent panel has already been set for " + this);
        }
        this.parentPanel = Objects.requireNonNull(parentPanel);
    }

    final void setPreviousSiblingPanel(EntityPanel previousSiblingPanel) {
        this.previousSiblingPanel = Objects.requireNonNull(previousSiblingPanel);
    }

    final void setNextSiblingPanel(EntityPanel nextSiblingPanel) {
        this.nextSiblingPanel = Objects.requireNonNull(nextSiblingPanel);
    }

    static void addEntityPanelAndLinkSiblings(EntityPanel detailPanel, List<EntityPanel> entityPanels) {
        if (!entityPanels.isEmpty()) {
            EntityPanel leftSibling = entityPanels.get(entityPanels.size() - 1);
            detailPanel.setPreviousSiblingPanel(leftSibling);
            leftSibling.setNextSiblingPanel(detailPanel);
            EntityPanel firstPanel = entityPanels.get(0);
            detailPanel.setNextSiblingPanel(firstPanel);
            firstPanel.setPreviousSiblingPanel(detailPanel);
        }
        entityPanels.add(detailPanel);
    }

    final WindowType windowType() {
        return this.configuration.windowType;
    }

    private JToolBar createControlToolBar(Controls controls) {
        return (JToolBar)((ToolBarBuilder)Components.toolBar((Controls)controls).orientation(this.configuration.horizontalControlLayout() ? 0 : 1)).build();
    }

    private JPanel createControlPanel(Controls controls) {
        if (this.configuration.horizontalControlLayout()) {
            return (JPanel)Components.flowLayoutPanel((int)1).add(((ButtonPanelBuilder)Components.buttonPanel((Controls)controls).toggleButtonType(ToggleButtonType.CHECKBOX)).build()).build();
        }
        return (JPanel)Components.borderLayoutPanel().northComponent(((ButtonPanelBuilder)((ButtonPanelBuilder)((ButtonPanelBuilder)Components.buttonPanel((Controls)controls).orientation(1)).buttonBuilder(buttonBuilder -> buttonBuilder.horizontalAlignment(10))).toggleButtonType(ToggleButtonType.CHECKBOX)).build()).build();
    }

    private void setupToggleEditPanelControl() {
        if (this.containsTablePanel() && this.containsEditPanel() && this.configuration.includeToggleEditPanelControl) {
            this.tablePanel.addToolBarControls((Controls)Controls.builder().control(this.createToggleEditPanelControl()).build());
        }
    }

    private void requestEditPanelFocus() {
        if (this.editPanelState.isEqualTo((Object)PanelState.HIDDEN)) {
            this.editPanelState.set((Object)PanelState.EMBEDDED);
        }
        ((EntityEditComponentPanel)this.editPanel()).requestInitialFocus();
    }

    private void selectInputComponent() {
        if (this.editPanelState.isEqualTo((Object)PanelState.HIDDEN)) {
            this.editPanelState.set((Object)PanelState.EMBEDDED);
        }
        ((EntityEditComponentPanel)this.editPanel()).selectInputComponent();
    }

    private void updateEditPanelState() {
        switch ((PanelState)((Object)this.editPanelState.get())) {
            case WINDOW: {
                this.showEditWindow();
                break;
            }
            case EMBEDDED: {
                this.hideEditWindow();
                this.mainPanel.add((Component)this.editControlPanel, "North");
                break;
            }
            case HIDDEN: {
                this.hideEditWindow();
                this.mainPanel.remove(this.editControlPanel);
                break;
            }
            default: {
                throw new IllegalStateException("Unkown panel state: " + this.editPanelState.get());
            }
        }
        this.revalidate();
        this.requestInitialFocus();
    }

    private void toggleEditPanelState() {
        this.editPanelState.map(PANEL_STATE_MAPPER);
    }

    private void showEditWindow() {
        JPanel basePanel = (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().border(BorderFactory.createEmptyBorder((Integer)Layouts.GAP.get(), (Integer)Layouts.GAP.get(), 0, (Integer)Layouts.GAP.get()))).centerComponent((JComponent)this.editControlPanel).build();
        if (this.configuration.windowType == WindowType.FRAME) {
            this.showEditFrame(basePanel);
        } else {
            this.showEditDialog(basePanel);
        }
    }

    private void showEditFrame(JPanel basePanel) {
        Windows.frame((JComponent)basePanel).locationRelativeTo((Component)(this.tablePanel == null ? this : this.tablePanel)).title(this.configuration.caption).icon(this.configuration.icon).defaultCloseOperation(2).onClosed(windowEvent -> this.editPanelState.set((Object)PanelState.HIDDEN)).build().setVisible(true);
    }

    private void showEditDialog(JPanel basePanel) {
        ((ComponentDialogBuilder)((ComponentDialogBuilder)((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)basePanel).owner((Component)this)).locationRelativeTo((Component)(this.tablePanel == null ? this : this.tablePanel))).title(this.configuration.caption)).icon(this.configuration.icon)).modal(false).disposeOnEscape(this.configuration.disposeEditDialogOnEscape).onClosed(windowEvent -> this.editPanelState.set((Object)PanelState.HIDDEN)).build().setVisible(true);
    }

    private void hideEditWindow() {
        Window editPanelWindow = Utilities.parentWindow((Component)this.editControlPanel);
        if (editPanelWindow != null) {
            editPanelWindow.dispose();
        }
    }

    private void throwIfInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Method must be called before the panel is initialized");
        }
    }

    private Config configure(Consumer<Config> configuration) {
        Config config = new Config(this);
        Objects.requireNonNull(configuration).accept(config);
        return new Config(config);
    }

    public static final class Config {
        public static final PropertyValue<Boolean> USE_KEYBOARD_NAVIGATION = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.useKeyboardNavigation", (boolean)true);
        public static final PropertyValue<Boolean> DISPOSE_EDIT_DIALOG_ON_ESCAPE = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.disposeEditDialogOnEscape", (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_TOGGLE_EDIT_PANEL_CONTROL = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.includeToggleEditPanelControl", (boolean)true);
        public static final PropertyValue<Boolean> TOOLBAR_CONTROLS = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.toolbarControls", (boolean)false);
        public static final PropertyValue<WindowType> WINDOW_TYPE = Configuration.enumValue((String)"is.codion.swing.framework.ui.EntityPanel.windowType", WindowType.class, (Enum)WindowType.DIALOG);
        public static final PropertyValue<String> CONTROL_PANEL_CONSTRAINTS = Configuration.stringValue((String)"is.codion.swing.framework.ui.EntityPanel.controlPanelConstraints", (String)"East");
        public static final PropertyValue<String> CONTROL_TOOLBAR_CONSTRAINTS = Configuration.stringValue((String)"is.codion.swing.framework.ui.EntityPanel.controlToolbarConstraints", (String)"West");
        public static final PropertyValue<Boolean> INCLUDE_CONTROLS = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.includeControls", (boolean)true);
        public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class);
        private final EntityPanel entityPanel;
        private final KeyboardShortcuts<KeyboardShortcut> shortcuts;
        private Function<EntityPanel, DetailLayout> detailLayout = new DefaultDetailLayout();
        private boolean disposeEditDialogOnEscape = (Boolean)DISPOSE_EDIT_DIALOG_ON_ESCAPE.get();
        private boolean toolbarControls = (Boolean)TOOLBAR_CONTROLS.get();
        private boolean includeToggleEditPanelControl = (Boolean)INCLUDE_TOGGLE_EDIT_PANEL_CONTROL.get();
        private String controlComponentConstraints = (Boolean)TOOLBAR_CONTROLS.get() != false ? (String)CONTROL_TOOLBAR_CONSTRAINTS.get() : (String)CONTROL_PANEL_CONSTRAINTS.get();
        private boolean includeControls = (Boolean)INCLUDE_CONTROLS.get();
        private boolean useKeyboardNavigation = (Boolean)USE_KEYBOARD_NAVIGATION.get();
        private WindowType windowType = (WindowType)((Object)WINDOW_TYPE.get());
        private PanelState editPanelState = PanelState.EMBEDDED;
        private String caption;
        private String description;
        private ImageIcon icon;

        private Config(EntityPanel entityPanel) {
            this.entityPanel = entityPanel;
            this.shortcuts = KEYBOARD_SHORTCUTS.copy();
            this.caption = entityPanel.model().entityDefinition().caption();
        }

        private Config(Config config) {
            this.entityPanel = config.entityPanel;
            this.shortcuts = config.shortcuts.copy();
            this.detailLayout = config.detailLayout;
            this.toolbarControls = config.toolbarControls;
            this.includeToggleEditPanelControl = config.includeToggleEditPanelControl;
            this.controlComponentConstraints = config.controlComponentConstraints;
            this.includeControls = config.includeControls;
            this.useKeyboardNavigation = config.useKeyboardNavigation;
            this.editPanelState = config.editPanelState;
            this.caption = config.caption;
            this.description = config.description;
            this.icon = config.icon;
            this.disposeEditDialogOnEscape = config.disposeEditDialogOnEscape;
            this.windowType = config.windowType;
        }

        public EntityPanel entityPanel() {
            return this.entityPanel;
        }

        public Config caption(String caption) {
            this.caption = Objects.requireNonNull(caption);
            return this;
        }

        public Config description(String description) {
            this.description = Objects.requireNonNull(description);
            return this;
        }

        public Config icon(ImageIcon icon) {
            this.icon = Objects.requireNonNull(icon);
            return this;
        }

        public Config detailLayout(Function<EntityPanel, DetailLayout> detailLayout) {
            this.detailLayout = Objects.requireNonNull(detailLayout);
            return this;
        }

        public Config toolbarControls(boolean toolbarControls) {
            this.toolbarControls = toolbarControls;
            return this;
        }

        public Config controlComponentConstraints(String controlComponentConstraints) {
            switch (Objects.requireNonNull(controlComponentConstraints)) {
                case "South": 
                case "North": 
                case "East": 
                case "West": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Control component constraints must be one of BorderLayout.SOUTH, NORTH, EAST or WEST");
                }
            }
            this.controlComponentConstraints = controlComponentConstraints;
            return this;
        }

        public Config includeToggleEditPanelControl(boolean includeToggleEditPanelControl) {
            this.includeToggleEditPanelControl = includeToggleEditPanelControl;
            return this;
        }

        public Config includeControls(boolean includeControls) {
            this.includeControls = includeControls;
            return this;
        }

        public Config useKeyboardNavigation(boolean useKeyboardNavigation) {
            this.useKeyboardNavigation = useKeyboardNavigation;
            return this;
        }

        public Config windowType(WindowType windowType) {
            this.windowType = Objects.requireNonNull(windowType);
            return this;
        }

        public Config keyStrokes(Consumer<KeyboardShortcuts<KeyboardShortcut>> shortcuts) {
            Objects.requireNonNull(shortcuts).accept(this.shortcuts);
            return this;
        }

        public Config editPanelState(PanelState editPanelState) {
            this.editPanelState = Objects.requireNonNull(editPanelState);
            return this;
        }

        public Config disposeEditDialogOnEscape(boolean disposeEditDialogOnEscape) {
            this.disposeEditDialogOnEscape = disposeEditDialogOnEscape;
            return this;
        }

        private boolean horizontalControlLayout() {
            return this.controlComponentConstraints.equals("South") || this.controlComponentConstraints.equals("North");
        }

        private static final class DefaultDetailLayout
        implements Function<EntityPanel, DetailLayout> {
            private DefaultDetailLayout() {
            }

            @Override
            public DetailLayout apply(EntityPanel entityPanel) {
                return TabbedDetailLayout.builder(entityPanel).build();
            }
        }
    }

    public static interface DetailLayout {
        public static final Function<EntityPanel, DetailLayout> NONE = entityPanel -> new DetailLayout(){};

        default public void updateUI() {
        }

        default public Optional<JComponent> layout() {
            return Optional.empty();
        }

        default public Optional<DetailController> controller() {
            return Optional.empty();
        }
    }

    public static interface DetailController {
        default public Value<PanelState> panelState(EntityPanel detailPanel) {
            throw new UnsupportedOperationException("panelState() has not been implemented for detail controller: " + this.getClass());
        }

        default public void activated(EntityPanel detailPanel) {
        }
    }

    public static enum PanelState {
        WINDOW,
        EMBEDDED,
        HIDDEN;

    }

    public static enum KeyboardShortcut implements KeyboardShortcuts.Shortcut
    {
        REQUEST_TABLE_FOCUS(KeyboardShortcuts.keyStroke((int)84, (int)128)),
        TOGGLE_CONDITION_PANEL(KeyboardShortcuts.keyStroke((int)83, (int)640)),
        SELECT_CONDITION_PANEL(KeyboardShortcuts.keyStroke((int)83, (int)128)),
        TOGGLE_FILTER_PANEL(KeyboardShortcuts.keyStroke((int)70, (int)640)),
        SELECT_FILTER_PANEL(KeyboardShortcuts.keyStroke((int)70, (int)192)),
        REQUEST_SEARCH_FIELD_FOCUS(KeyboardShortcuts.keyStroke((int)70, (int)128)),
        REQUEST_EDIT_PANEL_FOCUS(KeyboardShortcuts.keyStroke((int)69, (int)128)),
        SELECT_INPUT_FIELD(KeyboardShortcuts.keyStroke((int)73, (int)128)),
        TOGGLE_EDIT_PANEL(KeyboardShortcuts.keyStroke((int)69, (int)640)),
        NAVIGATE_UP(KeyboardShortcuts.keyStroke((int)38, (int)640)),
        NAVIGATE_DOWN(KeyboardShortcuts.keyStroke((int)40, (int)640)),
        NAVIGATE_RIGHT(KeyboardShortcuts.keyStroke((int)39, (int)640)),
        NAVIGATE_LEFT(KeyboardShortcuts.keyStroke((int)37, (int)640));

        private final KeyStroke defaultKeystroke;

        private KeyboardShortcut(KeyStroke defaultKeystroke) {
            this.defaultKeystroke = defaultKeystroke;
        }

        public KeyStroke defaultKeystroke() {
            return this.defaultKeystroke;
        }
    }

    private final class Navigate
    extends AbstractAction {
        private final Direction direction;

        private Navigate(Direction direction) {
            super("Navigate " + direction);
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this.direction) {
                case LEFT: {
                    if (EntityPanel.this.previousSiblingPanel == null) break;
                    EntityPanel.this.previousSiblingPanel.activate();
                    break;
                }
                case RIGHT: {
                    if (EntityPanel.this.nextSiblingPanel == null) break;
                    EntityPanel.this.nextSiblingPanel.activate();
                    break;
                }
                case UP: {
                    if (EntityPanel.this.parentPanel == null) break;
                    EntityPanel.this.parentPanel.activate();
                    break;
                }
                case DOWN: {
                    this.activeDetailPanel().ifPresent(EntityPanel::activate);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown direction: " + this.direction);
                }
            }
        }

        private Optional<EntityPanel> activeDetailPanel() {
            return EntityPanel.this.activeDetailPanels().stream().findFirst();
        }
    }

    public static enum Direction {
        UP,
        DOWN,
        RIGHT,
        LEFT;

    }

    private final class ActivateOnMouseClickListener
    extends MouseAdapter {
        private ActivateOnMouseClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            EntityPanel.this.editPanel.requestAfterUpdateFocus();
        }
    }

    public static enum WindowType {
        FRAME,
        DIALOG;

    }

    private final class ShowHiddenEditPanel
    implements Control.Command {
        private ShowHiddenEditPanel() {
        }

        public void execute() {
            Window editPanelWindow;
            if (EntityPanel.this.containsEditPanel() && EntityPanel.this.editPanelState.isEqualTo((Object)PanelState.HIDDEN)) {
                EntityPanel.this.editPanelState.set((Object)PanelState.WINDOW);
            }
            if ((editPanelWindow = Utilities.parentWindow((Component)EntityPanel.this.editControlPanel)) != null) {
                editPanelWindow.toFront();
            }
        }
    }

    private static final class PanelStateMapper
    implements Function<PanelState, PanelState> {
        private PanelStateMapper() {
        }

        @Override
        public PanelState apply(PanelState state) {
            switch (state) {
                case HIDDEN: {
                    return PanelState.EMBEDDED;
                }
                case EMBEDDED: {
                    return PanelState.WINDOW;
                }
                case WINDOW: {
                    return PanelState.HIDDEN;
                }
            }
            throw new IllegalArgumentException("Unknown panel state: " + state);
        }
    }

    public static interface Builder {
        public EntityType entityType();

        public Builder caption(String var1);

        public Optional<String> caption();

        public Builder description(String var1);

        public Optional<String> description();

        public Builder icon(ImageIcon var1);

        public Optional<ImageIcon> icon();

        public Builder detailPanel(Builder var1);

        public Builder refreshWhenInitialized(boolean var1);

        public Builder conditionPanelVisible(boolean var1);

        public Builder filterPanelVisible(boolean var1);

        public Builder detailLayout(Function<EntityPanel, DetailLayout> var1);

        public Builder preferredSize(Dimension var1);

        public Builder panel(Class<? extends EntityPanel> var1);

        public Builder editPanel(Class<? extends EntityEditPanel> var1);

        public Builder tablePanel(Class<? extends EntityTablePanel> var1);

        public Builder onBuildPanel(Consumer<EntityPanel> var1);

        public Builder onBuildEditPanel(Consumer<EntityEditPanel> var1);

        public Builder onBuildTablePanel(Consumer<EntityTablePanel> var1);

        public EntityPanel build(EntityConnectionProvider var1);

        public EntityPanel build(SwingEntityModel var1);
    }
}

