/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.tabbedpane.TabbedPaneBuilder;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.ui.EntityApplicationPanel;
import is.codion.swing.framework.ui.EntityPanel;
import java.awt.BorderLayout;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedApplicationLayout
implements EntityApplicationPanel.ApplicationLayout {
    public static final PropertyValue<Integer> TAB_PLACEMENT = Configuration.integerValue((String)"is.codion.swing.framework.ui.TabbedApplicationLayout.tabPlacement", (int)1);
    private final EntityApplicationPanel<?> applicationPanel;
    private JTabbedPane tabbedPane;

    public TabbedApplicationLayout(EntityApplicationPanel<?> applicationPanel) {
        this.applicationPanel = Objects.requireNonNull(applicationPanel);
    }

    @Override
    public JComponent layout() {
        if (this.tabbedPane != null) {
            throw new IllegalStateException("EntityApplicationPanel has already been laid out: " + this.applicationPanel);
        }
        this.tabbedPane = (JTabbedPane)((TabbedPaneBuilder)Components.tabbedPane().tabPlacement(((Integer)TAB_PLACEMENT.get()).intValue()).focusable(false)).changeListener((ChangeListener)new InitializeSelectedPanelListener()).build();
        this.applicationPanel.entityPanels().forEach(this::addTab);
        return ((BorderLayoutPanelBuilder)Components.borderLayoutPanel((BorderLayout)new BorderLayout()).centerComponent((JComponent)this.tabbedPane).border(BorderFactory.createEmptyBorder(0, (Integer)Layouts.GAP.get(), 0, (Integer)Layouts.GAP.get()))).build();
    }

    @Override
    public final void activated(EntityPanel entityPanel) {
        Objects.requireNonNull(entityPanel);
        if (this.tabbedPane == null) {
            throw new IllegalStateException("EntityApplicationPanel has not been laid out");
        }
        if (this.tabbedPane.indexOfComponent(entityPanel) != -1) {
            this.tabbedPane.setSelectedComponent(entityPanel);
        }
    }

    public final JTabbedPane tabbedPane() {
        return this.tabbedPane;
    }

    protected final <T extends EntityApplicationPanel<?>> T applicationPanel() {
        return (T)this.applicationPanel;
    }

    private void addTab(EntityPanel entityPanel) {
        this.tabbedPane.addTab(entityPanel.caption(), entityPanel);
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, entityPanel.description().orElse(null));
        this.tabbedPane.setIconAt(this.tabbedPane.getTabCount() - 1, entityPanel.icon().orElse(null));
    }

    private final class InitializeSelectedPanelListener
    implements ChangeListener {
        private InitializeSelectedPanelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (TabbedApplicationLayout.this.tabbedPane.getTabCount() > 0) {
                ((EntityPanel)TabbedApplicationLayout.this.tabbedPane.getSelectedComponent()).activate();
            }
        }
    }
}

