/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.common.value.Value;
import is.codion.framework.model.DefaultEntityModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.tabbedpane.TabbedPaneBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityModel;
import is.codion.swing.framework.ui.EntityPanel;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public final class TabbedDetailLayout
implements EntityPanel.DetailLayout {
    public static final PropertyValue<Boolean> INCLUDE_CONTROLS = Configuration.booleanValue((String)"is.codion.swing.framework.ui.TabbedPanelLayout.includeControls", (boolean)true);
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(TabbedDetailLayout.class.getName());
    public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class);
    private static final int RESIZE_AMOUNT = 30;
    private static final String DETAIL_TABLES = "detail_tables";
    private static final double DEFAULT_SPLIT_PANE_RESIZE_WEIGHT = 0.5;
    private static final int DETAIL_WINDOW_OFFSET = 38;
    private static final double DETAIL_WINDOW_SIZE_RATIO = 0.66;
    private final EntityPanel entityPanel;
    private final TabbedDetailController detailController;
    private final boolean includeControls;
    private final double splitPaneResizeWeight;
    private final KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts;
    private final EntityPanel.WindowType windowType;
    private JTabbedPane tabbedPane;
    private JSplitPane splitPane;
    private Window panelWindow;
    private EntityPanel.PanelState panelState = EntityPanel.PanelState.EMBEDDED;

    private TabbedDetailLayout(DefaultBuilder builder) {
        this.entityPanel = builder.entityPanel;
        this.windowType = builder.windowType;
        this.panelState = builder.panelState;
        this.includeControls = builder.includeControls;
        this.splitPaneResizeWeight = builder.splitPaneResizeWeight;
        this.detailController = new TabbedDetailController();
        this.keyboardShortcuts = builder.keyboardShortcuts;
    }

    @Override
    public void updateUI() {
        Utilities.updateUI((JComponent[])new JComponent[]{this.tabbedPane, this.splitPane});
    }

    @Override
    public Optional<JComponent> layout() {
        if (this.entityPanel.detailPanels().isEmpty()) {
            throw new IllegalStateException("EntityPanel " + this.entityPanel + " has no detail panels");
        }
        if (this.splitPane != null) {
            throw new IllegalStateException("EntityPanel " + this.entityPanel + " has already been laid out");
        }
        this.entityPanel.detailPanels().forEach(this::bindEvents);
        this.splitPane = this.createSplitPane(this.entityPanel.mainPanel());
        this.tabbedPane = this.createTabbedPane(this.entityPanel.detailPanels());
        this.setupControls(this.entityPanel);
        this.initializePanelState();
        return Optional.of(this.splitPane);
    }

    @Override
    public Optional<EntityPanel.DetailController> controller() {
        return Optional.of(this.detailController);
    }

    public static Builder builder(EntityPanel entityPanel) {
        return new DefaultBuilder(entityPanel);
    }

    private void bindEvents(EntityPanel detailPanel) {
        detailPanel.activateEvent().addConsumer(this.detailController::activated);
        detailPanel.addKeyEvent(KeyEvents.builder((KeyStroke)((KeyStroke)this.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.RESIZE_RIGHT).get())).condition(1).action((Action)new ResizeHorizontally(detailPanel, true)));
        detailPanel.addKeyEvent(KeyEvents.builder((KeyStroke)((KeyStroke)this.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.RESIZE_LEFT).get())).condition(1).action((Action)new ResizeHorizontally(detailPanel, false)));
    }

    private void setupControls(EntityPanel entityPanel) {
        if (entityPanel.containsTablePanel() && this.includeControls) {
            Object tablePanel = entityPanel.tablePanel();
            ((EntityTablePanel)tablePanel).addToolBarControls((Controls)Controls.builder().control(Control.builder(this.detailController::toggleDetailState).smallIcon((Icon)FrameworkIcons.instance().detail()).description(MESSAGES.getString("toggle_detail"))).build());
            ((EntityTablePanel)tablePanel).addPopupMenuControls((Controls)((Controls.Builder)((Controls.Builder)Controls.builder().name(MESSAGES.getString(DETAIL_TABLES))).smallIcon((Icon)FrameworkIcons.instance().detail())).controls((Control[])entityPanel.detailPanels().stream().map(detailPanel -> Control.builder((Control.Command)new ActivateDetailPanel((EntityPanel)detailPanel)).name(detailPanel.caption()).build()).toArray(Control[]::new)).build());
        }
    }

    private void initializePanelState() {
        Value<EntityPanel.PanelState> detailPanelStateValue = this.detailController.panelState(this.selectedDetailPanel());
        if (detailPanelStateValue.isNotEqualTo((Object)this.panelState)) {
            detailPanelStateValue.set((Object)this.panelState);
        } else {
            this.detailController.updateDetailState();
        }
    }

    private EntityPanel selectedDetailPanel() {
        if (this.tabbedPane == null) {
            throw new IllegalStateException("Detail panel has not been laid out");
        }
        return (EntityPanel)this.tabbedPane.getSelectedComponent();
    }

    private JSplitPane createSplitPane(JPanel mainPanel) {
        return (JSplitPane)Components.splitPane().orientation(1).continuousLayout(true).oneTouchExpandable(true).dividerSize((Integer)Layouts.GAP.get() * 2).resizeWeight(this.splitPaneResizeWeight).leftComponent((JComponent)mainPanel).build();
    }

    private JTabbedPane createTabbedPane(Collection<EntityPanel> detailPanels) {
        TabbedPaneBuilder builder = (TabbedPaneBuilder)((TabbedPaneBuilder)Components.tabbedPane().focusable(false)).changeListener(e -> this.selectedDetailPanel().activate()).focusCycleRoot(true);
        detailPanels.forEach(detailPanel -> builder.tabBuilder(detailPanel.caption(), (JComponent)detailPanel).toolTipText((String)detailPanel.description().orElse(null)).icon((Icon)detailPanel.icon().orElse(null)).add());
        if (this.includeControls) {
            builder.mouseListener((MouseListener)new TabbedPaneMouseReleasedListener());
        }
        return (JTabbedPane)builder.build();
    }

    private static final class DefaultBuilder
    implements Builder {
        private final KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts = KEYBOARD_SHORTCUTS.copy();
        private final EntityPanel entityPanel;
        private EntityPanel.PanelState panelState = EntityPanel.PanelState.EMBEDDED;
        private EntityPanel.WindowType windowType;
        private double splitPaneResizeWeight = 0.5;
        private boolean includeControls = (Boolean)INCLUDE_CONTROLS.get();

        private DefaultBuilder(EntityPanel entityPanel) {
            this.entityPanel = Objects.requireNonNull(entityPanel);
            this.windowType = entityPanel.windowType();
        }

        @Override
        public Builder panelState(EntityPanel.PanelState panelState) {
            this.panelState = Objects.requireNonNull(panelState);
            return this;
        }

        @Override
        public Builder windowType(EntityPanel.WindowType windowType) {
            this.windowType = Objects.requireNonNull(windowType);
            return this;
        }

        @Override
        public Builder splitPaneResizeWeight(double splitPaneResizeWeight) {
            this.splitPaneResizeWeight = splitPaneResizeWeight;
            return this;
        }

        @Override
        public Builder includeControls(boolean includeControls) {
            this.includeControls = includeControls;
            return this;
        }

        @Override
        public Builder keyStroke(KeyboardShortcut keyboardShortcut, KeyStroke keyStroke) {
            this.keyboardShortcuts.keyStroke((Enum)keyboardShortcut).set((Object)keyStroke);
            return this;
        }

        @Override
        public TabbedDetailLayout build() {
            return new TabbedDetailLayout(this);
        }
    }

    private final class TabbedDetailController
    implements EntityPanel.DetailController {
        private final Value<EntityPanel.PanelState> panelState = Value.nonNull((Object)((Object)EntityPanel.PanelState.EMBEDDED)).listener(this::updateDetailState).build();

        private TabbedDetailController() {
        }

        @Override
        public void activated(EntityPanel detailPanel) {
            Objects.requireNonNull(detailPanel);
            if (TabbedDetailLayout.this.tabbedPane == null) {
                throw new IllegalStateException("Detail panel has not been laid out");
            }
            TabbedDetailLayout.this.tabbedPane.setFocusable(true);
            TabbedDetailLayout.this.tabbedPane.setSelectedComponent(detailPanel);
            TabbedDetailLayout.this.tabbedPane.setFocusable(false);
            this.activateDetailModelLink((SwingEntityModel)detailPanel.model());
        }

        @Override
        public Value<EntityPanel.PanelState> panelState(EntityPanel detailPanel) {
            Objects.requireNonNull(detailPanel);
            return this.panelState;
        }

        private void updateDetailState() {
            EntityPanel selectedDetailPanel = TabbedDetailLayout.this.selectedDetailPanel();
            if (this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.HIDDEN)) {
                selectedDetailPanel.initialize();
            }
            Object selectedDetailModel = selectedDetailPanel.model();
            if (TabbedDetailLayout.this.entityPanel.model().containsDetailModel(selectedDetailModel)) {
                TabbedDetailLayout.this.entityPanel.model().detailModelLink(selectedDetailModel).active().set((Object)this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.HIDDEN));
            }
            if (this.previousPanelState() == EntityPanel.PanelState.WINDOW) {
                this.disposeDetailWindow();
            }
            if (this.panelState.isEqualTo((Object)EntityPanel.PanelState.EMBEDDED)) {
                TabbedDetailLayout.this.splitPane.setRightComponent(TabbedDetailLayout.this.tabbedPane);
            } else if (this.panelState.isEqualTo((Object)EntityPanel.PanelState.HIDDEN)) {
                TabbedDetailLayout.this.splitPane.setRightComponent(null);
            } else {
                this.displayDetailWindow();
            }
            TabbedDetailLayout.this.entityPanel.revalidate();
        }

        private EntityPanel.PanelState previousPanelState() {
            if (TabbedDetailLayout.this.panelWindow != null) {
                return EntityPanel.PanelState.WINDOW;
            }
            if (TabbedDetailLayout.this.tabbedPane.isShowing()) {
                return EntityPanel.PanelState.EMBEDDED;
            }
            return EntityPanel.PanelState.HIDDEN;
        }

        private void activateDetailModelLink(SwingEntityModel detailModel) {
            Object model = TabbedDetailLayout.this.entityPanel.model();
            if (model.containsDetailModel((DefaultEntityModel)detailModel)) {
                ((Set)model.activeDetailModels().get()).stream().filter(activeDetailModel -> activeDetailModel != detailModel).forEach(activeDetailModel -> model.detailModelLink((DefaultEntityModel)activeDetailModel).active().set((Object)false));
                model.detailModelLink((DefaultEntityModel)detailModel).active().set((Object)true);
            }
        }

        private void toggleDetailState() {
            this.panelState.map(EntityPanel.PANEL_STATE_MAPPER);
        }

        private void displayDetailWindow() {
            Window parent = Utilities.parentWindow((Component)TabbedDetailLayout.this.entityPanel);
            if (parent != null) {
                Dimension parentSize = parent.getSize();
                Dimension size = this.detailWindowSize(parentSize);
                Point parentLocation = parent.getLocation();
                int detailWindowX = parentLocation.x + (parentSize.width - size.width);
                int detailWindowY = parentLocation.y + (parentSize.height - size.height) - 38;
                TabbedDetailLayout.this.panelWindow = this.createDetailWindow();
                TabbedDetailLayout.this.panelWindow.setSize(size);
                TabbedDetailLayout.this.panelWindow.setLocation(new Point(detailWindowX, detailWindowY));
                TabbedDetailLayout.this.panelWindow.setVisible(true);
            }
        }

        private void disposeDetailWindow() {
            if (TabbedDetailLayout.this.panelWindow != null) {
                TabbedDetailLayout.this.panelWindow.setVisible(false);
                TabbedDetailLayout.this.panelWindow.dispose();
                TabbedDetailLayout.this.panelWindow = null;
            }
        }

        private Dimension detailWindowSize(Dimension parentSize) {
            int detailWindowWidth = (int)((double)parentSize.width * 0.66);
            int detailWindowHeight = TabbedDetailLayout.this.entityPanel.containsEditPanel() ? (int)((double)parentSize.height * 0.66) : parentSize.height;
            return new Dimension(detailWindowWidth, detailWindowHeight);
        }

        private Window createDetailWindow() {
            if (TabbedDetailLayout.this.windowType == EntityPanel.WindowType.FRAME) {
                return Windows.frame((JComponent)this.createEmptyBorderBasePanel(TabbedDetailLayout.this.tabbedPane)).title(TabbedDetailLayout.this.entityPanel.caption() + " - " + MESSAGES.getString(TabbedDetailLayout.DETAIL_TABLES)).defaultCloseOperation(2).onClosed(windowEvent -> {
                    if (this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.EMBEDDED)) {
                        this.panelState.set((Object)EntityPanel.PanelState.HIDDEN);
                    }
                }).build();
            }
            return ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)this.createEmptyBorderBasePanel(TabbedDetailLayout.this.tabbedPane)).owner((Component)TabbedDetailLayout.this.entityPanel)).title(TabbedDetailLayout.this.entityPanel.caption() + " - " + MESSAGES.getString(TabbedDetailLayout.DETAIL_TABLES))).modal(false).onClosed(e -> {
                if (this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.EMBEDDED)) {
                    this.panelState.set((Object)EntityPanel.PanelState.HIDDEN);
                }
            }).build();
        }

        private JPanel createEmptyBorderBasePanel(JComponent component) {
            int gap = (Integer)Layouts.GAP.get();
            return (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent(component).border(BorderFactory.createEmptyBorder(gap, gap, 0, gap))).build();
        }
    }

    public static enum KeyboardShortcut implements KeyboardShortcuts.Shortcut
    {
        RESIZE_RIGHT(KeyboardShortcuts.keyStroke((int)39, (int)576)),
        RESIZE_LEFT(KeyboardShortcuts.keyStroke((int)37, (int)576));

        private final KeyStroke defaultKeystroke;

        private KeyboardShortcut(KeyStroke defaultKeystroke) {
            this.defaultKeystroke = defaultKeystroke;
        }

        public KeyStroke defaultKeystroke() {
            return this.defaultKeystroke;
        }
    }

    private static final class ResizeHorizontally
    extends AbstractAction {
        private final EntityPanel panel;
        private final boolean right;

        private ResizeHorizontally(EntityPanel panel, boolean right) {
            super("Resize " + (right ? "right" : "left"));
            this.panel = panel;
            this.right = right;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.panel.parentPanel().ifPresent(parentPanel -> ResizeHorizontally.resizePanel(parentPanel, this.right));
        }

        private static void resizePanel(EntityPanel panel, boolean right) {
            JSplitPane splitPane = ((TabbedDetailLayout)panel.detailLayout()).splitPane;
            if (right) {
                splitPane.setDividerLocation(Math.min(splitPane.getDividerLocation() + 30, splitPane.getMaximumDividerLocation()));
            } else {
                splitPane.setDividerLocation(Math.max(splitPane.getDividerLocation() - 30, 0));
            }
        }
    }

    private final class TabbedPaneMouseReleasedListener
    extends MouseAdapter {
        private TabbedPaneMouseReleasedListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            EntityPanel selectedDetailPanel = TabbedDetailLayout.this.selectedDetailPanel();
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                TabbedDetailLayout.this.detailController.panelState(selectedDetailPanel).map(state -> state == EntityPanel.PanelState.WINDOW ? EntityPanel.PanelState.EMBEDDED : EntityPanel.PanelState.WINDOW);
            } else if (e.getButton() == 2) {
                TabbedDetailLayout.this.detailController.panelState(selectedDetailPanel).map(state -> state == EntityPanel.PanelState.EMBEDDED ? EntityPanel.PanelState.HIDDEN : EntityPanel.PanelState.EMBEDDED);
            }
        }
    }

    private final class ActivateDetailPanel
    implements Control.Command {
        private final EntityPanel detailPanel;

        private ActivateDetailPanel(EntityPanel detailPanel) {
            this.detailPanel = detailPanel;
        }

        public void execute() {
            if (TabbedDetailLayout.this.detailController.panelState.isEqualTo((Object)EntityPanel.PanelState.HIDDEN)) {
                TabbedDetailLayout.this.detailController.panelState.set((Object)EntityPanel.PanelState.EMBEDDED);
            }
            this.detailPanel.activate();
        }
    }

    public static interface Builder {
        public Builder panelState(EntityPanel.PanelState var1);

        public Builder windowType(EntityPanel.WindowType var1);

        public Builder splitPaneResizeWeight(double var1);

        public Builder includeControls(boolean var1);

        public Builder keyStroke(KeyboardShortcut var1, KeyStroke var2);

        public TabbedDetailLayout build();
    }
}

