/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.common.value.Value;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.swing.common.model.component.combobox.FilteredComboBoxModel;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.combobox.ComboBoxBuilder;
import is.codion.swing.common.ui.component.combobox.Completion;
import is.codion.swing.common.ui.component.combobox.DefaultComboBoxBuilder;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.component.EntityControls;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public final class EntityComboBox
extends JComboBox<Entity> {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(EntityComboBox.class.getName());
    public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class);
    private final Control addControl;
    private final Control editControl;

    private EntityComboBox(DefaultBuilder builder) {
        super(builder.comboBoxModel());
        this.addControl = this.createAddControl(builder.editPanel, (KeyStroke)builder.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.ADD).get());
        this.editControl = this.createEditControl(builder.editPanel, (KeyStroke)builder.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.EDIT).get());
    }

    public EntityComboBoxModel getModel() {
        return (EntityComboBoxModel)super.getModel();
    }

    public Optional<Control> addControl() {
        return Optional.ofNullable(this.addControl);
    }

    public Optional<Control> editControl() {
        return Optional.ofNullable(this.editControl);
    }

    @Override
    public void requestFocus() {
        if (this.isEditable()) {
            this.getEditor().getEditorComponent().requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        if (this.isEditable()) {
            this.getEditor().getEditorComponent().addFocusListener(listener);
        }
    }

    @Override
    public synchronized void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        if (this.isEditable()) {
            this.getEditor().getEditorComponent().removeFocusListener(listener);
        }
    }

    public Control createForeignKeyFilterControl(ForeignKey foreignKey) {
        return Control.builder((Control.Command)this.createForeignKeyFilterCommand(Objects.requireNonNull(foreignKey))).smallIcon((Icon)FrameworkIcons.instance().filter()).build();
    }

    public <B extends ComboBoxBuilder<Entity, EntityComboBox, B>> ComboBoxBuilder<Entity, EntityComboBox, B> createForeignKeyFilterComboBox(ForeignKey foreignKey) {
        return EntityComboBox.builder(this.getModel().createForeignKeyFilterComboBoxModel(Objects.requireNonNull(foreignKey))).completionMode(Completion.Mode.MAXIMUM_MATCH);
    }

    public <B extends TextFieldBuilder<Integer, NumberField<Integer>, B>> TextFieldBuilder<Integer, NumberField<Integer>, B> integerSelectorField(Attribute<Integer> attribute) {
        Objects.requireNonNull(attribute);
        return (TextFieldBuilder)((NumberField.Builder)Components.integerField((Value)this.getModel().createSelectorValue(attribute)).columns(2)).selectAllOnFocusGained(true);
    }

    public <B extends TextFieldBuilder<Integer, NumberField<Integer>, B>> TextFieldBuilder<Integer, NumberField<Integer>, B> integerSelectorField(FilteredComboBoxModel.ItemFinder<Entity, Integer> itemFinder) {
        Objects.requireNonNull(itemFinder);
        return (TextFieldBuilder)((NumberField.Builder)Components.integerField((Value)this.getModel().createSelectorValue(itemFinder)).columns(2)).selectAllOnFocusGained(true);
    }

    public <B extends TextFieldBuilder<String, JTextField, B>> TextFieldBuilder<String, JTextField, B> stringSelectorField(Attribute<String> attribute) {
        Objects.requireNonNull(attribute);
        return (TextFieldBuilder)Components.stringField((Value)this.getModel().createSelectorValue(attribute)).columns(2).selectAllOnFocusGained(true);
    }

    public <B extends TextFieldBuilder<String, JTextField, B>> TextFieldBuilder<String, JTextField, B> stringSelectorField(FilteredComboBoxModel.ItemFinder<Entity, String> itemFinder) {
        Objects.requireNonNull(itemFinder);
        return (TextFieldBuilder)Components.stringField((Value)this.getModel().createSelectorValue(itemFinder)).columns(2).selectAllOnFocusGained(true);
    }

    public static Builder builder(EntityComboBoxModel comboBoxModel) {
        return EntityComboBox.builder(comboBoxModel, null);
    }

    public static Builder builder(EntityComboBoxModel comboBoxModel, Value<Entity> linkedValue) {
        return new DefaultBuilder(comboBoxModel, linkedValue);
    }

    private Control createAddControl(Supplier<EntityEditPanel> editPanel, KeyStroke keyStroke) {
        return editPanel == null ? null : EntityControls.createAddControl(this, editPanel, keyStroke);
    }

    private Control createEditControl(Supplier<EntityEditPanel> editPanel, KeyStroke keyStroke) {
        return editPanel == null ? null : EntityControls.createEditControl(this, editPanel, keyStroke);
    }

    private Control.Command createForeignKeyFilterCommand(ForeignKey foreignKey) {
        return () -> {
            Collection currentFilterKeys = this.getModel().getForeignKeyFilterKeys(foreignKey);
            ((OkCancelDialogBuilder)((OkCancelDialogBuilder)Dialogs.okCancelDialog((JComponent)this.createForeignKeyFilterComboBox(foreignKey).build()).owner((Component)this)).title(MESSAGES.getString("filter_by"))).onCancel(() -> this.getModel().setForeignKeyFilterKeys(foreignKey, currentFilterKeys)).show();
        };
    }

    private static final class DefaultBuilder
    extends DefaultComboBoxBuilder<Entity, EntityComboBox, Builder>
    implements Builder {
        private final KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts = KEYBOARD_SHORTCUTS.copy();
        private Supplier<EntityEditPanel> editPanel;

        private DefaultBuilder(EntityComboBoxModel comboBoxModel, Value<Entity> linkedValue) {
            super((ComboBoxModel)comboBoxModel, linkedValue);
        }

        protected EntityComboBox createComboBox() {
            return new EntityComboBox(this);
        }

        @Override
        public Builder editPanel(Supplier<EntityEditPanel> editPanel) {
            this.editPanel = Objects.requireNonNull(editPanel);
            return this;
        }

        @Override
        public Builder keyStroke(KeyboardShortcut keyboardShortcut, KeyStroke keyStroke) {
            this.keyboardShortcuts.keyStroke((Enum)keyboardShortcut).set((Object)keyStroke);
            return this;
        }

        private EntityComboBoxModel comboBoxModel() {
            return (EntityComboBoxModel)this.comboBoxModel;
        }
    }

    public static enum KeyboardShortcut implements KeyboardShortcuts.Shortcut
    {
        ADD(KeyboardShortcuts.keyStroke((int)155)),
        EDIT(KeyboardShortcuts.keyStroke((int)155, (int)128));

        private final KeyStroke defaultKeystroke;

        private KeyboardShortcut(KeyStroke defaultKeystroke) {
            this.defaultKeystroke = defaultKeystroke;
        }

        public KeyStroke defaultKeystroke() {
            return this.defaultKeystroke;
        }
    }

    public static interface Builder
    extends ComboBoxBuilder<Entity, EntityComboBox, Builder> {
        public Builder editPanel(Supplier<EntityEditPanel> var1);

        public Builder keyStroke(KeyboardShortcut var1, KeyStroke var2);
    }
}

