/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.i18n.Messages;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.StateObserver;
import is.codion.common.value.ValueObserver;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.framework.model.EntityEditModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.text.TextFieldPanel;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.ActionDialogBuilder;
import is.codion.swing.common.ui.dialog.DialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.InputDialogBuilder;
import is.codion.swing.common.ui.dialog.ProgressWorkerDialogBuilder;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.component.DefaultEntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponents;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityDialogs {
    private static final MessageBundle EDIT_PANEL_MESSAGES = MessageBundle.messageBundle(EntityEditPanel.class, (ResourceBundle)ResourceBundle.getBundle(EntityEditPanel.class.getName()));
    private static final Consumer<?> EMPTY_CONSUMER = value -> {};

    private EntityDialogs() {
    }

    public static <T> EditAttributeDialogBuilder<T> editAttributeDialog(SwingEntityEditModel editModel, Attribute<T> attribute) {
        return new DefaultEditAttributeDialogBuilder<T>(editModel, attribute);
    }

    public static AddEntityDialogBuilder addEntityDialog(Supplier<EntityEditPanel> editPanel) {
        return new DefaultAddEntityDialogBuilder(editPanel);
    }

    public static EditEntityDialogBuilder editEntityDialog(Supplier<EntityEditPanel> editPanel) {
        return new DefaultEditEntityDialogBuilder(editPanel);
    }

    public static EntitySelectionDialogBuilder selectionDialog(SwingEntityTableModel tableModel) {
        return new DefaultEntitySelectionDialogBuilder(tableModel);
    }

    private static Control createCancelControl(Runnable disposeDialog) {
        return ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command((Control.Command)new RunnableCommand(disposeDialog)).name(Messages.cancel())).mnemonic((int)Messages.cancelMnemonic())).build();
    }

    private static <T> Consumer<T> emptyConsumer() {
        return EMPTY_CONSUMER;
    }

    private static final class DefaultEditAttributeDialogBuilder<T>
    extends AbstractDialogBuilder<EditAttributeDialogBuilder<T>>
    implements EditAttributeDialogBuilder<T> {
        private static final Logger LOG = LoggerFactory.getLogger(DefaultEditAttributeDialogBuilder.class);
        private final SwingEntityEditModel editModel;
        private final Attribute<T> attribute;
        private EntityComponentFactory<T, ?> componentFactory;
        private Consumer<ValidationException> onValidationException = new DefaultValidationExceptionHandler();
        private Consumer<Exception> onException = new DefaultExceptionHandler();

        private DefaultEditAttributeDialogBuilder(SwingEntityEditModel editModel, Attribute<T> attribute) {
            this.editModel = Objects.requireNonNull(editModel);
            this.attribute = Objects.requireNonNull(attribute);
            this.componentFactory = new EditEntityComponentFactory(attribute);
        }

        @Override
        public EditAttributeDialogBuilder<T> componentFactory(EntityComponentFactory<T, ?> componentFactory) {
            this.componentFactory = componentFactory == null ? new EditEntityComponentFactory(this.attribute) : componentFactory;
            return this;
        }

        @Override
        public EditAttributeDialogBuilder<T> onValidationException(Consumer<ValidationException> onValidationException) {
            this.onValidationException = Objects.requireNonNull(onValidationException);
            return this;
        }

        @Override
        public EditAttributeDialogBuilder<T> onException(Consumer<Exception> onException) {
            this.onException = Objects.requireNonNull(onException);
            return this;
        }

        @Override
        public void edit(Entity entity) {
            this.edit(Collections.singleton(Objects.requireNonNull(entity)));
        }

        @Override
        public void edit(Collection<Entity> entities) {
            Set entityTypes = Objects.requireNonNull(entities).stream().map(Entity::entityType).collect(Collectors.toSet());
            if (entityTypes.isEmpty()) {
                return;
            }
            if (entityTypes.size() > 1) {
                throw new IllegalArgumentException("All entities must be of the same type when editing");
            }
            ComponentValue<T, ?> componentValue = this.componentFactory.componentValue(this.editModel, this.initialValue(entities));
            ((InputDialogBuilder)((InputDialogBuilder)((InputDialogBuilder)((InputDialogBuilder)Dialogs.inputDialog(componentValue).owner(this.owner)).location(this.location)).locationRelativeTo(this.locationRelativeTo)).title(FrameworkMessages.edit())).caption(this.componentFactory.caption().orElse(this.editModel.entityDefinition().attributes().definition(this.attribute).caption())).validator((Predicate)new InputValidator(componentValue)).show((Predicate)new PerformUpdate(entities));
        }

        private T initialValue(Collection<Entity> entities) {
            Collection values = entities.stream().map(entity -> entity.get(this.attribute)).collect(Collectors.toSet());
            return values.size() == 1 ? (T)values.iterator().next() : null;
        }

        private final class DefaultValidationExceptionHandler
        implements Consumer<ValidationException> {
            private DefaultValidationExceptionHandler() {
            }

            @Override
            public void accept(ValidationException exception) {
                Objects.requireNonNull(exception);
                String title = DefaultEditAttributeDialogBuilder.this.editModel.entityDefinition().attributes().definition(exception.attribute()).caption();
                JOptionPane.showMessageDialog(DefaultEditAttributeDialogBuilder.this.locationRelativeTo == null ? DefaultEditAttributeDialogBuilder.this.owner : DefaultEditAttributeDialogBuilder.this.locationRelativeTo, exception.getMessage(), title, 0);
            }
        }

        private final class DefaultExceptionHandler
        implements Consumer<Exception> {
            private DefaultExceptionHandler() {
            }

            @Override
            public void accept(Exception exception) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focusOwner == null) {
                    focusOwner = DefaultEditAttributeDialogBuilder.this.owner;
                }
                Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
            }
        }

        private final class InputValidator
        implements Predicate<T> {
            private final ComponentValue<T, ?> componentValue;

            private InputValidator(ComponentValue<T, ?> componentValue) {
                this.componentValue = componentValue;
            }

            @Override
            public boolean test(T value) {
                EntityDefinition entityDefinition = DefaultEditAttributeDialogBuilder.this.editModel.entityDefinition();
                Entity entity = entityDefinition.entity();
                entity.put(DefaultEditAttributeDialogBuilder.this.attribute, value);
                try {
                    entityDefinition.validator().validate(entity, DefaultEditAttributeDialogBuilder.this.attribute);
                    this.componentValue.validate(value);
                    return true;
                }
                catch (ValidationException | IllegalArgumentException e) {
                    return false;
                }
            }
        }

        private final class PerformUpdate
        implements Predicate<T> {
            private final Collection<Entity> entities;

            private PerformUpdate(Collection<Entity> entities) {
                this.entities = entities.stream().map(Entity::copy).collect(Collectors.toList());
            }

            @Override
            public boolean test(T newValue) {
                this.entities.forEach(entity -> entity.put(DefaultEditAttributeDialogBuilder.this.attribute, newValue));
                try {
                    ((EntityEditModel.Update.Result)((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Update.Task)DefaultEditAttributeDialogBuilder.this.editModel.createUpdate((Collection)this.entities.stream().filter(Entity::modified).collect(Collectors.toList())).prepare()).perform()).title(EDIT_PANEL_MESSAGES.getString("updating"))).owner(DefaultEditAttributeDialogBuilder.this.owner)).location(DefaultEditAttributeDialogBuilder.this.location)).locationRelativeTo(DefaultEditAttributeDialogBuilder.this.locationRelativeTo)).onException(e -> {}).execute().get()).handle();
                    return true;
                }
                catch (ValidationException e2) {
                    LOG.debug(e2.getMessage(), (Throwable)e2);
                    DefaultEditAttributeDialogBuilder.this.onValidationException.accept(e2);
                }
                catch (ExecutionException e3) {
                    Throwable cause = e3.getCause();
                    LOG.error(e3.getMessage(), (Throwable)e3);
                    if (cause instanceof Exception) {
                        DefaultEditAttributeDialogBuilder.this.onException.accept((Exception)cause);
                    } else {
                        DefaultEditAttributeDialogBuilder.this.onException.accept(new RuntimeException(cause));
                    }
                }
                catch (InterruptedException e4) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e4);
                }
                return false;
            }
        }
    }

    private static final class DefaultAddEntityDialogBuilder
    extends AbstractDialogBuilder<AddEntityDialogBuilder>
    implements AddEntityDialogBuilder {
        private final Supplier<EntityEditPanel> editPanelSupplier;
        private Consumer<Entity> onInsert = EntityDialogs.emptyConsumer();
        private boolean closeDialog = true;
        private boolean confirm = false;

        private DefaultAddEntityDialogBuilder(Supplier<EntityEditPanel> editPanelSupplier) {
            this.editPanelSupplier = Objects.requireNonNull(editPanelSupplier);
        }

        @Override
        public AddEntityDialogBuilder onInsert(Consumer<Entity> onInsert) {
            this.onInsert = Objects.requireNonNull(onInsert);
            return this;
        }

        @Override
        public AddEntityDialogBuilder closeDialog(boolean closeDialog) {
            this.closeDialog = closeDialog;
            return this;
        }

        @Override
        public AddEntityDialogBuilder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        @Override
        public void show() {
            EntityEditPanel editPanel = this.editPanelSupplier.get().initialize();
            Object editModel = editPanel.editModel();
            DisposeDialog disposeDialog = new DisposeDialog(editPanel);
            ((ActionDialogBuilder)((ActionDialogBuilder)((ActionDialogBuilder)((ActionDialogBuilder)Dialogs.actionDialog((JComponent)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent((JComponent)editPanel).border(Borders.emptyBorder())).build()).owner(this.owner)).location(this.location)).locationRelativeTo(this.locationRelativeTo)).defaultAction((Action)DefaultAddEntityDialogBuilder.createAddControl(editPanel, new OnInsert(disposeDialog), this.confirm)).escapeAction((Action)EntityDialogs.createCancelControl(disposeDialog)).title(FrameworkMessages.add() + " - " + editModel.entities().definition(editModel.entityType()).caption())).onShown((Consumer)new ClearAndRequestFocus(editPanel)).show();
        }

        private static Control createAddControl(EntityEditPanel editPanel, Consumer<Collection<Entity>> onInsert, boolean confirm) {
            return ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(editPanel.insertCommand().confirm(confirm).onInsert(onInsert).build()).name(FrameworkMessages.add())).mnemonic((int)FrameworkMessages.addMnemonic())).onException((Consumer)new EditPanelExceptionHandler(editPanel)).build();
        }

        private final class OnInsert
        implements Consumer<Collection<Entity>> {
            private final Runnable disposeDialog;

            private OnInsert(Runnable disposeDialog) {
                this.disposeDialog = disposeDialog;
            }

            @Override
            public void accept(Collection<Entity> inserted) {
                DefaultAddEntityDialogBuilder.this.onInsert.accept(inserted.iterator().next());
                if (DefaultAddEntityDialogBuilder.this.closeDialog) {
                    this.disposeDialog.run();
                }
            }
        }
    }

    private static final class DefaultEditEntityDialogBuilder
    extends AbstractDialogBuilder<EditEntityDialogBuilder>
    implements EditEntityDialogBuilder {
        private final Supplier<EntityEditPanel> editPanelSupplier;
        private Supplier<Entity> entity;
        private Consumer<Entity> onUpdate = EntityDialogs.emptyConsumer();
        private boolean confirm = false;

        private DefaultEditEntityDialogBuilder(Supplier<EntityEditPanel> editPanelSupplier) {
            this.editPanelSupplier = Objects.requireNonNull(editPanelSupplier);
        }

        @Override
        public EditEntityDialogBuilder entity(Supplier<Entity> entity) {
            this.entity = Objects.requireNonNull(entity);
            return this;
        }

        @Override
        public EditEntityDialogBuilder onUpdate(Consumer<Entity> onUpdate) {
            this.onUpdate = Objects.requireNonNull(onUpdate);
            return this;
        }

        @Override
        public EditEntityDialogBuilder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        @Override
        public void show() {
            EntityEditPanel editPanel = this.editPanelSupplier.get().initialize();
            Object editModel = editPanel.editModel();
            this.initializeEditModel((SwingEntityEditModel)editModel);
            ((ActionDialogBuilder)((ActionDialogBuilder)((ActionDialogBuilder)((ActionDialogBuilder)Dialogs.actionDialog((JComponent)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent((JComponent)editPanel).border(Borders.emptyBorder())).build()).owner(this.owner)).location(this.location)).locationRelativeTo(this.locationRelativeTo)).defaultAction((Action)DefaultEditEntityDialogBuilder.createUpdateControl(editPanel, new OnUpdate(new DisposeDialog(editPanel)), this.confirm)).escapeAction((Action)EntityDialogs.createCancelControl(new RevertAndDisposeDialog(editPanel))).title(FrameworkMessages.edit() + " - " + editModel.entities().definition(editModel.entityType()).caption())).onShown((Consumer)new RequestFocus(editPanel)).show();
        }

        private void initializeEditModel(SwingEntityEditModel editModel) {
            if (this.entity != null) {
                editModel.entity().set(this.entity.get());
            } else {
                editModel.entity().revert();
            }
        }

        private static Control createUpdateControl(EntityEditPanel editPanel, Consumer<Collection<Entity>> onUpdate, boolean confirm) {
            return ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(editPanel.updateCommand().confirm(confirm).onUpdate(onUpdate).build()).name(FrameworkMessages.update())).mnemonic((int)FrameworkMessages.updateMnemonic())).onException((Consumer)new EditPanelExceptionHandler(editPanel)).enabled((StateObserver)editPanel.editModel().entity().modified())).build();
        }

        private final class OnUpdate
        implements Consumer<Collection<Entity>> {
            private final Runnable disposeDialog;

            private OnUpdate(Runnable disposeDialog) {
                this.disposeDialog = disposeDialog;
            }

            @Override
            public void accept(Collection<Entity> updatedEntities) {
                DefaultEditEntityDialogBuilder.this.onUpdate.accept(updatedEntities.iterator().next());
                this.disposeDialog.run();
            }
        }
    }

    private static final class DefaultEntitySelectionDialogBuilder
    extends AbstractDialogBuilder<EntitySelectionDialogBuilder>
    implements EntitySelectionDialogBuilder {
        private final SwingEntityTableModel tableModel;
        private Dimension dialogSize;

        private DefaultEntitySelectionDialogBuilder(SwingEntityTableModel tableModel) {
            this.tableModel = Objects.requireNonNull(tableModel);
        }

        @Override
        public EntitySelectionDialogBuilder dialogSize(Dimension dialogSize) {
            this.dialogSize = Objects.requireNonNull(dialogSize);
            return this;
        }

        @Override
        public List<Entity> select() {
            return new EntitySelectionDialog(this.tableModel, this.owner, this.location, this.locationRelativeTo, (ValueObserver<String>)this.title, this.icon, this.dialogSize, false).selectEntities();
        }

        @Override
        public Optional<Entity> selectSingle() {
            List<Entity> entities = new EntitySelectionDialog(this.tableModel, this.owner, this.location, this.locationRelativeTo, (ValueObserver<String>)this.title, this.icon, this.dialogSize, true).selectEntities();
            return entities.isEmpty() ? Optional.empty() : Optional.of(entities.get(0));
        }
    }

    private static final class RunnableCommand
    implements Control.Command {
        private final Runnable runnable;

        private RunnableCommand(Runnable runnable) {
            this.runnable = runnable;
        }

        public void execute() throws Exception {
            this.runnable.run();
        }
    }

    private static final class RevertAndDisposeDialog
    implements Runnable {
        private final EntityEditPanel editPanel;

        private RevertAndDisposeDialog(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
        }

        @Override
        public void run() {
            this.editPanel.editModel().entity().revert();
            Utilities.disposeParentWindow((Component)this.editPanel);
        }
    }

    private static final class DisposeDialog
    implements Runnable {
        private final EntityEditPanel editPanel;

        private DisposeDialog(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
        }

        @Override
        public void run() {
            Utilities.disposeParentWindow((Component)this.editPanel);
        }
    }

    private static final class RequestFocus
    implements Consumer<JDialog> {
        private final EntityEditPanel editPanel;

        private RequestFocus(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
        }

        @Override
        public void accept(JDialog dialog) {
            this.editPanel.requestInitialFocus();
        }
    }

    private static final class ClearAndRequestFocus
    implements Consumer<JDialog> {
        private final EntityEditPanel editPanel;

        private ClearAndRequestFocus(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
        }

        @Override
        public void accept(JDialog dialog) {
            this.editPanel.clearAndRequestFocus();
        }
    }

    private static final class EditPanelExceptionHandler
    implements Consumer<Exception> {
        private final EntityEditPanel editPanel;

        private EditPanelExceptionHandler(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
        }

        @Override
        public void accept(Exception exception) {
            this.editPanel.onException(exception);
        }
    }

    private static final class EntitySelectionDialog {
        private final EntityTablePanel entityTablePanel;

        private EntitySelectionDialog(SwingEntityTableModel tableModel, Window owner, Point location, Component locationRelativeTo, ValueObserver<String> title, ImageIcon icon, Dimension dialogSize, boolean singleSelection) {
            Control okControl = ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::ok).name(Messages.ok())).mnemonic((int)Messages.okMnemonic())).enabled(tableModel.selection().empty().not())).build();
            Control cancelControl = ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::cancel).name(Messages.cancel())).mnemonic((int)Messages.cancelMnemonic())).build();
            Control searchControl = ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::search).name(FrameworkMessages.searchVerb())).mnemonic((int)FrameworkMessages.searchMnemonic())).build();
            this.entityTablePanel = EntitySelectionDialog.createTablePanel(tableModel, okControl, singleSelection);
            ((ActionDialogBuilder)((ActionDialogBuilder)((ActionDialogBuilder)((ActionDialogBuilder)((ActionDialogBuilder)Dialogs.actionDialog((JComponent)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent((JComponent)this.entityTablePanel).border(Borders.emptyBorder())).build()).owner(owner)).location(location)).locationRelativeTo(locationRelativeTo)).title(title)).icon(icon)).size(dialogSize).defaultAction((Action)okControl).escapeAction((Action)cancelControl).action((Action)searchControl).show();
        }

        private static EntityTablePanel createTablePanel(SwingEntityTableModel tableModel, Control okControl, boolean singleSelection) {
            ((SwingEntityEditModel)tableModel.editModel()).readOnly().set((Object)true);
            EntityTablePanel tablePanel = new EntityTablePanel(tableModel, config -> config.includeSouthPanel(false));
            tablePanel.initialize();
            tablePanel.table().doubleClickAction().set((Object)okControl);
            tablePanel.conditionPanel().state().set((Object)ColumnConditionPanel.ConditionState.SIMPLE);
            tablePanel.table().getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
            tablePanel.table().setSelectionMode(singleSelection ? 0 : 2);
            return tablePanel;
        }

        private void ok() {
            Utilities.disposeParentWindow((Component)this.entityTablePanel);
        }

        private void cancel() {
            this.entityTablePanel.tableModel().selection().clear();
            Utilities.disposeParentWindow((Component)this.entityTablePanel);
        }

        private void search() {
            Object tableModel = this.entityTablePanel.tableModel();
            tableModel.refresh(items -> {
                if (tableModel.items().visible().count() > 0) {
                    tableModel.selection().index().set((Object)0);
                    this.entityTablePanel.table().requestFocusInWindow();
                } else {
                    JOptionPane.showMessageDialog(Utilities.parentWindow((Component)this.entityTablePanel), FrameworkMessages.noSearchResults());
                }
            });
        }

        private List<Entity> selectEntities() {
            return (List)this.entityTablePanel.tableModel().selection().items().get();
        }
    }

    private static final class EditEntityComponentFactory<T, C extends JComponent>
    extends DefaultEntityComponentFactory<T, C> {
        private static final int TEXT_INPUT_PANEL_COLUMNS = 20;

        private EditEntityComponentFactory(Attribute<T> attribute) {
            super(attribute);
        }

        @Override
        public ComponentValue<T, C> componentValue(SwingEntityEditModel editModel, T value) {
            AttributeDefinition attributeDefinition = editModel.entityDefinition().attributes().definition(this.attribute());
            if (attributeDefinition.items().isEmpty() && this.attribute().type().isString()) {
                return ((TextFieldPanel.Builder)EntityComponents.entityComponents(editModel.entityDefinition()).textFieldPanel(this.attribute()).value((Object)((String)value))).columns(20).buildValue();
            }
            return super.componentValue(editModel, value);
        }
    }

    public static interface EntitySelectionDialogBuilder
    extends DialogBuilder<EntitySelectionDialogBuilder> {
        public EntitySelectionDialogBuilder dialogSize(Dimension var1);

        public List<Entity> select();

        public Optional<Entity> selectSingle();
    }

    public static interface EditEntityDialogBuilder
    extends DialogBuilder<EditEntityDialogBuilder> {
        public EditEntityDialogBuilder entity(Supplier<Entity> var1);

        public EditEntityDialogBuilder onUpdate(Consumer<Entity> var1);

        public EditEntityDialogBuilder confirm(boolean var1);

        public void show();
    }

    public static interface AddEntityDialogBuilder
    extends DialogBuilder<AddEntityDialogBuilder> {
        public AddEntityDialogBuilder onInsert(Consumer<Entity> var1);

        public AddEntityDialogBuilder closeDialog(boolean var1);

        public AddEntityDialogBuilder confirm(boolean var1);

        public void show();
    }

    public static interface EditAttributeDialogBuilder<T>
    extends DialogBuilder<EditAttributeDialogBuilder<T>> {
        public EditAttributeDialogBuilder<T> componentFactory(EntityComponentFactory<T, ?> var1);

        public EditAttributeDialogBuilder<T> onValidationException(Consumer<ValidationException> var1);

        public EditAttributeDialogBuilder<T> onException(Consumer<Exception> var1);

        public void edit(Entity var1);

        public void edit(Collection<Entity> var1);
    }
}

