/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.EntityType;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.SwingEntityModel;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityPanel;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.TabbedDetailLayout;
import java.awt.Dimension;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.ImageIcon;

final class EntityPanelBuilder
implements EntityPanel.Builder {
    private final EntityType entityType;
    private final SwingEntityModel.Builder modelBuilder;
    private final SwingEntityModel model;
    private final List<EntityPanel.Builder> detailPanelBuilders = new ArrayList<EntityPanel.Builder>();
    private String caption;
    private String description;
    private ImageIcon icon;
    private boolean refreshWhenInitialized = true;
    private Dimension preferredSize;
    private ColumnConditionPanel.ConditionState conditionState = (ColumnConditionPanel.ConditionState)EntityTablePanel.Config.CONDITION_STATE.get();
    private ColumnConditionPanel.ConditionState filterState = (ColumnConditionPanel.ConditionState)EntityTablePanel.Config.FILTER_STATE.get();
    private Function<EntityPanel, EntityPanel.DetailLayout> detailLayout = new DefaultDetailLayout();
    private Class<? extends EntityPanel> panelClass;
    private Class<? extends EntityTablePanel> tablePanelClass;
    private Class<? extends EntityEditPanel> editPanelClass;
    private Consumer<EntityPanel> onBuildPanel = new EmptyOnBuild<EntityPanel>();
    private Consumer<EntityEditPanel> onBuildEditPanel = new EmptyOnBuild<EntityEditPanel>();
    private Consumer<EntityTablePanel> onBuildTablePanel = new EmptyOnBuild<EntityTablePanel>();

    EntityPanelBuilder(SwingEntityModel.Builder modelBuilder) {
        this.modelBuilder = Objects.requireNonNull(modelBuilder, "modelBuilder");
        this.entityType = modelBuilder.entityType();
        this.model = null;
    }

    EntityPanelBuilder(SwingEntityModel model) {
        this.model = Objects.requireNonNull(model, "model");
        this.entityType = model.entityType();
        this.modelBuilder = null;
    }

    @Override
    public EntityType entityType() {
        return this.entityType;
    }

    @Override
    public EntityPanelBuilder caption(String caption) {
        this.caption = caption;
        return this;
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public EntityPanelBuilder description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public Optional<String> caption() {
        return Optional.ofNullable(this.caption);
    }

    @Override
    public EntityPanel.Builder icon(ImageIcon icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public Optional<ImageIcon> icon() {
        return Optional.ofNullable(this.icon);
    }

    @Override
    public EntityPanel.Builder detailPanel(EntityPanel.Builder panelBuilder) {
        if (!this.detailPanelBuilders.contains(panelBuilder)) {
            this.detailPanelBuilders.add(panelBuilder);
        }
        return this;
    }

    @Override
    public EntityPanel.Builder refreshWhenInitialized(boolean refreshWhenInitialized) {
        this.refreshWhenInitialized = refreshWhenInitialized;
        return this;
    }

    @Override
    public EntityPanel.Builder conditionState(ColumnConditionPanel.ConditionState conditionState) {
        this.conditionState = Objects.requireNonNull(conditionState);
        return this;
    }

    @Override
    public EntityPanel.Builder filterState(ColumnConditionPanel.ConditionState filterState) {
        this.filterState = Objects.requireNonNull(filterState);
        return this;
    }

    @Override
    public EntityPanel.Builder detailLayout(Function<EntityPanel, EntityPanel.DetailLayout> detailLayout) {
        this.detailLayout = Objects.requireNonNull(detailLayout);
        return this;
    }

    @Override
    public EntityPanel.Builder preferredSize(Dimension preferredSize) {
        this.preferredSize = Objects.requireNonNull(preferredSize);
        return this;
    }

    @Override
    public EntityPanel.Builder panel(Class<? extends EntityPanel> panelClass) {
        if (this.editPanelClass != null || this.tablePanelClass != null) {
            throw new IllegalStateException("Edit or table panel class has been set");
        }
        this.panelClass = Objects.requireNonNull(panelClass, "panelClass");
        return this;
    }

    @Override
    public EntityPanel.Builder editPanel(Class<? extends EntityEditPanel> editPanelClass) {
        if (this.panelClass != null) {
            throw new IllegalStateException("Panel class has been set");
        }
        this.editPanelClass = Objects.requireNonNull(editPanelClass, "editPanelClass");
        return this;
    }

    @Override
    public EntityPanel.Builder tablePanel(Class<? extends EntityTablePanel> tablePanelClass) {
        if (this.panelClass != null) {
            throw new IllegalStateException("Panel class has been set");
        }
        this.tablePanelClass = Objects.requireNonNull(tablePanelClass, "tablePanelClass");
        return this;
    }

    @Override
    public EntityPanel.Builder onBuildPanel(Consumer<EntityPanel> onBuildPanel) {
        this.onBuildPanel = Objects.requireNonNull(onBuildPanel);
        return this;
    }

    @Override
    public EntityPanelBuilder onBuildEditPanel(Consumer<EntityEditPanel> onBuildEditPanel) {
        this.onBuildEditPanel = Objects.requireNonNull(onBuildEditPanel);
        return this;
    }

    @Override
    public EntityPanel.Builder onBuildTablePanel(Consumer<EntityTablePanel> onBuildTablePanel) {
        this.onBuildTablePanel = Objects.requireNonNull(onBuildTablePanel);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityPanelBuilder) {
            EntityPanelBuilder that = (EntityPanelBuilder)obj;
            return Objects.equals(this.modelBuilder, that.model) && Objects.equals(this.model, that.model) && Objects.equals(this.panelClass, that.panelClass) && Objects.equals(this.editPanelClass, that.editPanelClass) && Objects.equals(this.tablePanelClass, that.tablePanelClass);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.modelBuilder, this.model, this.panelClass, this.editPanelClass, this.tablePanelClass);
    }

    @Override
    public EntityPanel build(EntityConnectionProvider connectionProvider) {
        Objects.requireNonNull(connectionProvider, "connectionProvider");
        if (this.modelBuilder == null) {
            throw new IllegalStateException("A SwingEntityModel.Builder is not available in this panel builder: " + this.entityType);
        }
        return this.build(this.modelBuilder.build(connectionProvider));
    }

    @Override
    public EntityPanel build(SwingEntityModel model) {
        Objects.requireNonNull(model, "model");
        EntityPanel entityPanel = this.createPanel(model);
        if (entityPanel.containsTablePanel()) {
            ((EntityTablePanel)entityPanel.tablePanel()).conditionPanel().state().set((Object)this.conditionState);
            ((EntityTablePanel)entityPanel.tablePanel()).table().filterPanel().state().set((Object)this.filterState);
        }
        if (!this.detailPanelBuilders.isEmpty()) {
            for (EntityPanel.Builder detailPanelBuilder : this.detailPanelBuilders) {
                SwingEntityModel detailModel = (SwingEntityModel)model.detailModel(detailPanelBuilder.entityType());
                EntityPanel detailPanel = detailPanelBuilder.build(detailModel);
                entityPanel.addDetailPanel(detailPanel);
            }
        }
        this.onBuildPanel.accept(entityPanel);
        if (this.refreshWhenInitialized && model.containsTableModel()) {
            ((SwingEntityTableModel)model.tableModel()).refresh();
        }
        return entityPanel;
    }

    private EntityPanel createPanel(SwingEntityModel entityModel) {
        try {
            EntityPanel entityPanel;
            if (this.panelClass().equals(EntityPanel.class)) {
                EntityTablePanel tablePanel = entityModel.containsTableModel() ? this.createTablePanel((SwingEntityTableModel)entityModel.tableModel()) : null;
                EntityEditPanel editPanel = this.editPanelClass() == null ? null : this.createEditPanel((SwingEntityEditModel)entityModel.editModel());
                entityPanel = this.createPanel(entityModel, editPanel, tablePanel);
            } else {
                entityPanel = EntityPanelBuilder.findModelConstructor(this.panelClass()).newInstance(entityModel);
            }
            if (this.preferredSize != null) {
                entityPanel.setPreferredSize(this.preferredSize);
            }
            return entityPanel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private EntityPanel createPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, EntityTablePanel tablePanel) throws Exception {
        Consumer<EntityPanel.Config> configure = config -> {
            config.detailLayout(this.detailLayout);
            if (this.caption != null) {
                config.caption(this.caption);
            }
            if (this.description != null) {
                config.description(this.description);
            }
            if (this.icon != null) {
                config.icon(this.icon);
            }
        };
        return this.panelClass().getConstructor(SwingEntityModel.class, EntityEditPanel.class, EntityTablePanel.class, Consumer.class).newInstance(entityModel, editPanel, tablePanel, configure);
    }

    private EntityEditPanel createEditPanel(SwingEntityEditModel editModel) {
        if (this.editPanelClass == null) {
            throw new IllegalArgumentException("No edit panel class has been specified for entity panel builder: " + this.entityType);
        }
        if (!editModel.entityType().equals(this.entityType)) {
            throw new IllegalArgumentException("Entity type mismatch, editModel: " + editModel.entityType() + ", required: " + this.entityType);
        }
        try {
            EntityEditPanel editPanel = EntityPanelBuilder.findEditModelConstructor(this.editPanelClass).newInstance(editModel);
            this.onBuildEditPanel.accept(editPanel);
            return editPanel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private EntityTablePanel createTablePanel(SwingEntityTableModel tableModel) {
        try {
            if (!tableModel.entityType().equals(this.entityType)) {
                throw new IllegalArgumentException("Entity type mismatch, tableModel: " + tableModel.entityType() + ", required: " + this.entityType);
            }
            EntityTablePanel tablePanel = EntityPanelBuilder.findTableModelConstructor(this.tablePanelClass()).newInstance(tableModel);
            this.onBuildTablePanel.accept(tablePanel);
            return tablePanel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class<? extends EntityPanel> panelClass() {
        return this.panelClass == null ? EntityPanel.class : this.panelClass;
    }

    private Class<? extends EntityEditPanel> editPanelClass() {
        return this.editPanelClass;
    }

    private Class<? extends EntityTablePanel> tablePanelClass() {
        return this.tablePanelClass == null ? EntityTablePanel.class : this.tablePanelClass;
    }

    private static Constructor<EntityPanel> findModelConstructor(Class<? extends EntityPanel> panelClass) throws NoSuchMethodException {
        for (Constructor<EntityPanel> constructor : panelClass.getConstructors()) {
            if (constructor.getParameterCount() != 1 || !SwingEntityModel.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
            return constructor;
        }
        throw new NoSuchMethodException("Constructor with a single parameter of type SwingEntityModel (or subclass) not found in class: " + panelClass);
    }

    private static Constructor<EntityEditPanel> findEditModelConstructor(Class<? extends EntityEditPanel> editPanelClass) throws NoSuchMethodException {
        for (Constructor<EntityEditPanel> constructor : editPanelClass.getConstructors()) {
            if (constructor.getParameterCount() != 1 || !SwingEntityEditModel.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
            return constructor;
        }
        throw new NoSuchMethodException("Constructor with a single parameter of type SwingEntityEditModel (or subclass) not found in class: " + editPanelClass);
    }

    private static Constructor<EntityTablePanel> findTableModelConstructor(Class<? extends EntityTablePanel> tablePanelClass) throws NoSuchMethodException {
        for (Constructor<EntityTablePanel> constructor : tablePanelClass.getConstructors()) {
            if (constructor.getParameterCount() != 1 || !SwingEntityTableModel.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
            return constructor;
        }
        throw new NoSuchMethodException("Constructor with a single parameter of type SwingEntityTableModel (or subclass) not found in class: " + tablePanelClass);
    }

    private static final class DefaultDetailLayout
    implements Function<EntityPanel, EntityPanel.DetailLayout> {
        private DefaultDetailLayout() {
        }

        @Override
        public EntityPanel.DetailLayout apply(EntityPanel entityPanel) {
            return TabbedDetailLayout.builder(entityPanel).build();
        }
    }

    private static final class EmptyOnBuild<T>
    implements Consumer<T> {
        private EmptyOnBuild() {
        }

        @Override
        public void accept(T panel) {
        }
    }
}

