/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.model.condition.ConditionModel;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.swing.common.ui.Colors;
import is.codion.swing.common.ui.component.table.DefaultFilterTableCellRendererBuilder;
import is.codion.swing.common.ui.component.table.FilterTableCellRenderer;
import is.codion.swing.framework.model.SwingEntityTableModel;
import java.awt.Color;
import java.util.Objects;
import java.util.function.Function;

final class EntityTableCellRendererBuilder
extends DefaultFilterTableCellRendererBuilder<Attribute<?>> {
    private final ConditionModel<?> queryCondition;

    EntityTableCellRendererBuilder(SwingEntityTableModel tableModel, Attribute<?> attribute) {
        this(Objects.requireNonNull(tableModel), tableModel.entityDefinition().attributes().definition(attribute));
    }

    private EntityTableCellRendererBuilder(SwingEntityTableModel tableModel, AttributeDefinition<?> attributeDefinition) {
        super((Object)Objects.requireNonNull(attributeDefinition).attribute(), attributeDefinition.attribute().type().valueClass());
        Objects.requireNonNull(tableModel).entityDefinition().attributes().definition(attributeDefinition.attribute());
        this.queryCondition = tableModel.queryModel().conditions().optional((Object)attributeDefinition.attribute()).orElse(null);
        this.filter(tableModel.filters().optional((Object)attributeDefinition.attribute()).orElse(null));
        this.string(new DefaultString(attributeDefinition));
        this.cellColors(new EntityCellColors(tableModel));
    }

    protected FilterTableCellRenderer.Settings<Attribute<?>> settings(int leftPadding, int rightPadding, boolean alternateRowColoring) {
        return new EntitySettings(this.queryCondition, leftPadding, rightPadding, alternateRowColoring);
    }

    private static final class DefaultString
    implements Function<Object, String> {
        private final AttributeDefinition<Object> definition;

        private DefaultString(AttributeDefinition<?> attributeDefinition) {
            this.definition = attributeDefinition;
        }

        @Override
        public String apply(Object value) {
            return this.definition.string(value);
        }
    }

    private static final class EntityCellColors
    implements FilterTableCellRenderer.CellColors<Attribute<?>> {
        private final SwingEntityTableModel tableModel;

        private EntityCellColors(SwingEntityTableModel tableModel) {
            this.tableModel = tableModel;
        }

        public Color backgroundColor(int row, Attribute<?> identifier, Object cellValue, boolean selected) {
            return this.tableModel.backgroundColor(row, identifier);
        }

        public Color foregroundColor(int row, Attribute<?> identifier, Object cellValue, boolean selected) {
            return this.tableModel.foregroundColor(row, identifier);
        }
    }

    private static final class EntitySettings
    extends FilterTableCellRenderer.Settings<Attribute<?>> {
        private final ConditionModel<?> queryCondition;
        private Color backgroundColorDoubleShade;
        private Color backgroundColorAlternateDoubleShade;

        private EntitySettings(ConditionModel<?> queryCondition, int leftPadding, int rightPadding, boolean alternateRowColoring) {
            super(leftPadding, rightPadding, alternateRowColoring);
            this.queryCondition = queryCondition;
        }

        protected void updateColors() {
            super.updateColors();
            this.backgroundColorDoubleShade = Colors.darker((Color)this.backgroundColor(), (double)0.8);
            this.backgroundColorAlternateDoubleShade = Colors.darker((Color)this.backgroundColorAlternate(), (double)0.8);
        }

        protected Color backgroundColorShaded(ConditionModel<?> filter, int row, Attribute<?> identifier, Color cellBackgroundColor) {
            boolean filterEnabled;
            boolean conditionEnabled = this.queryCondition != null && (Boolean)this.queryCondition.enabled().get() != false;
            boolean bl = filterEnabled = filter != null && (Boolean)filter.enabled().get() != false;
            if (conditionEnabled || filterEnabled) {
                return this.backgroundColorShaded(row, conditionEnabled && filterEnabled, cellBackgroundColor);
            }
            return cellBackgroundColor;
        }

        private Color backgroundColorShaded(int row, boolean doubleShading, Color cellBackgroundColor) {
            if (cellBackgroundColor != null) {
                return Colors.darker((Color)cellBackgroundColor, (double)0.9);
            }
            return EntitySettings.alternateRow((int)row) ? (doubleShading ? this.backgroundColorAlternateDoubleShade : this.backgroundColorAlternateShaded()) : (doubleShading ? this.backgroundColorDoubleShade : this.backgroundColorShaded());
        }
    }
}

