/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.db.exception.ReferentialIntegrityException;
import is.codion.common.i18n.Messages;
import is.codion.common.model.FilterModel;
import is.codion.common.model.UserPreferences;
import is.codion.common.model.condition.ColumnConditions;
import is.codion.common.model.condition.ConditionModel;
import is.codion.common.model.selection.MultiItemSelection;
import is.codion.common.model.summary.SummaryModel;
import is.codion.common.model.summary.TableSummaryModel;
import is.codion.common.property.PropertyValue;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.framework.model.EntityEditModel;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.ui.Cursors;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ToolBarBuilder;
import is.codion.swing.common.ui.component.scrollpane.ScrollPaneBuilder;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.ColumnConditionsPanel;
import is.codion.swing.common.ui.component.table.ColumnSummaryPanel;
import is.codion.swing.common.ui.component.table.FilterColumnConditionPanel;
import is.codion.swing.common.ui.component.table.FilterColumnConditionsPanel;
import is.codion.swing.common.ui.component.table.FilterTable;
import is.codion.swing.common.ui.component.table.FilterTableCellEditorFactory;
import is.codion.swing.common.ui.component.table.FilterTableCellRenderer;
import is.codion.swing.common.ui.component.table.FilterTableCellRendererFactory;
import is.codion.swing.common.ui.component.table.FilterTableColumn;
import is.codion.swing.common.ui.component.table.FilterTableColumnComponentPanel;
import is.codion.swing.common.ui.component.table.FilterTableColumnModel;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.component.text.TemporalField;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.control.ControlMap;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.InputDialogBuilder;
import is.codion.swing.common.ui.dialog.ProgressWorkerDialogBuilder;
import is.codion.swing.common.ui.dialog.SelectionDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.ColumnPreferences;
import is.codion.swing.framework.ui.ConditionPreferences;
import is.codion.swing.framework.ui.EntityConditionFieldFactory;
import is.codion.swing.framework.ui.EntityDependenciesPanel;
import is.codion.swing.framework.ui.EntityDialogs;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityPopupMenu;
import is.codion.swing.framework.ui.EntityTableCellEditorFactory;
import is.codion.swing.framework.ui.EntityTableCellRendererFactory;
import is.codion.swing.framework.ui.EntityTableColumns;
import is.codion.swing.framework.ui.ReferentialIntegrityErrorHandling;
import is.codion.swing.framework.ui.component.EntityComponentFactory;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityTablePanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(EntityTablePanel.class);
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(EntityTablePanel.class, (ResourceBundle)ResourceBundle.getBundle(EntityTablePanel.class.getName()));
    private static final MessageBundle EDIT_PANEL_MESSAGES = MessageBundle.messageBundle(EntityEditPanel.class, (ResourceBundle)ResourceBundle.getBundle(EntityEditPanel.class.getName()));
    private static final FrameworkIcons ICONS = FrameworkIcons.instance();
    private static final String COLUMN_PREFERENCES = "-columns";
    private static final String CONDITIONS_PREFERENCES = "-conditions";
    private static final int FONT_SIZE_TO_ROW_HEIGHT = 4;
    private static final Consumer<Config> NO_CONFIGURATION = c -> {};
    private final State summaryPanelVisibleState = State.state((boolean)((Boolean)Config.SUMMARY_PANEL_VISIBLE.get()));
    private final State orderQueryBySortOrder = State.state((boolean)((Boolean)Config.ORDER_QUERY_BY_SORT_ORDER.get()));
    private final State queryHiddenColumns = State.state((boolean)((Boolean)Config.QUERY_HIDDEN_COLUMNS.get()));
    private final FilterTable<Entity, Attribute<?>> table;
    private final JScrollPane tableScrollPane = new JScrollPane();
    private final TablePanel tablePanel = new TablePanel();
    private final EntityEditPanel editPanel;
    private final ColumnConditionsPanel<Attribute<?>> columnConditionsPanel;
    private final Controls.Layout popupMenuLayout;
    private final Controls.Layout toolBarLayout;
    private final SwingEntityTableModel tableModel;
    private final Control conditionRefreshControl;
    private final JToolBar refreshButtonToolBar;
    private final List<Controls> additionalPopupControls = new ArrayList<Controls>();
    private final List<Controls> additionalToolBarControls = new ArrayList<Controls>();
    private final ScrollToColumn scrollToColumn = new ScrollToColumn();
    private JScrollPane conditionPanelScrollPane;
    private JScrollPane filterPanelScrollPane;
    private StatusPanel statusPanel;
    private FilterTableColumnComponentPanel<Attribute<?>> summaryPanel;
    private JScrollPane summaryPanelScrollPane;
    final Config configuration;
    private boolean initialized = false;

    public EntityTablePanel(SwingEntityTableModel tableModel) {
        this(tableModel, NO_CONFIGURATION);
    }

    public EntityTablePanel(SwingEntityTableModel tableModel, Consumer<Config> config) {
        this.tableModel = Objects.requireNonNull(tableModel, "tableModel");
        this.editPanel = null;
        this.conditionRefreshControl = this.createConditionRefreshControl();
        this.configuration = this.configure(config);
        this.table = (FilterTable)this.configuration.tableBuilder.build();
        this.columnConditionsPanel = this.createColumnConditionsPanel();
        this.refreshButtonToolBar = this.createRefreshButtonToolBar();
        this.popupMenuLayout = this.createPopupMenuLayout();
        this.toolBarLayout = this.createToolBarLayout();
        this.createControls();
        this.bindTableEvents();
        this.applyPreferences();
    }

    public EntityTablePanel(SwingEntityTableModel tableModel, EntityEditPanel editPanel) {
        this(tableModel, editPanel, NO_CONFIGURATION);
    }

    public EntityTablePanel(SwingEntityTableModel tableModel, EntityEditPanel editPanel, Consumer<Config> config) {
        this.tableModel = Objects.requireNonNull(tableModel, "tableModel");
        this.editPanel = this.validateEditModel(Objects.requireNonNull(editPanel, "editPanel"));
        this.conditionRefreshControl = this.createConditionRefreshControl();
        this.configuration = this.configure(config);
        this.table = (FilterTable)this.configuration.tableBuilder.build();
        this.columnConditionsPanel = this.createColumnConditionsPanel();
        this.refreshButtonToolBar = this.createRefreshButtonToolBar();
        this.popupMenuLayout = this.createPopupMenuLayout();
        this.toolBarLayout = this.createToolBarLayout();
        this.createControls();
        this.bindTableEvents();
        this.applyPreferences();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI((JComponent[])new JComponent[]{this.conditionPanelScrollPane, this.filterPanelScrollPane});
        Utilities.updateUI((JComponent[])new JComponent[]{this.columnConditionsPanel});
    }

    public final FilterTable<Entity, Attribute<?>> table() {
        if (this.table == null) {
            throw new IllegalStateException("The table is not available until configuration has finished");
        }
        return this.table;
    }

    public final <T extends SwingEntityTableModel> T tableModel() {
        return (T)this.tableModel;
    }

    public final <T extends ColumnConditionsPanel<Attribute<?>>> T conditionPanel() {
        if (!this.configuration.includeConditionPanel) {
            throw new IllegalStateException("No condition panel is available");
        }
        return (T)this.columnConditionsPanel;
    }

    public final State summaryPanelVisible() {
        return this.summaryPanelVisibleState;
    }

    public final State orderQueryBySortOrder() {
        return this.orderQueryBySortOrder;
    }

    public final State queryHiddenColumns() {
        return this.queryHiddenColumns;
    }

    public final void addPopupMenuControls(Controls additionalPopupMenuControls) {
        this.throwIfInitialized();
        this.additionalPopupControls.add(Objects.requireNonNull(additionalPopupMenuControls));
    }

    public final void addToolBarControls(Controls additionalToolBarControls) {
        this.throwIfInitialized();
        this.additionalToolBarControls.add(Objects.requireNonNull(additionalToolBarControls));
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.tableModel.entityType();
    }

    public final <T extends Control> Value<T> control(ControlKey<T> controlKey) {
        return this.configuration.controlMap.control(Objects.requireNonNull(controlKey));
    }

    public final void editSelected() {
        List sortedDefinitions = ((Set)this.configuration.editable.get()).stream().map(attribute -> this.tableModel.entityDefinition().attributes().definition(attribute)).sorted(AttributeDefinition.definitionComparator()).collect(Collectors.toList());
        ((SelectionDialogBuilder)Dialogs.selectionDialog(sortedDefinitions).owner((Component)this)).selectSingle().map(AttributeDefinition::attribute).ifPresent(this::editSelected);
    }

    public final void editSelected(Attribute<?> attributeToEdit) {
        Objects.requireNonNull(attributeToEdit);
        if (!((Boolean)this.tableModel.selection().empty().get()).booleanValue()) {
            this.editDialogBuilder(attributeToEdit).edit((Collection)this.tableModel.selection().items().get());
        }
    }

    public final void viewDependencies() {
        if (!((Boolean)this.tableModel.selection().empty().get()).booleanValue()) {
            EntityDependenciesPanel.displayDependenciesDialog((Collection)this.tableModel.selection().items().get(), this.tableModel.connectionProvider(), this);
        }
    }

    public final boolean deleteSelectedWithConfirmation() {
        if (this.confirmDelete()) {
            return this.deleteSelected();
        }
        return false;
    }

    public final boolean deleteSelected() {
        try {
            this.tableModel.deleteSelected();
            return true;
        }
        catch (ReferentialIntegrityException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.onException(e);
        }
        return false;
    }

    public void savePreferences() {
        try {
            UserPreferences.setUserPreference((String)(this.userPreferencesKey() + COLUMN_PREFERENCES), (String)ColumnPreferences.toString(this.createColumnPreferences()));
        }
        catch (Exception e) {
            LOG.error("Error while saving column preferences", (Throwable)e);
        }
        try {
            UserPreferences.setUserPreference((String)(this.userPreferencesKey() + CONDITIONS_PREFERENCES), (String)ConditionPreferences.toString(this.createConditionPreferences()));
        }
        catch (Exception e) {
            LOG.error("Error while saving condition preferences", (Throwable)e);
        }
    }

    public final EntityTablePanel initialize() {
        if (!this.initialized) {
            try {
                this.setupComponents();
                this.setupControls();
                this.setupStandardControls();
                this.addTablePopupMenu();
                this.addDoubleClickAction();
                this.layoutPanel(this.tablePanel, this.configuration.includeSouthPanel ? this.initializeSouthPanel() : null);
                this.setSummaryPanelVisible((Boolean)this.summaryPanelVisibleState.get());
                this.bindEvents();
                this.setupKeyboardActions();
                Utilities.updateComponentTreeUI((JComponent[])new JComponent[]{this});
            }
            finally {
                this.initialized = true;
            }
        }
        return this;
    }

    protected void setupControls() {
    }

    protected JPanel initializeSouthPanel() {
        return new SouthPanel();
    }

    protected void setupKeyboardActions() {
        this.configuration.controlMap.keyEvent(ControlKeys.REFRESH).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
        this.configuration.controlMap.keyEvent(ControlKeys.REQUEST_TABLE_FOCUS).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
        this.configuration.controlMap.keyEvent(ControlKeys.SELECT_CONDITION_PANEL).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
        this.configuration.controlMap.keyEvent(ControlKeys.TOGGLE_CONDITION_PANEL).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
        this.configuration.controlMap.keyEvent(ControlKeys.TOGGLE_FILTER_PANEL).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
        this.configuration.controlMap.keyEvent(ControlKeys.SELECT_FILTER_PANEL).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
        this.configuration.controlMap.keyEvent(ControlKeys.PRINT).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
        this.configuration.controlMap.keyEvent(ControlKeys.ADD).ifPresent(keyEvent -> keyEvent.enable(new JComponent[]{this.table}));
        this.configuration.controlMap.keyEvent(ControlKeys.EDIT).ifPresent(keyEvent -> keyEvent.enable(new JComponent[]{this.table}));
        this.configuration.controlMap.keyEvent(ControlKeys.EDIT_SELECTED_ATTRIBUTE).ifPresent(keyEvent -> keyEvent.enable(new JComponent[]{this.table}));
        this.configuration.controlMap.keyEvent(ControlKeys.DELETE).ifPresent(keyEvent -> keyEvent.enable(new JComponent[]{this.table}));
        this.configuration.controlMap.keyEvent(ControlKeys.MOVE_SELECTION_UP).ifPresent(keyEvent -> keyEvent.enable(new JComponent[]{this.table}));
        this.configuration.controlMap.keyEvent(ControlKeys.MOVE_SELECTION_DOWN).ifPresent(keyEvent -> keyEvent.enable(new JComponent[]{this.table}));
        this.configuration.controlMap.keyEvent(ControlKeys.DISPLAY_ENTITY_MENU).ifPresent(keyEvent -> keyEvent.enable(new JComponent[]{this.table}));
        this.configuration.controlMap.keyEvent(ControlKeys.DISPLAY_POPUP_MENU).ifPresent(keyEvent -> keyEvent.enable(new JComponent[]{this.table}));
    }

    protected final void configureToolBar(Consumer<Controls.Layout> toolBarLayout) {
        this.throwIfInitialized();
        Objects.requireNonNull(toolBarLayout).accept(this.toolBarLayout);
    }

    protected final void configurePopupMenu(Consumer<Controls.Layout> popupMenuLayout) {
        this.throwIfInitialized();
        Objects.requireNonNull(popupMenuLayout).accept(this.popupMenuLayout);
    }

    protected final <T extends EntityEditPanel> T editPanel() {
        if (this.editPanel == null) {
            throw new IllegalStateException("No editPanel is available");
        }
        return (T)this.editPanel;
    }

    protected void layoutPanel(JComponent tableComponent, JPanel southPanel) {
        Objects.requireNonNull(tableComponent, "tableComponent");
        this.setLayout(new BorderLayout());
        this.add((Component)tableComponent, "Center");
        if (southPanel != null) {
            this.add((Component)southPanel, "South");
        }
    }

    protected void onException(Exception exception) {
        if (exception instanceof ValidationException) {
            this.onValidationException((ValidationException)((Object)exception));
        } else if (exception instanceof ReferentialIntegrityException) {
            this.onReferentialIntegrityException((ReferentialIntegrityException)((Object)exception));
        } else {
            this.displayException(exception);
        }
    }

    protected void onReferentialIntegrityException(ReferentialIntegrityException exception) {
        Objects.requireNonNull(exception);
        if (this.configuration.referentialIntegrityErrorHandling == ReferentialIntegrityErrorHandling.DISPLAY_DEPENDENCIES) {
            EntityDependenciesPanel.displayDependenciesDialog((Collection)this.tableModel.selection().items().get(), this.tableModel.connectionProvider(), (JComponent)this, EDIT_PANEL_MESSAGES.getString("unknown_dependent_records"));
        } else {
            this.displayException((Exception)((Object)exception));
        }
    }

    protected void onValidationException(ValidationException exception) {
        Objects.requireNonNull(exception);
        String title = this.tableModel.entities().definition(exception.attribute().entityType()).attributes().definition(exception.attribute()).caption();
        JOptionPane.showMessageDialog(this, exception.getMessage(), title, 0);
    }

    protected <T> EntityDialogs.EditAttributeDialogBuilder<T> editDialogBuilder(Attribute<T> attribute) {
        return ((EntityDialogs.EditAttributeDialogBuilder)EntityDialogs.editAttributeDialog((SwingEntityEditModel)this.tableModel.editModel(), attribute).owner(this)).componentFactory(this.configuration.editComponentFactories.get(attribute));
    }

    protected String userPreferencesKey() {
        return this.tableModel.getClass().getSimpleName() + "-" + this.tableModel.entityType();
    }

    protected final void displayException(Exception exception) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            focusOwner = this;
        }
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
    }

    protected final boolean confirmDelete() {
        return this.configuration.deleteConfirmer.confirm(this);
    }

    final void clearPreferences() {
        String userPreferencesKey = this.userPreferencesKey();
        UserPreferences.removeUserPreference((String)(userPreferencesKey + COLUMN_PREFERENCES));
        UserPreferences.removeUserPreference((String)(userPreferencesKey + CONDITIONS_PREFERENCES));
    }

    private CommandControl createAddControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command((Control.Command)new AddCommand()).name(FrameworkMessages.add())).mnemonic((int)FrameworkMessages.addMnemonic())).smallIcon((Icon)ICONS.add())).build();
    }

    private CommandControl createEditControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().action((Control.ActionCommand)new EditCommand()).name(FrameworkMessages.edit())).mnemonic((int)FrameworkMessages.editMnemonic())).smallIcon((Icon)ICONS.edit())).enabled(this.tableModel().selection().single())).build();
    }

    private CommandControl createEditSelectedAttributeControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::editSelected).name(FrameworkMessages.edit())).enabled(this.createEditSelectedEnabledObserver())).smallIcon((Icon)ICONS.edit())).description(FrameworkMessages.editSelectedTip())).build();
    }

    private Controls createEditAttributeControls() {
        StateObserver editSelectedEnabledObserver = this.createEditSelectedEnabledObserver();
        Controls.ControlsBuilder builder = (Controls.ControlsBuilder)((Controls.ControlsBuilder)((Controls.ControlsBuilder)((Controls.ControlsBuilder)Controls.builder().name(FrameworkMessages.edit())).enabled(editSelectedEnabledObserver)).smallIcon((Icon)ICONS.edit())).description(FrameworkMessages.editSelectedTip());
        ((Set)this.configuration.editable.get()).stream().map(attribute -> this.tableModel.entityDefinition().attributes().definition(attribute)).sorted(AttributeDefinition.definitionComparator()).forEach(attributeDefinition -> builder.control(((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(() -> this.editSelected(attributeDefinition.attribute())).name(attributeDefinition.caption() == null ? attributeDefinition.attribute().name() : attributeDefinition.caption())).enabled(editSelectedEnabledObserver)).build()));
        Controls editControls = (Controls)builder.build();
        return editControls.empty() ? null : editControls;
    }

    private StateObserver createEditSelectedEnabledObserver() {
        StateObserver selectionNotEmpty = this.tableModel.selection().empty().not();
        State updateEnabled = ((SwingEntityEditModel)this.tableModel.editModel()).updateEnabled();
        State.Combination updateMultipleEnabledOrSingleSelection = State.or((StateObserver[])new StateObserver[]{((SwingEntityEditModel)this.tableModel.editModel()).updateMultipleEnabled(), this.tableModel.selection().single()});
        return State.and((StateObserver[])new StateObserver[]{selectionNotEmpty, updateEnabled, updateMultipleEnabledOrSingleSelection});
    }

    private CommandControl createViewDependenciesControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::viewDependencies).name(FrameworkMessages.dependencies())).enabled(this.tableModel.selection().empty().not())).description(FrameworkMessages.dependenciesTip())).smallIcon((Icon)ICONS.dependencies())).build();
    }

    private CommandControl createDeleteControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command((Control.Command)new DeleteCommand()).name(FrameworkMessages.delete())).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{((SwingEntityEditModel)this.tableModel.editModel()).deleteEnabled(), this.tableModel.selection().empty().not()}))).description(FrameworkMessages.deleteSelectedTip())).smallIcon((Icon)ICONS.delete())).build();
    }

    private CommandControl createRefreshControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(() -> ((SwingEntityTableModel)this.tableModel).refresh()).name(Messages.refresh())).description(Messages.refreshTip())).mnemonic((int)Messages.refreshMnemonic())).smallIcon((Icon)ICONS.refresh())).enabled(this.tableModel.refresher().observer().not())).build();
    }

    private CommandControl createClearControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(() -> ((FilterModel.Items)this.tableModel.items()).clear()).name(Messages.clear())).description(Messages.clearTip())).mnemonic((int)Messages.clearMnemonic())).smallIcon((Icon)ICONS.clear())).build();
    }

    private Controls createPrintControls() {
        Controls.ControlsBuilder builder = (Controls.ControlsBuilder)((Controls.ControlsBuilder)((Controls.ControlsBuilder)Controls.builder().name(Messages.print())).mnemonic((int)Messages.printMnemonic())).smallIcon((Icon)ICONS.print());
        this.control(ControlKeys.PRINT).optional().ifPresent(arg_0 -> ((Controls.ControlsBuilder)builder).control(arg_0));
        Controls printControls = (Controls)builder.build();
        return printControls.empty() ? null : printControls;
    }

    private Controls createAdditionalPopupControls() {
        Controls.ControlsBuilder builder = Controls.builder();
        this.additionalPopupControls.forEach(additionalControls -> {
            if (!additionalControls.name().isPresent()) {
                builder.actions((Collection)additionalControls.actions());
            } else {
                builder.control((Control)additionalControls);
            }
        });
        Controls additionalControls2 = (Controls)builder.build();
        return additionalControls2.empty() ? null : additionalControls2;
    }

    private Controls createAdditionalToolbarControls() {
        Controls.ControlsBuilder builder = Controls.builder();
        this.additionalToolBarControls.forEach(additionalControls -> {
            if (!additionalControls.name().isPresent()) {
                builder.actions((Collection)additionalControls.actions());
            } else {
                builder.control((Control)additionalControls);
            }
        });
        Controls additionalControls2 = (Controls)builder.build();
        return additionalControls2.empty() ? null : additionalControls2;
    }

    private CommandControl createToggleConditionPanelControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::toggleConditionPanel).smallIcon((Icon)ICONS.search())).description(MESSAGES.getString("show_condition_panel"))).build();
    }

    private CommandControl createSelectConditionPanelControl() {
        return Control.command(() -> this.conditionPanel().selectConditionPanel((JComponent)this));
    }

    private Controls createConditionControls() {
        if (!this.configuration.includeConditionPanel || this.columnConditionsPanel == null) {
            return null;
        }
        Controls.ControlsBuilder builder = (Controls.ControlsBuilder)((Controls.ControlsBuilder)Controls.builder().name(FrameworkMessages.searchNoun())).smallIcon((Icon)ICONS.search());
        Controls conditionPanelControls = this.columnConditionsPanel.controls();
        if (conditionPanelControls.notEmpty()) {
            builder.actions((Collection)conditionPanelControls.actions());
            builder.separator();
        }
        builder.control(((ToggleControl.ToggleControlBuilder)((ToggleControl.ToggleControlBuilder)Control.builder().toggle(this.tableModel.queryModel().conditionRequired()).name(MESSAGES.getString("require_query_condition"))).description(MESSAGES.getString("require_query_condition_description"))).build());
        Controls conditionControls = (Controls)builder.build();
        return conditionControls.empty() ? null : conditionControls;
    }

    private CommandControl createToggleFilterPanelControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::toggleFilterPanel).smallIcon((Icon)ICONS.filter())).description(MESSAGES.getString("show_filter_panel"))).build();
    }

    private CommandControl createSelectFilterPanelControl() {
        return Control.command(() -> this.table.filterPanel().selectConditionPanel((JComponent)this));
    }

    private void toggleConditionPanel() {
        Value conditionState = this.conditionPanel().state();
        switch ((ColumnConditionPanel.ConditionState)conditionState.get()) {
            case HIDDEN: {
                conditionState.set((Object)ColumnConditionPanel.ConditionState.SIMPLE);
                break;
            }
            case SIMPLE: {
                conditionState.set((Object)ColumnConditionPanel.ConditionState.ADVANCED);
                break;
            }
            case ADVANCED: {
                this.setConditionStateHidden(this.conditionPanelScrollPane, (Value<ColumnConditionPanel.ConditionState>)conditionState);
            }
        }
    }

    private void toggleFilterPanel() {
        Value conditionState = this.table.filterPanel().state();
        switch ((ColumnConditionPanel.ConditionState)conditionState.get()) {
            case HIDDEN: {
                conditionState.set((Object)ColumnConditionPanel.ConditionState.SIMPLE);
                break;
            }
            case SIMPLE: {
                conditionState.set((Object)ColumnConditionPanel.ConditionState.ADVANCED);
                break;
            }
            case ADVANCED: {
                this.setConditionStateHidden(this.filterPanelScrollPane, (Value<ColumnConditionPanel.ConditionState>)conditionState);
            }
        }
    }

    private Controls createFilterControls() {
        Controls filterControls;
        if (!this.configuration.includeFilterPanel) {
            return null;
        }
        Controls.ControlsBuilder builder = (Controls.ControlsBuilder)((Controls.ControlsBuilder)Controls.builder().name(FrameworkMessages.filterNoun())).smallIcon((Icon)ICONS.filter());
        Controls filterPanelControls = this.table.filterPanel().controls();
        if (filterPanelControls.notEmpty()) {
            builder.actions((Collection)filterPanelControls.actions());
        }
        return (filterControls = (Controls)builder.build()).empty() ? null : filterControls;
    }

    private ToggleControl createToggleSummaryPanelControl() {
        return (ToggleControl)((ToggleControl.ToggleControlBuilder)((ToggleControl.ToggleControlBuilder)Control.builder().toggle(this.summaryPanelVisibleState).smallIcon((Icon)ICONS.summary())).description(MESSAGES.getString("toggle_summary_tip"))).build();
    }

    private CommandControl createClearSelectionControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(() -> ((FilterTableModel.TableSelection)this.tableModel.selection()).clear()).enabled(this.tableModel.selection().empty().not())).smallIcon((Icon)ICONS.clearSelection())).description(MESSAGES.getString("clear_selection_tip"))).build();
    }

    private CommandControl createMoveSelectionDownControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(() -> ((MultiItemSelection.Indexes)this.tableModel.selection().indexes()).moveDown()).smallIcon((Icon)ICONS.down())).description(MESSAGES.getString("selection_down_tip"))).build();
    }

    private CommandControl createMoveSelectionUpControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(() -> ((MultiItemSelection.Indexes)this.tableModel.selection().indexes()).moveUp()).smallIcon((Icon)ICONS.up())).description(MESSAGES.getString("selection_up_tip"))).build();
    }

    private CommandControl createRequestTableFocusControl() {
        return Control.command(() -> this.table.requestFocus());
    }

    private CommandControl createRequestSearchFieldFocusControl() {
        return Control.command(this.table.searchField()::requestFocusInWindow);
    }

    private Controls createColumnControls() {
        Controls.ControlsBuilder builder = (Controls.ControlsBuilder)((Controls.ControlsBuilder)Controls.builder().name(MESSAGES.getString("columns"))).smallIcon((Icon)ICONS.columns());
        if (this.configuration.columnSelection == ColumnSelection.DIALOG) {
            this.control(ControlKeys.SELECT_COLUMNS).optional().ifPresent(arg_0 -> ((Controls.ControlsBuilder)builder).control(arg_0));
        } else {
            this.control(ControlKeys.TOGGLE_COLUMN_CONTROLS).optional().ifPresent(arg_0 -> ((Controls.ControlsBuilder)builder).control(arg_0));
        }
        this.control(ControlKeys.RESET_COLUMNS).optional().ifPresent(arg_0 -> ((Controls.ControlsBuilder)builder).control(arg_0));
        if (this.configuration.autoResizeModeSelection == AutoResizeModeSelection.DIALOG) {
            this.control(ControlKeys.SELECT_AUTO_RESIZE_MODE).optional().ifPresent(arg_0 -> ((Controls.ControlsBuilder)builder).control(arg_0));
        } else {
            this.control(ControlKeys.TOGGLE_AUTO_RESIZE_MODE_CONTROLS).optional().ifPresent(arg_0 -> ((Controls.ControlsBuilder)builder).control(arg_0));
        }
        Controls columnControls = (Controls)builder.build();
        return columnControls.empty() ? null : columnControls;
    }

    private Controls createCopyControls() {
        Controls.ControlsBuilder builder = (Controls.ControlsBuilder)((Controls.ControlsBuilder)Controls.builder().name(Messages.copy())).smallIcon((Icon)ICONS.copy());
        this.control(ControlKeys.COPY_CELL).optional().ifPresent(arg_0 -> ((Controls.ControlsBuilder)builder).control(arg_0));
        this.control(ControlKeys.COPY_ROWS).optional().ifPresent(arg_0 -> ((Controls.ControlsBuilder)builder).control(arg_0));
        Controls copyControls = (Controls)builder.build();
        return copyControls.empty() ? null : copyControls;
    }

    private CommandControl createCopyRowsControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)Control.builder().command(() -> this.table.copyToClipboard()).name(FrameworkMessages.copyTableWithHeader())).build();
    }

    private boolean includeAddControl() {
        return this.editPanel != null && this.configuration.includeAddControl && (Boolean)((SwingEntityEditModel)this.tableModel.editModel()).readOnly().get() == false && (Boolean)((SwingEntityEditModel)this.tableModel.editModel()).insertEnabled().get() != false;
    }

    private boolean includeEditControl() {
        return this.editPanel != null && this.updatable() && this.configuration.includeEditControl;
    }

    private boolean includeEditAttributeControls() {
        return !this.configuration.editable.empty() && this.updatable() && this.configuration.includeEditAttributeControl;
    }

    private boolean updatable() {
        return (Boolean)((SwingEntityEditModel)this.tableModel.editModel()).readOnly().get() == false && (Boolean)((SwingEntityEditModel)this.tableModel.editModel()).updateEnabled().get() != false;
    }

    private boolean includeDeleteControl() {
        return (Boolean)((SwingEntityEditModel)this.tableModel.editModel()).readOnly().get() == false && (Boolean)((SwingEntityEditModel)this.tableModel.editModel()).deleteEnabled().get() != false;
    }

    private boolean includeViewDependenciesControl() {
        return this.tableModel.entities().definitions().stream().flatMap(entityDefinition -> entityDefinition.foreignKeys().definitions().stream()).filter(foreignKeyDefinition -> !foreignKeyDefinition.soft()).anyMatch(foreignKeyDefinition -> foreignKeyDefinition.attribute().referencedType().equals(this.tableModel.entityType()));
    }

    private boolean includeToggleSummaryPanelControl() {
        return this.configuration.includeSummaryPanel && EntityTablePanel.containsSummaryModels(this.table);
    }

    private Control createConditionRefreshControl() {
        return ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(() -> ((SwingEntityTableModel)this.tableModel).refresh()).enabled(this.tableModel.queryModel().conditionChanged())).smallIcon((Icon)ICONS.refreshRequired())).build();
    }

    private JToolBar createRefreshButtonToolBar() {
        KeyEvents.builder((int)116).condition(1).action((Action)this.conditionRefreshControl).enable(new JComponent[]{this});
        return (JToolBar)((ToolBarBuilder)((ToolBarBuilder)Components.toolBar().action((Action)this.conditionRefreshControl)).floatable(false).rollover(false).visible(this.configuration.refreshButtonVisible == RefreshButtonVisible.ALWAYS || this.columnConditionsPanel != null && this.columnConditionsPanel.state().isNotEqualTo((Object)ColumnConditionPanel.ConditionState.HIDDEN))).build();
    }

    private ColumnConditionsPanel<Attribute<?>> createColumnConditionsPanel() {
        if (this.configuration.includeConditionPanel) {
            ColumnConditionsPanel conditionPanel = this.configuration.columnConditionsPanelFactory.create((ColumnConditions)this.tableModel.queryModel().conditions(), this.createColumnConditionPanels(), this.table.getColumnModel(), this::configureTableConditionPanel);
            KeyEvents.builder((int)10).condition(1).action((Action)this.conditionRefreshControl).enable(new JComponent[]{conditionPanel});
            conditionPanel.state().addConsumer(this.tablePanel::conditionPanelStateChanged);
            return conditionPanel;
        }
        return null;
    }

    private Collection<ColumnConditionPanel<Attribute<?>, ?>> createColumnConditionPanels() {
        ArrayList conditionPanels = new ArrayList();
        this.tableModel.queryModel().conditions().get().entrySet().stream().filter(entry -> this.table.columnModel().containsColumn((Object)((Attribute)entry.getKey()))).filter(entry -> this.configuration.conditionFieldFactory.supportsType(((ConditionModel)entry.getValue()).valueClass())).forEach(entry -> conditionPanels.add((ColumnConditionPanel<Attribute<?>, ?>)this.createColumnConditionPanel((ConditionModel)entry.getValue(), (Attribute)entry.getKey())));
        return conditionPanels;
    }

    private <C extends Attribute<?>> FilterColumnConditionPanel<C, ?> createColumnConditionPanel(ConditionModel<?> condition, C identifier) {
        return FilterColumnConditionPanel.builder(condition, identifier).fieldFactory(this.configuration.conditionFieldFactory).tableColumn((TableColumn)this.table.columnModel().column(identifier)).caption(Objects.toString(this.table.columnModel().column(identifier).getHeaderValue())).build();
    }

    private void configureTableConditionPanel(ColumnConditionsPanel<Attribute<?>> columnConditionsPanel) {
        columnConditionsPanel.conditionPanels().forEach(this::configureColumnConditionPanel);
    }

    private void configureColumnConditionPanel(ColumnConditionPanel<Attribute<?>, ?> conditionPanel) {
        conditionPanel.focusGainedObserver().ifPresent(focusGainedObserver -> focusGainedObserver.addConsumer((Consumer)this.scrollToColumn));
        conditionPanel.components().forEach(this::enableConditionPanelRefreshOnEnter);
    }

    private void bindTableEvents() {
        Runnable setSelectAttributes = () -> this.tableModel.queryModel().attributes().set(this.selectAttributes());
        this.table.columnModel().columnShown().addListener(setSelectAttributes);
        this.table.columnModel().columnHidden().addListener(setSelectAttributes);
        this.table.columnModel().columnHidden().addConsumer(this::onColumnHidden);
        this.queryHiddenColumns.addListener(setSelectAttributes);
        this.orderQueryBySortOrder.addConsumer(enabled -> this.tableModel.queryModel().orderBy().set((Object)(enabled != false ? this.orderByFromSortModel() : null)));
        this.table.sortModel().sortingChanged().addListener(() -> this.tableModel.queryModel().orderBy().set((Object)((Boolean)this.orderQueryBySortOrder.get() != false ? this.orderByFromSortModel() : null)));
    }

    private void bindEvents() {
        this.summaryPanelVisibleState.addConsumer(this::setSummaryPanelVisible);
        this.tableModel.queryModel().conditions().changed().addListener(this::onConditionChanged);
        this.tableModel.refresher().observer().addConsumer(this::onRefreshingChanged);
        this.tableModel.refresher().failure().addConsumer(this::onException);
        ((SwingEntityEditModel)this.tableModel.editModel()).afterInsertUpdateOrDelete().addListener(() -> this.table.repaint());
        if (this.configuration.includeFilterPanel) {
            this.table.filterPanel().conditionPanels().forEach(conditionPanel -> conditionPanel.focusGainedObserver().ifPresent(focusGainedObserver -> focusGainedObserver.addConsumer((Consumer)this.scrollToColumn)));
        }
    }

    private void enableConditionPanelRefreshOnEnter(JComponent component) {
        if (component instanceof JComboBox) {
            new ComboBoxEnterPressedAction((JComboBox)component, (Action)this.conditionRefreshControl);
        } else if (component instanceof TemporalField) {
            ((TemporalField)component).addActionListener((ActionListener)this.conditionRefreshControl);
        }
    }

    private void setSummaryPanelVisible(boolean visible) {
        if (this.summaryPanelScrollPane != null) {
            this.summaryPanelScrollPane.setVisible(visible);
            this.revalidate();
        }
    }

    private void setupComponents() {
        this.tableScrollPane.setViewportView((Component)this.table());
        this.tablePanel.initialize();
        this.table.getColumnModel().columns().forEach(this::configureColumn);
        this.summaryPanelVisibleState.addValidator((Value.Validator)new ComponentAvailableValidator((JComponent)this.summaryPanel, "summary"));
    }

    private void createControls() {
        Value.Validator controlValueValidator = control -> {
            if (this.initialized) {
                throw new IllegalStateException("Controls must be configured before the panel is initialized");
            }
        };
        ControlMap controlMap = this.configuration.controlMap;
        controlMap.controls().forEach(control -> control.addValidator(controlValueValidator));
        if (this.includeDeleteControl()) {
            controlMap.control(ControlKeys.DELETE).set((Object)this.createDeleteControl());
        }
        if (this.includeAddControl()) {
            controlMap.control(ControlKeys.ADD).set((Object)this.createAddControl());
        }
        if (this.includeEditControl()) {
            controlMap.control(ControlKeys.EDIT).set((Object)this.createEditControl());
        }
        if (this.includeEditAttributeControls()) {
            controlMap.control(ControlKeys.EDIT_ATTRIBUTE_CONTROLS).set((Object)this.createEditAttributeControls());
            controlMap.control(ControlKeys.EDIT_SELECTED_ATTRIBUTE).set((Object)this.createEditSelectedAttributeControl());
        }
        if (this.configuration.includeClearControl) {
            controlMap.control(ControlKeys.CLEAR).set((Object)this.createClearControl());
        }
        controlMap.control(ControlKeys.REFRESH).set((Object)this.createRefreshControl());
        controlMap.control(ControlKeys.SELECT_COLUMNS).set((Object)this.table.createSelectColumnsControl());
        controlMap.control(ControlKeys.TOGGLE_COLUMN_CONTROLS).set((Object)this.table.createToggleColumnsControls());
        controlMap.control(ControlKeys.RESET_COLUMNS).set((Object)this.table.createResetColumnsControl());
        controlMap.control(ControlKeys.SELECT_AUTO_RESIZE_MODE).set((Object)this.table.createSelectAutoResizeModeControl());
        controlMap.control(ControlKeys.TOGGLE_AUTO_RESIZE_MODE_CONTROLS).set((Object)this.table.createToggleAutoResizeModeControls());
        if (this.includeViewDependenciesControl()) {
            controlMap.control(ControlKeys.VIEW_DEPENDENCIES).set((Object)this.createViewDependenciesControl());
        }
        if (this.includeToggleSummaryPanelControl()) {
            controlMap.control(ControlKeys.TOGGLE_SUMMARY_PANEL).set((Object)this.createToggleSummaryPanelControl());
        }
        if (this.configuration.includeConditionPanel) {
            controlMap.control(ControlKeys.TOGGLE_CONDITION_PANEL).set((Object)this.createToggleConditionPanelControl());
            controlMap.control(ControlKeys.SELECT_CONDITION_PANEL).set((Object)this.createSelectConditionPanelControl());
        }
        if (this.configuration.includeFilterPanel) {
            controlMap.control(ControlKeys.TOGGLE_FILTER_PANEL).set((Object)this.createToggleFilterPanelControl());
            controlMap.control(ControlKeys.SELECT_FILTER_PANEL).set((Object)this.createSelectFilterPanelControl());
        }
        controlMap.control(ControlKeys.CLEAR_SELECTION).set((Object)this.createClearSelectionControl());
        controlMap.control(ControlKeys.MOVE_SELECTION_UP).set((Object)this.createMoveSelectionUpControl());
        controlMap.control(ControlKeys.MOVE_SELECTION_DOWN).set((Object)this.createMoveSelectionDownControl());
        controlMap.control(ControlKeys.COPY_CELL).set((Object)this.table.createCopyCellControl());
        controlMap.control(ControlKeys.COPY_ROWS).set((Object)this.createCopyRowsControl());
        if (this.configuration.includeEntityMenu) {
            controlMap.control(ControlKeys.DISPLAY_ENTITY_MENU).set((Object)Control.command(this::showEntityMenu));
        }
        if (this.configuration.includePopupMenu) {
            controlMap.control(ControlKeys.DISPLAY_POPUP_MENU).set((Object)Control.command(this::showPopupMenu));
        }
        if (this.configuration.includeSelectionModeControl) {
            controlMap.control(ControlKeys.SELECTION_MODE).set((Object)this.table.createSingleSelectionModeControl());
        }
        controlMap.control(ControlKeys.REQUEST_TABLE_FOCUS).set((Object)this.createRequestTableFocusControl());
        controlMap.control(ControlKeys.REQUEST_SEARCH_FIELD_FOCUS).set((Object)this.createRequestSearchFieldFocusControl());
    }

    private void setupStandardControls() {
        this.control(ControlKeys.ADDITIONAL_POPUP_MENU_CONTROLS).map((Function)new ReplaceIfNull(this::createAdditionalPopupControls));
        this.control(ControlKeys.ADDITIONAL_TOOLBAR_CONTROLS).map((Function)new ReplaceIfNull(this::createAdditionalToolbarControls));
        this.control(ControlKeys.PRINT_CONTROLS).map((Function)new ReplaceIfNull(this::createPrintControls));
        this.control(ControlKeys.CONDITION_CONTROLS).map((Function)new ReplaceIfNull(this::createConditionControls));
        this.control(ControlKeys.FILTER_CONTROLS).map((Function)new ReplaceIfNull(this::createFilterControls));
        this.control((ControlKey)ControlKeys.COLUMN_CONTROLS).map((Function)new ReplaceIfNull(this::createColumnControls));
        this.control((ControlKey)ControlKeys.COPY_CONTROLS).map((Function)new ReplaceIfNull(this::createCopyControls));
    }

    private void configureColumn(FilterTableColumn<Attribute<?>> column) {
        column.setHeaderRenderer((TableCellRenderer)new HeaderRenderer(column.getHeaderRenderer()));
    }

    private void addTablePopupMenu() {
        if (this.configuration.includePopupMenu) {
            Controls popupControls = this.popupMenuLayout.create(this.configuration.controlMap);
            if (popupControls == null || popupControls.empty()) {
                return;
            }
            JPopupMenu popupMenu = Components.menu((Controls)popupControls).buildPopupMenu();
            this.table.setComponentPopupMenu(popupMenu);
            this.tableScrollPane.setComponentPopupMenu(popupMenu);
        }
    }

    private void addDoubleClickAction() {
        if (this.table.doubleClickAction().isNull()) {
            this.control(ControlKeys.EDIT).optional().ifPresent(arg_0 -> ((Value)this.table.doubleClickAction()).set(arg_0));
        }
    }

    private void showEntityMenu() {
        Point location = EntityTablePanel.popupLocation(this.table);
        this.tableModel.selection().item().optional().ifPresent(selected -> new EntityPopupMenu(selected.copy(), this.tableModel.connection()).show((Component)this.table, location.x, location.y));
    }

    private void showPopupMenu() {
        Point location = EntityTablePanel.popupLocation(this.table);
        this.table.getComponentPopupMenu().show((Component)this.table, location.x, location.y);
    }

    private void onConditionChanged() {
        if (this.table != null) {
            this.table.getTableHeader().repaint();
            this.table.repaint();
        }
    }

    private void onRefreshingChanged(boolean refreshing) {
        if (refreshing) {
            this.setCursor(Cursors.WAIT);
        } else {
            this.setCursor(Cursors.DEFAULT);
        }
    }

    private void setConditionStateHidden(JScrollPane scrollPane, Value<ColumnConditionPanel.ConditionState> conditionState) {
        boolean conditionPanelHasFocus;
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        boolean bl = conditionPanelHasFocus = Utilities.parentOfType(JScrollPane.class, (Component)focusManager.getFocusOwner()) == scrollPane;
        if (conditionPanelHasFocus) {
            focusManager.clearFocusOwner();
        }
        conditionState.set((Object)ColumnConditionPanel.ConditionState.HIDDEN);
        if (conditionPanelHasFocus) {
            this.table.requestFocusInWindow();
        }
    }

    private EntityEditPanel validateEditModel(EntityEditPanel editPanel) {
        if (editPanel.editModel() != this.tableModel.editModel()) {
            throw new IllegalArgumentException("Edit panel model must be the same as the table edit model");
        }
        return editPanel;
    }

    private Map<Attribute<?>, ColumnPreferences> createColumnPreferences() {
        HashMap columnPreferencesMap = new HashMap();
        FilterTableColumnModel columnModel = this.table.getColumnModel();
        for (FilterTableColumn column : columnModel.columns()) {
            Attribute attribute = (Attribute)column.identifier();
            int index = (Boolean)columnModel.visible((Object)attribute).get() != false ? columnModel.getColumnIndex((Object)attribute) : -1;
            columnPreferencesMap.put(attribute, ColumnPreferences.columnPreferences(attribute, index, column.getWidth()));
        }
        return columnPreferencesMap;
    }

    private Map<Attribute<?>, ConditionPreferences> createConditionPreferences() {
        HashMap conditionPreferencesMap = new HashMap();
        for (Attribute attribute : this.tableModel.columns().identifiers()) {
            this.tableModel.queryModel().conditions().optional((Object)attribute).ifPresent(condition -> conditionPreferencesMap.put(attribute, ConditionPreferences.conditionPreferences(attribute, (Boolean)condition.autoEnable().get(), (Boolean)condition.caseSensitive().get(), (ConditionModel.Wildcard)condition.wildcard().get())));
        }
        return conditionPreferencesMap;
    }

    private void applyConditionPreferences(String preferencesString) {
        try {
            ConditionPreferences.apply(this.tableModel, this.tableModel.columns().identifiers(), preferencesString);
        }
        catch (Exception e) {
            LOG.error("Error while applying condition preferences: {}", (Object)preferencesString, (Object)e);
        }
    }

    private Collection<Attribute<?>> selectAttributes() {
        FilterTableColumnModel columnModel = this.table.getColumnModel();
        if (((Boolean)this.queryHiddenColumns.get()).booleanValue() || columnModel.hidden().isEmpty()) {
            return Collections.emptyList();
        }
        return this.tableModel.entityDefinition().attributes().selected().stream().filter(this::columnNotHidden).collect(Collectors.toList());
    }

    private boolean columnNotHidden(Attribute<?> attribute) {
        return !this.table.getColumnModel().containsColumn(attribute) || (Boolean)this.table.getColumnModel().visible(attribute).get() != false;
    }

    private OrderBy orderByFromSortModel() {
        if (!this.table.sortModel().sorted()) {
            return null;
        }
        OrderBy.Builder builder = OrderBy.builder();
        this.table.sortModel().columnSortOrder().stream().filter(columnSortOrder -> this.isColumn((Attribute)columnSortOrder.identifier())).forEach(columnSortOrder -> {
            switch (columnSortOrder.sortOrder()) {
                case ASCENDING: {
                    builder.ascending(new Column[]{(Column)columnSortOrder.identifier()});
                    break;
                }
                case DESCENDING: {
                    builder.descending(new Column[]{(Column)columnSortOrder.identifier()});
                    break;
                }
            }
        });
        return builder.build();
    }

    private boolean isColumn(Attribute<?> attribute) {
        return this.tableModel.entityDefinition().attributes().definition(attribute) instanceof ColumnDefinition;
    }

    private void onColumnHidden(Attribute<?> attribute) {
        this.tableModel.filters().optional(attribute).ifPresent(condition -> condition.enabled().set((Object)false));
    }

    private void applyPreferences() {
        String conditionPreferencesString;
        String columnPreferencesString = UserPreferences.getUserPreference((String)(this.userPreferencesKey() + COLUMN_PREFERENCES), (String)"");
        if (columnPreferencesString.isEmpty()) {
            columnPreferencesString = UserPreferences.getUserPreference((String)this.userPreferencesKey(), (String)"");
        }
        if (!columnPreferencesString.isEmpty()) {
            this.applyColumnPreferences(columnPreferencesString);
        }
        if (!(conditionPreferencesString = UserPreferences.getUserPreference((String)(this.userPreferencesKey() + CONDITIONS_PREFERENCES), (String)"")).isEmpty()) {
            this.applyConditionPreferences(conditionPreferencesString);
        }
    }

    private void applyColumnPreferences(String preferencesString) {
        List<Attribute<?>> columnAttributes = this.table.getColumnModel().columns().stream().map(FilterTableColumn::identifier).collect(Collectors.toList());
        try {
            ColumnPreferences.apply(this, columnAttributes, preferencesString, (attribute, columnWidth) -> this.table.getColumnModel().column(attribute).setPreferredWidth(columnWidth.intValue()));
        }
        catch (Exception e) {
            LOG.error("Error while applying column preferences: {}", (Object)preferencesString, (Object)e);
        }
    }

    private void throwIfInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Method must be called before the panel is initialized");
        }
    }

    private Config configure(Consumer<Config> configuration) {
        Config config = new Config(this);
        Objects.requireNonNull(configuration).accept(config);
        return new Config(config);
    }

    private Controls.Layout createPopupMenuLayout() {
        return Controls.layout(Arrays.asList(ControlKeys.REFRESH, ControlKeys.CLEAR, null, ControlKeys.ADD, ControlKeys.EDIT, ControlKeys.DELETE, null, this.configuration.popupMenuEditAttributeControl(), null, ControlKeys.VIEW_DEPENDENCIES, null, ControlKeys.ADDITIONAL_POPUP_MENU_CONTROLS, null, ControlKeys.PRINT_CONTROLS, null, ControlKeys.COLUMN_CONTROLS, null, ControlKeys.SELECTION_MODE, null, ControlKeys.CONDITION_CONTROLS, null, ControlKeys.FILTER_CONTROLS, null, ControlKeys.COPY_CONTROLS));
    }

    private Controls.Layout createToolBarLayout() {
        return Controls.layout(Arrays.asList(ControlKeys.TOGGLE_SUMMARY_PANEL, ControlKeys.TOGGLE_CONDITION_PANEL, ControlKeys.TOGGLE_FILTER_PANEL, null, ControlKeys.ADD, ControlKeys.EDIT, ControlKeys.DELETE, null, this.editPanel == null ? ControlKeys.EDIT_SELECTED_ATTRIBUTE : null, null, ControlKeys.PRINT, null, ControlKeys.ADDITIONAL_TOOLBAR_CONTROLS));
    }

    private static GridBagConstraints createHorizontalFillConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        return constraints;
    }

    private static Point popupLocation(JTable table) {
        Rectangle visibleRect = table.getVisibleRect();
        int x = visibleRect.x + visibleRect.width / 2;
        int y = table.getSelectionModel().isSelectionEmpty() ? visibleRect.y + visibleRect.height / 2 : table.getCellRect((int)table.getSelectedRow(), (int)table.getSelectedColumn(), (boolean)true).y;
        return new Point(x, y + table.getRowHeight() / 2);
    }

    private static boolean containsSummaryModels(FilterTable<Entity, Attribute<?>> table) {
        return table.getColumnModel().columns().stream().map(FilterTableColumn::identifier).map(arg_0 -> ((TableSummaryModel)table.summaryModel()).summaryModel(arg_0)).anyMatch(Optional::isPresent);
    }

    public static final class Config {
        public static final PropertyValue<Boolean> QUERY_HIDDEN_COLUMNS = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".queryHiddenColumns"), (boolean)true);
        public static final PropertyValue<Boolean> ORDER_QUERY_BY_SORT_ORDER = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".orderQueryBySortOrder"), (boolean)false);
        public static final PropertyValue<ColumnConditionPanel.ConditionState> CONDITION_STATE = Configuration.enumValue((String)(EntityTablePanel.class.getName() + ".conditionState"), ColumnConditionPanel.ConditionState.class, (Enum)ColumnConditionPanel.ConditionState.HIDDEN);
        public static final PropertyValue<ColumnConditionPanel.ConditionState> FILTER_STATE = Configuration.enumValue((String)(EntityTablePanel.class.getName() + ".filterState"), ColumnConditionPanel.ConditionState.class, (Enum)ColumnConditionPanel.ConditionState.HIDDEN);
        public static final PropertyValue<Boolean> SUMMARY_PANEL_VISIBLE = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".summaryPanelVisible"), (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_POPUP_MENU = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includePopupMenu"), (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_ENTITY_MENU = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeEntityMenu"), (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_CLEAR_CONTROL = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeClearControl"), (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_CONDITION_PANEL = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeConditionPanel"), (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_FILTER_PANEL = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeFilterPanel"), (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_SUMMARY_PANEL = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeSummaryPanel"), (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_LIMIT_MENU = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeLimitMenu"), (boolean)false);
        public static final PropertyValue<Boolean> SHOW_REFRESH_PROGRESS_BAR = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".showRefreshProgressBar"), (boolean)false);
        public static final PropertyValue<RefreshButtonVisible> REFRESH_BUTTON_VISIBLE = Configuration.enumValue((String)(EntityTablePanel.class.getName() + ".refreshButtonVisible"), RefreshButtonVisible.class, (Enum)RefreshButtonVisible.WHEN_CONDITION_PANEL_IS_VISIBLE);
        public static final PropertyValue<ColumnSelection> COLUMN_SELECTION = Configuration.enumValue((String)(EntityTablePanel.class.getName() + ".columnSelection"), ColumnSelection.class, (Enum)ColumnSelection.DIALOG);
        public static final PropertyValue<AutoResizeModeSelection> AUTO_RESIZE_MODE_SELECTION = Configuration.enumValue((String)(EntityTablePanel.class.getName() + ".autoResizeModeSelection"), AutoResizeModeSelection.class, (Enum)AutoResizeModeSelection.DIALOG);
        public static final PropertyValue<EditAttributeSelection> EDIT_ATTRIBUTE_SELECTION = Configuration.enumValue((String)(EntityTablePanel.class.getName() + ".editAttributeSelection"), EditAttributeSelection.class, (Enum)EditAttributeSelection.MENU);
        private static final Function<SwingEntityTableModel, String> DEFAULT_STATUS_MESSAGE = new DefaultStatusMessage();
        private final EntityTablePanel tablePanel;
        private final EntityDefinition entityDefinition;
        private final ValueSet<Attribute<?>> editable;
        private final Map<Attribute<?>, EntityComponentFactory<?, ?>> editComponentFactories;
        private final FilterTable.Builder<Entity, Attribute<?>> tableBuilder;
        private ColumnConditionsPanel.Factory<Attribute<?>> columnConditionsPanelFactory = new DefaultColumnConditionsPanelFactory();
        private FilterColumnConditionPanel.FieldFactory<Attribute<?>> conditionFieldFactory;
        private boolean includeSouthPanel = true;
        private boolean includeConditionPanel = (Boolean)INCLUDE_CONDITION_PANEL.get();
        private boolean includeFilterPanel = (Boolean)INCLUDE_FILTER_PANEL.get();
        private boolean includeSummaryPanel = (Boolean)INCLUDE_SUMMARY_PANEL.get();
        private boolean includeClearControl = (Boolean)INCLUDE_CLEAR_CONTROL.get();
        private boolean includeLimitMenu = (Boolean)INCLUDE_LIMIT_MENU.get();
        private boolean includeEntityMenu = (Boolean)INCLUDE_ENTITY_MENU.get();
        private boolean includePopupMenu = (Boolean)INCLUDE_POPUP_MENU.get();
        private boolean includeSelectionModeControl = false;
        private boolean includeAddControl = true;
        private boolean includeEditControl = true;
        private boolean includeEditAttributeControl = true;
        private boolean includeToolBar = true;
        private ColumnSelection columnSelection = (ColumnSelection)((Object)COLUMN_SELECTION.get());
        private AutoResizeModeSelection autoResizeModeSelection = (AutoResizeModeSelection)((Object)AUTO_RESIZE_MODE_SELECTION.get());
        private EditAttributeSelection editAttributeSelection = (EditAttributeSelection)((Object)EDIT_ATTRIBUTE_SELECTION.get());
        private ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling = (ReferentialIntegrityErrorHandling)((Object)ReferentialIntegrityErrorHandling.REFERENTIAL_INTEGRITY_ERROR_HANDLING.get());
        private RefreshButtonVisible refreshButtonVisible = (RefreshButtonVisible)((Object)REFRESH_BUTTON_VISIBLE.get());
        private Function<SwingEntityTableModel, String> statusMessage = DEFAULT_STATUS_MESSAGE;
        private boolean showRefreshProgressBar = (Boolean)SHOW_REFRESH_PROGRESS_BAR.get();
        private EntityEditPanel.Confirmer deleteConfirmer;
        final ControlMap controlMap;

        private Config(EntityTablePanel tablePanel) {
            this.tablePanel = tablePanel;
            this.entityDefinition = tablePanel.tableModel.entityDefinition();
            this.tableBuilder = (FilterTable.Builder)FilterTable.builder((FilterTableModel)tablePanel.tableModel, EntityTableColumns.entityTableColumns(this.entityDefinition)).summaryValuesFactory((SummaryModel.SummaryValues.Factory)new EntitySummaryValuesFactory(this.entityDefinition, (FilterTableModel<?, Attribute<?>>)tablePanel.tableModel)).cellRendererFactory((FilterTableCellRendererFactory)new EntityTableCellRendererFactory(tablePanel.tableModel)).cellEditorFactory((FilterTableCellEditorFactory)new EntityTableCellEditorFactory((SwingEntityEditModel)tablePanel.tableModel.editModel())).onBuild(filterTable -> filterTable.setRowHeight(filterTable.getFont().getSize() + 4));
            this.columnConditionsPanelFactory = new DefaultColumnConditionsPanelFactory();
            this.conditionFieldFactory = new EntityConditionFieldFactory(this.entityDefinition);
            this.controlMap = ControlMap.controlMap(ControlKeys.class);
            this.editable = ValueSet.valueSet((Collection)this.entityDefinition.attributes().updatable().stream().map(AttributeDefinition::attribute).collect(Collectors.toSet()));
            this.editable.addValidator((Value.Validator)new EditMenuAttributeValidator(this.entityDefinition));
            this.editComponentFactories = new HashMap();
            this.deleteConfirmer = new DeleteConfirmer(tablePanel.tableModel.selection());
        }

        private Config(Config config) {
            this.tablePanel = config.tablePanel;
            this.entityDefinition = config.entityDefinition;
            this.tableBuilder = config.tableBuilder;
            this.controlMap = config.controlMap.copy();
            this.editable = ValueSet.valueSet((Collection)((Collection)config.editable.get()));
            this.includeSouthPanel = config.includeSouthPanel;
            this.includeConditionPanel = config.includeConditionPanel;
            this.includeFilterPanel = config.includeFilterPanel;
            this.includeSummaryPanel = config.includeSummaryPanel;
            this.includeClearControl = config.includeClearControl;
            this.includeLimitMenu = config.includeLimitMenu;
            this.includeEntityMenu = config.includeEntityMenu;
            this.includePopupMenu = config.includePopupMenu;
            this.includeSelectionModeControl = config.includeSelectionModeControl;
            this.includeAddControl = config.includeAddControl;
            this.includeEditControl = config.includeEditControl;
            this.includeEditAttributeControl = config.includeEditAttributeControl;
            this.columnSelection = config.columnSelection;
            this.autoResizeModeSelection = config.autoResizeModeSelection;
            this.editAttributeSelection = config.editAttributeSelection;
            this.editComponentFactories = new HashMap(config.editComponentFactories);
            this.referentialIntegrityErrorHandling = config.referentialIntegrityErrorHandling;
            this.refreshButtonVisible = config.refreshButtonVisible;
            this.statusMessage = config.statusMessage;
            this.showRefreshProgressBar = config.showRefreshProgressBar;
            this.deleteConfirmer = config.deleteConfirmer;
            this.includeToolBar = config.includeToolBar;
            this.columnConditionsPanelFactory = config.columnConditionsPanelFactory;
            this.conditionFieldFactory = config.conditionFieldFactory;
        }

        public <T extends EntityTablePanel> T tablePanel() {
            return (T)this.tablePanel;
        }

        public Config configureTable(Consumer<FilterTable.Builder<Entity, Attribute<?>>> tableBuilder) {
            Objects.requireNonNull(tableBuilder).accept(this.tableBuilder);
            return this;
        }

        public Config columnConditionsPanelFactory(ColumnConditionsPanel.Factory<Attribute<?>> columnConditionsPanelFactory) {
            this.columnConditionsPanelFactory = Objects.requireNonNull(columnConditionsPanelFactory);
            return this;
        }

        public Config conditionFieldFactory(FilterColumnConditionPanel.FieldFactory<Attribute<?>> conditionFieldFactory) {
            this.conditionFieldFactory = Objects.requireNonNull(conditionFieldFactory);
            return this;
        }

        public Config includeSouthPanel(boolean includeSouthPanel) {
            this.includeSouthPanel = includeSouthPanel;
            return this;
        }

        public Config includeConditionPanel(boolean includeConditionPanel) {
            this.includeConditionPanel = includeConditionPanel;
            return this;
        }

        public Config includeFilterPanel(boolean includeFilterPanel) {
            this.includeFilterPanel = includeFilterPanel;
            return this;
        }

        public Config includeSummaryPanel(boolean includeSummaryPanel) {
            this.includeSummaryPanel = includeSummaryPanel;
            return this;
        }

        public Config includePopupMenu(boolean includePopupMenu) {
            this.includePopupMenu = includePopupMenu;
            return this;
        }

        public Config includeClearControl(boolean includeClearControl) {
            this.includeClearControl = includeClearControl;
            return this;
        }

        public Config includeLimitMenu(boolean includeLimitMenu) {
            this.includeLimitMenu = includeLimitMenu;
            return this;
        }

        public Config includeEntityMenu(boolean includeEntityMenu) {
            this.includeEntityMenu = includeEntityMenu;
            return this;
        }

        public Config includeSelectionModeControl(boolean includeSelectionModeControl) {
            this.includeSelectionModeControl = includeSelectionModeControl;
            return this;
        }

        public Config includeToolBar(boolean includeToolBar) {
            this.includeToolBar = includeToolBar;
            return this;
        }

        public Config includeAddControl(boolean includeAddControl) {
            this.includeAddControl = includeAddControl;
            return this;
        }

        public Config includeEditControl(boolean includeEditControl) {
            this.includeEditControl = includeEditControl;
            return this;
        }

        public Config includeEditAttributeControl(boolean includeEditAttributeControl) {
            this.includeEditAttributeControl = includeEditAttributeControl;
            return this;
        }

        public Config columnSelection(ColumnSelection columnSelection) {
            this.columnSelection = Objects.requireNonNull(columnSelection);
            return this;
        }

        public Config autoResizeModeSelection(AutoResizeModeSelection autoResizeModeSelection) {
            this.autoResizeModeSelection = Objects.requireNonNull(autoResizeModeSelection);
            return this;
        }

        public Config editAttributeSelection(EditAttributeSelection editAttributeSelection) {
            this.editAttributeSelection = Objects.requireNonNull(editAttributeSelection);
            return this;
        }

        public Config keyStroke(ControlKey<?> controlKey, Consumer<Value<KeyStroke>> keyStroke) {
            Objects.requireNonNull(keyStroke).accept((Value<KeyStroke>)this.controlMap.keyStroke(controlKey));
            return this;
        }

        public Config editable(Consumer<ValueSet<Attribute<?>>> attributes) {
            Objects.requireNonNull(attributes).accept(this.editable);
            return this;
        }

        public Config deleteConfirmer(EntityEditPanel.Confirmer deleteConfirmer) {
            this.deleteConfirmer = Objects.requireNonNull(deleteConfirmer);
            return this;
        }

        public <T, A extends Attribute<T>, C extends JComponent> Config editComponentFactory(A attribute, EntityComponentFactory<T, C> componentFactory) {
            this.entityDefinition.attributes().definition(attribute);
            this.editComponentFactories.put(attribute, Objects.requireNonNull(componentFactory));
            return this;
        }

        public Config referentialIntegrityErrorHandling(ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling) {
            this.referentialIntegrityErrorHandling = Objects.requireNonNull(referentialIntegrityErrorHandling);
            return this;
        }

        public Config refreshButtonVisible(RefreshButtonVisible refreshButtonVisible) {
            this.refreshButtonVisible = Objects.requireNonNull(refreshButtonVisible);
            return this;
        }

        public Config statusMessage(Function<SwingEntityTableModel, String> statusMessage) {
            this.statusMessage = Objects.requireNonNull(statusMessage);
            return this;
        }

        public Config showRefreshProgressBar(boolean showRefreshProgressBar) {
            this.showRefreshProgressBar = showRefreshProgressBar;
            return this;
        }

        private ControlKey<?> popupMenuEditAttributeControl() {
            return this.editAttributeSelection == EditAttributeSelection.MENU ? ControlKeys.EDIT_ATTRIBUTE_CONTROLS : ControlKeys.EDIT_SELECTED_ATTRIBUTE;
        }

        private static final class DefaultColumnConditionsPanelFactory
        implements ColumnConditionsPanel.Factory<Attribute<?>> {
            private DefaultColumnConditionsPanelFactory() {
            }

            public ColumnConditionsPanel<Attribute<?>> create(ColumnConditions<Attribute<?>> conditionModel, Collection<ColumnConditionPanel<Attribute<?>, ?>> columnConditionPanels, FilterTableColumnModel<Attribute<?>> columnModel, Consumer<ColumnConditionsPanel<Attribute<?>>> onPanelInitialized) {
                return FilterColumnConditionsPanel.filterColumnConditionsPanel(conditionModel, columnConditionPanels, columnModel, onPanelInitialized);
            }
        }

        private static final class EditMenuAttributeValidator
        implements Value.Validator<Set<Attribute<?>>> {
            private final EntityDefinition entityDefinition;

            private EditMenuAttributeValidator(EntityDefinition entityDefinition) {
                this.entityDefinition = entityDefinition;
            }

            public void validate(Set<Attribute<?>> attributes) {
                attributes.forEach(attribute -> this.entityDefinition.attributes().definition(attribute));
            }
        }
    }

    private final class TablePanel
    extends JPanel {
        private final JPanel tableSouthPanel;

        private TablePanel() {
            super(new BorderLayout());
            this.tableSouthPanel = new JPanel(new BorderLayout());
            this.add((Component)EntityTablePanel.this.tableScrollPane, "Center");
            this.add((Component)this.tableSouthPanel, "South");
        }

        private void initialize() {
            if (EntityTablePanel.this.includeToggleSummaryPanelControl()) {
                EntityTablePanel.this.summaryPanel = this.createSummaryPanel();
                if (EntityTablePanel.this.summaryPanel != null) {
                    EntityTablePanel.this.summaryPanelScrollPane = this.createLinkedScrollPane((JComponent)EntityTablePanel.this.summaryPanel);
                    EntityTablePanel.this.summaryPanelScrollPane.setVisible(false);
                    this.tableSouthPanel.add((Component)EntityTablePanel.this.summaryPanelScrollPane, "North");
                }
            }
            if (EntityTablePanel.this.configuration.includeFilterPanel) {
                EntityTablePanel.this.filterPanelScrollPane = this.createLinkedScrollPane((JComponent)EntityTablePanel.this.table.filterPanel());
                EntityTablePanel.this.table.filterPanel().state().addConsumer(this::filterPanelStateChanged);
                if (EntityTablePanel.this.table.filterPanel().state().isNotEqualTo((Object)ColumnConditionPanel.ConditionState.HIDDEN)) {
                    this.tableSouthPanel.add((Component)EntityTablePanel.this.filterPanelScrollPane, "South");
                }
            }
        }

        private void conditionPanelStateChanged(ColumnConditionPanel.ConditionState conditionState) {
            this.initializeConditionPanel();
            EntityTablePanel.this.refreshButtonToolBar.setVisible(EntityTablePanel.this.configuration.refreshButtonVisible == RefreshButtonVisible.ALWAYS || conditionState != ColumnConditionPanel.ConditionState.HIDDEN);
            if (conditionState == ColumnConditionPanel.ConditionState.HIDDEN) {
                this.remove(EntityTablePanel.this.conditionPanelScrollPane);
            } else {
                this.add((Component)EntityTablePanel.this.conditionPanelScrollPane, "North");
            }
            this.revalidate();
        }

        private void initializeConditionPanel() {
            if (EntityTablePanel.this.conditionPanelScrollPane == null) {
                EntityTablePanel.this.conditionPanelScrollPane = this.createLinkedScrollPane((JComponent)EntityTablePanel.this.columnConditionsPanel);
                if (EntityTablePanel.this.columnConditionsPanel.state().isNotEqualTo((Object)ColumnConditionPanel.ConditionState.HIDDEN)) {
                    EntityTablePanel.this.tablePanel.add((Component)EntityTablePanel.this.conditionPanelScrollPane, "North");
                }
                EntityTablePanel.this.refreshButtonToolBar.setVisible(EntityTablePanel.this.configuration.refreshButtonVisible == RefreshButtonVisible.ALWAYS || EntityTablePanel.this.columnConditionsPanel.state().isNotEqualTo((Object)ColumnConditionPanel.ConditionState.HIDDEN));
            }
        }

        private JScrollPane createLinkedScrollPane(JComponent componentToScroll) {
            return (JScrollPane)((ScrollPaneBuilder)Components.scrollPane((JComponent)componentToScroll).horizontalScrollBarPolicy(31).verticalScrollBarPolicy(21).onBuild(scrollPane -> Utilities.linkBoundedRangeModels((BoundedRangeModel)EntityTablePanel.this.tableScrollPane.getHorizontalScrollBar().getModel(), (BoundedRangeModel)scrollPane.getHorizontalScrollBar().getModel()))).build();
        }

        private void filterPanelStateChanged(ColumnConditionPanel.ConditionState conditionState) {
            if (conditionState == ColumnConditionPanel.ConditionState.HIDDEN) {
                this.tableSouthPanel.remove(EntityTablePanel.this.filterPanelScrollPane);
            } else {
                this.tableSouthPanel.add((Component)EntityTablePanel.this.filterPanelScrollPane, "South");
            }
            this.revalidate();
        }

        private FilterTableColumnComponentPanel<Attribute<?>> createSummaryPanel() {
            Map<Attribute<?>, JComponent> columnSummaryPanels = this.createColumnSummaryPanels();
            if (columnSummaryPanels.isEmpty()) {
                return null;
            }
            return FilterTableColumnComponentPanel.filterTableColumnComponentPanel((FilterTableColumnModel)EntityTablePanel.this.table.getColumnModel(), columnSummaryPanels);
        }

        private Map<Attribute<?>, JComponent> createColumnSummaryPanels() {
            HashMap components = new HashMap();
            EntityTablePanel.this.table.getColumnModel().columns().forEach(column -> EntityTablePanel.this.table.summaryModel().summaryModel((Object)((Attribute)column.identifier())).ifPresent(columnSummaryModel -> components.put((Attribute<?>)((Attribute)column.identifier()), (JComponent)ColumnSummaryPanel.columnSummaryPanel((SummaryModel)columnSummaryModel, (int)this.horizontalAlignment(column.getCellRenderer())))));
            return components;
        }

        private int horizontalAlignment(TableCellRenderer cellRenderer) {
            if (cellRenderer instanceof DefaultTableCellRenderer) {
                return ((DefaultTableCellRenderer)cellRenderer).getHorizontalAlignment();
            }
            return 0;
        }
    }

    private final class ScrollToColumn
    implements Consumer<Attribute<?>> {
        private ScrollToColumn() {
        }

        @Override
        public void accept(Attribute<?> attribute) {
            EntityTablePanel.this.table.scrollToColumn(attribute);
        }
    }

    private final class SouthPanel
    extends JPanel {
        private SouthPanel() {
            JToolBar southToolBar;
            super(new BorderLayout());
            this.add((Component)Components.splitPane().continuousLayout(true).leftComponent(Components.panel((LayoutManager)new GridBagLayout()).add((JComponent)EntityTablePanel.this.table.searchField(), (Object)EntityTablePanel.createHorizontalFillConstraints()).build()).rightComponent((JComponent)this.statusPanel()).build(), "Center");
            this.add((Component)EntityTablePanel.this.refreshButtonToolBar, "West");
            if (EntityTablePanel.this.configuration.includeToolBar && (southToolBar = this.createToolBar()) != null) {
                this.add((Component)southToolBar, "East");
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Utilities.updateUI((JComponent[])new JComponent[]{EntityTablePanel.this.statusPanel});
        }

        private StatusPanel statusPanel() {
            if (EntityTablePanel.this.statusPanel == null) {
                EntityTablePanel.this.statusPanel = new StatusPanel();
            }
            return EntityTablePanel.this.statusPanel;
        }

        private JToolBar createToolBar() {
            Controls toolbarControls = EntityTablePanel.this.toolBarLayout.create(EntityTablePanel.this.configuration.controlMap);
            if (toolbarControls == null || toolbarControls.empty()) {
                return null;
            }
            return (JToolBar)((ToolBarBuilder)Components.toolBar().controls(toolbarControls)).floatable(false).rollover(true).build(toolBar -> Arrays.stream(toolBar.getComponents()).map(JComponent.class::cast).forEach(component -> component.setToolTipText(null)));
        }
    }

    public static final class ControlKeys {
        public static final ControlKey<CommandControl> ADD = CommandControl.key((String)"add", (KeyStroke)KeyEvents.keyStroke((int)155));
        public static final ControlKey<CommandControl> EDIT = CommandControl.key((String)"edit", (KeyStroke)KeyEvents.keyStroke((int)155, (int)128));
        public static final ControlKey<CommandControl> EDIT_SELECTED_ATTRIBUTE = CommandControl.key((String)"editSelectedAttribute", (KeyStroke)KeyEvents.keyStroke((int)155, (int)64));
        public static final ControlKey<CommandControl> REQUEST_TABLE_FOCUS = CommandControl.key((String)"requestTableFocus", (KeyStroke)KeyEvents.keyStroke((int)84, (int)128));
        public static final ControlKey<CommandControl> TOGGLE_CONDITION_PANEL = CommandControl.key((String)"toggleConditionPanel", (KeyStroke)KeyEvents.keyStroke((int)83, (int)640));
        public static final ControlKey<CommandControl> SELECT_CONDITION_PANEL = CommandControl.key((String)"selectConditionPanel", (KeyStroke)KeyEvents.keyStroke((int)83, (int)128));
        public static final ControlKey<CommandControl> TOGGLE_FILTER_PANEL = CommandControl.key((String)"toggleFilterPanel", (KeyStroke)KeyEvents.keyStroke((int)70, (int)640));
        public static final ControlKey<CommandControl> SELECT_FILTER_PANEL = CommandControl.key((String)"selectFilterPanel", (KeyStroke)KeyEvents.keyStroke((int)70, (int)192));
        public static final ControlKey<CommandControl> MOVE_SELECTION_UP = CommandControl.key((String)"moveSelectionUp", (KeyStroke)KeyEvents.keyStroke((int)38, (int)576));
        public static final ControlKey<CommandControl> MOVE_SELECTION_DOWN = CommandControl.key((String)"moveSelectionDown", (KeyStroke)KeyEvents.keyStroke((int)40, (int)576));
        public static final ControlKey<CommandControl> PRINT = CommandControl.key((String)"print", (KeyStroke)KeyEvents.keyStroke((int)80, (int)128));
        public static final ControlKey<CommandControl> DELETE = CommandControl.key((String)"delete", (KeyStroke)KeyEvents.keyStroke((int)127));
        public static final ControlKey<CommandControl> DISPLAY_POPUP_MENU = CommandControl.key((String)"displayPopupMenu", (KeyStroke)KeyEvents.keyStroke((int)71, (int)128));
        public static final ControlKey<CommandControl> DISPLAY_ENTITY_MENU = CommandControl.key((String)"displayEntityMenu", (KeyStroke)KeyEvents.keyStroke((int)86, (int)640));
        public static final ControlKey<Controls> PRINT_CONTROLS = Controls.key((String)"printControls");
        public static final ControlKey<Controls> ADDITIONAL_POPUP_MENU_CONTROLS = Controls.key((String)"additionalPopupMenuControls");
        public static final ControlKey<Controls> ADDITIONAL_TOOLBAR_CONTROLS = Controls.key((String)"additionalToolBarControls");
        public static final ControlKey<CommandControl> VIEW_DEPENDENCIES = CommandControl.key((String)"viewDependencies");
        public static final ControlKey<Controls> EDIT_ATTRIBUTE_CONTROLS = Controls.key((String)"editAttributeControls");
        public static final ControlKey<CommandControl> SELECT_COLUMNS = CommandControl.key((String)"selectColumns");
        public static final ControlKey<Controls> TOGGLE_COLUMN_CONTROLS = Controls.key((String)"toggleColumnControls");
        public static final ControlKey<CommandControl> RESET_COLUMNS = CommandControl.key((String)"resetColumns");
        public static final ControlKey<CommandControl> SELECT_AUTO_RESIZE_MODE = CommandControl.key((String)"selectAutoResizeMode");
        public static final ControlKey<Controls> TOGGLE_AUTO_RESIZE_MODE_CONTROLS = Controls.key((String)"toggleAutoResizeModeControls");
        public static final ControlKey<ToggleControl> SELECTION_MODE = ToggleControl.key((String)"selectionMode");
        public static final ControlKey<CommandControl> CLEAR = CommandControl.key((String)"clear");
        public static final ControlKey<CommandControl> REFRESH = CommandControl.key((String)"refresh", (KeyStroke)KeyEvents.keyStroke((int)82, (int)512));
        public static final ControlKey<ToggleControl> TOGGLE_SUMMARY_PANEL = ToggleControl.key((String)"toggleSummaryPanel");
        public static final ControlKey<Controls> CONDITION_CONTROLS = Controls.key((String)"conditionControls");
        public static final ControlKey<Controls> FILTER_CONTROLS = Controls.key((String)"filterControls");
        public static final ControlKey<CommandControl> CLEAR_SELECTION = CommandControl.key((String)"clearSelection");
        public static final ControlKey<CommandControl> COPY_CELL = CommandControl.key((String)"copyCell", (KeyStroke)KeyEvents.keyStroke((int)67, (int)640));
        public static final ControlKey<CommandControl> COPY_ROWS = CommandControl.key((String)"copyRows");
        public static final Controls.ControlsKey COPY_CONTROLS = Controls.key((String)"copyControls", (Controls.Layout)Controls.layout(Arrays.asList(COPY_CELL, COPY_ROWS)));
        public static final Controls.ControlsKey COLUMN_CONTROLS = Controls.key((String)"columnControls", (Controls.Layout)Controls.layout(Arrays.asList(SELECT_COLUMNS, TOGGLE_COLUMN_CONTROLS, RESET_COLUMNS, SELECT_AUTO_RESIZE_MODE)));
        public static final ControlKey<CommandControl> REQUEST_SEARCH_FIELD_FOCUS = CommandControl.key((String)"requestSearchFieldFocus", (KeyStroke)KeyEvents.keyStroke((int)70, (int)128));

        private ControlKeys() {
        }
    }

    private final class AddCommand
    implements Control.Command {
        private AddCommand() {
        }

        public void execute() throws Exception {
            ((EntityDialogs.AddEntityDialogBuilder)EntityDialogs.addEntityDialog(() -> EntityTablePanel.this.editPanel).owner(EntityTablePanel.this)).closeDialog(false).show();
        }
    }

    private final class EditCommand
    implements Control.ActionCommand {
        private EditCommand() {
        }

        public void execute(ActionEvent actionEvent) throws Exception {
            ((EntityDialogs.EditEntityDialogBuilder)((EntityDialogs.EditEntityDialogBuilder)EntityDialogs.editEntityDialog(() -> EntityTablePanel.this.editPanel).owner(EntityTablePanel.this)).location(actionEvent.getSource() instanceof MouseEvent ? ((MouseEvent)actionEvent.getSource()).getLocationOnScreen() : null)).show();
        }
    }

    private final class DeleteCommand
    implements Control.Command {
        private DeleteCommand() {
        }

        public void execute() {
            if (EntityTablePanel.this.confirmDelete()) {
                List selectedItems = (List)EntityTablePanel.this.tableModel().selection().items().get();
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Delete.Task)((SwingEntityEditModel)EntityTablePanel.this.tableModel().editModel()).createDelete((Collection)selectedItems).prepare()).perform()).title(EDIT_PANEL_MESSAGES.getString("deleting"))).owner((Component)EntityTablePanel.this)).onException(this::onException).onResult(EntityEditModel.Delete.Result::handle).execute();
            }
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityTablePanel.this.onException(exception);
        }
    }

    public static enum ColumnSelection {
        DIALOG,
        MENU;

    }

    public static enum AutoResizeModeSelection {
        DIALOG,
        MENU;

    }

    public static enum RefreshButtonVisible {
        ALWAYS,
        WHEN_CONDITION_PANEL_IS_VISIBLE;

    }

    private static final class ComboBoxEnterPressedAction
    extends AbstractAction {
        private static final String ENTER_PRESSED = "enterPressed";
        private final JComboBox<?> comboBox;
        private final Action action;
        private final Action enterPressedAction;

        private ComboBoxEnterPressedAction(JComboBox<?> comboBox, Action action) {
            this.comboBox = comboBox;
            this.action = action;
            this.enterPressedAction = comboBox.getActionMap().get(ENTER_PRESSED);
            this.comboBox.getActionMap().put(ENTER_PRESSED, this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.comboBox.isPopupVisible()) {
                this.enterPressedAction.actionPerformed(e);
            } else if (this.action.isEnabled()) {
                this.action.actionPerformed(e);
            }
        }
    }

    private static final class ComponentAvailableValidator
    implements Value.Validator<Boolean> {
        private final JComponent component;
        private final String panelType;

        private ComponentAvailableValidator(JComponent component, String panelType) {
            this.component = component;
            this.panelType = panelType;
        }

        public void validate(Boolean visible) throws IllegalArgumentException {
            if (visible.booleanValue() && this.component == null) {
                throw new IllegalArgumentException("No " + this.panelType + " panel available");
            }
        }
    }

    private static final class ReplaceIfNull
    implements Function<Controls, Controls> {
        private final Supplier<Controls> controls;

        private ReplaceIfNull(Supplier<Controls> controls) {
            this.controls = controls;
        }

        @Override
        public Controls apply(Controls control) {
            return control == null ? this.controls.get() : control;
        }
    }

    private final class HeaderRenderer
    implements TableCellRenderer {
        private final TableCellRenderer wrappedRenderer;

        private HeaderRenderer(TableCellRenderer wrappedRenderer) {
            this.wrappedRenderer = wrappedRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.wrappedRenderer == null ? table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : this.wrappedRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            FilterTableColumn tableColumn = EntityTablePanel.this.table().getColumnModel().getColumn(column);
            TableCellRenderer renderer = tableColumn.getCellRenderer();
            boolean useBoldFont = renderer instanceof FilterTableCellRenderer && ((FilterTableCellRenderer)renderer).columnShading() && EntityTablePanel.this.tableModel.queryModel().conditions().optional((Object)((Attribute)tableColumn.identifier())).map(conditionModel -> (Boolean)conditionModel.enabled().get()).orElse(false) != false;
            Font defaultFont = component.getFont();
            component.setFont(useBoldFont ? defaultFont.deriveFont(defaultFont.getStyle() | 1) : defaultFont);
            return component;
        }
    }

    private final class StatusPanel
    extends JPanel {
        private final Value<String> statusMessage;
        private final JLabel label;
        private final JProgressBar progressBar;
        private final JPanel progressPanel;

        private StatusPanel() {
            super(new BorderLayout());
            this.statusMessage = Value.builder().nonNull((Object)"").value((Object)EntityTablePanel.this.configuration.statusMessage.apply(EntityTablePanel.this.tableModel)).build();
            this.label = (JLabel)Components.label(this.statusMessage).horizontalAlignment(0).build();
            this.progressBar = Components.progressBar().indeterminate(true).string(MESSAGES.getString("refreshing")).stringPainted(true).build();
            this.progressPanel = (JPanel)Components.panel((LayoutManager)new GridBagLayout()).add((JComponent)this.progressBar, (Object)EntityTablePanel.createHorizontalFillConstraints()).build();
            this.add((Component)this.label, "Center");
            EntityTablePanel.this.tableModel.refresher().observer().addConsumer((Consumer)new ConfigurePanel());
            EntityTablePanel.this.tableModel.selection().indexes().addListener(this::updateStatusMessage);
            EntityTablePanel.this.tableModel.items().visible().addListener(this::updateStatusMessage);
            if (EntityTablePanel.this.configuration.includeLimitMenu) {
                this.setComponentPopupMenu(Components.menu().control(((CommandControl.CommandControlBuilder)Control.builder().command(this::configureLimit).name(MESSAGES.getString("row_limit"))).build()).buildPopupMenu());
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Utilities.updateUI((JComponent[])new JComponent[]{this.label, this.progressBar, this.progressPanel});
        }

        private void configureLimit() {
            ComponentValue limitValue = ((NumberField.Builder)((NumberField.Builder)Components.integerField().value((Object)((Integer)EntityTablePanel.this.tableModel.queryModel().limit().get()))).groupingUsed(true).minimumValue((Number)0).columns(6)).buildValue();
            EntityTablePanel.this.tableModel.queryModel().limit().set((Object)((Integer)((InputDialogBuilder)((InputDialogBuilder)Dialogs.inputDialog((ComponentValue)limitValue).title(MESSAGES.getString("row_limit"))).owner((Component)EntityTablePanel.this)).validator((Predicate)new LimitValidator()).show()));
        }

        private void updateStatusMessage() {
            this.statusMessage.set((Object)EntityTablePanel.this.configuration.statusMessage.apply(EntityTablePanel.this.tableModel));
        }

        private final class ConfigurePanel
        implements Consumer<Boolean> {
            private ConfigurePanel() {
            }

            @Override
            public void accept(Boolean isRefreshing) {
                if (EntityTablePanel.this.configuration.showRefreshProgressBar) {
                    StatusPanel.this.removeAll();
                    StatusPanel.this.add((Component)(isRefreshing != false ? StatusPanel.this.progressPanel : StatusPanel.this.label), "Center");
                    StatusPanel.this.revalidate();
                    StatusPanel.this.repaint();
                }
            }
        }

        private final class LimitValidator
        implements Predicate<Integer> {
            private LimitValidator() {
            }

            @Override
            public boolean test(Integer limit) {
                try {
                    EntityTablePanel.this.tableModel.queryModel().limit().validate((Object)limit);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        }
    }

    private static final class DefaultStatusMessage
    implements Function<SwingEntityTableModel, String> {
        private static final NumberFormat STATUS_MESSAGE_NUMBER_FORMAT = NumberFormat.getIntegerInstance();

        private DefaultStatusMessage() {
        }

        @Override
        public String apply(SwingEntityTableModel tableModel) {
            int rowCount = tableModel.items().visible().count();
            int filteredCount = tableModel.items().filtered().count();
            if (rowCount == 0 && filteredCount == 0) {
                return "";
            }
            int selectionCount = tableModel.selection().count();
            StringBuilder builder = new StringBuilder();
            if (tableModel.queryModel().limit().isEqualTo((Object)rowCount)) {
                builder.append(MESSAGES.getString("limited_to")).append(" ");
            }
            builder.append(STATUS_MESSAGE_NUMBER_FORMAT.format(rowCount));
            if (selectionCount > 0 || filteredCount > 0) {
                builder.append(" (");
                if (selectionCount > 0) {
                    builder.append(STATUS_MESSAGE_NUMBER_FORMAT.format(selectionCount)).append(" ").append(MESSAGES.getString("selected"));
                }
                if (filteredCount > 0) {
                    if (selectionCount > 0) {
                        builder.append(" - ");
                    }
                    builder.append(STATUS_MESSAGE_NUMBER_FORMAT.format(filteredCount)).append(" ").append(MESSAGES.getString("filtered"));
                }
                builder.append(")");
            }
            return builder.toString();
        }
    }

    private static final class EntitySummaryValuesFactory
    implements SummaryModel.SummaryValues.Factory<Attribute<?>> {
        private final EntityDefinition entityDefinition;
        private final FilterTableModel<?, Attribute<?>> tableModel;

        private EntitySummaryValuesFactory(EntityDefinition entityDefinition, FilterTableModel<?, Attribute<?>> tableModel) {
            this.entityDefinition = Objects.requireNonNull(entityDefinition);
            this.tableModel = Objects.requireNonNull(tableModel);
        }

        public <T extends Number> Optional<SummaryModel.SummaryValues<T>> createSummaryValues(Attribute<?> identifier, Format format) {
            AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(identifier);
            if (identifier.type().isNumerical() && attributeDefinition.items().isEmpty()) {
                return Optional.of(FilterTable.summaryValues(identifier, this.tableModel, (Format)format));
            }
            return Optional.empty();
        }
    }

    private static final class DeleteConfirmer
    implements EntityEditPanel.Confirmer {
        private final FilterTableModel.TableSelection<?> selection;

        private DeleteConfirmer(FilterTableModel.TableSelection<?> selection) {
            this.selection = selection;
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmDelete((int)this.selection.count()), FrameworkMessages.delete());
        }
    }

    public static enum EditAttributeSelection {
        DIALOG,
        MENU;

    }
}

