/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.swing.common.ui.component.text.TemporalField;
import is.codion.swing.common.ui.component.text.TemporalFieldPanel;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.ui.component.EntityComboBox;
import is.codion.swing.framework.ui.component.EntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponents;
import is.codion.swing.framework.ui.component.EntitySearchField;
import java.time.temporal.Temporal;
import java.util.Objects;
import javax.swing.JComponent;

public class DefaultEntityComponentFactory<T, C extends JComponent>
implements EntityComponentFactory<T, C> {
    private final Attribute<T> attribute;

    public DefaultEntityComponentFactory(Attribute<T> attribute) {
        this.attribute = Objects.requireNonNull(attribute);
    }

    @Override
    public ComponentValue<T, C> componentValue(SwingEntityEditModel editModel, T value) {
        Objects.requireNonNull(editModel, "editModel");
        EntityComponents inputComponents = EntityComponents.entityComponents(editModel.entityDefinition());
        if (this.attribute instanceof ForeignKey) {
            return this.createForeignKeyComponentValue((ForeignKey)this.attribute, editModel, (Entity)value, inputComponents);
        }
        if (this.attribute.type().isTemporal()) {
            return DefaultEntityComponentFactory.createTemporalComponentValue(this.attribute, (Temporal)value, inputComponents);
        }
        return inputComponents.component(this.attribute).value(value).buildValue();
    }

    protected final Attribute<T> attribute() {
        return this.attribute;
    }

    private ComponentValue<T, C> createForeignKeyComponentValue(ForeignKey foreignKey, SwingEntityEditModel editModel, Entity value, EntityComponents inputComponents) {
        if (editModel.entities().definition(foreignKey.referencedType()).smallDataset()) {
            return ((EntityComboBox.Builder)((EntityComboBox.Builder)inputComponents.foreignKeyComboBox(foreignKey, editModel.createForeignKeyComboBoxModel(foreignKey)).value(value)).onSetVisible(comboBox -> comboBox.getModel().refresh())).buildValue();
        }
        return ((EntitySearchField.Builder)inputComponents.foreignKeySearchField(foreignKey, editModel.createForeignKeySearchModel(foreignKey)).value(value)).buildValue();
    }

    private static <T, A extends Attribute<T>, C extends JComponent> ComponentValue<T, C> createTemporalComponentValue(A attribute, Temporal value, EntityComponents inputComponents) {
        if (TemporalFieldPanel.supports((Class)attribute.type().valueClass())) {
            return ((TemporalFieldPanel.Builder)inputComponents.temporalFieldPanel(attribute).value((Object)value)).buildValue();
        }
        return ((TemporalField.Builder)inputComponents.temporalField(attribute).value((Object)value)).buildValue();
    }
}

