/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.model.condition.ConditionModel;
import is.codion.common.value.ValueSet;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.EntitySearchModel;
import is.codion.framework.model.ForeignKeyConditionModel;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.combobox.Completion;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.framework.model.SwingForeignKeyConditionModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import is.codion.swing.framework.ui.component.EntityComboBox;
import is.codion.swing.framework.ui.component.EntityComponents;
import is.codion.swing.framework.ui.component.EntitySearchField;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;

public final class EntityConditionFieldFactory
implements ColumnConditionPanel.FieldFactory {
    private static final List<Class<?>> SUPPORTED_TYPES = Arrays.asList(Character.class, String.class, Boolean.class, Short.class, Integer.class, Double.class, BigDecimal.class, Long.class, LocalTime.class, LocalDate.class, LocalDateTime.class, OffsetDateTime.class, Entity.class);
    private final EntityComponents inputComponents;
    private final Attribute<?> attribute;

    public EntityConditionFieldFactory(EntityDefinition entityDefinition, Attribute<?> attribute) {
        this.inputComponents = EntityComponents.entityComponents(entityDefinition);
        this.attribute = Objects.requireNonNull(attribute);
    }

    public boolean supportsType(Class<?> valueClass) {
        return SUPPORTED_TYPES.contains(Objects.requireNonNull(valueClass));
    }

    public <T> JComponent createEqualField(ConditionModel<T> condition) {
        if (this.attribute instanceof ForeignKey) {
            return this.createEqualForeignKeyField(condition);
        }
        return this.inputComponents.component(this.attribute).link(condition.operands().equal()).build();
    }

    public <T> Optional<JComponent> createUpperField(ConditionModel<T> condition) {
        Class columnClass = condition.valueClass();
        if (columnClass.equals(Boolean.class) || columnClass.equals(Entity.class)) {
            return Optional.empty();
        }
        return Optional.of(this.inputComponents.component(this.attribute).link(condition.operands().upper()).build());
    }

    public <T> Optional<JComponent> createLowerField(ConditionModel<T> condition) {
        Class columnClass = condition.valueClass();
        if (columnClass.equals(Boolean.class) || columnClass.equals(Entity.class)) {
            return Optional.empty();
        }
        return Optional.of(this.inputComponents.component(this.attribute).link(condition.operands().lower()).build());
    }

    public <T> JComponent createInField(ConditionModel<T> condition) {
        if (this.attribute instanceof ForeignKey) {
            return this.createInForeignKeyField(condition);
        }
        return Components.listBox((ComponentValue)this.inputComponents.component(this.attribute).buildValue(), (ValueSet)condition.operands().in()).build();
    }

    private <T> JComponent createEqualForeignKeyField(ConditionModel<T> model) {
        if (model instanceof ForeignKeyConditionModel) {
            EntitySearchModel searchModel = ((ForeignKeyConditionModel)model).equalSearchModel();
            return this.inputComponents.searchField((ForeignKey)this.attribute, searchModel).build();
        }
        if (model instanceof SwingForeignKeyConditionModel) {
            EntityComboBoxModel comboBoxModel = ((SwingForeignKeyConditionModel)model).equalComboBoxModel();
            return ((EntityComboBox.Builder)((EntityComboBox.Builder)this.inputComponents.comboBox((ForeignKey)this.attribute, comboBoxModel).completionMode(Completion.Mode.MAXIMUM_MATCH)).onSetVisible(comboBox -> comboBoxModel.items().refresh())).build();
        }
        throw new IllegalArgumentException("Unknown foreign key condition model type: " + model);
    }

    private JComponent createInForeignKeyField(ConditionModel<Entity> model) {
        ForeignKey foreignKey = (ForeignKey)this.attribute;
        if (model instanceof ForeignKeyConditionModel) {
            EntitySearchModel searchModel = ((ForeignKeyConditionModel)model).inSearchModel();
            return EntityConditionFieldFactory.configureSearchField(searchModel, (EntitySearchField)((Object)this.inputComponents.searchField(foreignKey, searchModel).build()));
        }
        if (model instanceof SwingForeignKeyConditionModel) {
            EntitySearchModel searchModel = ((SwingForeignKeyConditionModel)model).inSearchModel();
            return EntityConditionFieldFactory.configureSearchField(searchModel, (EntitySearchField)((Object)this.inputComponents.searchField(foreignKey, searchModel).build()));
        }
        throw new IllegalArgumentException("Unknown foreign key condition model type: " + model);
    }

    private static EntitySearchField configureSearchField(EntitySearchModel searchModel, EntitySearchField searchField) {
        boolean searchable;
        boolean bl = searchable = !searchModel.connectionProvider().entities().definition(searchModel.entityType()).columns().searchable().isEmpty();
        if (!searchable) {
            searchField.setEditable(false);
            searchField.hint().set((Object)"");
        }
        return searchField;
    }
}

