/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.EntityTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

final class EntityDependenciesPanel
extends JPanel {
    private final Map<EntityType, EntityTablePanel> tablePanels;
    private final JTabbedPane tabPane = new JTabbedPane(1);

    EntityDependenciesPanel(Map<EntityType, Collection<Entity>> dependencies, EntityConnectionProvider connectionProvider) {
        super(new BorderLayout());
        this.tablePanels = Collections.unmodifiableMap(dependencies.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> EntityDependenciesPanel.createTablePanel((Collection)entry.getValue(), connectionProvider))));
        this.tablePanels.forEach((entityType, tablePanel) -> this.tabPane.addTab(connectionProvider.entities().definition(entityType).caption(), (Component)tablePanel));
        this.add((Component)this.tabPane, "Center");
        ControlKeys.NAVIGATE_RIGHT.defaultKeystroke().optional().ifPresent(keyStroke -> KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)Control.command((Control.Command)new NavigateRightCommand())).enable(new JComponent[]{this.tabPane}));
        ControlKeys.NAVIGATE_LEFT.defaultKeystroke().optional().ifPresent(keyStroke -> KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)Control.command((Control.Command)new NavigateLeftCommand())).enable(new JComponent[]{this.tabPane}));
    }

    Map<EntityType, EntityTablePanel> tablePanels() {
        return this.tablePanels;
    }

    private static EntityTablePanel createTablePanel(Collection<Entity> entities, EntityConnectionProvider connectionProvider) {
        SwingEntityTableModel tableModel = new SwingEntityTableModel(entities, connectionProvider);
        EntityTablePanel tablePanel = new EntityTablePanel(tableModel, config -> config.includeConditions(false));
        tablePanel.configurePopupMenu(layout -> layout.clear().control(EntityTablePanel.ControlKeys.EDIT_ATTRIBUTE_CONTROLS).control(EntityTablePanel.ControlKeys.DELETE).separator().control(EntityTablePanel.ControlKeys.VIEW_DEPENDENCIES).separator().control((ControlKey)EntityTablePanel.ControlKeys.COLUMN_CONTROLS));
        return tablePanel.initialize();
    }

    void requestSelectedTableFocus() {
        ((EntityTablePanel)this.tabPane.getSelectedComponent()).table().requestFocusInWindow();
    }

    static final class ControlKeys {
        static final ControlKey<CommandControl> NAVIGATE_LEFT = CommandControl.key((String)"navigateLeft", (KeyStroke)KeyEvents.keyStroke((int)37, (int)640));
        static final ControlKey<CommandControl> NAVIGATE_RIGHT = CommandControl.key((String)"navigateRight", (KeyStroke)KeyEvents.keyStroke((int)39, (int)640));

        private ControlKeys() {
        }
    }

    private final class NavigateLeftCommand
    implements Control.Command {
        private NavigateLeftCommand() {
        }

        public void execute() {
            int selectedIndex = EntityDependenciesPanel.this.tabPane.getSelectedIndex();
            EntityDependenciesPanel.this.tabPane.setSelectedIndex(selectedIndex == 0 ? EntityDependenciesPanel.this.tabPane.getTabCount() - 1 : selectedIndex - 1);
            EntityDependenciesPanel.this.requestSelectedTableFocus();
        }
    }

    private final class NavigateRightCommand
    implements Control.Command {
        private NavigateRightCommand() {
        }

        public void execute() {
            int selectedIndex = EntityDependenciesPanel.this.tabPane.getSelectedIndex();
            EntityDependenciesPanel.this.tabPane.setSelectedIndex(selectedIndex == EntityDependenciesPanel.this.tabPane.getTabCount() - 1 ? 0 : selectedIndex + 1);
            EntityDependenciesPanel.this.requestSelectedTableFocus();
        }
    }
}

