/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.exception.ReferentialIntegrityException;
import is.codion.common.i18n.Messages;
import is.codion.common.model.CancelException;
import is.codion.common.property.PropertyValue;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.ObservableState;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.framework.model.EntityEditModel;
import is.codion.swing.common.ui.Cursors;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.control.ControlMap;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.ProgressWorkerDialogBuilder;
import is.codion.swing.common.ui.dialog.SelectionDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.ui.EntityDependenciesPanel;
import is.codion.swing.framework.ui.EntityEditComponentPanel;
import is.codion.swing.framework.ui.EntityPanel;
import is.codion.swing.framework.ui.EntityPopupMenu;
import is.codion.swing.framework.ui.ReferentialIntegrityErrorHandling;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityEditPanel
extends EntityEditComponentPanel {
    private static final Logger LOG = LoggerFactory.getLogger(EntityEditPanel.class);
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(EntityEditPanel.class, (ResourceBundle)ResourceBundle.getBundle(EntityEditPanel.class.getName()));
    private static final FrameworkIcons ICONS = FrameworkIcons.instance();
    private static final Consumer<?> EMPTY_CONSUMER = value -> {};
    private static final String ALT_PREFIX = " (ALT-";
    private static final State.Group ACTIVE_STATE_GROUP;
    private static final Consumer<Config> NO_CONFIGURATION;
    private final Controls.Layout controlsLayout;
    private final State active;
    final Config configuration;
    private boolean initialized = false;

    public EntityEditPanel(SwingEntityEditModel editModel) {
        this(editModel, NO_CONFIGURATION);
    }

    public EntityEditPanel(SwingEntityEditModel editModel, Consumer<Config> config) {
        super(editModel);
        this.configuration = this.configure(config);
        this.active = State.state((!this.configuration.focusActivation ? 1 : 0) != 0);
        this.controlsLayout = EntityEditPanel.createControlsLayout();
        this.createControls();
        this.setupFocusActivation();
        this.setupKeyboardActions();
        if (editModel.editor().exists().not().get().booleanValue()) {
            editModel.editor().defaults();
        }
    }

    @Override
    public final String toString() {
        return this.editModel().toString();
    }

    public final State active() {
        return this.active;
    }

    public final void clearAndRequestFocus() {
        this.editModel().editor().defaults();
        this.focus().initial().request();
    }

    public final void selectInputComponent() {
        Collection<Attribute<?>> attributes = this.selectComponentAttributes();
        if (attributes.size() == 1) {
            this.focus().request(attributes.iterator().next());
        } else if (!attributes.isEmpty()) {
            Entities entities = this.editModel().entities();
            List sortedDefinitions = attributes.stream().map(attribute -> entities.definition(attribute.entityType()).attributes().definition(attribute)).sorted(new EntityEditComponentPanel.AttributeDefinitionComparator()).collect(Collectors.toList());
            ((SelectionDialogBuilder)((SelectionDialogBuilder)Dialogs.selectionDialog(sortedDefinitions).owner((Component)this)).title(FrameworkMessages.selectInputField())).selectSingle().ifPresent(attributeDefinition -> this.focus().request(attributeDefinition.attribute()));
        }
    }

    public final EntityEditPanel initialize() {
        if (!this.initialized) {
            try {
                this.setupControls();
                this.bindEvents();
                this.initializeUI();
            }
            finally {
                this.initialized = true;
            }
        }
        return this;
    }

    public final boolean insertWithConfirmation() {
        if (this.confirmInsert()) {
            return this.insert();
        }
        return false;
    }

    public final boolean insert() {
        try {
            this.editModel().insert();
            if (this.configuration.clearAfterInsert) {
                this.editModel().editor().defaults();
            }
            if (this.configuration.requestFocusAfterInsert) {
                this.focus().afterInsert().request();
            }
            return true;
        }
        catch (ValidationException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.onException(e);
        }
        return false;
    }

    public final boolean deleteWithConfirmation() {
        if (this.confirmDelete()) {
            return this.delete();
        }
        return false;
    }

    public final boolean delete() {
        try {
            this.editModel().delete();
            this.focus().initial().request();
            return true;
        }
        catch (ReferentialIntegrityException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            this.onException(ex);
        }
        return false;
    }

    public final boolean updateWithConfirmation() {
        if (this.confirmUpdate()) {
            return this.update();
        }
        return false;
    }

    public final boolean update() {
        try {
            this.editModel().update();
            this.focus().afterUpdate().request();
            return true;
        }
        catch (ValidationException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            this.onException(ex);
        }
        return false;
    }

    public final boolean initialized() {
        return this.initialized;
    }

    protected final boolean confirmInsert() {
        return this.configuration.insertConfirmer.confirm(this);
    }

    protected final boolean confirmUpdate() {
        return this.configuration.updateConfirmer.confirm(this);
    }

    protected final boolean confirmDelete() {
        return this.configuration.deleteConfirmer.confirm(this);
    }

    protected final InsertCommandBuilder insertCommand() {
        return new DefaultInsertCommandBuilder();
    }

    protected final UpdateCommandBuilder updateCommand() {
        return new DefaultUpdateCommandBuilder();
    }

    protected final DeleteCommandBuilder deleteCommand() {
        return new DefaultDeleteCommandBuilder();
    }

    @Override
    protected void onException(Exception exception) {
        if (exception instanceof ValidationException) {
            this.onValidationException((ValidationException)((Object)exception));
        } else if (exception instanceof ReferentialIntegrityException) {
            this.onReferentialIntegrityException((ReferentialIntegrityException)((Object)exception));
        } else {
            super.onException(exception);
        }
    }

    protected void onReferentialIntegrityException(ReferentialIntegrityException exception) {
        Objects.requireNonNull(exception);
        if (exception.operation() == Database.Operation.DELETE && this.configuration.referentialIntegrityErrorHandling == ReferentialIntegrityErrorHandling.DISPLAY_DEPENDENCIES) {
            this.displayDependencies();
        } else {
            super.onException((Exception)((Object)exception));
        }
    }

    protected void onValidationException(ValidationException exception) {
        Objects.requireNonNull(exception);
        String title = this.editModel().entities().definition(exception.attribute().entityType()).attributes().definition(exception.attribute()).caption();
        JOptionPane.showMessageDialog(this, exception.getMessage(), title, 0);
        this.focus().request(exception.attribute());
    }

    protected void setupControls() {
    }

    protected abstract void initializeUI();

    protected final void configureControls(Consumer<Controls.Layout> controlsConfig) {
        Objects.requireNonNull(controlsConfig).accept(this.controlsLayout);
    }

    protected final <T extends Control> Value<T> control(ControlKey<T> controlKey) {
        return this.configuration.controlMap.control(Objects.requireNonNull(controlKey));
    }

    protected final Controls controls() {
        if (!this.initialized()) {
            throw new IllegalStateException("Method must be called after the panel is initialized");
        }
        return this.controlsLayout.create(this.configuration.controlMap);
    }

    private void createControls() {
        Value.Validator controlValueValidator = control -> {
            if (this.initialized) {
                throw new IllegalStateException("Controls must be configured before the panel is initialized");
            }
        };
        ControlMap controlMap = this.configuration.controlMap;
        controlMap.controls().forEach(control -> control.addValidator(controlValueValidator));
        if (!this.editModel().readOnly().get().booleanValue()) {
            if (this.editModel().insertEnabled().get().booleanValue()) {
                controlMap.control(ControlKeys.INSERT).set((Object)this.createInsertControl());
            }
            if (this.editModel().updateEnabled().get().booleanValue()) {
                controlMap.control(ControlKeys.UPDATE).set((Object)this.createUpdateControl());
            }
            if (this.editModel().deleteEnabled().get().booleanValue()) {
                controlMap.control(ControlKeys.DELETE).set((Object)this.createDeleteControl());
            }
        }
        controlMap.control(ControlKeys.CLEAR).set((Object)this.createClearControl());
        controlMap.control(ControlKeys.SELECT_INPUT_FIELD).set((Object)this.createSelectInputComponentControl());
        if (this.configuration.includeEntityMenu) {
            controlMap.control(ControlKeys.DISPLAY_ENTITY_MENU).set((Object)this.createShowEntityMenuControl());
        }
    }

    private CommandControl createDeleteControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this.deleteCommand().confirm(true).build()).name(FrameworkMessages.delete())).enabled((ObservableState)State.and((ObservableState[])new ObservableState[]{this.active, this.editModel().deleteEnabled(), this.editModel().editor().exists()}))).description(FrameworkMessages.deleteCurrentTip() + ALT_PREFIX + FrameworkMessages.deleteMnemonic() + ")")).mnemonic((int)FrameworkMessages.deleteMnemonic())).smallIcon((Icon)ICONS.delete())).onException(this::onException).build();
    }

    private CommandControl createClearControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::clearAndRequestFocus).name(Messages.clear())).enabled((ObservableState)this.active)).description(Messages.clearTip() + ALT_PREFIX + Messages.clearMnemonic() + ")")).mnemonic((int)Messages.clearMnemonic())).smallIcon((Icon)ICONS.clear())).build();
    }

    private CommandControl createSelectInputComponentControl() {
        return Control.command(this::selectInputComponent);
    }

    private CommandControl createShowEntityMenuControl() {
        return Control.command(this::showEntityMenu);
    }

    private CommandControl createUpdateControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this.updateCommand().confirm(true).build()).name(FrameworkMessages.update())).enabled((ObservableState)State.and((ObservableState[])new ObservableState[]{this.active, this.editModel().updateEnabled(), this.editModel().editor().modified()}))).description(FrameworkMessages.updateTip() + ALT_PREFIX + FrameworkMessages.updateMnemonic() + ")")).mnemonic((int)FrameworkMessages.updateMnemonic())).smallIcon((Icon)ICONS.update())).onException(this::onException).build();
    }

    private CommandControl createInsertControl() {
        boolean useSaveCaption = (Boolean)Config.USE_SAVE_CAPTION.getOrThrow();
        char mnemonic = useSaveCaption ? FrameworkMessages.saveMnemonic() : FrameworkMessages.insertMnemonic();
        String caption = useSaveCaption ? FrameworkMessages.save() : FrameworkMessages.insert();
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this.insertCommand().confirm(true).build()).name(caption)).enabled((ObservableState)State.and((ObservableState[])new ObservableState[]{this.active, this.editModel().insertEnabled()}))).description(FrameworkMessages.insertTip() + ALT_PREFIX + mnemonic + ")")).mnemonic((int)mnemonic)).smallIcon((Icon)ICONS.add())).onException(this::onException).build();
    }

    private void bindEvents() {
        this.editModel().editor().changing().addConsumer(this::beforeEntity);
    }

    private Collection<Attribute<?>> selectComponentAttributes() {
        return this.components().keySet().stream().filter(attribute -> !this.configuration.excludeFromSelection.contains(attribute)).filter(attribute -> EntityEditPanel.componentSelectable((JComponent)this.component((Attribute<?>)attribute).get())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableCollection));
    }

    private void beforeEntity(Entity entity) {
        if (this.configuration.modifiedWarning && this.editModel().editor().modified().get().booleanValue() && !Objects.equals(this.editModel().editor(), entity) && JOptionPane.showConfirmDialog(this, FrameworkMessages.modifiedWarning(), FrameworkMessages.modifiedWarningTitle(), 0) != 0) {
            throw new CancelException();
        }
    }

    private void setupFocusActivation() {
        if (this.configuration.focusActivation) {
            ACTIVE_STATE_GROUP.add(this.active);
        }
    }

    private void setupKeyboardActions() {
        this.configuration.controlMap.keyEvent(ControlKeys.DISPLAY_ENTITY_MENU).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
        this.configuration.controlMap.keyEvent(ControlKeys.SELECT_INPUT_FIELD).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
    }

    private void showEntityMenu() {
        new EntityPopupMenu(this.editModel().editor().get(), this.editModel().connection()).show(this, 0, 0);
    }

    private void displayDependencies() {
        Map<EntityType, Collection<Entity>> dependencies = this.entityDependencies();
        if (dependencies.isEmpty()) {
            JOptionPane.showMessageDialog(this, MESSAGES.getString("unknown_dependent_records"), MESSAGES.getString("no_dependencies_title"), 1);
        } else {
            EntityDependenciesPanel dependenciesPanel = new EntityDependenciesPanel(dependencies, this.editModel().connectionProvider());
            int gap = (Integer)Layouts.GAP.getOrThrow();
            dependenciesPanel.setBorder(BorderFactory.createEmptyBorder(0, gap, 0, gap));
            ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)dependenciesPanel).owner((Component)this)).modal(false).title(FrameworkMessages.dependencies())).onShown(dialog -> dependenciesPanel.requestSelectedTableFocus()).show();
        }
    }

    private Map<EntityType, Collection<Entity>> entityDependencies() {
        this.setCursor(Cursors.WAIT);
        try {
            Map map = this.editModel().connectionProvider().connection().dependencies(Collections.singletonList(this.editModel().editor().get()));
            return map;
        }
        catch (DatabaseException e) {
            this.displayException((Exception)((Object)e));
            Map<EntityType, Collection<Entity>> map = Collections.emptyMap();
            return map;
        }
        finally {
            this.setCursor(Cursors.DEFAULT);
        }
    }

    private Config configure(Consumer<Config> configuration) {
        Config config = new Config(this);
        Objects.requireNonNull(configuration).accept(config);
        return new Config(config);
    }

    private static boolean componentSelectable(JComponent component) {
        return component != null && component.isDisplayable() && component.isVisible() && component.isEnabled() && EntityEditPanel.focusable(component);
    }

    private static boolean focusable(JComponent component) {
        if (component instanceof JSpinner) {
            return ((JSpinner.DefaultEditor)((JSpinner)component).getEditor()).getTextField().isFocusable();
        }
        return component.isFocusable();
    }

    private static Controls.Layout createControlsLayout() {
        return Controls.layout(Arrays.asList(ControlKeys.INSERT, ControlKeys.UPDATE, ControlKeys.DELETE, ControlKeys.CLEAR));
    }

    private static <T> Consumer<T> emptyConsumer() {
        return EMPTY_CONSUMER;
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new FocusActivationListener());
        ACTIVE_STATE_GROUP = State.group((State[])new State[0]);
        NO_CONFIGURATION = EntityEditPanel.emptyConsumer();
    }

    public static final class Config {
        public static final PropertyValue<Boolean> USE_SAVE_CAPTION = Configuration.booleanValue((String)(EntityEditPanel.class.getName() + ".useSaveCaption"), (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_ENTITY_MENU = Configuration.booleanValue((String)(EntityEditPanel.class.getName() + ".includeEntityMenu"), (boolean)true);
        public static final PropertyValue<Boolean> USE_FOCUS_ACTIVATION = Configuration.booleanValue((String)(EntityEditPanel.class.getName() + ".useFocusActivation"), (boolean)true);
        public static final PropertyValue<Boolean> MODIFIED_WARNING = Configuration.booleanValue((String)(EntityEditPanel.class.getName() + ".modifiedWarning"), (boolean)false);
        private static final Confirmer DEFAULT_INSERT_CONFIRMER = Confirmer.NONE;
        private static final Confirmer DEFAULT_UPDATE_CONFIRMER = new UpdateConfirmer();
        private static final Confirmer DEFAULT_DELETE_CONFIRMER = new DeleteConfirmer();
        private final EntityEditPanel editPanel;
        private boolean clearAfterInsert = true;
        private boolean requestFocusAfterInsert = true;
        private boolean focusActivation = (Boolean)USE_FOCUS_ACTIVATION.getOrThrow();
        private boolean includeEntityMenu = (Boolean)INCLUDE_ENTITY_MENU.getOrThrow();
        private boolean modifiedWarning = (Boolean)MODIFIED_WARNING.getOrThrow();
        private ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling = (ReferentialIntegrityErrorHandling)((Object)ReferentialIntegrityErrorHandling.REFERENTIAL_INTEGRITY_ERROR_HANDLING.get());
        private Confirmer insertConfirmer = DEFAULT_INSERT_CONFIRMER;
        private Confirmer deleteConfirmer = DEFAULT_DELETE_CONFIRMER;
        private Confirmer updateConfirmer = DEFAULT_UPDATE_CONFIRMER;
        private Set<Attribute<?>> excludeFromSelection = Collections.emptySet();
        final ControlMap controlMap;

        private Config(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
            this.controlMap = ControlMap.controlMap(ControlKeys.class);
        }

        private Config(Config config) {
            this.editPanel = config.editPanel;
            this.controlMap = config.controlMap.copy();
            this.clearAfterInsert = config.clearAfterInsert;
            this.requestFocusAfterInsert = config.requestFocusAfterInsert;
            this.referentialIntegrityErrorHandling = config.referentialIntegrityErrorHandling;
            this.focusActivation = config.focusActivation;
            this.insertConfirmer = config.insertConfirmer;
            this.updateConfirmer = config.updateConfirmer;
            this.deleteConfirmer = config.deleteConfirmer;
            this.includeEntityMenu = config.includeEntityMenu;
            this.modifiedWarning = config.modifiedWarning;
            this.excludeFromSelection = Collections.unmodifiableSet(new HashSet(config.excludeFromSelection));
        }

        public EntityEditPanel editPanel() {
            return this.editPanel;
        }

        public Config keyStroke(ControlKey<?> controlKey, Consumer<Value<KeyStroke>> keyStroke) {
            Objects.requireNonNull(keyStroke).accept((Value<KeyStroke>)this.controlMap.keyStroke(controlKey));
            return this;
        }

        public Config clearAfterInsert(boolean clearAfterInsert) {
            this.clearAfterInsert = clearAfterInsert;
            return this;
        }

        public Config requestFocusAfterInsert(boolean requestFocusAfterInsert) {
            this.requestFocusAfterInsert = requestFocusAfterInsert;
            return this;
        }

        public Config referentialIntegrityErrorHandling(ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling) {
            this.referentialIntegrityErrorHandling = Objects.requireNonNull(referentialIntegrityErrorHandling);
            return this;
        }

        public Config focusActivation(boolean focusActivation) {
            this.focusActivation = focusActivation;
            return this;
        }

        public Config includeEntityMenu(boolean includeEntityMenu) {
            this.includeEntityMenu = includeEntityMenu;
            return this;
        }

        public Config modifiedWarning(boolean modifiedWarning) {
            this.modifiedWarning = modifiedWarning;
            return this;
        }

        public Config insertConfirmer(Confirmer insertConfirmer) {
            this.insertConfirmer = Objects.requireNonNull(insertConfirmer);
            return this;
        }

        public Config deleteConfirmer(Confirmer deleteConfirmer) {
            this.deleteConfirmer = Objects.requireNonNull(deleteConfirmer);
            return this;
        }

        public Config updateConfirmer(Confirmer updateConfirmer) {
            this.updateConfirmer = Objects.requireNonNull(updateConfirmer);
            return this;
        }

        public Config excludeFromSelection(Collection<Attribute<?>> excludeFromSelection) {
            this.excludeFromSelection = Collections.unmodifiableSet(new HashSet(excludeFromSelection));
            return this;
        }
    }

    public static interface Confirmer {
        public static final Confirmer NONE = dialogOwner -> true;

        public boolean confirm(JComponent var1);

        default public boolean confirm(JComponent dialogOwner, String message, String title) {
            return JOptionPane.showConfirmDialog(dialogOwner, message, title, 2) == 0;
        }
    }

    private final class DefaultInsertCommandBuilder
    implements InsertCommandBuilder {
        private boolean confirm;
        private Consumer<Collection<Entity>> onInsert = EntityEditPanel.emptyConsumer();

        private DefaultInsertCommandBuilder() {
        }

        @Override
        public InsertCommandBuilder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        @Override
        public InsertCommandBuilder onInsert(Consumer<Collection<Entity>> onInsert) {
            this.onInsert = Objects.requireNonNull(onInsert);
            return this;
        }

        @Override
        public Control.Command build() {
            return new InsertCommand(this);
        }
    }

    private final class DefaultUpdateCommandBuilder
    implements UpdateCommandBuilder {
        private boolean confirm = true;
        private Consumer<Collection<Entity>> onUpdate = EntityEditPanel.emptyConsumer();

        private DefaultUpdateCommandBuilder() {
        }

        @Override
        public UpdateCommandBuilder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        @Override
        public UpdateCommandBuilder onUpdate(Consumer<Collection<Entity>> onUpdate) {
            this.onUpdate = Objects.requireNonNull(onUpdate);
            return this;
        }

        @Override
        public Control.Command build() {
            return new UpdateCommand(this);
        }
    }

    private final class DefaultDeleteCommandBuilder
    implements DeleteCommandBuilder {
        private boolean confirm = true;
        private Consumer<Collection<Entity>> onDelete = EntityEditPanel.emptyConsumer();

        private DefaultDeleteCommandBuilder() {
        }

        @Override
        public DeleteCommandBuilder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        @Override
        public DeleteCommandBuilder onDelete(Consumer<Collection<Entity>> onDelete) {
            this.onDelete = Objects.requireNonNull(onDelete);
            return this;
        }

        @Override
        public Control.Command build() {
            return new DeleteCommand(this);
        }
    }

    public static final class ControlKeys {
        public static final ControlKey<CommandControl> INSERT = CommandControl.key((String)"insert");
        public static final ControlKey<CommandControl> UPDATE = CommandControl.key((String)"update");
        public static final ControlKey<CommandControl> DELETE = CommandControl.key((String)"delete");
        public static final ControlKey<CommandControl> CLEAR = CommandControl.key((String)"clear");
        public static final ControlKey<CommandControl> SELECT_INPUT_FIELD = CommandControl.key((String)"selectInputField", (KeyStroke)KeyEvents.keyStroke((int)73, (int)128));
        public static final ControlKey<CommandControl> DISPLAY_ENTITY_MENU = CommandControl.key((String)"displayEntityMenu", (KeyStroke)KeyEvents.keyStroke((int)86, (int)640));

        private ControlKeys() {
        }
    }

    public static interface DeleteCommandBuilder {
        public DeleteCommandBuilder confirm(boolean var1);

        public DeleteCommandBuilder onDelete(Consumer<Collection<Entity>> var1);

        public Control.Command build();
    }

    public static interface UpdateCommandBuilder {
        public UpdateCommandBuilder confirm(boolean var1);

        public UpdateCommandBuilder onUpdate(Consumer<Collection<Entity>> var1);

        public Control.Command build();
    }

    public static interface InsertCommandBuilder {
        public InsertCommandBuilder confirm(boolean var1);

        public InsertCommandBuilder onInsert(Consumer<Collection<Entity>> var1);

        public Control.Command build();
    }

    private static final class FocusActivationListener
    implements PropertyChangeListener {
        private FocusActivationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            Component focusedComponent = (Component)changeEvent.getNewValue();
            if (focusedComponent != null) {
                EntityEditPanel editPanel = null;
                EntityPanel entityPanel = FocusActivationListener.entityPanel(focusedComponent);
                if (entityPanel != null) {
                    if (entityPanel.containsEditPanel()) {
                        editPanel = entityPanel.editPanel();
                    }
                } else {
                    editPanel = (EntityEditPanel)Utilities.parentOfType(EntityEditPanel.class, (Component)focusedComponent);
                }
                if (editPanel != null && editPanel.configuration.focusActivation) {
                    editPanel.active.set((Object)true);
                }
            }
        }

        private static EntityPanel entityPanel(Component focusedComponent) {
            Component selectedComponent;
            if (focusedComponent instanceof JTabbedPane && (selectedComponent = ((JTabbedPane)focusedComponent).getSelectedComponent()) instanceof EntityPanel) {
                return (EntityPanel)selectedComponent;
            }
            return (EntityPanel)Utilities.parentOfType(EntityPanel.class, (Component)focusedComponent);
        }
    }

    private static final class DeleteConfirmer
    implements Confirmer {
        private DeleteConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmDelete((int)1), FrameworkMessages.delete());
        }
    }

    private static final class UpdateConfirmer
    implements Confirmer {
        private UpdateConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmUpdate(), FrameworkMessages.update());
        }
    }

    private final class DeleteCommand
    implements Control.Command {
        private final boolean confirm;
        private final Consumer<Collection<Entity>> onDelete;

        private DeleteCommand(DefaultDeleteCommandBuilder builder) {
            this.confirm = builder.confirm;
            this.onDelete = builder.onDelete;
        }

        public void execute() {
            block3: {
                block2: {
                    if (!this.confirm) break block2;
                    if (!EntityEditPanel.this.confirmDelete()) break block3;
                }
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Delete.Task)EntityEditPanel.this.editModel().createDelete().prepare()).perform()).title(MESSAGES.getString("deleting"))).owner((Component)EntityEditPanel.this)).onResult(this::handleResult).onException(this::onException).execute();
            }
        }

        private void handleResult(EntityEditModel.Delete.Result result) {
            this.onDelete.accept(result.handle());
            EntityEditPanel.this.focus().initial().request();
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityEditPanel.this.onException(exception);
        }
    }

    private final class UpdateCommand
    implements Control.Command {
        private final boolean confirm;
        private final Consumer<Collection<Entity>> onUpdate;

        private UpdateCommand(DefaultUpdateCommandBuilder builder) {
            this.confirm = builder.confirm;
            this.onUpdate = builder.onUpdate;
        }

        public void execute() {
            block3: {
                block2: {
                    if (!this.confirm) break block2;
                    if (!EntityEditPanel.this.confirmUpdate()) break block3;
                }
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Update.Task)EntityEditPanel.this.editModel().createUpdate().prepare()).perform()).title(MESSAGES.getString("updating"))).owner((Component)EntityEditPanel.this)).onResult(this::handleResult).onException(this::onException).execute();
            }
        }

        private void handleResult(EntityEditModel.Update.Result result) {
            this.onUpdate.accept(result.handle());
            EntityEditPanel.this.focus().afterUpdate().request();
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityEditPanel.this.onException(exception);
        }
    }

    private final class InsertCommand
    implements Control.Command {
        private final boolean confirm;
        private final Consumer<Collection<Entity>> onInsert;

        private InsertCommand(DefaultInsertCommandBuilder builder) {
            this.confirm = builder.confirm;
            this.onInsert = builder.onInsert;
        }

        public void execute() {
            block3: {
                block2: {
                    if (!this.confirm) break block2;
                    if (!EntityEditPanel.this.confirmInsert()) break block3;
                }
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Insert.Task)EntityEditPanel.this.editModel().createInsert().prepare()).perform()).title(MESSAGES.getString("inserting"))).owner((Component)EntityEditPanel.this)).onResult(this::handleResult).onException(this::onException).execute();
            }
        }

        private void handleResult(EntityEditModel.Insert.Result result) {
            this.onInsert.accept(result.handle());
            if (EntityEditPanel.this.configuration.clearAfterInsert) {
                EntityEditPanel.this.editModel().editor().defaults();
            }
            if (EntityEditPanel.this.configuration.requestFocusAfterInsert) {
                EntityEditPanel.this.focus().afterInsert().request();
            }
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityEditPanel.this.onException(exception);
        }
    }
}

