/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.event.Event;
import is.codion.common.i18n.Messages;
import is.codion.common.observable.Observer;
import is.codion.common.property.PropertyValue;
import is.codion.common.resource.MessageBundle;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.EntityType;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ButtonPanelBuilder;
import is.codion.swing.common.ui.component.button.ToolBarBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.table.ConditionPanel;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.control.ControlMap;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.SwingEntityModel;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.EntityEditComponentPanel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityPanelBuilder;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.TabbedDetailLayout;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class EntityPanel
extends JPanel {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(EntityPanel.class, (ResourceBundle)ResourceBundle.getBundle(EntityPanel.class.getName()));
    private static final FrameworkIcons ICONS = FrameworkIcons.instance();
    private static final Consumer<Config> NO_CONFIGURATION = c -> {};
    private final SwingEntityModel entityModel;
    private final DetailPanels detailPanels = new DetailPanels();
    private final EntityEditPanel editPanel;
    private final EntityTablePanel tablePanel;
    private final JPanel editControlPanel;
    private final JPanel mainPanel;
    private final DetailLayout detailLayout;
    private final DetailController detailController;
    private final Event<EntityPanel> activatedEvent = Event.event();
    private final Value<PanelState> editPanelState;
    private final Function<PanelState, PanelState> editPanelStateMapper;
    private final Config configuration;
    private final Controls.Layout controlsLayout;
    private EntityPanel parentPanel;
    private EntityPanel previousPanel;
    private EntityPanel nextPanel;
    private Window editWindow;
    private boolean initialized = false;

    public EntityPanel(SwingEntityModel entityModel) {
        this(Objects.requireNonNull(entityModel), NO_CONFIGURATION);
    }

    public EntityPanel(SwingEntityModel entityModel, Consumer<Config> config) {
        this(Objects.requireNonNull(entityModel), null, entityModel.containsTableModel() ? new EntityTablePanel((SwingEntityTableModel)entityModel.tableModel()) : null, config);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel) {
        this(Objects.requireNonNull(entityModel), editPanel, NO_CONFIGURATION);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, Consumer<Config> config) {
        this(Objects.requireNonNull(entityModel), editPanel, entityModel.containsTableModel() ? new EntityTablePanel((SwingEntityTableModel)entityModel.tableModel()) : null, config);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityTablePanel tablePanel) {
        this(entityModel, tablePanel, NO_CONFIGURATION);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityTablePanel tablePanel, Consumer<Config> config) {
        this(entityModel, null, tablePanel, config);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, EntityTablePanel tablePanel) {
        this(entityModel, editPanel, tablePanel, NO_CONFIGURATION);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, EntityTablePanel tablePanel, Consumer<Config> config) {
        this.entityModel = Objects.requireNonNull(entityModel);
        this.editPanel = editPanel;
        this.tablePanel = tablePanel;
        this.editControlPanel = this.createEditControlPanel();
        this.mainPanel = (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().minimumSize(new Dimension(0, 0))).build();
        this.configuration = this.configure(config);
        this.controlsLayout = EntityPanel.createControlsLayout();
        this.detailLayout = this.configuration.detailLayout.apply(this);
        this.detailController = this.detailLayout.controller().orElse(new DetailController(){});
        this.editPanelStateMapper = EntityPanel.panelStateMapper(this.configuration.enabledEditStates);
        this.editPanelState = Value.builder().nonNull((Object)this.configuration.initialEditState).consumer(this::updateEditState).build();
        this.createControls();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI((JComponent[])new JComponent[]{this.editControlPanel, this.mainPanel, this.tablePanel, this.editPanel});
        if (this.detailPanels != null) {
            Utilities.updateUI(this.detailPanels.get());
        }
        if (this.detailLayout != null) {
            this.detailLayout.updateUI();
        }
    }

    public final <T extends SwingEntityModel> T model() {
        return (T)this.entityModel;
    }

    public final <T extends SwingEntityEditModel> T editModel() {
        return (T)((SwingEntityEditModel)this.entityModel.editModel());
    }

    public final <T extends SwingEntityTableModel> T tableModel() {
        return (T)((SwingEntityTableModel)this.entityModel.tableModel());
    }

    public final Optional<EntityPanel> parentPanel() {
        return Optional.ofNullable(this.parentPanel);
    }

    public final DetailPanels detailPanels() {
        return this.detailPanels;
    }

    public final <T extends EntityPanel> T initialize() {
        if (!this.initialized) {
            try {
                this.setupControls();
                this.setFocusCycleRoot(true);
                this.setupEditAndTablePanelControls();
                this.initializeEditPanel();
                this.initializeUI();
                this.initializeTablePanel();
                this.setupKeyboardActions();
            }
            finally {
                this.initialized = true;
            }
        }
        return (T)this;
    }

    public final <T extends EntityEditPanel> T editPanel() {
        if (this.editPanel == null) {
            throw new IllegalStateException("No edit panel available");
        }
        return (T)this.editPanel;
    }

    public final boolean containsEditPanel() {
        return this.editPanel != null;
    }

    public final <T extends EntityTablePanel> T tablePanel() {
        if (this.tablePanel == null) {
            throw new IllegalStateException("No table panel available");
        }
        return (T)this.tablePanel;
    }

    public final boolean containsTablePanel() {
        return this.tablePanel != null;
    }

    public final <T extends Control> Value<T> control(ControlKey<T> controlKey) {
        return this.configuration.controlMap.control(Objects.requireNonNull(controlKey));
    }

    public final void addKeyEvent(KeyEvents.Builder keyEventBuilder) {
        Objects.requireNonNull(keyEventBuilder);
        keyEventBuilder.enable(new JComponent[]{this});
        if (this.containsEditPanel()) {
            keyEventBuilder.enable(new JComponent[]{this.editControlPanel});
        }
    }

    public final void removeKeyEvent(KeyEvents.Builder keyEventBuilder) {
        Objects.requireNonNull(keyEventBuilder);
        keyEventBuilder.disable(new JComponent[]{this});
        if (this.containsEditPanel()) {
            keyEventBuilder.disable(new JComponent[]{this.editControlPanel});
        }
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.configuration.caption;
    }

    public final String caption() {
        return this.configuration.caption;
    }

    public final Optional<String> description() {
        return Optional.ofNullable(this.configuration.description);
    }

    public final Optional<ImageIcon> icon() {
        return Optional.ofNullable(this.configuration.icon);
    }

    public final Observer<EntityPanel> activated() {
        return this.activatedEvent.observer();
    }

    public final void activate() {
        this.activatedEvent.accept((Object)this);
        this.initialize();
        this.requestInitialFocus();
    }

    public final void displayException(Exception exception) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            focusOwner = this;
        }
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
    }

    public final Value<PanelState> editPanelState() {
        return this.editPanelState;
    }

    public final void requestInitialFocus() {
        if (this.editPanel != null && this.editPanel.isShowing()) {
            this.editPanel.focus().initial().request();
        } else if (this.tablePanel != null) {
            this.tablePanel.table().requestFocus();
        } else if (this.getComponentCount() > 0) {
            this.getComponents()[0].requestFocus();
        } else {
            this.requestFocus();
        }
    }

    public void savePreferences() {
        if (this.containsTablePanel()) {
            this.tablePanel.savePreferences();
        }
        this.detailPanels.get().forEach(EntityPanel::savePreferences);
    }

    public void applyPreferences() {
        if (this.containsTablePanel()) {
            this.tablePanel.applyPreferences();
        }
        this.detailPanels.get().forEach(EntityPanel::applyPreferences);
    }

    public static Builder builder(EntityType entityType) {
        return new EntityPanelBuilder(entityType);
    }

    public static Builder builder(SwingEntityModel.Builder modelBuilder) {
        return new EntityPanelBuilder(modelBuilder);
    }

    protected void initializeUI() {
        this.setLayout(Layouts.borderLayout());
        this.add((Component)this.createMainComponent(), "Center");
    }

    protected void setupControls() {
    }

    protected final void configureControls(Consumer<Controls.Layout> controlsLayout) {
        Objects.requireNonNull(controlsLayout).accept(this.controlsLayout);
    }

    protected final JComponent createMainComponent() {
        return this.detailPanels.get().isEmpty() ? this.mainPanel() : this.detailLayout().layout().orElse(this.mainPanel());
    }

    protected final JPanel mainPanel() {
        JComponent controlComponent;
        Controls controls;
        if (this.editPanel != null && this.editControlPanel.getComponents().length == 0) {
            this.editControlPanel.add((Component)this.configuration.editBasePanel.apply(this.editPanel), "Center");
        }
        if (this.tablePanel != null && this.mainPanel.getComponents().length == 0) {
            this.mainPanel.add((Component)this.tablePanel, "Center");
        }
        if (this.configuration.includeControls && this.editControlPanel != null && (controls = this.controlsLayout.create(this.configuration.controlMap)).notEmpty() && (controlComponent = this.configuration.controlComponent.apply(controls)) != null) {
            this.editControlPanel.add((Component)controlComponent, this.configuration.controlComponentConstraints);
        }
        if (this.containsEditPanel()) {
            this.updateEditState(this.configuration.initialEditState);
        }
        return this.mainPanel;
    }

    protected final void setupKeyboardActions() {
        if (this.containsTablePanel()) {
            this.tablePanel.configuration.controlMap.keyEvent(EntityTablePanel.ControlKeys.REQUEST_TABLE_FOCUS).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
            this.tablePanel.configuration.controlMap.keyEvent(EntityTablePanel.ControlKeys.TOGGLE_CONDITION_VIEW).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
            this.tablePanel.configuration.controlMap.keyEvent(EntityTablePanel.ControlKeys.SELECT_CONDITION).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
            this.tablePanel.configuration.controlMap.keyEvent(EntityTablePanel.ControlKeys.TOGGLE_FILTER_VIEW).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
            this.tablePanel.configuration.controlMap.keyEvent(EntityTablePanel.ControlKeys.SELECT_FILTER).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
            this.tablePanel.configuration.controlMap.keyEvent(EntityTablePanel.ControlKeys.REQUEST_SEARCH_FIELD_FOCUS).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this}));
            if (this.containsEditPanel()) {
                this.tablePanel.configuration.controlMap.keyEvent(EntityTablePanel.ControlKeys.REQUEST_TABLE_FOCUS).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.configuration.controlMap.keyEvent(EntityTablePanel.ControlKeys.TOGGLE_CONDITION_VIEW).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.configuration.controlMap.keyEvent(EntityTablePanel.ControlKeys.SELECT_CONDITION).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.configuration.controlMap.keyEvent(EntityTablePanel.ControlKeys.TOGGLE_FILTER_VIEW).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.configuration.controlMap.keyEvent(EntityTablePanel.ControlKeys.SELECT_FILTER).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this.editControlPanel}));
            }
        }
        if (this.containsEditPanel()) {
            this.configuration.controlMap.keyEvent(ControlKeys.REQUEST_EDIT_PANEL_FOCUS).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this, this.editControlPanel}));
            this.editPanel.configuration.controlMap.keyEvent(EntityEditPanel.ControlKeys.SELECT_INPUT_FIELD).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this, this.editControlPanel}));
            this.configuration.controlMap.keyEvent(ControlKeys.TOGGLE_EDIT_PANEL).ifPresent(keyEvent -> keyEvent.condition(1).enable(new JComponent[]{this, this.editControlPanel}));
        }
        if (this.configuration.useKeyboardNavigation) {
            this.setupNavigation();
        }
    }

    protected final void setupNavigation() {
        JComponent[] components = this.navigationComponents();
        this.configuration.controlMap.keyEvent(ControlKeys.NAVIGATE_UP).ifPresent(keyEvent -> keyEvent.condition(1).enable(components));
        this.configuration.controlMap.keyEvent(ControlKeys.NAVIGATE_DOWN).ifPresent(keyEvent -> keyEvent.condition(1).enable(components));
        this.configuration.controlMap.keyEvent(ControlKeys.NAVIGATE_LEFT).ifPresent(keyEvent -> keyEvent.condition(1).enable(components));
        this.configuration.controlMap.keyEvent(ControlKeys.NAVIGATE_RIGHT).ifPresent(keyEvent -> keyEvent.condition(1).enable(components));
    }

    private JComponent[] navigationComponents() {
        ArrayList<JPanel> comps = new ArrayList<JPanel>();
        comps.add(this);
        if (this.containsEditPanel()) {
            comps.add(this.editControlPanel);
        }
        return comps.toArray(new JComponent[0]);
    }

    private CommandControl createRequestEditPanelFocusControl() {
        return Control.command(this::requestEditPanelFocus);
    }

    private CommandControl createToggleEditPanelControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::toggleEditPanelState).smallIcon((Icon)ICONS.editPanel())).description(MESSAGES.getString("toggle_edit"))).build();
    }

    private CommandControl createRefreshTableControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(() -> ((FilterTableModel.FilterTableModelItems)this.tableModel().items()).refresh()).name(Messages.refresh())).enabled(this.editPanel == null ? null : this.editPanel.active())).description(Messages.refreshTip() + " (ALT-" + Messages.refreshMnemonic() + ")")).mnemonic((int)Messages.refreshMnemonic())).smallIcon((Icon)ICONS.refresh())).build();
    }

    protected final void initializeEditPanel() {
        if (this.editPanel != null) {
            this.editPanel.initialize();
            this.configuration.controlMap.control(ControlKeys.EDIT_CONTROLS).set((Object)this.editPanel.controls());
        }
    }

    protected final void initializeTablePanel() {
        if (this.tablePanel != null) {
            this.tablePanel.initialize();
            if (this.tablePanel.table().doubleClickAction().isNull()) {
                this.tablePanel.table().doubleClickAction().set((Object)Control.command((Control.Command)new ShowHiddenEditPanel()));
            }
        }
    }

    protected final <T extends DetailLayout> T detailLayout() {
        return (T)this.detailLayout;
    }

    protected final <T extends DetailController> T detailController() {
        return (T)this.detailController;
    }

    private JPanel createEditControlPanel() {
        if (this.editPanel == null) {
            return null;
        }
        return (JPanel)((BorderLayoutPanelBuilder)((BorderLayoutPanelBuilder)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().minimumSize(new Dimension(0, 0))).border(BorderFactory.createEmptyBorder((Integer)Layouts.GAP.getOrThrow(), 0, (Integer)Layouts.GAP.getOrThrow(), 0))).mouseListener((MouseListener)new ActivateOnMouseClickListener())).build();
    }

    final void setParentPanel(EntityPanel parentPanel) {
        if (this.parentPanel != null) {
            throw new IllegalStateException("Parent panel has already been set for " + this);
        }
        this.parentPanel = Objects.requireNonNull(parentPanel);
    }

    final void setPreviousPanel(EntityPanel previousPanel) {
        this.previousPanel = Objects.requireNonNull(previousPanel);
    }

    final void setNextPanel(EntityPanel nextPanel) {
        this.nextPanel = Objects.requireNonNull(nextPanel);
    }

    static void addEntityPanelAndLinkSiblings(EntityPanel detailPanel, List<EntityPanel> entityPanels) {
        if (!entityPanels.isEmpty()) {
            EntityPanel previousPanel = entityPanels.get(entityPanels.size() - 1);
            detailPanel.setPreviousPanel(previousPanel);
            previousPanel.setNextPanel(detailPanel);
            EntityPanel firstPanel = entityPanels.get(0);
            detailPanel.setNextPanel(firstPanel);
            firstPanel.setPreviousPanel(detailPanel);
        }
        entityPanels.add(detailPanel);
    }

    final WindowType windowType() {
        return this.configuration.windowType;
    }

    private void setupEditAndTablePanelControls() {
        if (this.containsTablePanel() && this.containsEditPanel() && this.configuration.includeToggleEditPanelControl) {
            this.control(ControlKeys.TOGGLE_EDIT_PANEL).optional().ifPresent(control -> this.tablePanel.addToolBarControls((Controls)Controls.builder().control((Control)control).build()));
        }
        if (this.containsEditPanel()) {
            this.editPanel.control(EntityEditPanel.ControlKeys.SELECT_INPUT_FIELD).map(control -> (CommandControl)control.copy(this::selectInputComponent).build());
        }
    }

    private void requestEditPanelFocus() {
        if (this.editPanelState.isEqualTo((Object)PanelState.HIDDEN)) {
            this.editPanelState.map(this.editPanelStateMapper);
        }
        ((EntityEditComponentPanel)this.editPanel()).focus().initial().request();
    }

    private void selectInputComponent() {
        if (this.editPanelState.isEqualTo((Object)PanelState.HIDDEN)) {
            this.editPanelState.map(this.editPanelStateMapper);
        }
        ((EntityEditPanel)this.editPanel()).selectInputComponent();
    }

    private void updateEditState(PanelState newState) {
        switch (newState) {
            case HIDDEN: {
                this.disposeEditWindow();
                this.mainPanel.remove(this.editControlPanel);
                break;
            }
            case EMBEDDED: {
                this.disposeEditWindow();
                this.mainPanel.add((Component)this.editControlPanel, this.configuration.editPanelContstraints);
                break;
            }
            case WINDOW: {
                this.displayEditWindow();
            }
        }
        this.revalidate();
        this.requestInitialFocus();
    }

    private void displayEditWindow() {
        if (this.configuration.windowType == WindowType.FRAME) {
            this.displayEditFrame(this.editControlPanel);
        } else if (this.configuration.windowType == WindowType.DIALOG) {
            this.displayEditDialog(this.editControlPanel);
        }
    }

    private void displayEditFrame(JPanel editControlPanel) {
        this.editWindow = Windows.frame((JComponent)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent((JComponent)editControlPanel).border(Borders.emptyBorder())).build()).locationRelativeTo((Component)(this.tablePanel == null ? this : this.tablePanel)).title(this.configuration.caption).icon(this.configuration.icon).defaultCloseOperation(2).onClosed(windowEvent -> this.editPanelState.set((Object)PanelState.HIDDEN)).show();
    }

    private void displayEditDialog(JPanel editControlPanel) {
        this.editWindow = ((ComponentDialogBuilder)((ComponentDialogBuilder)((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent((JComponent)editControlPanel).border(Borders.emptyBorder())).build()).owner((Component)this)).locationRelativeTo((Component)(this.tablePanel == null ? this : this.tablePanel))).title(this.configuration.caption)).icon(this.configuration.icon)).modal(false).disposeOnEscape(this.configuration.disposeEditDialogOnEscape).onClosed(windowEvent -> this.editPanelState.set((Object)PanelState.HIDDEN)).show();
    }

    private void disposeEditWindow() {
        if (this.editWindow != null) {
            this.editWindow.dispose();
            this.editWindow = null;
        }
    }

    private void toggleEditPanelState() {
        this.editPanelState.map(this.editPanelStateMapper);
    }

    private Config configure(Consumer<Config> configuration) {
        Config config = new Config(this);
        Objects.requireNonNull(configuration).accept(config);
        return new Config(config);
    }

    private static Controls.Layout createControlsLayout() {
        return Controls.layout(Arrays.asList(ControlKeys.EDIT_CONTROLS, ControlKeys.REFRESH));
    }

    private void createControls() {
        Value.Validator controlValueValidator = control -> {
            if (this.initialized) {
                throw new IllegalStateException("Controls must be configured before the panel is initialized");
            }
        };
        ControlMap controlMap = this.configuration.controlMap;
        controlMap.controls().forEach(control -> control.addValidator(controlValueValidator));
        controlMap.control(ControlKeys.REQUEST_EDIT_PANEL_FOCUS).set((Object)this.createRequestEditPanelFocusControl());
        controlMap.control(ControlKeys.TOGGLE_EDIT_PANEL).set((Object)this.createToggleEditPanelControl());
        controlMap.control(ControlKeys.NAVIGATE_UP).set((Object)Control.command((Control.Command)new Navigate(Direction.UP)));
        controlMap.control(ControlKeys.NAVIGATE_DOWN).set((Object)Control.command((Control.Command)new Navigate(Direction.DOWN)));
        controlMap.control(ControlKeys.NAVIGATE_LEFT).set((Object)Control.command((Control.Command)new Navigate(Direction.LEFT)));
        controlMap.control(ControlKeys.NAVIGATE_RIGHT).set((Object)Control.command((Control.Command)new Navigate(Direction.RIGHT)));
        if (this.containsTablePanel()) {
            controlMap.control(ControlKeys.REFRESH).set((Object)this.createRefreshTableControl());
        }
    }

    static Function<PanelState, PanelState> panelStateMapper(Set<PanelState> states) {
        return new PanelStateMapper(states);
    }

    public final class DetailPanels {
        private final List<EntityPanel> panels = new ArrayList<EntityPanel>();
        private final Event<EntityPanel> panelAdded = Event.event();

        private DetailPanels() {
        }

        public void add(EntityPanel ... detailPanels) {
            for (EntityPanel detailPanel : Objects.requireNonNull(detailPanels)) {
                this.add(detailPanel);
            }
        }

        public Collection<EntityPanel> get() {
            return Collections.unmodifiableCollection(this.panels);
        }

        public <T extends EntityPanel> T get(EntityType entityType) {
            Objects.requireNonNull(entityType);
            return (T)this.panels.stream().filter(detailPanel -> detailPanel.model().entityType().equals(entityType)).findFirst().orElseThrow(() -> new IllegalArgumentException("Detail panel for entity: " + entityType + " not found in panel: " + this));
        }

        public Collection<EntityPanel> linked() {
            return this.panels.stream().filter(detailPanel -> EntityPanel.this.entityModel.detailModels().linked().contains((Object)detailPanel.entityModel)).collect(Collectors.toList());
        }

        public Observer<EntityPanel> added() {
            return this.panelAdded.observer();
        }

        private void add(EntityPanel detailPanel) {
            if (EntityPanel.this.initialized) {
                throw new IllegalStateException("Detail panels must be added before the panel is initialized");
            }
            if (this.panels.contains(Objects.requireNonNull(detailPanel))) {
                throw new IllegalArgumentException("Panel already contains detail panel: " + detailPanel);
            }
            EntityPanel.addEntityPanelAndLinkSiblings(detailPanel, this.panels);
            detailPanel.setParentPanel(EntityPanel.this);
            this.panelAdded.accept((Object)detailPanel);
        }
    }

    public static final class Config {
        public static final PropertyValue<Boolean> USE_KEYBOARD_NAVIGATION = Configuration.booleanValue((String)(EntityPanel.class.getName() + ".useKeyboardNavigation"), (boolean)true);
        public static final PropertyValue<Boolean> DISPOSE_EDIT_DIALOG_ON_ESCAPE = Configuration.booleanValue((String)(EntityPanel.class.getName() + ".disposeEditDialogOnEscape"), (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_TOGGLE_EDIT_PANEL_CONTROL = Configuration.booleanValue((String)(EntityPanel.class.getName() + ".includeToggleEditPanelControl"), (boolean)true);
        public static final PropertyValue<Boolean> TOOLBAR_CONTROLS = Configuration.booleanValue((String)(EntityPanel.class.getName() + ".toolbarControls"), (boolean)false);
        public static final PropertyValue<WindowType> WINDOW_TYPE = Configuration.enumValue((String)(EntityPanel.class.getName() + ".windowType"), WindowType.class, (Enum)WindowType.DIALOG);
        public static final PropertyValue<String> CONTROL_PANEL_CONSTRAINTS = Configuration.stringValue((String)(EntityPanel.class.getName() + ".controlPanelConstraints"), (String)"East");
        public static final PropertyValue<String> CONTROL_TOOLBAR_CONSTRAINTS = Configuration.stringValue((String)(EntityPanel.class.getName() + ".controlToolBarConstraints"), (String)"West");
        public static final PropertyValue<String> EDIT_PANEL_CONSTRAINTS = Configuration.stringValue((String)(EntityPanel.class.getName() + ".editPanelConstraints"), (String)"North");
        public static final PropertyValue<Boolean> INCLUDE_CONTROLS = Configuration.booleanValue((String)(EntityPanel.class.getName() + ".includeControls"), (boolean)true);
        private final EntityPanel entityPanel;
        private final ControlMap controlMap;
        private final Set<PanelState> enabledEditStates;
        private Function<EntityPanel, DetailLayout> detailLayout = new DefaultDetailLayout();
        private Function<Controls, JComponent> controlComponent = new DefaultControlComponent();
        private Function<EntityEditPanel, JPanel> editBasePanel = new DefaultEditBasePanel();
        private boolean disposeEditDialogOnEscape = (Boolean)DISPOSE_EDIT_DIALOG_ON_ESCAPE.getOrThrow();
        private boolean toolbarControls = (Boolean)TOOLBAR_CONTROLS.getOrThrow();
        private boolean includeToggleEditPanelControl = (Boolean)INCLUDE_TOGGLE_EDIT_PANEL_CONTROL.getOrThrow();
        private String controlComponentConstraints = (Boolean)TOOLBAR_CONTROLS.getOrThrow() != false ? (String)CONTROL_TOOLBAR_CONSTRAINTS.get() : (String)CONTROL_PANEL_CONSTRAINTS.get();
        private boolean includeControls = (Boolean)INCLUDE_CONTROLS.getOrThrow();
        private boolean useKeyboardNavigation = (Boolean)USE_KEYBOARD_NAVIGATION.getOrThrow();
        private WindowType windowType = (WindowType)((Object)WINDOW_TYPE.get());
        private PanelState initialEditState = PanelState.EMBEDDED;
        private String editPanelContstraints = (String)EDIT_PANEL_CONSTRAINTS.get();
        private String caption;
        private String description;
        private ImageIcon icon;

        private Config(EntityPanel entityPanel) {
            this.entityPanel = entityPanel;
            this.controlMap = ControlMap.controlMap(ControlKeys.class);
            this.enabledEditStates = new LinkedHashSet<PanelState>(Arrays.asList(PanelState.values()));
            this.caption = entityPanel.model().entityDefinition().caption();
            this.description = entityPanel.model().entityDefinition().description().orElse(null);
        }

        private Config(Config config) {
            this.entityPanel = config.entityPanel;
            this.controlMap = config.controlMap.copy();
            this.enabledEditStates = new LinkedHashSet<PanelState>(config.enabledEditStates);
            this.detailLayout = config.detailLayout;
            this.controlComponent = config.controlComponent;
            this.editBasePanel = config.editBasePanel;
            this.toolbarControls = config.toolbarControls;
            this.includeToggleEditPanelControl = config.includeToggleEditPanelControl;
            this.controlComponentConstraints = config.controlComponentConstraints;
            this.includeControls = config.includeControls;
            this.useKeyboardNavigation = config.useKeyboardNavigation;
            this.initialEditState = config.initialEditState;
            this.caption = config.caption;
            this.description = config.description;
            this.icon = config.icon;
            this.disposeEditDialogOnEscape = config.disposeEditDialogOnEscape;
            this.windowType = config.windowType;
            this.editPanelContstraints = config.editPanelContstraints;
        }

        public <T extends EntityPanel> T entityPanel() {
            return (T)this.entityPanel;
        }

        public Config caption(String caption) {
            this.caption = Objects.requireNonNull(caption);
            return this;
        }

        public Config description(String description) {
            this.description = Objects.requireNonNull(description);
            return this;
        }

        public Config icon(ImageIcon icon) {
            this.icon = Objects.requireNonNull(icon);
            return this;
        }

        public Config detailLayout(Function<EntityPanel, DetailLayout> detailLayout) {
            this.detailLayout = Objects.requireNonNull(detailLayout);
            return this;
        }

        public Config controlComponent(Function<Controls, JComponent> controlComponent) {
            this.controlComponent = Objects.requireNonNull(controlComponent);
            return this;
        }

        public Config editBasePanel(Function<EntityEditPanel, JPanel> editBasePanel) {
            this.editBasePanel = Objects.requireNonNull(editBasePanel);
            return this;
        }

        public Config toolbarControls(boolean toolbarControls) {
            this.toolbarControls = toolbarControls;
            return this;
        }

        public Config controlComponentConstraints(String controlComponentConstraints) {
            this.controlComponentConstraints = Config.validateBorderLayoutConstraints(controlComponentConstraints);
            return this;
        }

        public Config editPanelConstraints(String editPanelConstraints) {
            this.editPanelContstraints = Config.validateBorderLayoutConstraints(editPanelConstraints);
            return this;
        }

        public Config includeToggleEditPanelControl(boolean includeToggleEditPanelControl) {
            this.includeToggleEditPanelControl = includeToggleEditPanelControl;
            return this;
        }

        public Config includeControls(boolean includeControls) {
            this.includeControls = includeControls;
            return this;
        }

        public Config useKeyboardNavigation(boolean useKeyboardNavigation) {
            this.useKeyboardNavigation = useKeyboardNavigation;
            return this;
        }

        public Config windowType(WindowType windowType) {
            this.windowType = Objects.requireNonNull(windowType);
            return this;
        }

        public Config keyStroke(ControlKey<?> controlKey, Consumer<Value<KeyStroke>> keyStroke) {
            Objects.requireNonNull(keyStroke).accept((Value<KeyStroke>)this.controlMap.keyStroke(controlKey));
            return this;
        }

        public Config initialEditState(PanelState initialState) {
            if (Objects.requireNonNull(initialState) == PanelState.WINDOW) {
                throw new IllegalArgumentException(PanelState.WINDOW + " is not a supported initial state");
            }
            if (!this.enabledEditStates.contains((Object)Objects.requireNonNull(initialState))) {
                throw new IllegalArgumentException("Edit panel state: " + initialState + " is not enabled");
            }
            this.initialEditState = initialState;
            return this;
        }

        public Config enabledEditStates(PanelState ... editStates) {
            if (Objects.requireNonNull(editStates).length == 0) {
                throw new IllegalArgumentException("No edit panel states specified");
            }
            List<PanelState> states = Arrays.asList(editStates);
            if (!states.contains((Object)this.initialEditState)) {
                throw new IllegalArgumentException("Initial edit state has already been set to: " + this.initialEditState);
            }
            this.enabledEditStates.clear();
            this.enabledEditStates.addAll(Arrays.asList(editStates));
            return this;
        }

        public Config disposeEditDialogOnEscape(boolean disposeEditDialogOnEscape) {
            this.disposeEditDialogOnEscape = disposeEditDialogOnEscape;
            return this;
        }

        private boolean horizontalControlLayout() {
            return this.controlComponentConstraints.equals("South") || this.controlComponentConstraints.equals("North");
        }

        private static String validateBorderLayoutConstraints(String constraints) {
            switch (Objects.requireNonNull(constraints)) {
                case "South": 
                case "North": 
                case "East": 
                case "West": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Constraints must be one of BorderLayout.SOUTH, NORTH, EAST or WEST");
                }
            }
            return constraints;
        }

        private static final class DefaultDetailLayout
        implements Function<EntityPanel, DetailLayout> {
            private DefaultDetailLayout() {
            }

            @Override
            public DetailLayout apply(EntityPanel entityPanel) {
                return TabbedDetailLayout.builder(entityPanel).build();
            }
        }

        private final class DefaultControlComponent
        implements Function<Controls, JComponent> {
            private DefaultControlComponent() {
            }

            @Override
            public JComponent apply(Controls controls) {
                Objects.requireNonNull(controls);
                return Config.this.toolbarControls ? this.createControlToolBar(controls) : this.createControlPanel(controls);
            }

            private JToolBar createControlToolBar(Controls controls) {
                return (JToolBar)((ToolBarBuilder)Components.toolBar((Controls)controls).orientation(Config.this.horizontalControlLayout() ? 0 : 1)).build();
            }

            private JPanel createControlPanel(Controls controls) {
                if (Config.this.horizontalControlLayout()) {
                    return (JPanel)Components.flowLayoutPanel((int)1).add(Components.buttonPanel((Controls)controls).build()).build();
                }
                return (JPanel)Components.borderLayoutPanel().northComponent(((ButtonPanelBuilder)((ButtonPanelBuilder)Components.buttonPanel((Controls)controls).orientation(1)).buttonBuilder(buttonBuilder -> buttonBuilder.horizontalAlignment(10))).build()).build();
            }
        }

        private final class DefaultEditBasePanel
        implements Function<EntityEditPanel, JPanel> {
            private DefaultEditBasePanel() {
            }

            @Override
            public JPanel apply(EntityEditPanel editPanel) {
                return (JPanel)Components.panel((LayoutManager)new FlowLayout(Config.this.horizontalControlLayout() ? 1 : 3, 0, 0)).add((JComponent)editPanel).build();
            }
        }
    }

    public static interface DetailLayout {
        public static final Function<EntityPanel, DetailLayout> NONE = entityPanel -> new DetailLayout(){};

        default public void updateUI() {
        }

        default public Optional<JComponent> layout() {
            return Optional.empty();
        }

        default public Optional<DetailController> controller() {
            return Optional.empty();
        }
    }

    public static interface DetailController {
        default public Value<PanelState> panelState(EntityPanel detailPanel) {
            throw new UnsupportedOperationException("panelState() has not been implemented for detail controller: " + this.getClass());
        }

        default public void activated(EntityPanel detailPanel) {
        }
    }

    public static enum PanelState {
        EMBEDDED,
        WINDOW,
        HIDDEN;

    }

    public static final class ControlKeys {
        public static final ControlKey<CommandControl> REQUEST_EDIT_PANEL_FOCUS = CommandControl.key((String)"requestEditPanelFocus", (KeyStroke)KeyEvents.keyStroke((int)69, (int)128));
        public static final ControlKey<CommandControl> TOGGLE_EDIT_PANEL = CommandControl.key((String)"toggleEditPanel", (KeyStroke)KeyEvents.keyStroke((int)69, (int)640));
        public static final ControlKey<CommandControl> NAVIGATE_UP = CommandControl.key((String)"navigateUp", (KeyStroke)KeyEvents.keyStroke((int)38, (int)640));
        public static final ControlKey<CommandControl> NAVIGATE_DOWN = CommandControl.key((String)"navigateDown", (KeyStroke)KeyEvents.keyStroke((int)40, (int)640));
        public static final ControlKey<CommandControl> NAVIGATE_RIGHT = CommandControl.key((String)"navigateRight", (KeyStroke)KeyEvents.keyStroke((int)39, (int)640));
        public static final ControlKey<CommandControl> NAVIGATE_LEFT = CommandControl.key((String)"navigateLeft", (KeyStroke)KeyEvents.keyStroke((int)37, (int)640));
        public static final ControlKey<CommandControl> REFRESH = CommandControl.key((String)"refresh");
        public static final ControlKey<Controls> EDIT_CONTROLS = Controls.key((String)"editControls");

        private ControlKeys() {
        }
    }

    private final class ShowHiddenEditPanel
    implements Control.Command {
        private ShowHiddenEditPanel() {
        }

        public void execute() {
            Window editPanelWindow;
            if (EntityPanel.this.containsEditPanel() && EntityPanel.this.editPanelState.isEqualTo((Object)PanelState.HIDDEN)) {
                EntityPanel.this.editPanelState.map(EntityPanel.this.editPanelStateMapper);
            }
            if ((editPanelWindow = Utilities.parentWindow((Component)EntityPanel.this.editControlPanel)) != null) {
                editPanelWindow.toFront();
            }
        }
    }

    private final class ActivateOnMouseClickListener
    extends MouseAdapter {
        private ActivateOnMouseClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            EntityPanel.this.editPanel.focus().afterUpdate().request();
        }
    }

    public static enum WindowType {
        FRAME,
        DIALOG;

    }

    private final class Navigate
    implements Control.Command {
        private final Direction direction;

        private Navigate(Direction direction) {
            this.direction = direction;
        }

        public void execute() {
            switch (this.direction) {
                case LEFT: {
                    if (EntityPanel.this.previousPanel == null) break;
                    EntityPanel.this.previousPanel.activate();
                    break;
                }
                case RIGHT: {
                    if (EntityPanel.this.nextPanel == null) break;
                    EntityPanel.this.nextPanel.activate();
                    break;
                }
                case UP: {
                    if (EntityPanel.this.parentPanel == null) break;
                    EntityPanel.this.parentPanel.activate();
                    break;
                }
                case DOWN: {
                    if (EntityPanel.this.detailPanels.get().isEmpty()) break;
                    this.navigateDown();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown direction: " + this.direction);
                }
            }
        }

        private void navigateDown() {
            EntityPanel.this.detailPanels.linked().stream().findFirst().orElse(EntityPanel.this.detailPanels.panels.get(0)).activate();
        }
    }

    public static enum Direction {
        UP,
        DOWN,
        RIGHT,
        LEFT;

    }

    private static final class PanelStateMapper
    implements Function<PanelState, PanelState> {
        private final List<PanelState> states;

        private PanelStateMapper(Set<PanelState> states) {
            this.states = new ArrayList<PanelState>(states);
        }

        @Override
        public PanelState apply(PanelState state) {
            int index = this.states.indexOf((Object)state);
            if (index < 0) {
                throw new IllegalArgumentException("Invalid PanelState: " + state);
            }
            if (index == this.states.size() - 1) {
                return this.states.get(0);
            }
            return this.states.get(index + 1);
        }
    }

    public static interface Builder {
        public EntityType entityType();

        public Builder caption(String var1);

        public Optional<String> caption();

        public Builder description(String var1);

        public Optional<String> description();

        public Builder icon(ImageIcon var1);

        public Optional<ImageIcon> icon();

        public Builder detailPanel(Builder var1);

        public Builder refreshWhenInitialized(boolean var1);

        public Builder conditionView(ConditionPanel.ConditionView var1);

        public Builder filterView(ConditionPanel.ConditionView var1);

        public Builder detailLayout(Function<EntityPanel, DetailLayout> var1);

        public Builder preferredSize(Dimension var1);

        public Builder panel(Class<? extends EntityPanel> var1);

        public Builder editPanel(Class<? extends EntityEditPanel> var1);

        public Builder tablePanel(Class<? extends EntityTablePanel> var1);

        public Builder onBuildPanel(Consumer<EntityPanel> var1);

        public Builder onBuildEditPanel(Consumer<EntityEditPanel> var1);

        public Builder onBuildTablePanel(Consumer<EntityTablePanel> var1);

        public EntityPanel build(EntityConnectionProvider var1);

        public EntityPanel build(SwingEntityModel var1);
    }

    public final class Display {
        private final Event<EntityPanel> request = Event.event();

        private Display() {
        }

        public void request() {
            Window editPanelWindow;
            this.request.accept((Object)EntityPanel.this);
            Window parentWindow = Utilities.parentWindow((Component)EntityPanel.this);
            if (parentWindow != null) {
                parentWindow.toFront();
            }
            if ((editPanelWindow = Utilities.parentWindow((Component)EntityPanel.this.editControlPanel)) != null) {
                editPanelWindow.toFront();
            }
        }

        public Observer<EntityPanel> requested() {
            return this.request.observer();
        }
    }
}

