/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Text;
import is.codion.common.db.exception.RecordNotFoundException;
import is.codion.common.proxy.ProxyBuilder;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.control.Control;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

final class EntityPopupMenu
extends JPopupMenu {
    private static final int MAXIMUM_VALUE_LENGTH = 42;

    EntityPopupMenu(Entity entity, EntityConnection connection) {
        Objects.requireNonNull(entity);
        Objects.requireNonNull(connection);
        EntityPopupMenu.populateEntityMenu(this, EntityPopupMenu.populateEntityGraph(entity.copy().mutable(), connection, new HashSet<ForeignKeyEntity>()), connection);
    }

    private static void populateEntityMenu(JComponent rootMenu, Entity entity, EntityConnection connection) {
        EntityPopupMenu.populatePrimaryKeyMenu(rootMenu, entity, new ArrayList(entity.definition().primaryKey().definitions()));
        EntityPopupMenu.populateForeignKeyMenu(rootMenu, entity, connection);
        EntityPopupMenu.populateValueMenu(rootMenu, entity);
    }

    private static void populatePrimaryKeyMenu(JComponent rootMenu, Entity entity, List<ColumnDefinition<?>> primaryKeyColumns) {
        Text.collate(primaryKeyColumns);
        for (ColumnDefinition<?> primaryKeyColumn : primaryKeyColumns) {
            JMenuItem menuItem = new JMenuItem("[PK] " + primaryKeyColumn.attribute() + " [" + primaryKeyColumn.attribute().type().valueClass().getSimpleName() + "]: " + EntityPopupMenu.createValueString(entity, primaryKeyColumn));
            menuItem.addActionListener((ActionListener)EntityPopupMenu.clipboardControl(entity, primaryKeyColumn.attribute()));
            EntityPopupMenu.configureMenuItem(menuItem, entity, primaryKeyColumn.attribute(), primaryKeyColumn.attribute().name());
            rootMenu.add(menuItem);
        }
    }

    private static void populateForeignKeyMenu(JComponent rootMenu, Entity entity, EntityConnection connection) {
        ArrayList fkDefinitions = new ArrayList(entity.definition().foreignKeys().definitions());
        Text.collate(fkDefinitions);
        for (ForeignKeyDefinition fkDefinition : fkDefinitions) {
            StringBuilder captionBuilder = new StringBuilder("[FK] ").append(fkDefinition.caption()).append(": ");
            ForeignKey foreignKey = fkDefinition.attribute();
            String caption = captionBuilder.append(EntityPopupMenu.createValueString(entity, fkDefinition)).toString();
            JMenuItem menuItem = entity.isNull((Attribute)foreignKey) ? new JMenuItem(caption) : new JMenu(caption);
            EntityPopupMenu.configureMenuItem(menuItem, entity, foreignKey, EntityPopupMenu.foreignKeyAttributeNames(foreignKey));
            rootMenu.add(menuItem);
            Entity referencedEntity = (Entity)entity.get((Attribute)foreignKey);
            if (referencedEntity == null) continue;
            EntityPopupMenu.populateEntityMenu(menuItem, referencedEntity, connection);
        }
    }

    private static String foreignKeyAttributeNames(ForeignKey foreignKey) {
        return foreignKey.references().stream().map(reference -> reference.column().toString()).collect(Collectors.joining(", "));
    }

    private static void populateValueMenu(JComponent rootMenu, Entity entity) {
        List attributeDefinitions = Text.collate(new ArrayList(entity.definition().attributes().definitions()));
        for (AttributeDefinition attributeDefinition : attributeDefinitions) {
            boolean primaryKeyColumn = attributeDefinition instanceof ColumnDefinition && ((ColumnDefinition)attributeDefinition).primaryKey();
            if (primaryKeyColumn || attributeDefinition instanceof ForeignKeyDefinition) continue;
            JMenuItem menuItem = new JMenuItem(attributeDefinition.toString() + " [" + attributeDefinition.attribute().type().valueClass().getSimpleName() + (attributeDefinition.derived() ? "*" : "") + "]: " + EntityPopupMenu.createValueString(entity, attributeDefinition));
            menuItem.addActionListener((ActionListener)EntityPopupMenu.clipboardControl(entity, attributeDefinition.attribute()));
            EntityPopupMenu.configureMenuItem(menuItem, entity, attributeDefinition.attribute(), attributeDefinition.attribute().toString());
            rootMenu.add(menuItem);
        }
    }

    private static String createValueString(Entity entity, AttributeDefinition<?> attributeDefinition) {
        StringBuilder builder = new StringBuilder();
        if (entity.modified(attributeDefinition.attribute())) {
            builder.append(EntityPopupMenu.createValueString(entity.original(attributeDefinition.attribute()), attributeDefinition));
            builder.append(" \u2192 ");
        }
        builder.append(EntityPopupMenu.createValueString(entity.get(attributeDefinition.attribute()), attributeDefinition));
        return builder.toString();
    }

    private static String createValueString(Object value, AttributeDefinition<Object> attributeDefinition) {
        Object valueAsString;
        Object object = valueAsString = value == null ? "<null>" : attributeDefinition.string(value);
        if (((String)valueAsString).length() > 42) {
            valueAsString = ((String)valueAsString).substring(0, 42) + "...";
        }
        return valueAsString;
    }

    private static void configureMenuItem(JMenuItem menuItem, Entity entity, Attribute<?> attribute, String toolTipText) {
        Font currentFont = menuItem.getFont();
        if (!EntityPopupMenu.valid(entity, attribute)) {
            menuItem.setForeground(Color.RED);
            menuItem.setFont(new Font(currentFont.getName(), 1, currentFont.getSize()));
        }
        if (entity.modified(attribute)) {
            menuItem.setFont(new Font(currentFont.getName(), currentFont.getStyle() | 2, currentFont.getSize()));
        }
        menuItem.setToolTipText(toolTipText);
    }

    private static boolean valid(Entity entity, Attribute<?> attribute) {
        try {
            entity.definition().validator().validate(entity, attribute);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    private static Entity populateEntityGraph(Entity entity, EntityConnection connection, Set<ForeignKeyEntity> visited) {
        for (ForeignKey foreignKey : entity.definition().foreignKeys().get()) {
            Entity.Key key = entity.key(foreignKey);
            if (!entity.isNotNull((Attribute)foreignKey)) continue;
            ForeignKeyEntity foreignKeyEntity = new ForeignKeyEntity(foreignKey, EntityPopupMenu.select(key, connection));
            if (visited.contains(foreignKeyEntity)) {
                entity.put((Attribute)foreignKey, (Object)EntityPopupMenu.duplicate(foreignKeyEntity.entity));
                continue;
            }
            visited.add(foreignKeyEntity);
            entity.put((Attribute)foreignKey, (Object)foreignKeyEntity.entity);
            EntityPopupMenu.populateEntityGraph(foreignKeyEntity.entity, connection, visited);
        }
        return entity;
    }

    private static Entity select(Entity.Key primaryKey, EntityConnection connection) {
        try {
            return connection.selectSingle(EntityConnection.Select.where((Condition)Condition.key((Entity.Key)primaryKey)).fetchDepth(0).build());
        }
        catch (RecordNotFoundException e) {
            return (Entity)ProxyBuilder.builder(Entity.class).delegate((Object)Entity.entity((Entity.Key)primaryKey)).method("toString", parameters -> primaryKey + " <RECORD NOT FOUND>").build();
        }
    }

    private static Entity duplicate(Entity entity) {
        return (Entity)ProxyBuilder.builder(Entity.class).delegate((Object)entity).method("toString", parameters -> entity + " <DUPLICATE>").build();
    }

    private static Control clipboardControl(Entity entity, Attribute<?> attribute) {
        return Control.command((Control.Command)new ClipboardCommand(entity, attribute));
    }

    private static final class ForeignKeyEntity {
        private final ForeignKey foreignKey;
        private final Entity entity;

        private ForeignKeyEntity(ForeignKey foreignKey, Entity entity) {
            this.foreignKey = foreignKey;
            this.entity = entity;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ForeignKeyEntity)) {
                return false;
            }
            ForeignKeyEntity that = (ForeignKeyEntity)object;
            return Objects.equals(this.foreignKey, that.foreignKey) && Objects.equals(this.entity, that.entity);
        }

        public int hashCode() {
            return Objects.hash(this.foreignKey, this.entity);
        }
    }

    private static final class ClipboardCommand
    implements Control.Command {
        private final Entity entity;
        private final Attribute<?> attribute;

        private ClipboardCommand(Entity entity, Attribute<?> attribute) {
            this.entity = entity;
            this.attribute = attribute;
        }

        public void execute() {
            Utilities.setClipboard((String)this.entity.string(this.attribute));
        }
    }
}

