/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.swing.common.ui.component.table.FilterTableCellEditor;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.ui.component.DefaultEntityComponentFactory;
import java.util.Objects;
import java.util.Optional;
import javax.swing.table.TableCellEditor;

final class EntityTableCellEditorFactory
implements FilterTableCellEditor.Factory<Attribute<?>> {
    private final SwingEntityEditModel editModel;

    EntityTableCellEditorFactory(SwingEntityEditModel editModel) {
        this.editModel = Objects.requireNonNull(editModel);
    }

    public Optional<TableCellEditor> create(Attribute<?> attribute) {
        if (this.nonUpdatableForeignKey(attribute)) {
            return Optional.empty();
        }
        DefaultEntityComponentFactory componentFactory = new DefaultEntityComponentFactory(attribute);
        return Optional.of(FilterTableCellEditor.filterTableCellEditor(() -> componentFactory.componentValue(this.editModel, null)));
    }

    private boolean nonUpdatableForeignKey(Attribute<?> attribute) {
        if (attribute instanceof ForeignKey) {
            ForeignKey foreignKey = (ForeignKey)attribute;
            return foreignKey.references().stream().map(ForeignKey.Reference::column).map(referenceAttribute -> this.editModel.entityDefinition().columns().definition(referenceAttribute)).map(ColumnDefinition.class::cast).noneMatch(ColumnDefinition::updatable);
        }
        return false;
    }
}

