/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.model.condition.ConditionModel;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.ui.Colors;
import is.codion.swing.common.ui.component.table.FilterTable;
import is.codion.swing.common.ui.component.table.FilterTableCellRenderer;
import is.codion.swing.framework.model.SwingEntityTableModel;
import java.awt.Color;

public final class EntityTableCellRenderer {
    private EntityTableCellRenderer() {
    }

    public static <T> FilterTableCellRenderer.Builder<Entity, Attribute<?>, T> builder(Attribute<T> attribute, SwingEntityTableModel tableModel) {
        EntityDefinition entityDefinition = tableModel.entityDefinition();
        AttributeDefinition attributeDefinition = entityDefinition.attributes().definition(attribute);
        ConditionModel queryCondition = tableModel.queryModel().conditions().optional(attribute).orElse(null);
        FilterTableCellRenderer.Builder builder = FilterTableCellRenderer.builder((Class)attributeDefinition.attribute().type().valueClass()).uiSettings((FilterTableCellRenderer.UISettings)new EntityUISettings(queryCondition)).string(arg_0 -> ((AttributeDefinition)attributeDefinition).string(arg_0));
        if (!attributeDefinition.items().isEmpty()) {
            builder.horizontalAlignment(((Integer)FilterTableCellRenderer.HORIZONTAL_ALIGNMENT.getOrThrow()).intValue());
        }
        return builder;
    }

    public static Factory factory() {
        return new DefaultFactory();
    }

    private static final class EntityUISettings
    extends FilterTableCellRenderer.DefaultUISettings {
        private final ConditionModel<?> queryCondition;
        private Color filteredConditionBackground;
        private Color alternateFilteredConditionBackground;

        private EntityUISettings(ConditionModel<?> queryCondition) {
            this.queryCondition = queryCondition;
        }

        public void update(int leftPadding, int rightPadding) {
            super.update(leftPadding, rightPadding);
            this.filteredConditionBackground = Colors.darker((Color)this.background(), (double)0.8);
            this.alternateFilteredConditionBackground = Colors.darker((Color)this.alternateBackground(), (double)0.8);
        }

        public Color background(boolean filterEnabled, boolean alternateRow, Color cellBackgroundColor) {
            boolean conditionEnabled;
            boolean bl = conditionEnabled = this.queryCondition != null && this.queryCondition.enabled().get() != false;
            if (conditionEnabled || filterEnabled) {
                return this.filtererdConditionBackground(alternateRow, conditionEnabled && filterEnabled, cellBackgroundColor);
            }
            return cellBackgroundColor;
        }

        private Color filtererdConditionBackground(boolean alternateRow, boolean filterAndConditionEnabled, Color cellBackgroundColor) {
            if (cellBackgroundColor != null) {
                return Colors.darker((Color)cellBackgroundColor, (double)0.9);
            }
            return alternateRow ? (filterAndConditionEnabled ? this.alternateFilteredConditionBackground : this.alternateFilteredBackground()) : (filterAndConditionEnabled ? this.filteredConditionBackground : this.filteredBackground());
        }
    }

    private static final class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        public FilterTableCellRenderer<?> create(Attribute<?> attribute, SwingEntityTableModel tableModel) {
            return EntityTableCellRenderer.builder(attribute, tableModel).build();
        }
    }

    public static interface Factory
    extends FilterTableCellRenderer.Factory<Entity, Attribute<?>> {
        public FilterTableCellRenderer<?> create(Attribute<?> var1, SwingEntityTableModel var2);

        default public FilterTableCellRenderer<?> create(Attribute<?> attribute, FilterTableModel<Entity, Attribute<?>> tableModel) {
            return this.create(attribute, (SwingEntityTableModel)tableModel);
        }
    }

    public static interface EntityColorProvider<T>
    extends FilterTableCellRenderer.ColorProvider<Entity, Attribute<?>, T> {
        public Color color(FilterTable<Entity, Attribute<?>> var1, Entity var2, Attribute<?> var3, T var4);
    }
}

