/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.common.resource.MessageBundle;
import is.codion.common.value.Value;
import is.codion.framework.model.EntityModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.splitpane.SplitPaneBuilder;
import is.codion.swing.common.ui.component.tabbedpane.TabbedPaneBuilder;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.control.ControlMap;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityModel;
import is.codion.swing.framework.ui.EntityPanel;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public final class TabbedDetailLayout
implements EntityPanel.DetailLayout {
    public static final PropertyValue<Boolean> INCLUDE_CONTROLS = Configuration.booleanValue((String)(TabbedDetailLayout.class.getName() + ".includeControls"), (boolean)true);
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(TabbedDetailLayout.class, (ResourceBundle)ResourceBundle.getBundle(TabbedDetailLayout.class.getName()));
    private static final FrameworkIcons ICONS = FrameworkIcons.instance();
    private static final int RESIZE_AMOUNT = 30;
    private static final String DETAIL_TABLES = "detail_tables";
    private static final double DEFAULT_SPLIT_PANE_RESIZE_WEIGHT = 0.5;
    private static final int DETAIL_WINDOW_OFFSET = 38;
    private static final double DETAIL_WINDOW_SIZE_RATIO = 0.66;
    private final EntityPanel entityPanel;
    private final TabbedDetailController detailController;
    private final boolean includeControls;
    private final double splitPaneResizeWeight;
    private final ControlMap controlMap;
    private final EntityPanel.WindowType windowType;
    private JTabbedPane tabbedPane;
    private JSplitPane splitPane;
    private Window panelWindow;

    private TabbedDetailLayout(DefaultBuilder builder) {
        this.entityPanel = builder.entityPanel;
        this.windowType = builder.windowType;
        this.includeControls = builder.includeControls;
        this.splitPaneResizeWeight = builder.splitPaneResizeWeight;
        this.detailController = new TabbedDetailController(builder.enabledDetailStates, builder.initialState);
        this.controlMap = builder.controlMap;
        this.entityPanel.detailPanels().added().addConsumer(this::bindEvents);
    }

    @Override
    public void updateUI() {
        Utilities.updateUI((JComponent[])new JComponent[]{this.tabbedPane, this.splitPane});
    }

    @Override
    public Optional<JComponent> layout() {
        if (this.entityPanel.detailPanels().get().isEmpty()) {
            throw new IllegalStateException("EntityPanel " + this.entityPanel + " has no detail panels");
        }
        if (this.splitPane != null) {
            throw new IllegalStateException("EntityPanel " + this.entityPanel + " has already been laid out");
        }
        this.entityPanel.activated().addListener((Runnable)new ShowIfHidden());
        this.splitPane = this.createSplitPane(this.entityPanel.mainPanel());
        this.tabbedPane = this.createTabbedPane(this.entityPanel.detailPanels().get());
        this.setupControls(this.entityPanel);
        this.detailController.initialize();
        return Optional.of(this.splitPane);
    }

    @Override
    public Optional<EntityPanel.DetailController> controller() {
        return Optional.of(this.detailController);
    }

    public static Builder builder(EntityPanel entityPanel) {
        return new DefaultBuilder(entityPanel);
    }

    private void bindEvents(EntityPanel detailPanel) {
        detailPanel.activated().addConsumer(this.detailController::activated);
        this.controlMap.keyStroke(ControlKeys.RESIZE_RIGHT).optional().ifPresent(keyStroke -> detailPanel.addKeyEvent(KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)new ResizeAction(detailPanel, true, false))));
        this.controlMap.keyStroke(ControlKeys.RESIZE_LEFT).optional().ifPresent(keyStroke -> detailPanel.addKeyEvent(KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)new ResizeAction(detailPanel, false, false))));
        this.controlMap.keyStroke(ControlKeys.COLLAPSE).optional().ifPresent(keyStroke -> detailPanel.addKeyEvent(KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)new ResizeAction(detailPanel, true, true))));
        this.controlMap.keyStroke(ControlKeys.EXPAND).optional().ifPresent(keyStroke -> detailPanel.addKeyEvent(KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)new ResizeAction(detailPanel, false, true))));
    }

    private void setupControls(EntityPanel entityPanel) {
        if (entityPanel.containsTablePanel() && this.includeControls) {
            Object tablePanel = entityPanel.tablePanel();
            ((EntityTablePanel)tablePanel).addToolBarControls((Controls)Controls.builder().control(((CommandControl.CommandControlBuilder)Control.builder().command(this.detailController::toggleDetailState).smallIcon((Icon)ICONS.detail())).description(MESSAGES.getString("toggle_detail"))).build());
            ((EntityTablePanel)tablePanel).addPopupMenuControls((Controls)((Controls.ControlsBuilder)((Controls.ControlsBuilder)Controls.builder().name(MESSAGES.getString(DETAIL_TABLES))).smallIcon((Icon)ICONS.detail())).controls((Collection)entityPanel.detailPanels().get().stream().map(detailPanel -> (CommandControl)((CommandControl.CommandControlBuilder)Control.builder().command((Control.Command)new ActivateDetailPanel((EntityPanel)detailPanel)).name(detailPanel.caption())).build()).collect(Collectors.toList())).build());
        }
    }

    private EntityPanel selectedDetailPanel() {
        if (this.tabbedPane == null) {
            throw new IllegalStateException("Detail panel has not been laid out");
        }
        return (EntityPanel)this.tabbedPane.getSelectedComponent();
    }

    private JSplitPane createSplitPane(JPanel mainPanel) {
        return (JSplitPane)((SplitPaneBuilder)Components.splitPane().orientation(1).continuousLayout(true).oneTouchExpandable(true).dividerSize((Integer)Layouts.GAP.getOrThrow() * 2).resizeWeight(this.splitPaneResizeWeight).leftComponent((JComponent)mainPanel).propertyChangeListener((PropertyChangeListener)new ActivateWhenDetailHidden())).build();
    }

    private JTabbedPane createTabbedPane(Collection<EntityPanel> detailPanels) {
        TabbedPaneBuilder builder = (TabbedPaneBuilder)((TabbedPaneBuilder)((TabbedPaneBuilder)Components.tabbedPane().focusable(false)).changeListener(e -> this.selectedDetailPanel().activate()).minimumSize(new Dimension(0, 0))).focusCycleRoot(true);
        detailPanels.forEach(detailPanel -> builder.tabBuilder(detailPanel.caption(), (JComponent)detailPanel).toolTipText((String)detailPanel.description().orElse(null)).icon((Icon)detailPanel.icon().orElse(null)).add());
        if (this.includeControls) {
            builder.mouseListener((MouseListener)new TabbedPaneMouseReleasedListener());
        }
        return (JTabbedPane)builder.build();
    }

    private static final class DefaultBuilder
    implements Builder {
        private final ControlMap controlMap = ControlMap.controlMap(ControlKeys.class);
        private final EntityPanel entityPanel;
        private final Set<EntityPanel.PanelState> enabledDetailStates = new LinkedHashSet<EntityPanel.PanelState>(Arrays.asList(EntityPanel.PanelState.values()));
        private EntityPanel.PanelState initialState = EntityPanel.PanelState.EMBEDDED;
        private EntityPanel.WindowType windowType;
        private double splitPaneResizeWeight = 0.5;
        private boolean includeControls = (Boolean)INCLUDE_CONTROLS.getOrThrow();

        private DefaultBuilder(EntityPanel entityPanel) {
            this.entityPanel = Objects.requireNonNull(entityPanel);
            this.windowType = entityPanel.windowType();
        }

        @Override
        public Builder initialDetailState(EntityPanel.PanelState initialState) {
            if (Objects.requireNonNull(initialState) == EntityPanel.PanelState.WINDOW) {
                throw new IllegalArgumentException(EntityPanel.PanelState.WINDOW + " is not a supported initial state");
            }
            if (!this.enabledDetailStates.contains((Object)initialState)) {
                throw new IllegalArgumentException("Detail state: " + initialState + " is not enabled");
            }
            this.initialState = initialState;
            return this;
        }

        @Override
        public Builder enabledDetailStates(EntityPanel.PanelState ... panelStates) {
            if (Objects.requireNonNull(panelStates).length == 0) {
                throw new IllegalArgumentException("No detail panel states specified");
            }
            List<EntityPanel.PanelState> states = Arrays.asList(panelStates);
            if (!states.contains((Object)this.initialState)) {
                throw new IllegalArgumentException("Detail state has already been set to: " + this.initialState);
            }
            this.enabledDetailStates.clear();
            this.enabledDetailStates.addAll(states);
            return this;
        }

        @Override
        public Builder windowType(EntityPanel.WindowType windowType) {
            this.windowType = Objects.requireNonNull(windowType);
            return this;
        }

        @Override
        public Builder splitPaneResizeWeight(double splitPaneResizeWeight) {
            this.splitPaneResizeWeight = splitPaneResizeWeight;
            return this;
        }

        @Override
        public Builder includeControls(boolean includeControls) {
            this.includeControls = includeControls;
            return this;
        }

        @Override
        public Builder keyStroke(ControlKey<?> controlKey, KeyStroke keyStroke) {
            this.controlMap.keyStroke(controlKey).set((Object)keyStroke);
            return this;
        }

        @Override
        public TabbedDetailLayout build() {
            return new TabbedDetailLayout(this);
        }
    }

    private final class TabbedDetailController
    implements EntityPanel.DetailController {
        private final Set<EntityPanel.PanelState> panelStates;
        private final Function<EntityPanel.PanelState, EntityPanel.PanelState> panelStateMapper;
        private final Value<EntityPanel.PanelState> panelState;

        private TabbedDetailController(Set<EntityPanel.PanelState> panelStates, EntityPanel.PanelState initialState) {
            this.panelStates = panelStates;
            this.panelStateMapper = EntityPanel.panelStateMapper(panelStates);
            this.panelState = Value.builder().nonNull((Object)initialState).consumer(this::updateDetailState).build();
        }

        @Override
        public void activated(EntityPanel detailPanel) {
            Objects.requireNonNull(detailPanel);
            TabbedDetailLayout.this.entityPanel.initialize();
            TabbedDetailLayout.this.tabbedPane.setFocusable(true);
            TabbedDetailLayout.this.tabbedPane.setSelectedComponent(detailPanel);
            TabbedDetailLayout.this.tabbedPane.setFocusable(false);
            this.showDetailPanel();
            this.activateDetailModelLink((SwingEntityModel)detailPanel.model());
            this.showWindow(detailPanel);
        }

        @Override
        public Value<EntityPanel.PanelState> panelState(EntityPanel detailPanel) {
            Objects.requireNonNull(detailPanel);
            return this.panelState;
        }

        private void showDetailPanel() {
            if (TabbedDetailLayout.this.splitPane.getDividerLocation() == TabbedDetailLayout.this.splitPane.getMaximumDividerLocation()) {
                TabbedDetailLayout.this.splitPane.resetToPreferredSizes();
            }
            if (TabbedDetailLayout.this.detailController.panelState.isEqualTo((Object)EntityPanel.PanelState.HIDDEN)) {
                this.panelState.set((Object)this.panelStateMapper.apply(EntityPanel.PanelState.HIDDEN));
            }
        }

        private void showWindow(EntityPanel detailPanel) {
            Window editPanelWindow;
            Window parentWindow = Utilities.parentWindow((Component)detailPanel);
            if (parentWindow != null) {
                parentWindow.toFront();
            }
            if (detailPanel.containsEditPanel() && (editPanelWindow = Utilities.parentWindow(detailPanel.editPanel())) != null) {
                editPanelWindow.toFront();
            }
        }

        private void updateDetailState(EntityPanel.PanelState newState) {
            Object model = TabbedDetailLayout.this.selectedDetailPanel().model();
            switch (newState) {
                case HIDDEN: {
                    this.deactivateDetailModelLink((SwingEntityModel)model);
                    this.disposeDetailWindow();
                    TabbedDetailLayout.this.splitPane.setRightComponent(null);
                    break;
                }
                case EMBEDDED: {
                    this.activateDetailModelLink((SwingEntityModel)model);
                    TabbedDetailLayout.this.selectedDetailPanel().initialize();
                    this.disposeDetailWindow();
                    TabbedDetailLayout.this.splitPane.setRightComponent(TabbedDetailLayout.this.tabbedPane);
                    TabbedDetailLayout.this.selectedDetailPanel().requestInitialFocus();
                    break;
                }
                case WINDOW: {
                    this.activateDetailModelLink((SwingEntityModel)model);
                    TabbedDetailLayout.this.selectedDetailPanel().initialize();
                    this.displayDetailWindow();
                }
            }
            TabbedDetailLayout.this.entityPanel.revalidate();
        }

        private void deactivateDetailModelLink(SwingEntityModel detailModel) {
            Object model = TabbedDetailLayout.this.entityPanel.model();
            if (model.detailModels().contains((EntityModel)detailModel)) {
                model.detailModels().link((EntityModel)detailModel).active().set((Object)false);
            }
        }

        private void activateDetailModelLink(SwingEntityModel detailModel) {
            Object model = TabbedDetailLayout.this.entityPanel.model();
            if (model.detailModels().contains((EntityModel)detailModel)) {
                ((Set)model.detailModels().linked().get()).stream().filter(linkedDetailModel -> linkedDetailModel != detailModel).forEach(linkedDetailModel -> model.detailModels().link((EntityModel)linkedDetailModel).active().set((Object)false));
                model.detailModels().link((EntityModel)detailModel).active().set((Object)true);
            }
        }

        private void initialize() {
            this.updateDetailState((EntityPanel.PanelState)((Object)this.panelState.getOrThrow()));
        }

        private void toggleDetailState() {
            this.panelState.map(this.panelStateMapper);
        }

        private void displayDetailWindow() {
            Window parent = Utilities.parentWindow((Component)TabbedDetailLayout.this.entityPanel);
            if (parent != null) {
                FocusManager.getCurrentManager().clearFocusOwner();
                TabbedDetailLayout.this.panelWindow = this.createDetailWindow(parent);
                TabbedDetailLayout.this.panelWindow.setVisible(true);
            }
        }

        private void disposeDetailWindow() {
            if (TabbedDetailLayout.this.panelWindow != null) {
                FocusManager.getCurrentManager().clearFocusOwner();
                TabbedDetailLayout.this.panelWindow.setVisible(false);
                TabbedDetailLayout.this.panelWindow.dispose();
                TabbedDetailLayout.this.panelWindow = null;
            }
        }

        private Dimension detailWindowSize(Dimension parentSize) {
            int detailWindowWidth = (int)((double)parentSize.width * 0.66);
            int detailWindowHeight = TabbedDetailLayout.this.entityPanel.containsEditPanel() ? (int)((double)parentSize.height * 0.66) : parentSize.height;
            return new Dimension(detailWindowWidth, detailWindowHeight);
        }

        private Window createDetailWindow(Window parent) {
            Dimension parentSize = parent.getSize();
            Dimension size = this.detailWindowSize(parentSize);
            Point parentLocation = parent.getLocation();
            int detailWindowX = parentLocation.x + (parentSize.width - size.width);
            int detailWindowY = parentLocation.y + (parentSize.height - size.height) - 38;
            Point location = new Point(detailWindowX, detailWindowY);
            if (TabbedDetailLayout.this.windowType == EntityPanel.WindowType.FRAME) {
                return Windows.frame((JComponent)TabbedDetailController.createEmptyBorderBasePanel(TabbedDetailLayout.this.tabbedPane)).title(TabbedDetailLayout.this.entityPanel.caption() + " - " + MESSAGES.getString(TabbedDetailLayout.DETAIL_TABLES)).defaultCloseOperation(2).size(size).location(location).onClosed(windowEvent -> {
                    if (this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.EMBEDDED)) {
                        this.panelState.set((Object)EntityPanel.PanelState.HIDDEN);
                    }
                }).build();
            }
            return ((ComponentDialogBuilder)((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)TabbedDetailController.createEmptyBorderBasePanel(TabbedDetailLayout.this.tabbedPane)).owner((Component)TabbedDetailLayout.this.entityPanel)).title(TabbedDetailLayout.this.entityPanel.caption() + " - " + MESSAGES.getString(TabbedDetailLayout.DETAIL_TABLES))).modal(false).size(size).location(location)).onClosed(windowEvent -> {
                if (this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.EMBEDDED)) {
                    this.panelState.set((Object)EntityPanel.PanelState.HIDDEN);
                }
            }).build();
        }

        private static JPanel createEmptyBorderBasePanel(JComponent component) {
            int gap = (Integer)Layouts.GAP.getOrThrow();
            return (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent(component).border(BorderFactory.createEmptyBorder(gap, gap, 0, gap))).build();
        }
    }

    private final class ShowIfHidden
    implements Runnable {
        private ShowIfHidden() {
        }

        @Override
        public void run() {
            if (TabbedDetailLayout.this.splitPane.getDividerLocation() == TabbedDetailLayout.this.splitPane.getMinimumDividerLocation()) {
                TabbedDetailLayout.this.splitPane.resetToPreferredSizes();
            }
        }
    }

    public static final class ControlKeys {
        public static final ControlKey<CommandControl> RESIZE_RIGHT = CommandControl.key((String)"resizeRight", (KeyStroke)KeyEvents.keyStroke((int)39, (int)576));
        public static final ControlKey<CommandControl> RESIZE_LEFT = CommandControl.key((String)"resizeLeft", (KeyStroke)KeyEvents.keyStroke((int)37, (int)576));
        public static final ControlKey<CommandControl> COLLAPSE = CommandControl.key((String)"collapse", (KeyStroke)KeyEvents.keyStroke((int)39, (int)704));
        public static final ControlKey<CommandControl> EXPAND = CommandControl.key((String)"expand", (KeyStroke)KeyEvents.keyStroke((int)37, (int)704));

        private ControlKeys() {
        }
    }

    private final class ActivateWhenDetailHidden
    implements PropertyChangeListener {
        private static final String DIVIDER_LOCATION = "dividerLocation";

        private ActivateWhenDetailHidden() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            if (DIVIDER_LOCATION.equals(changeEvent.getPropertyName())) {
                JSplitPane pane = (JSplitPane)changeEvent.getSource();
                if (Objects.equals(changeEvent.getNewValue(), pane.getMaximumDividerLocation())) {
                    TabbedDetailLayout.this.entityPanel.activate();
                }
            }
        }
    }

    private final class TabbedPaneMouseReleasedListener
    extends MouseAdapter {
        private TabbedPaneMouseReleasedListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            EntityPanel selectedDetailPanel = TabbedDetailLayout.this.selectedDetailPanel();
            if (e.getClickCount() == 2 && e.getButton() == 1 && TabbedDetailLayout.this.detailController.panelStates.containsAll(Arrays.asList(EntityPanel.PanelState.WINDOW, EntityPanel.PanelState.EMBEDDED))) {
                TabbedDetailLayout.this.detailController.panelState(selectedDetailPanel).map(state -> state == EntityPanel.PanelState.WINDOW ? EntityPanel.PanelState.EMBEDDED : EntityPanel.PanelState.WINDOW);
            } else if (e.getButton() == 2 && TabbedDetailLayout.this.detailController.panelStates.containsAll(Arrays.asList(EntityPanel.PanelState.HIDDEN, EntityPanel.PanelState.EMBEDDED))) {
                TabbedDetailLayout.this.detailController.panelState(selectedDetailPanel).map(state -> state == EntityPanel.PanelState.EMBEDDED ? EntityPanel.PanelState.HIDDEN : EntityPanel.PanelState.EMBEDDED);
            }
        }
    }

    private final class ActivateDetailPanel
    implements Control.Command {
        private final EntityPanel detailPanel;

        private ActivateDetailPanel(EntityPanel detailPanel) {
            this.detailPanel = detailPanel;
        }

        public void execute() {
            if (TabbedDetailLayout.this.detailController.panelState.isEqualTo((Object)EntityPanel.PanelState.HIDDEN)) {
                TabbedDetailLayout.this.detailController.panelState.set((Object)TabbedDetailLayout.this.detailController.panelStateMapper.apply(EntityPanel.PanelState.HIDDEN));
            }
            this.detailPanel.activate();
        }
    }

    private static final class ResizeAction
    extends AbstractAction {
        private final EntityPanel panel;
        private final boolean right;
        private final boolean expand;

        private ResizeAction(EntityPanel panel, boolean right, boolean expand) {
            super("Resize " + (right ? "right" : "left"));
            this.panel = panel;
            this.right = right;
            this.expand = expand;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.panel.parentPanel().ifPresent(parentPanel -> ResizeAction.resizePanel(parentPanel, this.right, this.expand));
        }

        private static void resizePanel(EntityPanel parentPanel, boolean right, boolean expand) {
            TabbedDetailLayout detailLayout = (TabbedDetailLayout)parentPanel.detailLayout();
            JSplitPane splitPane = detailLayout.splitPane;
            if (expand) {
                ResizeAction.expand(splitPane, right);
            } else {
                ResizeAction.resize(splitPane, right);
            }
        }

        private static void expand(JSplitPane splitPane, boolean right) {
            boolean expandedOrCollapsed;
            boolean bl = expandedOrCollapsed = splitPane.getDividerLocation() == splitPane.getMinimumDividerLocation() || splitPane.getDividerLocation() == splitPane.getMaximumDividerLocation();
            if (expandedOrCollapsed) {
                splitPane.resetToPreferredSizes();
            } else {
                splitPane.setDividerLocation(right ? splitPane.getMaximumDividerLocation() : splitPane.getMinimumDividerLocation());
            }
        }

        private static void resize(JSplitPane splitPane, boolean right) {
            if (right) {
                splitPane.setDividerLocation(Math.min(splitPane.getDividerLocation() + 30, splitPane.getMaximumDividerLocation()));
            } else {
                splitPane.setDividerLocation(Math.max(splitPane.getDividerLocation() - 30, 0));
            }
        }
    }

    public static interface Builder {
        public Builder initialDetailState(EntityPanel.PanelState var1);

        public Builder enabledDetailStates(EntityPanel.PanelState ... var1);

        public Builder windowType(EntityPanel.WindowType var1);

        public Builder splitPaneResizeWeight(double var1);

        public Builder includeControls(boolean var1);

        public Builder keyStroke(ControlKey<?> var1, KeyStroke var2);

        public TabbedDetailLayout build();
    }
}

