/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.common.value.Value;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.swing.common.model.component.combobox.FilterComboBoxModel;
import is.codion.swing.common.ui.Cursors;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.combobox.ComboBoxBuilder;
import is.codion.swing.common.ui.component.combobox.DefaultComboBoxBuilder;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.control.ControlMap;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.component.EntityControls;
import java.awt.event.FocusListener;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public final class EntityComboBox
extends JComboBox<Entity> {
    private final ControlMap controlMap;

    private EntityComboBox(DefaultBuilder builder) {
        super(builder.comboBoxModel());
        this.controlMap = builder.controlMap;
        this.controlMap.control(ControlKeys.ADD).set((Object)this.createAddControl(builder.editPanel, (KeyStroke)builder.controlMap.keyStroke(ControlKeys.ADD).get(), builder.confirmAdd));
        this.controlMap.control(ControlKeys.EDIT).set((Object)this.createEditControl(builder.editPanel, (KeyStroke)builder.controlMap.keyStroke(ControlKeys.EDIT).get(), builder.confirmEdit));
        this.model().items().refresher().active().addConsumer(this::refresherActive);
    }

    public EntityComboBoxModel getModel() {
        return (EntityComboBoxModel)super.getModel();
    }

    public EntityComboBoxModel model() {
        return this.getModel();
    }

    public Optional<CommandControl> addControl() {
        return this.controlMap.control(ControlKeys.ADD).optional();
    }

    public Optional<CommandControl> editControl() {
        return this.controlMap.control(ControlKeys.EDIT).optional();
    }

    @Override
    public void requestFocus() {
        if (this.isEditable()) {
            this.getEditor().getEditorComponent().requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        if (this.isEditable()) {
            this.getEditor().getEditorComponent().addFocusListener(listener);
        }
    }

    @Override
    public synchronized void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        if (this.isEditable()) {
            this.getEditor().getEditorComponent().removeFocusListener(listener);
        }
    }

    public <B extends TextFieldBuilder<Integer, NumberField<Integer>, B>> TextFieldBuilder<Integer, NumberField<Integer>, B> integerSelectorField(Attribute<Integer> attribute) {
        Objects.requireNonNull(attribute);
        return (TextFieldBuilder)((NumberField.Builder)Components.integerField((Value)this.getModel().createSelectorValue(attribute)).columns(2)).selectAllOnFocusGained(true);
    }

    public <B extends TextFieldBuilder<Integer, NumberField<Integer>, B>> TextFieldBuilder<Integer, NumberField<Integer>, B> integerSelectorField(FilterComboBoxModel.ItemFinder<Entity, Integer> itemFinder) {
        Objects.requireNonNull(itemFinder);
        return (TextFieldBuilder)((NumberField.Builder)Components.integerField((Value)this.getModel().createSelectorValue(itemFinder)).columns(2)).selectAllOnFocusGained(true);
    }

    public <B extends TextFieldBuilder<String, JTextField, B>> TextFieldBuilder<String, JTextField, B> stringSelectorField(Attribute<String> attribute) {
        Objects.requireNonNull(attribute);
        return (TextFieldBuilder)Components.stringField((Value)this.getModel().createSelectorValue(attribute)).columns(2).selectAllOnFocusGained(true);
    }

    public <B extends TextFieldBuilder<String, JTextField, B>> TextFieldBuilder<String, JTextField, B> stringSelectorField(FilterComboBoxModel.ItemFinder<Entity, String> itemFinder) {
        Objects.requireNonNull(itemFinder);
        return (TextFieldBuilder)Components.stringField((Value)this.getModel().createSelectorValue(itemFinder)).columns(2).selectAllOnFocusGained(true);
    }

    public static Builder builder(EntityComboBoxModel comboBoxModel) {
        return EntityComboBox.builder(comboBoxModel, null);
    }

    public static Builder builder(EntityComboBoxModel comboBoxModel, Value<Entity> linkedValue) {
        return new DefaultBuilder(comboBoxModel, linkedValue);
    }

    private CommandControl createAddControl(Supplier<EntityEditPanel> editPanel, KeyStroke keyStroke, boolean confirm) {
        return editPanel == null ? null : EntityControls.createAddControl(this, editPanel, keyStroke, confirm);
    }

    private CommandControl createEditControl(Supplier<EntityEditPanel> editPanel, KeyStroke keyStroke, boolean confirm) {
        return editPanel == null ? null : EntityControls.createEditControl(this, editPanel, keyStroke, confirm);
    }

    private void refresherActive(boolean refresherActive) {
        this.setCursor(refresherActive ? Cursors.WAIT : Cursors.DEFAULT);
    }

    private static final class DefaultBuilder
    extends DefaultComboBoxBuilder<Entity, EntityComboBox, Builder>
    implements Builder {
        private final ControlMap controlMap = ControlMap.controlMap(ControlKeys.class);
        private Supplier<EntityEditPanel> editPanel;
        private boolean confirmAdd;
        private boolean confirmEdit;

        private DefaultBuilder(EntityComboBoxModel comboBoxModel, Value<Entity> linkedValue) {
            super((ComboBoxModel)comboBoxModel, linkedValue);
        }

        protected EntityComboBox createComboBox() {
            return new EntityComboBox(this);
        }

        @Override
        public Builder editPanel(Supplier<EntityEditPanel> editPanel) {
            this.editPanel = Objects.requireNonNull(editPanel);
            return this;
        }

        @Override
        public Builder keyStroke(ControlKey<?> controlKey, KeyStroke keyStroke) {
            this.controlMap.keyStroke(controlKey).set((Object)keyStroke);
            return this;
        }

        @Override
        public Builder confirmAdd(boolean confirmAdd) {
            this.confirmAdd = confirmAdd;
            return this;
        }

        @Override
        public Builder confirmEdit(boolean confirmEdit) {
            this.confirmEdit = confirmEdit;
            return this;
        }

        private EntityComboBoxModel comboBoxModel() {
            return (EntityComboBoxModel)this.comboBoxModel;
        }
    }

    public static final class ControlKeys {
        public static final ControlKey<CommandControl> ADD = CommandControl.key((String)"add", (KeyStroke)KeyEvents.keyStroke((int)155));
        public static final ControlKey<CommandControl> EDIT = CommandControl.key((String)"edit", (KeyStroke)KeyEvents.keyStroke((int)155, (int)128));

        private ControlKeys() {
        }
    }

    public static interface Builder
    extends ComboBoxBuilder<Entity, EntityComboBox, Builder> {
        public Builder editPanel(Supplier<EntityEditPanel> var1);

        public Builder keyStroke(ControlKey<?> var1, KeyStroke var2);

        public Builder confirmAdd(boolean var1);

        public Builder confirmEdit(boolean var1);
    }
}

