/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.common.value.Value;
import is.codion.framework.domain.entity.Entity;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.key.TransferFocusOnEnter;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.component.EntityComboBox;
import is.codion.swing.framework.ui.component.EntityControls;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class EntityComboBoxPanel
extends JPanel {
    private final EntityComboBox comboBox;
    private final List<AbstractButton> buttons = new ArrayList<AbstractButton>(0);

    private EntityComboBoxPanel(DefaultBuilder builder) {
        this.comboBox = builder.createComboBox();
        ArrayList actions = new ArrayList();
        if (builder.includeAddButton) {
            this.comboBox.addControl().ifPresent(actions::add);
        }
        if (builder.includeEditButton) {
            this.comboBox.editControl().ifPresent(actions::add);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)EntityControls.createButtonPanel(this.comboBox, builder.buttonsFocusable, builder.buttonLocation, this.buttons, actions.toArray(new Action[0])), "Center");
        this.addFocusListener(new InputFocusAdapter(this.comboBox));
    }

    public EntityComboBox comboBox() {
        return this.comboBox;
    }

    public static Builder builder(EntityComboBoxModel comboBoxModel, Supplier<EntityEditPanel> editPanel) {
        return new DefaultBuilder(comboBoxModel, editPanel, null);
    }

    public static Builder builder(EntityComboBoxModel comboBoxModel, Supplier<EntityEditPanel> editPanel, Value<Entity> linkedValue) {
        return new DefaultBuilder(comboBoxModel, editPanel, Objects.requireNonNull(linkedValue));
    }

    private static final class DefaultBuilder
    extends AbstractComponentBuilder<Entity, EntityComboBoxPanel, Builder>
    implements Builder {
        private final EntityComboBox.Builder entityComboBoxBuilder;
        private boolean includeAddButton;
        private boolean includeEditButton;
        private boolean buttonsFocusable;
        private String buttonLocation = EntityControls.defaultButtonLocation();

        private DefaultBuilder(EntityComboBoxModel comboBoxModel, Supplier<EntityEditPanel> editPanelSupplier, Value<Entity> linkedValue) {
            super(linkedValue);
            this.entityComboBoxBuilder = EntityComboBox.builder(comboBoxModel).editPanel(editPanelSupplier);
        }

        @Override
        public Builder includeAddButton(boolean includeAddButton) {
            this.includeAddButton = includeAddButton;
            return this;
        }

        @Override
        public Builder includeEditButton(boolean includeEditButton) {
            this.includeEditButton = includeEditButton;
            return this;
        }

        @Override
        public Builder confirmAdd(boolean confirmAdd) {
            this.entityComboBoxBuilder.confirmAdd(confirmAdd);
            return this;
        }

        @Override
        public Builder confirmEdit(boolean confirmEdit) {
            this.entityComboBoxBuilder.confirmEdit(confirmEdit);
            return this;
        }

        @Override
        public Builder buttonsFocusable(boolean buttonsFocusable) {
            this.buttonsFocusable = buttonsFocusable;
            return this;
        }

        @Override
        public Builder buttonLocation(String buttonLocation) {
            this.buttonLocation = EntityControls.validateButtonLocation(buttonLocation);
            return this;
        }

        @Override
        public Builder comboBoxPreferredWidth(int comboBoxPreferredWidth) {
            this.entityComboBoxBuilder.preferredWidth(comboBoxPreferredWidth);
            return this;
        }

        protected EntityComboBoxPanel createComponent() {
            return new EntityComboBoxPanel(this);
        }

        protected ComponentValue<Entity, EntityComboBoxPanel> createComponentValue(EntityComboBoxPanel component) {
            return new EntityComboBoxPanelValue(component);
        }

        protected void enableTransferFocusOnEnter(EntityComboBoxPanel component) {
            TransferFocusOnEnter.enable((JComponent)component.comboBox());
            component.buttons.forEach(TransferFocusOnEnter::enable);
        }

        private EntityComboBox createComboBox() {
            return (EntityComboBox)this.entityComboBoxBuilder.build();
        }

        private static class EntityComboBoxPanelValue
        extends AbstractComponentValue<Entity, EntityComboBoxPanel> {
            private EntityComboBoxPanelValue(EntityComboBoxPanel component) {
                super((JComponent)component);
                component.comboBox.getModel().selection().item().addListener(() -> this.notifyListeners());
            }

            protected Entity getComponentValue() {
                return (Entity)((EntityComboBoxPanel)this.component()).comboBox.model().selection().item().get();
            }

            protected void setComponentValue(Entity entity) {
                ((EntityComboBoxPanel)this.component()).comboBox.model().selection().item().set((Object)entity);
            }
        }
    }

    private static final class InputFocusAdapter
    extends FocusAdapter {
        private final EntityComboBox comboBox;

        private InputFocusAdapter(EntityComboBox comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.comboBox.requestFocusInWindow();
        }
    }

    public static interface Builder
    extends ComponentBuilder<Entity, EntityComboBoxPanel, Builder> {
        public Builder includeAddButton(boolean var1);

        public Builder includeEditButton(boolean var1);

        public Builder confirmAdd(boolean var1);

        public Builder confirmEdit(boolean var1);

        public Builder buttonsFocusable(boolean var1);

        public Builder buttonLocation(String var1);

        public Builder comboBoxPreferredWidth(int var1);

        public EntityComboBoxPanel build();
    }
}

