/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.icon;

import is.codion.swing.common.ui.icon.FontImageIcon;
import is.codion.swing.common.ui.icon.Icons;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import is.codion.swing.framework.ui.icon.FrameworkIkon;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import javax.swing.ImageIcon;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.swing.FontIcon;

public final class DefaultFrameworkIcons
implements FrameworkIcons {
    private static final FontImageIcon.IconPainter LOGO_ICON_PAINTER = new FontImageIcon.IconPainter(){

        public void paintIcon(FontIcon fontIcon, ImageIcon imageIcon) {
            int yOffset = (fontIcon.getIconHeight() - fontIcon.getIconWidth()) / 2;
            fontIcon.paintIcon(null, imageIcon.getImage().getGraphics(), 0, -yOffset);
        }
    };
    private static final FontImageIcon.ImageIconFactory LOGO_ICON_FACTORY = new FontImageIcon.ImageIconFactory(){

        public ImageIcon createImageIcon(FontIcon fontIcon) {
            int yCorrection = fontIcon.getIconHeight() - fontIcon.getIconWidth();
            return new ImageIcon(new BufferedImage(fontIcon.getIconWidth(), fontIcon.getIconHeight() - yCorrection, 2));
        }
    };
    private static FrameworkIcons instance;
    private final Icons icons = Icons.icons();
    private final Map<Integer, FontImageIcon> logos = new HashMap<Integer, FontImageIcon>();
    private final ImageIcon refreshRequired = FontImageIcon.builder((Ikon)FrameworkIkon.REFRESH).color(Color.RED.darker()).build().imageIcon();

    public DefaultFrameworkIcons() {
        this.add(FrameworkIkon.LOGO, FrameworkIkon.FILTER, FrameworkIkon.SEARCH, FrameworkIkon.ADD, FrameworkIkon.DELETE, FrameworkIkon.UPDATE, FrameworkIkon.COPY, FrameworkIkon.REFRESH, FrameworkIkon.CLEAR, FrameworkIkon.UP, FrameworkIkon.DOWN, FrameworkIkon.DETAIL, FrameworkIkon.PRINT, FrameworkIkon.EDIT, FrameworkIkon.SUMMARY, FrameworkIkon.EDIT_PANEL, FrameworkIkon.DEPENDENCIES, FrameworkIkon.SETTINGS, FrameworkIkon.CALENDAR, FrameworkIkon.EDIT_TEXT, FrameworkIkon.COLUMNS);
    }

    public void add(Ikon ... ikons) {
        this.icons.add(ikons);
    }

    public ImageIcon icon(Ikon ikon) {
        return this.icons.icon(ikon);
    }

    @Override
    public ImageIcon filter() {
        return this.icon(FrameworkIkon.FILTER);
    }

    @Override
    public ImageIcon search() {
        return this.icon(FrameworkIkon.SEARCH);
    }

    @Override
    public ImageIcon add() {
        return this.icon(FrameworkIkon.ADD);
    }

    @Override
    public ImageIcon delete() {
        return this.icon(FrameworkIkon.DELETE);
    }

    @Override
    public ImageIcon update() {
        return this.icon(FrameworkIkon.UPDATE);
    }

    @Override
    public ImageIcon copy() {
        return this.icon(FrameworkIkon.COPY);
    }

    @Override
    public ImageIcon refresh() {
        return this.icon(FrameworkIkon.REFRESH);
    }

    @Override
    public ImageIcon refreshRequired() {
        return this.refreshRequired;
    }

    @Override
    public ImageIcon clear() {
        return this.icon(FrameworkIkon.CLEAR);
    }

    @Override
    public ImageIcon up() {
        return this.icon(FrameworkIkon.UP);
    }

    @Override
    public ImageIcon down() {
        return this.icon(FrameworkIkon.DOWN);
    }

    @Override
    public ImageIcon detail() {
        return this.icon(FrameworkIkon.DETAIL);
    }

    @Override
    public ImageIcon print() {
        return this.icon(FrameworkIkon.PRINT);
    }

    @Override
    public ImageIcon clearSelection() {
        return this.icon(FrameworkIkon.CLEAR);
    }

    @Override
    public ImageIcon edit() {
        return this.icon(FrameworkIkon.EDIT);
    }

    @Override
    public ImageIcon summary() {
        return this.icon(FrameworkIkon.SUMMARY);
    }

    @Override
    public ImageIcon editPanel() {
        return this.icon(FrameworkIkon.EDIT_PANEL);
    }

    @Override
    public ImageIcon dependencies() {
        return this.icon(FrameworkIkon.DEPENDENCIES);
    }

    @Override
    public ImageIcon settings() {
        return this.icon(FrameworkIkon.SETTINGS);
    }

    @Override
    public ImageIcon calendar() {
        return this.icon(FrameworkIkon.CALENDAR);
    }

    @Override
    public ImageIcon editText() {
        return this.icon(FrameworkIkon.EDIT_TEXT);
    }

    @Override
    public ImageIcon columns() {
        return this.icon(FrameworkIkon.COLUMNS);
    }

    @Override
    public ImageIcon logo() {
        return this.icon(FrameworkIkon.LOGO);
    }

    @Override
    public ImageIcon logo(int size) {
        return this.logos.computeIfAbsent(size, k -> FontImageIcon.builder((Ikon)FrameworkIkon.LOGO).size(size).iconPainter(LOGO_ICON_PAINTER).imageIconFactory(LOGO_ICON_FACTORY).build()).imageIcon();
    }

    public void iconColor(Color color) {
        this.icons.iconColor(color);
    }

    public FrameworkIcons enableIconColorConsumer() {
        this.icons.enableIconColorConsumer();
        return this;
    }

    public FrameworkIcons disableIconColorConsumer() {
        this.icons.disableIconColorConsumer();
        return this;
    }

    static FrameworkIcons instance() {
        if (instance == null) {
            instance = (FrameworkIcons)DefaultFrameworkIcons.createInstance().enableIconColorConsumer();
        }
        return instance;
    }

    private static FrameworkIcons createInstance() {
        String iconsClassName = (String)FRAMEWORK_ICONS_CLASSNAME.get();
        try {
            return StreamSupport.stream(ServiceLoader.load(FrameworkIcons.class).spliterator(), false).filter(icons -> icons.getClass().getName().equals(iconsClassName)).findFirst().orElseThrow(() -> new IllegalArgumentException("FrameworkIcons implementation " + iconsClassName + " not found"));
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

