/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Text;
import is.codion.common.model.UserPreferences;
import is.codion.common.user.User;
import java.awt.Dimension;
import org.json.JSONObject;

final class ApplicationPreferences {
    private static final String LEGACY_DEFAULT_USERNAME_PROPERTY = "is.codion.swing.framework.ui.defaultUsername";
    private static final String LEGACY_LOOK_AND_FEEL_PROPERTY = "is.codion.swing.framework.ui.LookAndFeel";
    private static final String LEGACY_FONT_SIZE_PROPERTY = "is.codion.swing.framework.ui.FontSize";
    private static final String LEGACY_FRAME_SIZE_PROPERTY = "is.codion.swing.framework.ui.frameSize";
    private static final String LEGACY_FRAME_MAXIMIZED_PROPERTY = "is.codion.swing.framework.ui.maximized";
    private static final String PREFERENCES_KEY = "#preferences";
    private static final String DEFAULT_USERNAME_KEY = "defaultUsername";
    private static final String LOOK_AND_FEEL_KEY = "lookAndFeel";
    private static final String FONT_SIZE_KEY = "fontSize";
    private static final String FRAME_SIZE_KEY = "frameSize";
    private static final String FRAME_MAXIMIZED_KEY = "maximized";
    private final String defaultUsername;
    private final String lookAndFeel;
    private final int fontSize;
    private final Dimension frameSize;
    private final boolean frameMaximized;

    ApplicationPreferences(String defaultUsername, String lookAndFeel, int fontSize, Dimension frameSize, boolean frameMaximized) {
        this.defaultUsername = defaultUsername;
        this.lookAndFeel = lookAndFeel;
        this.fontSize = fontSize;
        this.frameSize = frameSize;
        this.frameMaximized = frameMaximized;
    }

    String defaultUsername() {
        return this.defaultUsername;
    }

    String lookAndFeel() {
        return this.lookAndFeel;
    }

    int fontSize() {
        return this.fontSize;
    }

    Dimension frameSize() {
        return this.frameSize;
    }

    boolean frameMaximized() {
        return this.frameMaximized;
    }

    void save(Class<?> applicationClassName) {
        UserPreferences.setUserPreference((String)(applicationClassName.getName() + PREFERENCES_KEY), (String)this.toJSONObject().toString());
    }

    User defaultLoginUser() {
        return this.defaultUsername == null || this.defaultUsername.isEmpty() ? null : User.user((String)this.defaultUsername);
    }

    private JSONObject toJSONObject() {
        JSONObject preferences = new JSONObject();
        preferences.put(DEFAULT_USERNAME_KEY, (Object)this.defaultUsername);
        preferences.put(LOOK_AND_FEEL_KEY, (Object)this.lookAndFeel);
        preferences.put(FONT_SIZE_KEY, this.fontSize);
        preferences.put(FRAME_SIZE_KEY, (Object)(this.frameSize.width + "x" + this.frameSize.height));
        preferences.put(FRAME_MAXIMIZED_KEY, this.frameMaximized);
        return preferences;
    }

    static ApplicationPreferences load(Class<?> applicationClass) {
        String preferences = UserPreferences.getUserPreference((String)(applicationClass.getName() + PREFERENCES_KEY), (String)"");
        if (preferences.isEmpty()) {
            String applicationDefaultUsernameProperty = "is.codion.swing.framework.ui.defaultUsername#" + applicationClass.getSimpleName();
            String applicationLookAndFeelProperty = "is.codion.swing.framework.ui.LookAndFeel#" + applicationClass.getSimpleName();
            String applicationFontSizeProperty = "is.codion.swing.framework.ui.FontSize#" + applicationClass.getSimpleName();
            String applicationFrameSizeProperty = "is.codion.swing.framework.ui.frameSize#" + applicationClass.getSimpleName();
            String applicationFrameMaximizedProperty = "is.codion.swing.framework.ui.maximized#" + applicationClass.getSimpleName();
            return new ApplicationPreferences(UserPreferences.getUserPreference((String)applicationDefaultUsernameProperty, (String)System.getProperty("user.name")), UserPreferences.getUserPreference((String)applicationLookAndFeelProperty, null), Integer.parseInt(UserPreferences.getUserPreference((String)applicationFontSizeProperty, (String)"100")), ApplicationPreferences.parseFrameSize(UserPreferences.getUserPreference((String)applicationFrameSizeProperty, (String)"")), Boolean.parseBoolean(UserPreferences.getUserPreference((String)applicationFrameMaximizedProperty, (String)"false")));
        }
        return ApplicationPreferences.fromString(preferences);
    }

    private static ApplicationPreferences fromString(String preferences) {
        JSONObject jsonObject = new JSONObject(preferences);
        return new ApplicationPreferences(jsonObject.has(DEFAULT_USERNAME_KEY) ? jsonObject.getString(DEFAULT_USERNAME_KEY) : null, jsonObject.has(LOOK_AND_FEEL_KEY) ? jsonObject.getString(LOOK_AND_FEEL_KEY) : null, jsonObject.has(FONT_SIZE_KEY) ? jsonObject.getInt(FONT_SIZE_KEY) : 100, jsonObject.has(FRAME_SIZE_KEY) ? ApplicationPreferences.parseFrameSize(jsonObject.getString(FRAME_SIZE_KEY)) : null, jsonObject.has(FONT_SIZE_KEY) && jsonObject.getBoolean(FRAME_MAXIMIZED_KEY));
    }

    private static Dimension parseFrameSize(String userPreference) {
        if (Text.nullOrEmpty((String)userPreference)) {
            return null;
        }
        String[] split = userPreference.split("x");
        return new Dimension(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
    }
}

