/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.swing.common.ui.component.table.FilterTableCellEditor;
import is.codion.swing.common.ui.component.table.FilterTableCellEditorFactory;
import is.codion.swing.common.ui.component.table.FilterTableColumn;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.ui.component.DefaultEntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponentFactory;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.table.TableCellEditor;

public class EntityTableCellEditorFactory
implements FilterTableCellEditorFactory<Attribute<?>> {
    private final SwingEntityEditModel editModel;
    private final EntityComponentFactory<Object, Attribute<Object>, JComponent> componentFactory = new DefaultEntityComponentFactory<Object, Attribute<Object>, JComponent>();

    public EntityTableCellEditorFactory(SwingEntityEditModel editModel) {
        this.editModel = Objects.requireNonNull(editModel);
    }

    public Optional<TableCellEditor> tableCellEditor(FilterTableColumn<Attribute<?>> column) {
        if (this.nonUpdatableForeignKey((Attribute)column.identifier())) {
            return Optional.empty();
        }
        return Optional.of(FilterTableCellEditor.filterTableCellEditor(() -> this.componentFactory.componentValue((Attribute<Object>)((Attribute)column.identifier()), this.editModel, null)));
    }

    private boolean nonUpdatableForeignKey(Attribute<?> attribute) {
        if (attribute instanceof ForeignKey) {
            ForeignKey foreignKey = (ForeignKey)attribute;
            return foreignKey.references().stream().map(ForeignKey.Reference::column).map(referenceAttribute -> this.editModel.entityDefinition().columns().definition(referenceAttribute)).filter(ColumnDefinition.class::isInstance).map(ColumnDefinition.class::cast).noneMatch(ColumnDefinition::updatable);
        }
        return false;
    }
}

