/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.ui.Colors;
import is.codion.swing.common.ui.component.table.DefaultFilterTableCellRendererBuilder;
import is.codion.swing.common.ui.component.table.FilterTableCellRenderer;
import is.codion.swing.framework.model.SwingEntityTableModel;
import java.awt.Color;
import java.util.Objects;
import java.util.function.Function;

final class EntityTableCellRendererBuilder
extends DefaultFilterTableCellRendererBuilder<Entity, Attribute<?>> {
    EntityTableCellRendererBuilder(SwingEntityTableModel tableModel, Attribute<?> attribute) {
        this(Objects.requireNonNull(tableModel), tableModel.entityDefinition().attributes().definition(attribute));
    }

    private EntityTableCellRendererBuilder(SwingEntityTableModel tableModel, AttributeDefinition<?> attributeDefinition) {
        super((FilterTableModel)Objects.requireNonNull(tableModel), (Object)Objects.requireNonNull(attributeDefinition).attribute(), attributeDefinition.attribute().type().valueClass(), attributeDefinition.attribute().type().isBoolean() && attributeDefinition.items().isEmpty());
        tableModel.entityDefinition().attributes().definition(attributeDefinition.attribute());
        this.string(new DefaultString(attributeDefinition));
        this.cellColors(new EntityCellColors(tableModel));
    }

    protected FilterTableCellRenderer.Settings<Attribute<?>> settings(int leftPadding, int rightPadding, boolean alternateRowColoring) {
        return new EntitySettings(leftPadding, rightPadding, alternateRowColoring);
    }

    private static final class DefaultString
    implements Function<Object, String> {
        private final AttributeDefinition<Object> definition;

        private DefaultString(AttributeDefinition<?> attributeDefinition) {
            this.definition = attributeDefinition;
        }

        @Override
        public String apply(Object value) {
            return this.definition.string(value);
        }
    }

    private static final class EntityCellColors
    implements FilterTableCellRenderer.CellColors<Attribute<?>> {
        private final SwingEntityTableModel tableModel;

        private EntityCellColors(SwingEntityTableModel tableModel) {
            this.tableModel = tableModel;
        }

        public Color backgroundColor(int row, Attribute<?> identifier, Object cellValue, boolean selected) {
            return this.tableModel.backgroundColor(row, identifier);
        }

        public Color foregroundColor(int row, Attribute<?> identifier, Object cellValue, boolean selected) {
            return this.tableModel.foregroundColor(row, identifier);
        }
    }

    private static final class EntitySettings
    extends FilterTableCellRenderer.Settings<Attribute<?>> {
        private Color backgroundColorDoubleShade;
        private Color backgroundColorAlternateDoubleShade;

        private EntitySettings(int leftPadding, int rightPadding, boolean alternateRoColoring) {
            super(leftPadding, rightPadding, alternateRoColoring);
        }

        protected void updateColors() {
            super.updateColors();
            this.backgroundColorDoubleShade = Colors.darker((Color)this.backgroundColor(), (double)0.8);
            this.backgroundColorAlternateDoubleShade = Colors.darker((Color)this.backgroundColorAlternate(), (double)0.8);
        }

        protected Color backgroundColorShaded(FilterTableModel<?, Attribute<?>> tableModel, int row, Attribute<?> identifier, Color cellBackgroundColor) {
            boolean showCondition;
            boolean conditionEnabled = ((SwingEntityTableModel)tableModel).conditionModel().enabled(identifier);
            boolean filterEnabled = tableModel.filterModel().enabled(identifier);
            boolean bl = showCondition = conditionEnabled || filterEnabled;
            if (showCondition) {
                return this.backgroundColorShaded(row, conditionEnabled && filterEnabled, cellBackgroundColor);
            }
            return cellBackgroundColor;
        }

        private Color backgroundColorShaded(int row, boolean doubleShading, Color cellBackgroundColor) {
            if (cellBackgroundColor != null) {
                return Colors.darker((Color)cellBackgroundColor, (double)0.9);
            }
            return this.alternateRowColor(row) ? (doubleShading ? this.backgroundColorDoubleShade : this.backgroundColorShaded()) : (doubleShading ? this.backgroundColorAlternateDoubleShade : this.backgroundColorAlternateShaded());
        }
    }
}

