/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.common.resource.MessageBundle;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.model.EntitySearchModel;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ButtonPanelBuilder;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import is.codion.swing.framework.ui.EntityDialogs;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.component.EntityComboBox;
import is.codion.swing.framework.ui.component.EntitySearchField;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

final class EntityControls {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(EntityControls.class, (ResourceBundle)ResourceBundle.getBundle(EntityControls.class.getName()));
    private static final FrameworkIcons ICONS = FrameworkIcons.instance();

    private EntityControls() {
    }

    static CommandControl createAddControl(EntityComboBox comboBox, Supplier<EntityEditPanel> editPanel, KeyStroke keyStroke, boolean confirm) {
        return EntityControls.createAddControl(() -> ((EntityDialogs.AddEntityDialogBuilder)EntityDialogs.addEntityDialog(editPanel).owner(comboBox)).confirm(confirm).onInsert(new EntityComboBoxOnInsert(comboBox.getModel())).show(), comboBox, keyStroke);
    }

    static CommandControl createAddControl(EntitySearchField searchField, Supplier<EntityEditPanel> editPanel, KeyStroke keyStroke, boolean confirm) {
        return EntityControls.createAddControl(() -> ((EntityDialogs.AddEntityDialogBuilder)EntityDialogs.addEntityDialog(editPanel).owner((Component)((Object)searchField))).confirm(confirm).onInsert(new EntitySearchFieldOnInsert(searchField.model())).show(), (JComponent)((Object)searchField), keyStroke);
    }

    static CommandControl createEditControl(EntityComboBox comboBox, Supplier<EntityEditPanel> editPanel, KeyStroke keyStroke, boolean confirm) {
        return EntityControls.createEditControl(() -> ((EntityDialogs.EditEntityDialogBuilder)EntityDialogs.editEntityDialog(editPanel).owner(comboBox)).confirm(confirm).entity(() -> comboBox.getModel().selectedValue()).onUpdate(new EntityComboBoxOnUpdate(comboBox.getModel())).show(), comboBox, comboBox.getModel().selectionEmpty().not(), keyStroke);
    }

    static CommandControl createEditControl(EntitySearchField searchField, Supplier<EntityEditPanel> editPanel, KeyStroke keyStroke, boolean confirm) {
        return EntityControls.createEditControl(() -> ((EntityDialogs.EditEntityDialogBuilder)EntityDialogs.editEntityDialog(editPanel).owner((Component)((Object)searchField))).confirm(confirm).entity(() -> (Entity)searchField.model().entity().get()).onUpdate(new EntitySearchFieldOnUpdate(searchField.model())).show(), (JComponent)((Object)searchField), searchField.model().selectionEmpty().not(), keyStroke);
    }

    static String validateButtonLocation(String buttonLocation) {
        Objects.requireNonNull(buttonLocation);
        if (!buttonLocation.equals("West") && !buttonLocation.equals("East")) {
            throw new IllegalArgumentException("Button location must be BorderLayout.WEST or BorderLayout.EAST");
        }
        return buttonLocation;
    }

    static JComponent createButtonPanel(JComponent centerComponent, boolean buttonFocusable, String borderLayoutConstraints, List<AbstractButton> buttons, Action ... buttonActions) {
        if (buttonActions.length == 0) {
            return centerComponent;
        }
        Dimension preferredSize = centerComponent.getPreferredSize();
        return Components.panel((LayoutManager)new BorderLayout()).add(centerComponent, (Object)"Center").add(((ButtonPanelBuilder)((ButtonPanelBuilder)((ButtonPanelBuilder)Components.buttonPanel((Action[])buttonActions).buttonsFocusable(buttonFocusable)).preferredButtonSize(new Dimension(preferredSize.height, preferredSize.height))).buttonGap(0).buttonBuilder(buttonBuilder -> buttonBuilder.onBuild(buttons::add))).build(), (Object)borderLayoutConstraints).build();
    }

    static String defaultButtonLocation() {
        return ComponentOrientation.getOrientation(Locale.getDefault()) == ComponentOrientation.LEFT_TO_RIGHT ? "East" : "West";
    }

    private static CommandControl createAddControl(Control.Command addEntityCommand, JComponent component, KeyStroke keyStroke) {
        CommandControl control = (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(addEntityCommand).smallIcon((Icon)ICONS.add())).description(MESSAGES.getString("add_new"))).enabled((StateObserver)EntityControls.createComponentEnabledState(component))).build();
        if (keyStroke != null) {
            KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{component});
        }
        return control;
    }

    private static CommandControl createEditControl(Control.Command editEntityCommand, JComponent component, StateObserver selectionNonEmptyState, KeyStroke keyStroke) {
        CommandControl control = (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(editEntityCommand).smallIcon((Icon)ICONS.edit())).description(MESSAGES.getString("edit_selected"))).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{EntityControls.createComponentEnabledState(component), selectionNonEmptyState}))).build();
        if (keyStroke != null) {
            KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{component});
        }
        return control;
    }

    private static State createComponentEnabledState(JComponent component) {
        State componentEnabledState = State.state((boolean)component.isEnabled());
        component.addPropertyChangeListener("enabled", changeEvent -> componentEnabledState.set((Object)((Boolean)changeEvent.getNewValue())));
        return componentEnabledState;
    }

    private static final class EntitySearchFieldOnUpdate
    implements Consumer<Entity> {
        private final EntitySearchModel searchModel;

        private EntitySearchFieldOnUpdate(EntitySearchModel searchModel) {
            this.searchModel = searchModel;
        }

        @Override
        public void accept(Entity updated) {
            this.searchModel.entity().set((Object)updated);
        }
    }

    private static final class EntityComboBoxOnUpdate
    implements Consumer<Entity> {
        private final EntityComboBoxModel comboBoxModel;

        private EntityComboBoxOnUpdate(EntityComboBoxModel comboBoxModel) {
            this.comboBoxModel = comboBoxModel;
        }

        @Override
        public void accept(Entity updated) {
            this.comboBoxModel.replace(this.comboBoxModel.selectedValue(), updated);
            this.comboBoxModel.setSelectedItem((Object)updated);
        }
    }

    private static class EntitySearchFieldOnInsert
    implements Consumer<Entity> {
        private final EntitySearchModel searchModel;

        private EntitySearchFieldOnInsert(EntitySearchModel searchModel) {
            this.searchModel = searchModel;
        }

        @Override
        public void accept(Entity inserted) {
            this.searchModel.entity().set((Object)inserted);
        }
    }

    private static class EntityComboBoxOnInsert
    implements Consumer<Entity> {
        private final EntityComboBoxModel comboBoxModel;

        private EntityComboBoxOnInsert(EntityComboBoxModel comboBoxModel) {
            this.comboBoxModel = comboBoxModel;
        }

        @Override
        public void accept(Entity inserted) {
            this.comboBoxModel.add(inserted);
            this.comboBoxModel.setSelectedItem((Object)inserted);
        }
    }
}

