/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.generator.model;

import is.codion.common.Configuration;
import is.codion.common.Text;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.tools.generator.domain.DatabaseDomain;
import is.codion.tools.generator.domain.DomainSource;
import is.codion.tools.generator.model.EntityRow;
import is.codion.tools.generator.model.SchemaRow;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class DomainGeneratorModel {
    public static final PropertyValue<String> DEFAULT_DOMAIN_PACKAGE = Configuration.stringValue((String)"codion.domain.generator.defaultDomainPackage", (String)"");
    public static final PropertyValue<String> DEFAULT_SOURCE_DIRECTORY = Configuration.stringValue((String)"codion.domain.generator.defaultSourceDirectory", (String)System.getProperty("user.dir"));
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^[A-Za-z_][A-Za-z0-9_]*(?:\\.[A-Za-z_][A-Za-z0-9_]*)*$");
    private final FilterTableModel<SchemaRow, SchemaColumns.Id> schemaTableModel = FilterTableModel.builder((FilterTableModel.Columns)new SchemaColumns()).items((Supplier)new SchemaItems()).build();
    private final State populatedSchemaSelected = State.state();
    private final FilterTableModel<EntityRow, EntityColumns.Id> entityTableModel = FilterTableModel.builder((FilterTableModel.Columns)new EntityColumns()).items((Supplier)new EntityItems()).build();
    private final Connection connection;
    private final State domainPackageSpecified = State.state();
    private final Value<String> domainPackageValue = Value.nonNull((Object)((String)DEFAULT_DOMAIN_PACKAGE.get())).listener(this::domainPackageChanged).build();
    private final State sourceDirectorySpecified = State.state();
    private final Value<String> sourceDirectoryValue = Value.nonNull((Object)((String)DEFAULT_SOURCE_DIRECTORY.get())).listener(this::sourceDirectoryChanged).build();
    private final Value<String> domainImplValue = Value.nullable().notify(Value.Notify.WHEN_SET).build();
    private final Value<String> domainApiValue = Value.nullable().notify(Value.Notify.WHEN_SET).build();
    private final Value<String> domainCombinedValue = Value.nullable().notify(Value.Notify.WHEN_SET).build();
    private final Value<String> apiSearchValue = Value.value();
    private final Value<String> implSearchValue = Value.value();

    private DomainGeneratorModel(Database database, User user) throws DatabaseException {
        this.connection = Objects.requireNonNull(database, "database").createConnection(user);
        this.sourceDirectoryChanged();
        this.domainPackageChanged();
        this.schemaTableModel.refresh();
        this.bindEvents();
    }

    public FilterTableModel<SchemaRow, SchemaColumns.Id> schemaModel() {
        return this.schemaTableModel;
    }

    public FilterTableModel<EntityRow, EntityColumns.Id> entityModel() {
        return this.entityTableModel;
    }

    public ValueObserver<String> domainImpl() {
        return this.domainImplValue.observer();
    }

    public ValueObserver<String> domainApi() {
        return this.domainApiValue.observer();
    }

    public ValueObserver<String> domainCombined() {
        return this.domainCombinedValue.observer();
    }

    public Value<String> domainPackage() {
        return this.domainPackageValue;
    }

    public Value<String> sourceDirectory() {
        return this.sourceDirectoryValue;
    }

    public Value<String> apiSearchValue() {
        return this.apiSearchValue;
    }

    public Value<String> implSearchValue() {
        return this.implSearchValue;
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void populateSelected(Consumer<String> schemaNotifier) {
        this.schemaTableModel.selectionModel().selectedItem().ifPresent(schema -> {
            schemaNotifier.accept(schema.name());
            schema.setDomain(DatabaseDomain.databaseDomain((Connection)this.connection, (String)schema.name()));
            int index = this.schemaTableModel.indexOf(schema);
            this.schemaTableModel.fireTableRowsUpdated(index, index);
        });
        this.schemaSelectionChanged();
    }

    public void saveApiImpl() throws IOException {
        DatabaseDomain domain;
        if (((Boolean)this.schemaTableModel.selectionModel().selectionNotEmpty().get()).booleanValue() && (domain = this.selectedDomain()) != null) {
            DomainSource.domainSource((DatabaseDomain)domain, (String)this.domainPackageValue.optional().filter(DomainGeneratorModel::validPackageName).orElse("")).writeApiImpl(this.savePath(new File((String)this.sourceDirectoryValue.get())));
        }
    }

    public void saveCombined() throws IOException {
        DatabaseDomain domain;
        if (((Boolean)this.schemaTableModel.selectionModel().selectionNotEmpty().get()).booleanValue() && (domain = this.selectedDomain()) != null) {
            DomainSource.domainSource((DatabaseDomain)domain, (String)this.domainPackageValue.optional().filter(DomainGeneratorModel::validPackageName).orElse("")).writeCombined(this.savePath(new File((String)this.sourceDirectoryValue.get())));
        }
    }

    public StateObserver saveEnabled() {
        return State.and((StateObserver[])new StateObserver[]{this.domainPackageSpecified, this.sourceDirectorySpecified, this.populatedSchemaSelected});
    }

    private void bindEvents() {
        this.schemaTableModel.selectionModel().selectionEvent().addListener(this::schemaSelectionChanged);
        this.entityModel().selectionModel().selectedItemEvent().addConsumer(this::search);
    }

    private void schemaSelectionChanged() {
        this.entityTableModel.refresh();
        this.updateDomainSource();
        this.populatedSchemaSelected.set((Object)this.schemaTableModel.selectionModel().selectedItem().map(SchemaRow::populated).orElse(false));
    }

    private void search(EntityRow entityRow) {
        this.apiSearchValue.set(entityRow == null ? null : DomainSource.apiSearchString((EntityDefinition)entityRow.definition));
        this.implSearchValue.set(entityRow == null ? null : DomainSource.implSearchString((EntityDefinition)entityRow.definition));
    }

    public static DomainGeneratorModel domainGeneratorModel(Database database, User user) throws DatabaseException {
        return new DomainGeneratorModel(database, user);
    }

    private void sourceDirectoryChanged() {
        this.sourceDirectorySpecified.set((Object)Objects.nonNull(this.sourceDirectoryValue.get()));
    }

    private void domainPackageChanged() {
        this.domainPackageSpecified.set((Object)(!Text.nullOrEmpty((String)((String)this.domainPackageValue.get())) ? 1 : 0));
        this.updateDomainSource();
    }

    private void updateDomainSource() {
        DatabaseDomain selectedDomain = this.selectedDomain();
        if (selectedDomain != null) {
            DomainSource domainSource = DomainSource.domainSource((DatabaseDomain)selectedDomain, (String)this.domainPackageValue.optional().filter(DomainGeneratorModel::validPackageName).orElse(""));
            this.domainApiValue.set((Object)domainSource.api());
            this.domainImplValue.set((Object)domainSource.implementation());
            this.domainCombinedValue.set((Object)domainSource.combined());
        } else {
            this.domainApiValue.set(null);
            this.domainImplValue.set(null);
            this.domainCombinedValue.set(null);
        }
    }

    private DatabaseDomain selectedDomain() {
        return this.schemaTableModel.selectionModel().selectedItem().map(SchemaRow::domain).filter(Optional::isPresent).map(Optional::get).orElse(null);
    }

    private Path savePath(File directory) {
        Path path = directory.toPath();
        String domainPackage = (String)this.domainPackageValue.get();
        if (domainPackage != null) {
            for (String pkg : domainPackage.split("\\.")) {
                path = path.resolve(pkg);
            }
        }
        return path;
    }

    private static boolean validPackageName(String packageName) {
        return PACKAGE_PATTERN.matcher(packageName).matches();
    }

    public static final class SchemaColumns
    implements FilterTableModel.Columns<SchemaRow, Id> {
        private static final List<Id> IDENTIFIERS = Collections.unmodifiableList(Arrays.asList(Id.values()));

        public List<Id> identifiers() {
            return IDENTIFIERS;
        }

        public Class<?> columnClass(Id identifier) {
            if (identifier == Id.POPULATED) {
                return Boolean.class;
            }
            return String.class;
        }

        public Object value(SchemaRow row, Id identifier) {
            switch (identifier) {
                case CATALOG: {
                    return row.catalog();
                }
                case SCHEMA: {
                    return row.name();
                }
                case POPULATED: {
                    return row.populated();
                }
            }
            throw new IllegalArgumentException("Unknown column: " + identifier);
        }

        public static enum Id {
            CATALOG,
            SCHEMA,
            POPULATED;

        }
    }

    private final class SchemaItems
    implements Supplier<Collection<SchemaRow>> {
        private SchemaItems() {
        }

        @Override
        public Collection<SchemaRow> get() {
            ArrayList<SchemaRow> arrayList;
            block9: {
                ArrayList<SchemaRow> schemaRows = new ArrayList<SchemaRow>();
                ResultSet resultSet = DomainGeneratorModel.this.connection.getMetaData().getSchemas();
                try {
                    while (resultSet.next()) {
                        String tableSchem = resultSet.getString("TABLE_SCHEM");
                        if (tableSchem == null) continue;
                        schemaRows.add(new SchemaRow(resultSet.getString("TABLE_CATALOG"), tableSchem));
                    }
                    arrayList = schemaRows;
                    if (resultSet == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                resultSet.close();
            }
            return arrayList;
        }
    }

    public static final class EntityColumns
    implements FilterTableModel.Columns<EntityRow, Id> {
        private static final List<Id> IDENTIFIERS = Collections.unmodifiableList(Arrays.asList(Id.values()));

        public List<Id> identifiers() {
            return IDENTIFIERS;
        }

        public Class<?> columnClass(Id identifier) {
            return String.class;
        }

        public Object value(EntityRow row, Id identifier) {
            switch (identifier) {
                case ENTITY: {
                    return row.definition.entityType().name();
                }
                case TABLE_TYPE: {
                    return row.tableType;
                }
            }
            throw new IllegalArgumentException("Unknown column: " + identifier);
        }

        public static enum Id {
            ENTITY,
            TABLE_TYPE;

        }
    }

    private final class EntityItems
    implements Supplier<Collection<EntityRow>> {
        private EntityItems() {
        }

        @Override
        public Collection<EntityRow> get() {
            return DomainGeneratorModel.this.schemaTableModel.selectionModel().getSelectedItems().stream().map(SchemaRow::domain).filter(Optional::isPresent).map(Optional::get).flatMap(domain -> domain.entities().definitions().stream().map(definition -> new EntityRow((EntityDefinition)definition, domain.tableType(definition.entityType())))).collect(Collectors.toList());
        }
    }
}

