/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.generator.ui;

import com.formdev.flatlaf.intellijthemes.FlatAllIJThemes;
import is.codion.common.Configuration;
import is.codion.common.db.database.Database;
import is.codion.common.i18n.Messages;
import is.codion.common.model.CancelException;
import is.codion.common.model.UserPreferences;
import is.codion.common.property.PropertyValue;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.table.FilterTable;
import is.codion.swing.common.ui.component.table.FilterTableColumn;
import is.codion.swing.common.ui.component.text.SearchHighlighter;
import is.codion.swing.common.ui.component.text.TextAreaBuilder;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.LoginDialogBuilder;
import is.codion.swing.common.ui.dialog.ProgressWorkerDialogBuilder;
import is.codion.swing.common.ui.icon.Logos;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.laf.LookAndFeelProvider;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.tools.generator.model.DomainGeneratorModel;
import is.codion.tools.generator.model.EntityRow;
import is.codion.tools.generator.model.SchemaRow;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public final class DomainGeneratorPanel
extends JPanel {
    public static final PropertyValue<String> DEFAULT_USER = Configuration.stringValue((String)"codion.domain.generator.defaultUser");
    private static final String DEFAULT_FLAT_LOOK_AND_FEEL = "com.formdev.flatlaf.intellijthemes.FlatMaterialDesignDarkIJTheme";
    private static final double RESIZE_WEIGHT = 0.2;
    private final DomainGeneratorModel model;
    private final FilterTable<SchemaRow, DomainGeneratorModel.SchemaColumns.Id> schemaTable;
    private final FilterTable<EntityRow, DomainGeneratorModel.EntityColumns.Id> entityTable;
    private final JTextArea apiTextArea;
    private final JTextArea implementationTextArea;
    private final JTextArea combinedTextArea;
    private final JTabbedPane sourceTabbedPane;
    private final SearchHighlighter apiHighlighter;
    private final SearchHighlighter implementationHighlighter;
    private final SearchHighlighter combinedHighlighter;

    DomainGeneratorPanel(DomainGeneratorModel model) {
        this.model = Objects.requireNonNull(model);
        this.schemaTable = this.createSchemaTable();
        this.entityTable = this.createEntityTable();
        this.apiTextArea = DomainGeneratorPanel.createSourceTextArea((ValueObserver<String>)model.domainApi());
        this.implementationTextArea = DomainGeneratorPanel.createSourceTextArea((ValueObserver<String>)model.domainImpl());
        this.combinedTextArea = DomainGeneratorPanel.createSourceTextArea((ValueObserver<String>)model.domainCombined());
        this.sourceTabbedPane = this.createSourceTabbedPane();
        this.apiHighlighter = DomainGeneratorPanel.searchHighlighter(this.apiTextArea);
        this.implementationHighlighter = DomainGeneratorPanel.searchHighlighter(this.implementationTextArea);
        this.combinedHighlighter = DomainGeneratorPanel.searchHighlighter(this.combinedTextArea);
        this.initializeUI();
        this.bindEvents();
        this.setupKeyEvents();
    }

    private void initializeUI() {
        JPanel schemaSourceDirPanel = (JPanel)Components.borderLayoutPanel().northComponent((JComponent)this.createSourceDirectoryPanel()).centerComponent(Components.borderLayoutPanel().centerComponent(Components.splitPane().orientation(0).resizeWeight(0.2).topComponent((JComponent)DomainGeneratorPanel.createScrollablePanel(this.schemaTable, "Schemas (Alt-1)")).bottomComponent((JComponent)DomainGeneratorPanel.createScrollablePanel(this.entityTable, "Entities (Alt-2)")).build()).build()).build();
        JPanel sourcePackagePanel = (JPanel)Components.borderLayoutPanel().northComponent((JComponent)this.createPackageSavePanel()).centerComponent((JComponent)this.sourceTabbedPane).build();
        JSplitPane splitPane = (JSplitPane)Components.splitPane().resizeWeight(0.2).leftComponent((JComponent)schemaSourceDirPanel).rightComponent((JComponent)sourcePackagePanel).build();
        this.setLayout(Layouts.borderLayout());
        this.add((Component)splitPane, "Center");
    }

    private FilterTable<SchemaRow, DomainGeneratorModel.SchemaColumns.Id> createSchemaTable() {
        Control populateSchemaControl = ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::populateSchema).name("Populate")).enabled(this.model.schemaModel().selectionModel().selectionNotEmpty())).build();
        return (FilterTable)((FilterTable.Builder)((FilterTable.Builder)((FilterTable.Builder)FilterTable.builder((FilterTableModel)this.model.schemaModel(), DomainGeneratorPanel.createSchemaColumns()).autoResizeMode(4).doubleClickAction((Action)populateSchemaControl).selectionMode(0).keyEvent(KeyEvents.builder((int)10).modifiers(128).action((Action)populateSchemaControl))).popupMenuControls(table -> (Controls)Controls.builder().control(populateSchemaControl).control((Control.Builder)((Controls.ControlsBuilder)Controls.builder().name("Columns")).control((Control)table.createToggleColumnsControls()).control((Control)table.createToggleAutoResizeModelControls())).build())).onBuild(table -> table.sortModel().setSortOrder((Object)DomainGeneratorModel.SchemaColumns.Id.SCHEMA, SortOrder.ASCENDING))).build();
    }

    private FilterTable<EntityRow, DomainGeneratorModel.EntityColumns.Id> createEntityTable() {
        return (FilterTable)((FilterTable.Builder)((FilterTable.Builder)FilterTable.builder((FilterTableModel)this.model.entityModel(), DomainGeneratorPanel.createEntityColumns()).autoResizeMode(4).popupMenuControl(FilterTable::createToggleAutoResizeModelControls)).onBuild(table -> table.sortModel().setSortOrder((Object)DomainGeneratorModel.EntityColumns.Id.ENTITY, SortOrder.ASCENDING))).build();
    }

    private JSplitPane createApiImplPanel() {
        return (JSplitPane)Components.splitPane().orientation(0).resizeWeight(0.5).topComponent(Components.borderLayoutPanel().centerComponent((JComponent)DomainGeneratorPanel.createScrollablePanel(this.apiTextArea, "API (Alt-3)")).southComponent((JComponent)DomainGeneratorPanel.createSearchCopyPanel(this.apiTextArea)).build()).bottomComponent(Components.borderLayoutPanel().centerComponent((JComponent)DomainGeneratorPanel.createScrollablePanel(this.implementationTextArea, "Implementation (Alt-4)")).southComponent((JComponent)DomainGeneratorPanel.createSearchCopyPanel(this.implementationTextArea)).build()).continuousLayout(true).oneTouchExpandable(true).build();
    }

    private JPanel createCombinedPanel() {
        return (JPanel)Components.borderLayoutPanel().centerComponent((JComponent)DomainGeneratorPanel.createScrollablePanel(this.combinedTextArea, "Combined (Alt-5)")).southComponent((JComponent)DomainGeneratorPanel.createSearchCopyPanel(this.combinedTextArea)).build();
    }

    private static JPanel createSearchCopyPanel(JTextArea textArea) {
        return (JPanel)Components.borderLayoutPanel().eastComponent(Components.button((Control)DomainGeneratorPanel.createCopyControl(textArea)).build()).build();
    }

    private static Control createCopyControl(JTextArea textArea) {
        return ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(() -> Utilities.setClipboard((String)textArea.getText())).name(Messages.copy())).mnemonic((int)Messages.copy().charAt(0))).build();
    }

    private static JTextArea createSourceTextArea(ValueObserver<String> sourceValue) {
        return (JTextArea)((TextAreaBuilder)((TextAreaBuilder)((TextAreaBuilder)((TextAreaBuilder)Components.textArea().link(sourceValue)).rowsColumns(40, 60).editable(false)).font(DomainGeneratorPanel.monospaceFont())).caretUpdatePolicy(1)).build();
    }

    private JTabbedPane createSourceTabbedPane() {
        return (JTabbedPane)Components.tabbedPane().tabBuilder("API/Impl", (JComponent)this.createApiImplPanel()).mnemonic(65).add().tabBuilder("Combined", (JComponent)this.createCombinedPanel()).mnemonic(67).add().build();
    }

    private static Font monospaceFont() {
        Font font = UIManager.getFont("TextArea.font");
        return new Font("Monospaced", font.getStyle(), font.getSize());
    }

    private JPanel createPackageSavePanel() {
        JLabel packageLabel = (JLabel)Components.label((String)"Package").displayedMnemonic('P').build();
        return (JPanel)Components.borderLayoutPanel().centerComponent(Components.gridLayoutPanel((int)2, (int)1).add((JComponent)packageLabel).add((JComponent)this.createPackageField(packageLabel)).build()).eastComponent(Components.gridLayoutPanel((int)2, (int)1).add(Components.label((String)" ").build()).add(Components.button((Control.Builder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::save).name("Save")).mnemonic(83)).enabled(this.model.saveEnabled())).build()).build()).build();
    }

    private JPanel createSourceDirectoryPanel() {
        JLabel sourceDirectoryLabel = (JLabel)Components.label((String)"Source directory").displayedMnemonic('D').build();
        Control selectSourceDirectoryControl = ((CommandControl.CommandControlBuilder)Control.builder().command(this::selectSourceDirectory).name("...")).build();
        return (JPanel)Components.borderLayoutPanel().centerComponent(Components.gridLayoutPanel((int)2, (int)1).add((JComponent)sourceDirectoryLabel).add((JComponent)this.createSourceDirectoryField(sourceDirectoryLabel, selectSourceDirectoryControl)).build()).eastComponent(Components.gridLayoutPanel((int)2, (int)1).add(Components.label((String)" ").build()).add(Components.button((Control)selectSourceDirectoryControl).build()).build()).build();
    }

    private JTextField createPackageField(JLabel packageLabel) {
        return (JTextField)((TextFieldBuilder)((TextFieldBuilder)Components.stringField((Value)this.model.domainPackage()).hint("(Alt-P)").onBuild(field -> KeyEvents.builder((int)80).condition(1).modifiers(512).action((Action)Control.commandControl(field::requestFocusInWindow)).enable(new JComponent[]{this}))).onBuild(packageLabel::setLabelFor)).build();
    }

    private JTextField createSourceDirectoryField(JLabel sourceDirectoryLabel, Control selectSourceDirectoryControl) {
        return (JTextField)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)Components.stringField((Value)this.model.sourceDirectory()).hint("(Alt-D / INSERT)").editable(false)).keyEvent(KeyEvents.builder((int)155).action((Action)selectSourceDirectoryControl))).onBuild(field -> KeyEvents.builder((int)68).condition(1).modifiers(512).action((Action)Control.commandControl(field::requestFocusInWindow)).enable(new JComponent[]{this}))).onBuild(sourceDirectoryLabel::setLabelFor)).build();
    }

    private void selectSourceDirectory() {
        this.model.sourceDirectory().set((Object)Dialogs.fileSelectionDialog().startDirectory((String)DomainGeneratorModel.DEFAULT_SOURCE_DIRECTORY.get()).selectDirectory().getAbsolutePath());
    }

    private void save() throws IOException {
        if (this.sourceTabbedPane.getSelectedIndex() == 0) {
            this.model.saveApiImpl();
        } else {
            this.model.saveCombined();
        }
        JOptionPane.showMessageDialog(this, "File(s) saved");
    }

    private static JPanel createScrollablePanel(JComponent component, String title) {
        return (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent(Components.scrollPane((JComponent)component).build()).border((Border)BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), DomainGeneratorPanel.createEmptyBorder()))).build();
    }

    private static Border createEmptyBorder() {
        return BorderFactory.createEmptyBorder((Integer)Layouts.GAP.get(), (Integer)Layouts.GAP.get(), (Integer)Layouts.GAP.get(), (Integer)Layouts.GAP.get());
    }

    public void showFrame() {
        Windows.frame((JComponent)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent((JComponent)this).border(DomainGeneratorPanel.createEmptyBorder())).build()).title("Codion Domain Generator").icon(Logos.logoTransparent()).menuBar(Components.menu((Controls)this.createMainMenuControls()).createMenuBar()).defaultCloseOperation(3).centerFrame(true).show();
    }

    private void populateSchema() {
        JLabel schemaLabel = new JLabel("Testing", 0);
        JPanel northPanel = (JPanel)Components.borderLayoutPanel().centerComponent((JComponent)schemaLabel).build();
        Consumer<String> schemaNotifier = schema -> SwingUtilities.invokeLater(() -> schemaLabel.setText((String)schema));
        ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> this.model.populateSelected(schemaNotifier)).owner((Component)this)).title("Populating")).northPanel(northPanel).onResult(() -> ((FilterTableModel)this.model.entityModel()).refresh()).execute();
    }

    private Controls createMainMenuControls() {
        return (Controls)Controls.builder().control((Control.Builder)((Controls.ControlsBuilder)((Controls.ControlsBuilder)Controls.builder().name("File")).mnemonic(70)).control(((CommandControl.CommandControlBuilder)Control.builder().command(() -> System.exit(0)).name("Exit")).mnemonic(88))).control((Control.Builder)((Controls.ControlsBuilder)((Controls.ControlsBuilder)Controls.builder().name("View")).mnemonic(86)).control(Dialogs.lookAndFeelSelectionDialog().owner((JComponent)this).createControl(DomainGeneratorPanel::lookAndFeelSelected))).build();
    }

    private void bindEvents() {
        this.model.domainApi().addListener(() -> this.apiTextArea.setCaretPosition(0));
        this.model.domainImpl().addListener(() -> this.implementationTextArea.setCaretPosition(0));
        this.model.domainCombined().addListener(() -> this.combinedTextArea.setCaretPosition(0));
        this.model.apiSearchValue().addConsumer(arg_0 -> ((Value)this.apiHighlighter.searchString()).set(arg_0));
        this.model.implSearchValue().addConsumer(arg_0 -> ((Value)this.implementationHighlighter.searchString()).set(arg_0));
        this.model.implSearchValue().addConsumer(arg_0 -> ((Value)this.combinedHighlighter.searchString()).set(arg_0));
    }

    private void setupKeyEvents() {
        KeyEvents.builder().modifiers(512).condition(1).keyCode(49).action((Action)Control.commandControl(() -> this.schemaTable.requestFocusInWindow())).enable(new JComponent[]{this}).keyCode(50).action((Action)Control.commandControl(() -> this.entityTable.requestFocusInWindow())).enable(new JComponent[]{this}).keyCode(51).action((Action)Control.commandControl(this.apiTextArea::requestFocusInWindow)).enable(new JComponent[]{this}).keyCode(52).action((Action)Control.commandControl(this.implementationTextArea::requestFocusInWindow)).enable(new JComponent[]{this}).keyCode(53).action((Action)Control.commandControl(this.combinedTextArea::requestFocusInWindow)).enable(new JComponent[]{this});
    }

    private static List<FilterTableColumn<DomainGeneratorModel.SchemaColumns.Id>> createSchemaColumns() {
        FilterTableColumn catalogColumn = FilterTableColumn.builder((Enum)DomainGeneratorModel.SchemaColumns.Id.CATALOG).headerValue((Object)"Catalog").build();
        FilterTableColumn schemaColumn = FilterTableColumn.builder((Enum)DomainGeneratorModel.SchemaColumns.Id.SCHEMA).headerValue((Object)"Schema").build();
        FilterTableColumn populatedColumn = FilterTableColumn.builder((Enum)DomainGeneratorModel.SchemaColumns.Id.POPULATED).headerValue((Object)"Populated").build();
        return Arrays.asList(catalogColumn, schemaColumn, populatedColumn);
    }

    private static List<FilterTableColumn<DomainGeneratorModel.EntityColumns.Id>> createEntityColumns() {
        FilterTableColumn entityTypeColumn = FilterTableColumn.builder((Enum)DomainGeneratorModel.EntityColumns.Id.ENTITY).headerValue((Object)"Entity").build();
        FilterTableColumn typeColumn = FilterTableColumn.builder((Enum)DomainGeneratorModel.EntityColumns.Id.TABLE_TYPE).headerValue((Object)"Type").preferredWidth(120).build();
        return Arrays.asList(entityTypeColumn, typeColumn);
    }

    private static SearchHighlighter searchHighlighter(JTextArea textArea) {
        return SearchHighlighter.builder((JTextComponent)textArea).scrollYRatio(0.2).scrollXRatio(0.5).build();
    }

    private static void lookAndFeelSelected(LookAndFeelProvider lookAndFeelProvider) {
        UserPreferences.setUserPreference((String)DomainGeneratorPanel.class.getName(), (String)lookAndFeelProvider.lookAndFeelInfo().getClassName());
    }

    public static void main(String[] arguments) {
        Arrays.stream(FlatAllIJThemes.INFOS).forEach(LookAndFeelProvider::addLookAndFeel);
        LookAndFeelProvider.SYSTEM.set((Object)false);
        LookAndFeelProvider.CROSS_PLATFORM.set((Object)false);
        LookAndFeelProvider.findLookAndFeelProvider((String)LookAndFeelProvider.defaultLookAndFeelName((String)DomainGeneratorPanel.class.getName(), (String)DEFAULT_FLAT_LOOK_AND_FEEL)).ifPresent(LookAndFeelProvider::enable);
        try {
            SwingUtilities.invokeLater(DomainGeneratorPanel::start);
        }
        catch (CancelException ignored) {
            System.exit(0);
        }
        catch (Exception e) {
            Dialogs.displayExceptionDialog((Throwable)e, null);
            System.exit(1);
        }
    }

    private static void start() {
        Database database = Database.instance();
        new DomainGeneratorPanel(DomainGeneratorModel.domainGeneratorModel((Database)database, (User)((LoginDialogBuilder)Dialogs.loginDialog().icon(Logos.logoTransparent())).defaultUser((User)DEFAULT_USER.optional().map(User::parse).orElse(null)).validator(user -> database.createConnection(user).close()).show())).showFrame();
    }
}

