/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.loadtest.model;

import is.codion.common.model.loadtest.LoadTest;
import is.codion.common.state.State;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.tools.loadtest.model.DefaultLoadTestModel;
import java.time.LocalDateTime;
import java.util.List;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public interface LoadTestModel<T> {
    public LoadTest<T> loadTest();

    public FilterTableModel<ApplicationRow, ApplicationRow.ColumnId> applicationTableModel();

    public int getUpdateInterval();

    public void setUpdateInterval(int var1);

    public State collectChartData();

    public State autoRefreshApplications();

    public void removeSelectedApplications();

    public void clearCharts();

    public int totalRunCount(String var1);

    public int successfulRunCount(String var1);

    public int unsuccessfulRunCount(String var1);

    public void resetRunCounter();

    public List<Exception> exceptions(String var1);

    public void clearExceptions(String var1);

    public IntervalXYDataset scenarioDurationDataset(String var1);

    public XYDataset thinkTimeDataset();

    public XYDataset numberOfApplicationsDataset();

    public XYDataset scenarioDataset();

    public XYDataset memoryUsageDataset();

    public XYDataset systemLoadDataset();

    public XYDataset scenarioFailureDataset();

    public static <T> LoadTestModel<T> loadTestModel(LoadTest<T> loadTest) {
        return new DefaultLoadTestModel<T>(loadTest);
    }

    public static interface ApplicationRow {
        public String name();

        public String username();

        public LocalDateTime created();

        public List<LoadTest.Scenario.Result> results();

        public static enum ColumnId {
            NAME,
            USERNAME,
            SCENARIO,
            SUCCESSFUL,
            DURATION,
            EXCEPTION,
            MESSAGE,
            CREATED;

        }
    }
}

