/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.darwin.manager.util;

import it.agilelab.darwin.common.DarwinConcurrentHashMap;
import it.agilelab.darwin.common.DarwinConcurrentHashMap$;
import it.agilelab.darwin.manager.exception.DarwinException;
import it.agilelab.darwin.manager.util.ByteArrayUtils$;
import it.agilelab.darwin.manager.util.ByteArrayUtils$EnrichedLong$;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.avro.Schema;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;

public final class AvroSingleObjectEncodingUtils$ {
    public static final AvroSingleObjectEncodingUtils$ MODULE$ = new AvroSingleObjectEncodingUtils$();
    private static final byte[] V1_HEADER = (byte[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{(byte)195, (byte)1}), (ClassTag)ClassTag$.MODULE$.Byte());
    private static final int ID_SIZE = 8;
    private static final int HEADER_LENGTH = MODULE$.V1_HEADER().length + MODULE$.ID_SIZE();
    private static final DarwinConcurrentHashMap<Schema, Object> schemaMap = DarwinConcurrentHashMap$.MODULE$.empty();

    private byte[] V1_HEADER() {
        return V1_HEADER;
    }

    private int ID_SIZE() {
        return ID_SIZE;
    }

    private int HEADER_LENGTH() {
        return HEADER_LENGTH;
    }

    private DarwinConcurrentHashMap<Schema, Object> schemaMap() {
        return schemaMap;
    }

    public DarwinException parseException() {
        return new DarwinException(new StringBuilder(0).append("Byte array is not in correct format.").append(new StringBuilder(31).append(" First ").append(this.V1_HEADER().length).append(" bytes are not equal to ").append(this.byteArray2HexString(this.V1_HEADER())).toString()).toString());
    }

    public boolean isAvroSingleObjectEncoded(byte[] data) {
        if (data.length < this.V1_HEADER().length) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(16).append("At least ").append(this.V1_HEADER().length).append(" bytes ").toString()).append("required to store the Single-Object Encoder header").toString());
        }
        return this.isAvroSingleObjectEncoded(ByteBuffer.wrap(data));
    }

    public boolean isAvroSingleObjectEncoded(ByteBuffer data) {
        boolean bl;
        try {
            int originalPosition = data.position();
            byte[] buffer = new byte[this.V1_HEADER().length];
            data.get(buffer);
            data.position(originalPosition);
            bl = Arrays.equals(buffer, this.V1_HEADER());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(16).append("At least ").append(this.V1_HEADER().length).append(" bytes ").toString()).append("required to store the Single-Object Encoder header").toString(), indexOutOfBoundsException);
        }
        return bl;
    }

    public byte[] generateAvroSingleObjectEncoded(byte[] avroPayload, long schemaId, ByteOrder endianness) {
        return (byte[])Array$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{this.V1_HEADER(), ByteArrayUtils$EnrichedLong$.MODULE$.longToByteArray$extension(ByteArrayUtils$.MODULE$.EnrichedLong(schemaId), endianness), avroPayload}), (ClassTag)ClassTag$.MODULE$.Byte());
    }

    public OutputStream writeHeaderToStream(OutputStream byteStream, long schemaId, ByteOrder endianness) {
        byteStream.write(this.V1_HEADER());
        ByteArrayUtils$EnrichedLong$.MODULE$.writeToStream$extension(ByteArrayUtils$.MODULE$.EnrichedLong(schemaId), byteStream, endianness);
        return byteStream;
    }

    public OutputStream generateAvroSingleObjectEncoded(OutputStream byteStream, byte[] avroValue, long schemaId, ByteOrder endianness) {
        this.writeHeaderToStream(byteStream, schemaId, endianness);
        byteStream.write(avroValue);
        return byteStream;
    }

    public OutputStream generateAvroSingleObjectEncoded(OutputStream byteStream, long schemaId, ByteOrder endianness, Function1<OutputStream, OutputStream> avroWriter) {
        byteStream.write(this.V1_HEADER());
        ByteArrayUtils$EnrichedLong$.MODULE$.writeToStream$extension(ByteArrayUtils$.MODULE$.EnrichedLong(schemaId), byteStream, endianness);
        return (OutputStream)avroWriter.apply((Object)byteStream);
    }

    public long extractId(byte[] avroSingleObjectEncoded, ByteOrder endianness) {
        return this.extractId(ByteBuffer.wrap(avroSingleObjectEncoded), endianness);
    }

    public long extractId(ByteBuffer avroSingleObjectEncoded, ByteOrder endianness) {
        if (avroSingleObjectEncoded.remaining() < this.HEADER_LENGTH()) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(16).append("At least ").append(this.V1_HEADER().length).append(" bytes ").toString()).append("required to store the Single-Object Encoder header").toString());
        }
        avroSingleObjectEncoded.position(avroSingleObjectEncoded.position() + this.V1_HEADER().length);
        return this.readLong(avroSingleObjectEncoded, endianness);
    }

    public long readLong(ByteBuffer buf, ByteOrder endianness) {
        long l;
        ByteOrder byteOrder = buf.order();
        ByteOrder byteOrder2 = endianness;
        if (!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null)) {
            l = buf.getLong();
        } else {
            ByteOrder lastEndianness = buf.order();
            buf.order(endianness);
            long toRet = buf.getLong();
            buf.order(lastEndianness);
            l = toRet;
        }
        return l;
    }

    public Either<byte[], Object> extractId(InputStream inputStream, ByteOrder endianness) {
        Left left;
        int bytesReadMagicBytes;
        byte[] buffer = new byte[this.HEADER_LENGTH()];
        if (inputStream.markSupported()) {
            inputStream.mark(2);
        }
        if ((bytesReadMagicBytes = inputStream.read(buffer, 0, this.V1_HEADER().length)) == 2) {
            if (ByteArrayUtils$.MODULE$.arrayEquals(buffer, this.V1_HEADER(), 0, 0, 2)) {
                int bytesReadFingerPrint = inputStream.read(buffer, 2, this.ID_SIZE());
                if (bytesReadFingerPrint + bytesReadMagicBytes == this.HEADER_LENGTH()) {
                    ByteBuffer buf = ByteBuffer.wrap(buffer, 0, this.HEADER_LENGTH());
                    left = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.extractId(buf, endianness)));
                } else {
                    left = package$.MODULE$.Left().apply(ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(buffer), 0, bytesReadFingerPrint + bytesReadMagicBytes));
                }
            } else {
                if (inputStream.markSupported()) {
                    inputStream.reset();
                    inputStream.mark(0);
                }
                left = package$.MODULE$.Left().apply(ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(buffer), 0, this.V1_HEADER().length));
            }
        } else {
            if (inputStream.markSupported()) {
                inputStream.reset();
                inputStream.mark(0);
            }
            left = package$.MODULE$.Left().apply(ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(buffer), 0, bytesReadMagicBytes));
        }
        return left;
    }

    public byte[] dropHeader(byte[] avroSingleObjectEncoded) {
        return (byte[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.byteArrayOps(avroSingleObjectEncoded), this.HEADER_LENGTH());
    }

    public long getId(Schema schema, Function1<Schema, Object> fingerprinter) {
        return BoxesRunTime.unboxToLong((Object)this.schemaMap().getOrElseUpdate(schema, (Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)fingerprinter.apply((Object)schema))));
    }

    public String byteArray2HexString(byte[] bytes) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(bytes), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString("[", " ", "]");
    }

    private AvroSingleObjectEncodingUtils$() {
    }
}

