/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.{ParameterContextEntity, ParameterContextUpdateRequestEntity, ParameterContextValidationRequestEntity}
import sttp.client._
import sttp.model.Method

object ParameterContextsApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new ParameterContextsApi(baseUrl)
}

class ParameterContextsApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  
  import serializer._

  /**
   * Expected answers:
   *   code 200 : ParameterContextEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param body The Parameter Context.
   */
  def createParameterContext(body: ParameterContextEntity): ApiRequestT[ParameterContextEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/parameter-contexts")
      .contentType("application/json")
      .body(body)
      .response(asJson[ParameterContextEntity])

  /**
   * Deletes the Parameter Context with the given ID.
   * 
   * Expected answers:
   *   code 200 : ParameterContextEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The Parameter Context ID.
   * @param version The version is used to verify the client is working with the latest version of the flow.
   * @param clientId If the client id is not specified, a new one will be generated. This value (whether specified or generated) is included in the response.
   * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
   */
  def deleteParameterContext(id: String, version: Option[String] = None, clientId: Option[String] = None, disconnectedNodeAcknowledged: Option[Boolean] = None): ApiRequestT[ParameterContextEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/parameter-contexts/${id}?version=$version&clientId=$clientId&disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged")
      .contentType("application/json")
      .response(asJson[ParameterContextEntity])

  /**
   * Deletes the Update Request with the given ID. After a request is created via a POST to /nifi-api/parameter-contexts/update-requests, it is expected that the client will properly clean up the request by DELETE'ing it, once the Update process has completed. If the request is deleted before the request completes, then the Update request will finish the step that it is currently performing and then will cancel any subsequent steps.
   * 
   * Expected answers:
   *   code 200 : ParameterContextUpdateRequestEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param contextId The ID of the ParameterContext
   * @param requestId The ID of the Update Request
   * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
   */
  def deleteUpdateRequest(contextId: String, requestId: String, disconnectedNodeAcknowledged: Option[Boolean] = None): ApiRequestT[ParameterContextUpdateRequestEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/parameter-contexts/${contextId}/update-requests/${requestId}?disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged")
      .contentType("application/json")
      .response(asJson[ParameterContextUpdateRequestEntity])

  /**
   * Deletes the Validation Request with the given ID. After a request is created via a POST to /nifi-api/validation-contexts, it is expected that the client will properly clean up the request by DELETE'ing it, once the validation process has completed. If the request is deleted before the request completes, then the Validation request will finish the step that it is currently performing and then will cancel any subsequent steps.
   * 
   * Expected answers:
   *   code 200 : ParameterContextValidationRequestEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param contextId The ID of the Parameter Context
   * @param id The ID of the Update Request
   * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
   */
  def deleteValidationRequest(contextId: String, id: String, disconnectedNodeAcknowledged: Option[Boolean] = None): ApiRequestT[ParameterContextValidationRequestEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/parameter-contexts/${contextId}/validation-requests/${id}?disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged")
      .contentType("application/json")
      .response(asJson[ParameterContextValidationRequestEntity])

  /**
   * Returns the Parameter Context with the given ID.
   * 
   * Expected answers:
   *   code 200 : ParameterContextEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The ID of the Parameter Context
   */
  def getParameterContext(id: String): ApiRequestT[ParameterContextEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/parameter-contexts/${id}")
      .contentType("application/json")
      .response(asJson[ParameterContextEntity])

  /**
   * Returns the Update Request with the given ID. Once an Update Request has been created by performing a POST to /nifi-api/parameter-contexts, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. 
   * 
   * Expected answers:
   *   code 200 : ParameterContextUpdateRequestEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param contextId The ID of the Parameter Context
   * @param requestId The ID of the Update Request
   */
  def getParameterContextUpdate(contextId: String, requestId: String): ApiRequestT[ParameterContextUpdateRequestEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/parameter-contexts/${contextId}/update-requests/${requestId}")
      .contentType("application/json")
      .response(asJson[ParameterContextUpdateRequestEntity])

  /**
   * Returns the Validation Request with the given ID. Once a Validation Request has been created by performing a POST to /nifi-api/validation-contexts, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. 
   * 
   * Expected answers:
   *   code 200 : ParameterContextValidationRequestEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param contextId The ID of the Parameter Context
   * @param id The ID of the Validation Request
   */
  def getValidationRequest(contextId: String, id: String): ApiRequestT[ParameterContextValidationRequestEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/parameter-contexts/${contextId}/validation-requests/${id}")
      .contentType("application/json")
      .response(asJson[ParameterContextValidationRequestEntity])

  /**
   * This will initiate the process of updating a Parameter Context. Changing the value of a Parameter may require that one or more components be stopped and restarted, so this acttion may take significantly more time than many other REST API actions. As a result, this endpoint will immediately return a ParameterContextUpdateRequestEntity, and the process of updating the necessary components will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-contexts/update-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-contexts/update-requests/{requestId}.
   * 
   * Expected answers:
   *   code 200 : ParameterContextUpdateRequestEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param contextId 
   * @param body The updated version of the parameter context.
   */
  def submitParameterContextUpdate(contextId: String, body: ParameterContextEntity): ApiRequestT[ParameterContextUpdateRequestEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/parameter-contexts/${contextId}/update-requests")
      .contentType("application/json")
      .body(body)
      .response(asJson[ParameterContextUpdateRequestEntity])

  /**
   * This will initiate the process of validating all components whose Process Group is bound to the specified Parameter Context. Performing validation against an arbitrary number of components may be expect and take significantly more time than many other REST API actions. As a result, this endpoint will immediately return a ParameterContextValidationRequestEntity, and the process of validating the necessary components will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-contexts/validation-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-contexts/validation-requests/{requestId}.
   * 
   * Expected answers:
   *   code 200 : ParameterContextValidationRequestEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param contextId 
   * @param body The validation request
   */
  def submitValidationRequest(contextId: String, body: ParameterContextValidationRequestEntity): ApiRequestT[ParameterContextValidationRequestEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/parameter-contexts/${contextId}/validation-requests")
      .contentType("application/json")
      .body(body)
      .response(asJson[ParameterContextValidationRequestEntity])

  /**
   * This endpoint will update a Parameter Context to match the provided entity. However, this request will fail if any component is running and is referencing a Parameter in the Parameter Context. Generally, this endpoint is not called directly. Instead, an update request should be submitted by making a POST to the /parameter-contexts/update-requests endpoint. That endpoint will, in turn, call this endpoint.
   * 
   * Expected answers:
   *   code 200 : ParameterContextEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id 
   * @param body The updated Parameter Context
   */
  def updateParameterContext(id: String, body: ParameterContextEntity): ApiRequestT[ParameterContextEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/parameter-contexts/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[ParameterContextEntity])

}

