/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.AccessPolicyEntity
import sttp.client._
import sttp.model.Method

object PoliciesApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new PoliciesApi(baseUrl)
}

class PoliciesApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  import serializer._

  /**
   * Expected answers:
   *   code 200 : AccessPolicyEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param body The access policy configuration details.
   */
  def createAccessPolicy(body: AccessPolicyEntity): ApiRequestT[AccessPolicyEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/policies")
      .contentType("application/json")
      .body(body)
      .response(asJson[AccessPolicyEntity])

  /**
   * Expected answers:
   *   code 200 : AccessPolicyEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The access policy id.
   */
  def getAccessPolicy(id: String): ApiRequestT[AccessPolicyEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/policies/${id}")
      .contentType("application/json")
      .response(asJson[AccessPolicyEntity])

  /**
   * Will return the effective policy if no component specific policy exists for the specified action and resource. Must have Read permissions to the policy with the desired action and resource. Permissions for the policy that is returned will be indicated in the response. This means the client could be authorized to get the policy for a given component but the effective policy may be inherited from an ancestor Process Group. If the client does not have permissions to that policy, the response will not include the policy and the permissions in the response will be marked accordingly. If the client does not have permissions to the policy of the desired action and resource a 403 response will be returned.
   * 
   * Expected answers:
   *   code 200 : AccessPolicyEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param action The request action.
   * @param resource The resource of the policy.
   */
  def getAccessPolicyForResource(action: String, resource: String): ApiRequestT[AccessPolicyEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/policies/${action}/${resource}")
      .contentType("application/json")
      .response(asJson[AccessPolicyEntity])

  /**
   * Expected answers:
   *   code 200 : AccessPolicyEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The access policy id.
   * @param version The revision is used to verify the client is working with the latest version of the flow.
   * @param clientId If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
   * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
   */
  def removeAccessPolicy(id: String, version: Option[String] = None, clientId: Option[String] = None, disconnectedNodeAcknowledged: Option[Boolean] = None): ApiRequestT[AccessPolicyEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/policies/${id}?version=$version&clientId=$clientId&disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged")
      .contentType("application/json")
      .response(asJson[AccessPolicyEntity])

  /**
   * Expected answers:
   *   code 200 : AccessPolicyEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The access policy id.
   * @param body The access policy configuration details.
   */
  def updateAccessPolicy(id: String, body: AccessPolicyEntity): ApiRequestT[AccessPolicyEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/policies/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[AccessPolicyEntity])

}

