/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.{ComponentStateEntity, ProcessorEntity, ProcessorRunStatusEntity, PropertyDescriptorEntity}
import sttp.client._
import sttp.model.Method

object ProcessorsApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new ProcessorsApi(baseUrl)
}

class ProcessorsApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  
  import serializer._

  /**
   * Expected answers:
   *   code 200 : ComponentStateEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The processor id.
   */
  def clearState(id: String): ApiRequestT[ComponentStateEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/processors/${id}/state/clear-requests")
      .contentType("application/json")
      .response(asJson[ComponentStateEntity])

  /**
   * Expected answers:
   *   code 200 : ProcessorEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The processor id.
   * @param version The revision is used to verify the client is working with the latest version of the flow.
   * @param clientId If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
   * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
   */
  def deleteProcessor(id: String, version: Option[String] = None, clientId: Option[String] = None, disconnectedNodeAcknowledged: Option[Boolean] = None): ApiRequestT[ProcessorEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/processors/${id}?version=$version&clientId=$clientId&disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged")
      .contentType("application/json")
      .response(asJson[ProcessorEntity])

  /**
   * Expected answers:
   *   code 200 : ProcessorEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The processor id.
   */
  def getProcessor(id: String): ApiRequestT[ProcessorEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/processors/${id}")
      .contentType("application/json")
      .response(asJson[ProcessorEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : ProcessorEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The processor id.
   */
  def getProcessorDiagnostics(id: String): ApiRequestT[ProcessorEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/processors/${id}/diagnostics")
      .contentType("application/json")
      .response(asJson[ProcessorEntity])

  /**
   * Expected answers:
   *   code 200 : PropertyDescriptorEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The processor id.
   * @param propertyName The property name.
   * @param clientId If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
   */
  def getPropertyDescriptor(id: String, propertyName: String, clientId: Option[String] = None): ApiRequestT[PropertyDescriptorEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/processors/${id}/descriptors?clientId=$clientId&propertyName=$propertyName")
      .contentType("application/json")
      .response(asJson[PropertyDescriptorEntity])

  /**
   * Expected answers:
   *   code 200 : ComponentStateEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The processor id.
   */
  def getState(id: String): ApiRequestT[ComponentStateEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/processors/${id}/state")
      .contentType("application/json")
      .response(asJson[ComponentStateEntity])

  /**
   * Expected answers:
   *   code 200 : ProcessorEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The processor id.
   */
  def terminateProcessor(id: String): ApiRequestT[ProcessorEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/processors/${id}/threads")
      .contentType("application/json")
      .response(asJson[ProcessorEntity])

  /**
   * Expected answers:
   *   code 200 : ProcessorEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The processor id.
   * @param body The processor configuration details.
   */
  def updateProcessor(id: String, body: ProcessorEntity): ApiRequestT[ProcessorEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/processors/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[ProcessorEntity])

  /**
   * Expected answers:
   *   code 200 : ProcessorEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The processor id.
   * @param body The processor run status.
   */
  def updateRunStatus(id: String, body: ProcessorRunStatusEntity): ApiRequestT[ProcessorEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/processors/${id}/run-status")
      .contentType("application/json")
      .body(body)
      .response(asJson[ProcessorEntity])

}

