/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.{ComponentStateEntity, PropertyDescriptorEntity, ReportingTaskEntity, ReportingTaskRunStatusEntity}
import sttp.client._
import sttp.model.Method

object ReportingTasksApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new ReportingTasksApi(baseUrl)
}

class ReportingTasksApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  
  import serializer._

  /**
   * Expected answers:
   *   code 200 : ComponentStateEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The reporting task id.
   */
  def clearState(id: String): ApiRequestT[ComponentStateEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/reporting-tasks/${id}/state/clear-requests")
      .contentType("application/json")
      .response(asJson[ComponentStateEntity])

  /**
   * Expected answers:
   *   code 200 : PropertyDescriptorEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The reporting task id.
   * @param propertyName The property name.
   */
  def getPropertyDescriptor(id: String, propertyName: String): ApiRequestT[PropertyDescriptorEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/reporting-tasks/${id}/descriptors?propertyName=$propertyName")
      .contentType("application/json")
      .response(asJson[PropertyDescriptorEntity])

  /**
   * Expected answers:
   *   code 200 : ReportingTaskEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The reporting task id.
   */
  def getReportingTask(id: String): ApiRequestT[ReportingTaskEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/reporting-tasks/${id}")
      .contentType("application/json")
      .response(asJson[ReportingTaskEntity])

  /**
   * Expected answers:
   *   code 200 : ComponentStateEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The reporting task id.
   */
  def getState(id: String): ApiRequestT[ComponentStateEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/reporting-tasks/${id}/state")
      .contentType("application/json")
      .response(asJson[ComponentStateEntity])

  /**
   * Expected answers:
   *   code 200 : ReportingTaskEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The reporting task id.
   * @param version The revision is used to verify the client is working with the latest version of the flow.
   * @param clientId If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
   * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
   */
  def removeReportingTask(id: String, version: Option[String] = None, clientId: Option[String] = None, disconnectedNodeAcknowledged: Option[Boolean] = None): ApiRequestT[ReportingTaskEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/reporting-tasks/${id}?version=$version&clientId=$clientId&disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged")
      .contentType("application/json")
      .response(asJson[ReportingTaskEntity])

  /**
   * Expected answers:
   *   code 200 : ReportingTaskEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The reporting task id.
   * @param body The reporting task configuration details.
   */
  def updateReportingTask(id: String, body: ReportingTaskEntity): ApiRequestT[ReportingTaskEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/reporting-tasks/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[ReportingTaskEntity])

  /**
   * Expected answers:
   *   code 200 : ReportingTaskEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The reporting task id.
   * @param body The reporting task run status.
   */
  def updateRunStatus(id: String, body: ReportingTaskRunStatusEntity): ApiRequestT[ReportingTaskEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/reporting-tasks/${id}/run-status")
      .contentType("application/json")
      .body(body)
      .response(asJson[ReportingTaskEntity])

}

