/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ControllerServiceReferencingComponentDTO(
  /* The group id for the component referencing a controller service. If this component is another controller service or a reporting task, this field is blank. */
  groupId: Option[String] = None,
  /* The id of the component referencing a controller service. */
  id: Option[String] = None,
  /* The name of the component referencing a controller service. */
  name: Option[String] = None,
  /* The type of the component referencing a controller service in simple Java class name format without package name. */
  `type`: Option[String] = None,
  /* The scheduled state of a processor or reporting task referencing a controller service. If this component is another controller service, this field represents the controller service state. */
  state: Option[String] = None,
  /* The properties for the component. */
  properties: Option[Map[String, String]] = None,
  /* The descriptors for the component properties. */
  descriptors: Option[Map[String, PropertyDescriptorDTO]] = None,
  /* The validation errors for the component. */
  validationErrors: Option[Seq[String]] = None,
  /* The type of reference this is. */
  referenceType: Option[ControllerServiceReferencingComponentDTOEnums.ReferenceType] = None,
  /* The number of active threads for the referencing component. */
  activeThreadCount: Option[Int] = None,
  /* If the referencing component represents a controller service, this indicates whether it has already been represented in this hierarchy. */
  referenceCycle: Option[Boolean] = None,
  /* If the referencing component represents a controller service, these are the components that reference it. */
  referencingComponents: Option[Set[ControllerServiceReferencingComponentEntity]] = None
) extends ApiModel

object ControllerServiceReferencingComponentDTOEnums {

  type ReferenceType = ReferenceType.Value
  object ReferenceType extends Enumeration {
    val Processor = Value("Processor")
    val ControllerService = Value("ControllerService")
    val ReportingTask = Value("ReportingTask")
  }

}

