/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class LineageRequestDTO(
  /* The event id that was used to generate this lineage, if applicable. The event id is allowed for any type of lineageRequestType. If the lineageRequestType is FLOWFILE and the flowfile uuid is also included in the request, the event id will be ignored. */
  eventId: Option[Long] = None,
  /* The type of lineage request. PARENTS will return the lineage for the flowfiles that are parents of the specified event. CHILDREN will return the lineage for the flowfiles that are children of the specified event. FLOWFILE will return the lineage for the specified flowfile. */
  lineageRequestType: Option[LineageRequestDTOEnums.LineageRequestType] = None,
  /* The flowfile uuid that was used to generate the lineage. The flowfile uuid is only allowed when the lineageRequestType is FLOWFILE and will take precedence over event id. */
  uuid: Option[String] = None,
  /* The id of the node where this lineage originated if clustered. */
  clusterNodeId: Option[String] = None
) extends ApiModel

object LineageRequestDTOEnums {

  type LineageRequestType = LineageRequestType.Value
  object LineageRequestType extends Enumeration {
    val PARENTS = Value("PARENTS")
    val CHILDREN = Value("CHILDREN")
    val AndFLOWFILE = Value("and FLOWFILE")
  }

}

