/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ProcessGroupDTO(
  /* The id of the component. */
  id: Option[String] = None,
  /* The ID of the corresponding component that is under version control */
  versionedComponentId: Option[String] = None,
  /* The id of parent process group of this component if applicable. */
  parentGroupId: Option[String] = None,
  position: Option[PositionDTO] = None,
  /* The name of the process group. */
  name: Option[String] = None,
  /* The comments for the process group. */
  comments: Option[String] = None,
  /* The variables that are configured for the Process Group. Note that this map contains only those variables that are defined on this Process Group and not any variables that are defined in the parent Process Group, etc. I.e., this Map will not contain all variables that are accessible by components in this Process Group by rather only the variables that are defined for this Process Group itself. */
  variables: Option[Map[String, String]] = None,
  versionControlInformation: Option[VersionControlInformationDTO] = None,
  parameterContext: Option[ParameterContextReferenceEntity] = None,
  /* The number of running components in this process group. */
  runningCount: Option[Int] = None,
  /* The number of stopped components in the process group. */
  stoppedCount: Option[Int] = None,
  /* The number of invalid components in the process group. */
  invalidCount: Option[Int] = None,
  /* The number of disabled components in the process group. */
  disabledCount: Option[Int] = None,
  /* The number of active remote ports in the process group. */
  activeRemotePortCount: Option[Int] = None,
  /* The number of inactive remote ports in the process group. */
  inactiveRemotePortCount: Option[Int] = None,
  /* The number of up to date versioned process groups in the process group. */
  upToDateCount: Option[Int] = None,
  /* The number of locally modified versioned process groups in the process group. */
  locallyModifiedCount: Option[Int] = None,
  /* The number of stale versioned process groups in the process group. */
  staleCount: Option[Int] = None,
  /* The number of locally modified and stale versioned process groups in the process group. */
  locallyModifiedAndStaleCount: Option[Int] = None,
  /* The number of versioned process groups in the process group that are unable to sync to a registry. */
  syncFailureCount: Option[Int] = None,
  /* The number of local input ports in the process group. */
  localInputPortCount: Option[Int] = None,
  /* The number of local output ports in the process group. */
  localOutputPortCount: Option[Int] = None,
  /* The number of public input ports in the process group. */
  publicInputPortCount: Option[Int] = None,
  /* The number of public output ports in the process group. */
  publicOutputPortCount: Option[Int] = None,
  contents: Option[FlowSnippetDTO] = None,
  /* The number of input ports in the process group. */
  inputPortCount: Option[Int] = None,
  /* The number of output ports in the process group. */
  outputPortCount: Option[Int] = None
) extends ApiModel


