/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ProcessGroupEntity(
  revision: Option[RevisionDTO] = None,
  /* The id of the component. */
  id: Option[String] = None,
  /* The URI for futures requests to the component. */
  uri: Option[String] = None,
  position: Option[PositionDTO] = None,
  permissions: Option[PermissionsDTO] = None,
  /* The bulletins for this component. */
  bulletins: Option[Seq[BulletinEntity]] = None,
  /* Acknowledges that this node is disconnected to allow for mutable requests to proceed. */
  disconnectedNodeAcknowledged: Option[Boolean] = None,
  component: Option[ProcessGroupDTO] = None,
  status: Option[ProcessGroupStatusDTO] = None,
  versionedFlowSnapshot: Option[VersionedFlowSnapshot] = None,
  /* The number of running components in this process group. */
  runningCount: Option[Int] = None,
  /* The number of stopped components in the process group. */
  stoppedCount: Option[Int] = None,
  /* The number of invalid components in the process group. */
  invalidCount: Option[Int] = None,
  /* The number of disabled components in the process group. */
  disabledCount: Option[Int] = None,
  /* The number of active remote ports in the process group. */
  activeRemotePortCount: Option[Int] = None,
  /* The number of inactive remote ports in the process group. */
  inactiveRemotePortCount: Option[Int] = None,
  /* The current state of the Process Group, as it relates to the Versioned Flow */
  versionedFlowState: Option[ProcessGroupEntityEnums.VersionedFlowState] = None,
  /* The number of up to date versioned process groups in the process group. */
  upToDateCount: Option[Int] = None,
  /* The number of locally modified versioned process groups in the process group. */
  locallyModifiedCount: Option[Int] = None,
  /* The number of stale versioned process groups in the process group. */
  staleCount: Option[Int] = None,
  /* The number of locally modified and stale versioned process groups in the process group. */
  locallyModifiedAndStaleCount: Option[Int] = None,
  /* The number of versioned process groups in the process group that are unable to sync to a registry. */
  syncFailureCount: Option[Int] = None,
  /* The number of local input ports in the process group. */
  localInputPortCount: Option[Int] = None,
  /* The number of local output ports in the process group. */
  localOutputPortCount: Option[Int] = None,
  /* The number of public input ports in the process group. */
  publicInputPortCount: Option[Int] = None,
  /* The number of public output ports in the process group. */
  publicOutputPortCount: Option[Int] = None,
  parameterContext: Option[ParameterContextReferenceEntity] = None,
  /* The number of input ports in the process group. */
  inputPortCount: Option[Int] = None,
  /* The number of output ports in the process group. */
  outputPortCount: Option[Int] = None
) extends ApiModel

object ProcessGroupEntityEnums {

  type VersionedFlowState = VersionedFlowState.Value
  object VersionedFlowState extends Enumeration {
    val LOCALLYMODIFIED = Value("LOCALLY_MODIFIED")
    val STALE = Value("STALE")
    val LOCALLYMODIFIEDANDSTALE = Value("LOCALLY_MODIFIED_AND_STALE")
    val UPTODATE = Value("UP_TO_DATE")
    val SYNCFAILURE = Value("SYNC_FAILURE")
  }

}

