/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ProcessorConfigDTO(
  /* The properties for the processor. Properties whose value is not set will only contain the property name. */
  properties: Option[Map[String, String]] = None,
  /* Descriptors for the processor's properties. */
  descriptors: Option[Map[String, PropertyDescriptorDTO]] = None,
  /* The frequency with which to schedule the processor. The format of the value will depend on th value of schedulingStrategy. */
  schedulingPeriod: Option[String] = None,
  /* Indcates whether the prcessor should be scheduled to run in event or timer driven mode. */
  schedulingStrategy: Option[String] = None,
  /* Indicates the node where the process will execute. */
  executionNode: Option[String] = None,
  /* The amount of time that is used when the process penalizes a flowfile. */
  penaltyDuration: Option[String] = None,
  /* The amount of time that must elapse before this processor is scheduled again after yielding. */
  yieldDuration: Option[String] = None,
  /* The level at which the processor will report bulletins. */
  bulletinLevel: Option[String] = None,
  /* The run duration for the processor in milliseconds. */
  runDurationMillis: Option[Long] = None,
  /* The number of tasks that should be concurrently schedule for the processor. If the processor doesn't allow parallol processing then any positive input will be ignored. */
  concurrentlySchedulableTaskCount: Option[Int] = None,
  /* The names of all relationships that cause a flow file to be terminated if the relationship is not connected elsewhere. This property differs from the 'isAutoTerminate' property of the RelationshipDTO in that the RelationshipDTO is meant to depict the current configuration, whereas this property can be set in a DTO when updating a Processor in order to change which Relationships should be auto-terminated. */
  autoTerminatedRelationships: Option[Set[String]] = None,
  /* The comments for the processor. */
  comments: Option[String] = None,
  /* The URL for the processor's custom configuration UI if applicable. */
  customUiUrl: Option[String] = None,
  /* Whether the processor is loss tolerant. */
  lossTolerant: Option[Boolean] = None,
  /* The annotation data for the processor used to relay configuration between a custom UI and the procesosr. */
  annotationData: Option[String] = None,
  /* Maps default values for concurrent tasks for each applicable scheduling strategy. */
  defaultConcurrentTasks: Option[Map[String, String]] = None,
  /* Maps default values for scheduling period for each applicable scheduling strategy. */
  defaultSchedulingPeriod: Option[Map[String, String]] = None
) extends ApiModel


