/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ProcessorDTO(
  /* The id of the component. */
  id: Option[String] = None,
  /* The ID of the corresponding component that is under version control */
  versionedComponentId: Option[String] = None,
  /* The id of parent process group of this component if applicable. */
  parentGroupId: Option[String] = None,
  position: Option[PositionDTO] = None,
  /* The name of the processor. */
  name: Option[String] = None,
  /* The type of the processor. */
  `type`: Option[String] = None,
  bundle: Option[BundleDTO] = None,
  /* The state of the processor */
  state: Option[ProcessorDTOEnums.State] = None,
  /* Styles for the processor (background-color : #eee). */
  style: Option[Map[String, String]] = None,
  /* The available relationships that the processor currently supports. */
  relationships: Option[Seq[RelationshipDTO]] = None,
  /* The description of the processor. */
  description: Option[String] = None,
  /* Whether the processor supports parallel processing. */
  supportsParallelProcessing: Option[Boolean] = None,
  /* Whether the processor supports event driven scheduling. */
  supportsEventDriven: Option[Boolean] = None,
  /* Whether the processor supports batching. This makes the run duration settings available. */
  supportsBatching: Option[Boolean] = None,
  /* Whether the processor persists state. */
  persistsState: Option[Boolean] = None,
  /* Whether the processor requires elevated privileges. */
  restricted: Option[Boolean] = None,
  /* Whether the processor has been deprecated. */
  deprecated: Option[Boolean] = None,
  /* Indicates if the execution node of a processor is restricted to run only on the primary node */
  executionNodeRestricted: Option[Boolean] = None,
  /* Whether the processor has multiple versions available. */
  multipleVersionsAvailable: Option[Boolean] = None,
  /* The input requirement for this processor. */
  inputRequirement: Option[String] = None,
  config: Option[ProcessorConfigDTO] = None,
  /* The validation errors for the processor. These validation errors represent the problems with the processor that must be resolved before it can be started. */
  validationErrors: Option[Seq[String]] = None,
  /* Indicates whether the Processor is valid, invalid, or still in the process of validating (i.e., it is unknown whether or not the Processor is valid) */
  validationStatus: Option[ProcessorDTOEnums.ValidationStatus] = None,
  /* Whether the underlying extension is missing. */
  extensionMissing: Option[Boolean] = None
) extends ApiModel

object ProcessorDTOEnums {

  type State = State.Value
  type ValidationStatus = ValidationStatus.Value
  object State extends Enumeration {
    val RUNNING = Value("RUNNING")
    val STOPPED = Value("STOPPED")
    val DISABLED = Value("DISABLED")
  }

  object ValidationStatus extends Enumeration {
    val VALID = Value("VALID")
    val INVALID = Value("INVALID")
    val VALIDATING = Value("VALIDATING")
  }

}

