/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ProvenanceEventDTO(
  /* The event uuid. */
  id: Option[String] = None,
  /* The event id. This is a one up number thats unique per node. */
  eventId: Option[Long] = None,
  /* The timestamp of the event. */
  eventTime: Option[String] = None,
  /* The event duration in milliseconds. */
  eventDuration: Option[Long] = None,
  /* The duration since the lineage began, in milliseconds. */
  lineageDuration: Option[Long] = None,
  /* The type of the event. */
  eventType: Option[String] = None,
  /* The uuid of the flowfile for the event. */
  flowFileUuid: Option[String] = None,
  /* The size of the flowfile for the event. */
  fileSize: Option[String] = None,
  /* The size of the flowfile in bytes for the event. */
  fileSizeBytes: Option[Long] = None,
  /* The identifier for the node where the event originated. */
  clusterNodeId: Option[String] = None,
  /* The label for the node where the event originated. */
  clusterNodeAddress: Option[String] = None,
  /* The id of the group that the component resides in. If the component is no longer in the flow, the group id will not be set. */
  groupId: Option[String] = None,
  /* The id of the component that generated the event. */
  componentId: Option[String] = None,
  /* The type of the component that generated the event. */
  componentType: Option[String] = None,
  /* The name of the component that generated the event. */
  componentName: Option[String] = None,
  /* The source system flowfile id. */
  sourceSystemFlowFileId: Option[String] = None,
  /* The alternate identifier uri for the fileflow for the event. */
  alternateIdentifierUri: Option[String] = None,
  /* The attributes of the flowfile for the event. */
  attributes: Option[Seq[AttributeDTO]] = None,
  /* The parent uuids for the event. */
  parentUuids: Option[Seq[String]] = None,
  /* The child uuids for the event. */
  childUuids: Option[Seq[String]] = None,
  /* The source/destination system uri if the event was a RECEIVE/SEND. */
  transitUri: Option[String] = None,
  /* The relationship to which the flowfile was routed if the event is of type ROUTE. */
  relationship: Option[String] = None,
  /* The event details. */
  details: Option[String] = None,
  /* Whether the input and output content claim is the same. */
  contentEqual: Option[Boolean] = None,
  /* Whether the input content is still available. */
  inputContentAvailable: Option[Boolean] = None,
  /* The section in which the input content claim lives. */
  inputContentClaimSection: Option[String] = None,
  /* The container in which the input content claim lives. */
  inputContentClaimContainer: Option[String] = None,
  /* The identifier of the input content claim. */
  inputContentClaimIdentifier: Option[String] = None,
  /* The offset into the input content claim where the flowfiles content begins. */
  inputContentClaimOffset: Option[Long] = None,
  /* The file size of the input content claim formatted. */
  inputContentClaimFileSize: Option[String] = None,
  /* The file size of the intput content claim in bytes. */
  inputContentClaimFileSizeBytes: Option[Long] = None,
  /* Whether the output content is still available. */
  outputContentAvailable: Option[Boolean] = None,
  /* The section in which the output content claim lives. */
  outputContentClaimSection: Option[String] = None,
  /* The container in which the output content claim lives. */
  outputContentClaimContainer: Option[String] = None,
  /* The identifier of the output content claim. */
  outputContentClaimIdentifier: Option[String] = None,
  /* The offset into the output content claim where the flowfiles content begins. */
  outputContentClaimOffset: Option[Long] = None,
  /* The file size of the output content claim formatted. */
  outputContentClaimFileSize: Option[String] = None,
  /* The file size of the output content claim in bytes. */
  outputContentClaimFileSizeBytes: Option[Long] = None,
  /* Whether or not replay is available. */
  replayAvailable: Option[Boolean] = None,
  /* Explanation as to why replay is unavailable. */
  replayExplanation: Option[String] = None,
  /* The identifier of the queue/connection from which the flowfile was pulled to genereate this event. May be null if the queue/connection is unknown or the flowfile was generated from this event. */
  sourceConnectionIdentifier: Option[String] = None
) extends ApiModel


