/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class RemoteProcessGroupDTO(
  /* The id of the component. */
  id: Option[String] = None,
  /* The ID of the corresponding component that is under version control */
  versionedComponentId: Option[String] = None,
  /* The id of parent process group of this component if applicable. */
  parentGroupId: Option[String] = None,
  position: Option[PositionDTO] = None,
  /* The target URI of the remote process group. If target uri is not set, but uris are set, then returns the first url in the urls. If neither target uri nor uris are set, then returns null. */
  targetUri: Option[String] = None,
  /* The target URI of the remote process group. If target uris is not set but target uri is set, then returns a collection containing the single target uri. If neither target uris nor uris are set, then returns null. */
  targetUris: Option[String] = None,
  /* Whether the target is running securely. */
  targetSecure: Option[Boolean] = None,
  /* The name of the remote process group. */
  name: Option[String] = None,
  /* The comments for the remote process group. */
  comments: Option[String] = None,
  /* The time period used for the timeout when communicating with the target. */
  communicationsTimeout: Option[String] = None,
  /* When yielding, this amount of time must elapse before the remote process group is scheduled again. */
  yieldDuration: Option[String] = None,
  transportProtocol: Option[String] = None,
  /* The local network interface to send/receive data. If not specified, any local address is used. If clustered, all nodes must have an interface with this identifier. */
  localNetworkInterface: Option[String] = None,
  proxyHost: Option[String] = None,
  proxyPort: Option[Int] = None,
  proxyUser: Option[String] = None,
  proxyPassword: Option[String] = None,
  /* Any remote authorization issues for the remote process group. */
  authorizationIssues: Option[Seq[String]] = None,
  /* The validation errors for the remote process group. These validation errors represent the problems with the remote process group that must be resolved before it can transmit. */
  validationErrors: Option[Seq[String]] = None,
  /* Whether the remote process group is actively transmitting. */
  transmitting: Option[Boolean] = None,
  /* The number of remote input ports currently available on the target. */
  inputPortCount: Option[Int] = None,
  /* The number of remote output ports currently available on the target. */
  outputPortCount: Option[Int] = None,
  /* The number of active remote input ports. */
  activeRemoteInputPortCount: Option[Int] = None,
  /* The number of inactive remote input ports. */
  inactiveRemoteInputPortCount: Option[Int] = None,
  /* The number of active remote output ports. */
  activeRemoteOutputPortCount: Option[Int] = None,
  /* The number of inactive remote output ports. */
  inactiveRemoteOutputPortCount: Option[Int] = None,
  /* The timestamp when this remote process group was last refreshed. */
  flowRefreshed: Option[String] = None,
  contents: Option[RemoteProcessGroupContentsDTO] = None
) extends ApiModel


