/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ReportingTaskDTO(
  /* The id of the component. */
  id: Option[String] = None,
  /* The ID of the corresponding component that is under version control */
  versionedComponentId: Option[String] = None,
  /* The id of parent process group of this component if applicable. */
  parentGroupId: Option[String] = None,
  position: Option[PositionDTO] = None,
  /* The name of the reporting task. */
  name: Option[String] = None,
  /* The fully qualified type of the reporting task. */
  `type`: Option[String] = None,
  bundle: Option[BundleDTO] = None,
  /* The state of the reporting task. */
  state: Option[ReportingTaskDTOEnums.State] = None,
  /* The comments of the reporting task. */
  comments: Option[String] = None,
  /* Whether the reporting task persists state. */
  persistsState: Option[Boolean] = None,
  /* Whether the reporting task requires elevated privileges. */
  restricted: Option[Boolean] = None,
  /* Whether the reporting task has been deprecated. */
  deprecated: Option[Boolean] = None,
  /* Whether the reporting task has multiple versions available. */
  multipleVersionsAvailable: Option[Boolean] = None,
  /* The frequency with which to schedule the reporting task. The format of the value willd epend on the valud of the schedulingStrategy. */
  schedulingPeriod: Option[String] = None,
  /* The scheduling strategy that determines how the schedulingPeriod value should be interpreted. */
  schedulingStrategy: Option[String] = None,
  /* The default scheduling period for the different scheduling strategies. */
  defaultSchedulingPeriod: Option[Map[String, String]] = None,
  /* The properties of the reporting task. */
  properties: Option[Map[String, String]] = None,
  /* The descriptors for the reporting tasks properties. */
  descriptors: Option[Map[String, PropertyDescriptorDTO]] = None,
  /* The URL for the custom configuration UI for the reporting task. */
  customUiUrl: Option[String] = None,
  /* The annotation data for the repoting task. This is how the custom UI relays configuration to the reporting task. */
  annotationData: Option[String] = None,
  /* Gets the validation errors from the reporting task. These validation errors represent the problems with the reporting task that must be resolved before it can be scheduled to run. */
  validationErrors: Option[Seq[String]] = None,
  /* Indicates whether the Processor is valid, invalid, or still in the process of validating (i.e., it is unknown whether or not the Processor is valid) */
  validationStatus: Option[ReportingTaskDTOEnums.ValidationStatus] = None,
  /* The number of active threads for the reporting task. */
  activeThreadCount: Option[Int] = None,
  /* Whether the underlying extension is missing. */
  extensionMissing: Option[Boolean] = None
) extends ApiModel

object ReportingTaskDTOEnums {

  type State = State.Value
  type ValidationStatus = ValidationStatus.Value
  object State extends Enumeration {
    val RUNNING = Value("RUNNING")
    val STOPPED = Value("STOPPED")
    val DISABLED = Value("DISABLED")
  }

  object ValidationStatus extends Enumeration {
    val VALID = Value("VALID")
    val INVALID = Value("INVALID")
    val VALIDATING = Value("VALIDATING")
  }

}

