/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.spark.DynamicLogicExpression;
import org.apache.hadoop.hbase.spark.ExecutionRuleForUnitTesting;
import org.apache.hadoop.hbase.spark.RowKeyFilter;
import org.apache.hadoop.hbase.types.RawDouble;
import org.apache.hadoop.hbase.types.RawFloat;
import org.apache.hadoop.hbase.types.RawInteger;
import org.apache.hadoop.hbase.types.RawLong;
import org.apache.hadoop.hbase.types.RawString;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.apache.spark.sql.datasources.hbase.Field;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Predef$;
import scala.collection.immutable.StringOps;

@InterfaceAudience.Private
public final class DefaultSourceStaticUtils$ {
    public static final DefaultSourceStaticUtils$ MODULE$;
    private final RawInteger rawInteger;
    private final RawLong rawLong;
    private final RawFloat rawFloat;
    private final RawDouble rawDouble;
    private final RawString rawString;
    private final ThreadLocal<PositionedByteRange> byteRange;
    private final ConcurrentLinkedQueue<ExecutionRuleForUnitTesting> lastFiveExecutionRules;

    static {
        new DefaultSourceStaticUtils$();
    }

    public RawInteger rawInteger() {
        return this.rawInteger;
    }

    public RawLong rawLong() {
        return this.rawLong;
    }

    public RawFloat rawFloat() {
        return this.rawFloat;
    }

    public RawDouble rawDouble() {
        return this.rawDouble;
    }

    public RawString rawString() {
        return this.rawString;
    }

    public ThreadLocal<PositionedByteRange> byteRange() {
        return this.byteRange;
    }

    public PositionedByteRange getFreshByteRange(byte[] bytes) {
        return this.getFreshByteRange(bytes, 0, bytes.length);
    }

    public PositionedByteRange getFreshByteRange(byte[] bytes, int offset, int length2) {
        return this.byteRange().get().set(bytes).setLength(length2).setOffset(offset);
    }

    public int getFreshByteRange$default$2() {
        return 0;
    }

    public ConcurrentLinkedQueue<ExecutionRuleForUnitTesting> lastFiveExecutionRules() {
        return this.lastFiveExecutionRules;
    }

    public void populateLatestExecutionRules(RowKeyFilter rowKeyFilter, DynamicLogicExpression dynamicLogicExpression) {
        this.lastFiveExecutionRules().add(new ExecutionRuleForUnitTesting(rowKeyFilter, dynamicLogicExpression));
        while (this.lastFiveExecutionRules().size() > 5) {
            this.lastFiveExecutionRules().poll();
        }
    }

    public Object getValue(Field field, Result r) {
        Integer n;
        if (field.isRowKey()) {
            byte[] row = r.getRow();
            DataType dataType = field.dt();
            Object object = IntegerType$.MODULE$.equals(dataType) ? this.rawInteger().decode(this.getFreshByteRange(row)) : (LongType$.MODULE$.equals(dataType) ? this.rawLong().decode(this.getFreshByteRange(row)) : (FloatType$.MODULE$.equals(dataType) ? this.rawFloat().decode(this.getFreshByteRange(row)) : (DoubleType$.MODULE$.equals(dataType) ? this.rawDouble().decode(this.getFreshByteRange(row)) : (StringType$.MODULE$.equals(dataType) ? this.rawString().decode(this.getFreshByteRange(row)) : (TimestampType$.MODULE$.equals(dataType) ? this.rawLong().decode(this.getFreshByteRange(row)) : Bytes.toString((byte[])row))))));
            n = object;
        } else {
            Cell cellByteValue = r.getColumnLatestCell(field.cfBytes(), field.colBytes());
            if (cellByteValue == null) {
                n = null;
            } else {
                DataType dataType = field.dt();
                Object object = IntegerType$.MODULE$.equals(dataType) ? this.rawInteger().decode(this.getFreshByteRange(cellByteValue.getValueArray(), cellByteValue.getValueOffset(), cellByteValue.getValueLength())) : (LongType$.MODULE$.equals(dataType) ? this.rawLong().decode(this.getFreshByteRange(cellByteValue.getValueArray(), cellByteValue.getValueOffset(), cellByteValue.getValueLength())) : (FloatType$.MODULE$.equals(dataType) ? this.rawFloat().decode(this.getFreshByteRange(cellByteValue.getValueArray(), cellByteValue.getValueOffset(), cellByteValue.getValueLength())) : (DoubleType$.MODULE$.equals(dataType) ? this.rawDouble().decode(this.getFreshByteRange(cellByteValue.getValueArray(), cellByteValue.getValueOffset(), cellByteValue.getValueLength())) : (StringType$.MODULE$.equals(dataType) ? Bytes.toString((byte[])cellByteValue.getValueArray(), (int)cellByteValue.getValueOffset(), (int)cellByteValue.getValueLength()) : (TimestampType$.MODULE$.equals(dataType) ? this.rawLong().decode(this.getFreshByteRange(cellByteValue.getValueArray(), cellByteValue.getValueOffset(), cellByteValue.getValueLength())) : Bytes.toString((byte[])cellByteValue.getValueArray(), (int)cellByteValue.getValueOffset(), (int)cellByteValue.getValueLength()))))));
                n = object;
            }
        }
        return n;
    }

    public byte[] getByteValue(Field field, String value) {
        byte[] byArray;
        DataType dataType = field.dt();
        if (IntegerType$.MODULE$.equals(dataType)) {
            byte[] result = new byte[4];
            PositionedByteRange localDataRange = this.getFreshByteRange(result);
            this.rawInteger().encode(localDataRange, Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(value)).toInt()));
            byArray = localDataRange.getBytes();
        } else if (LongType$.MODULE$.equals(dataType)) {
            byte[] result = new byte[8];
            PositionedByteRange localDataRange = this.getFreshByteRange(result);
            this.rawLong().encode(localDataRange, Predef$.MODULE$.long2Long(new StringOps(Predef$.MODULE$.augmentString(value)).toLong()));
            byArray = localDataRange.getBytes();
        } else if (FloatType$.MODULE$.equals(dataType)) {
            byte[] result = new byte[4];
            PositionedByteRange localDataRange = this.getFreshByteRange(result);
            this.rawFloat().encode(localDataRange, Predef$.MODULE$.float2Float(new StringOps(Predef$.MODULE$.augmentString(value)).toFloat()));
            byArray = localDataRange.getBytes();
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            byte[] result = new byte[8];
            PositionedByteRange localDataRange = this.getFreshByteRange(result);
            this.rawDouble().encode(localDataRange, Predef$.MODULE$.double2Double(new StringOps(Predef$.MODULE$.augmentString(value)).toDouble()));
            byArray = localDataRange.getBytes();
        } else if (StringType$.MODULE$.equals(dataType)) {
            byArray = Bytes.toBytes((String)value);
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            byte[] result = new byte[8];
            PositionedByteRange localDataRange = this.getFreshByteRange(result);
            this.rawLong().encode(localDataRange, Predef$.MODULE$.long2Long(new StringOps(Predef$.MODULE$.augmentString(value)).toLong()));
            byArray = localDataRange.getBytes();
        } else {
            byArray = Bytes.toBytes((String)value);
        }
        return byArray;
    }

    private DefaultSourceStaticUtils$() {
        MODULE$ = this;
        this.rawInteger = new RawInteger();
        this.rawLong = new RawLong();
        this.rawFloat = new RawFloat();
        this.rawDouble = new RawDouble();
        this.rawString = RawString.ASCENDING;
        this.byteRange = new ThreadLocal<PositionedByteRange>(){

            public PositionedByteRange initialValue() {
                SimplePositionedMutableByteRange range = new SimplePositionedMutableByteRange();
                range.setOffset(0);
                return range.setPosition(0);
            }
        };
        this.lastFiveExecutionRules = new ConcurrentLinkedQueue();
    }
}

