/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.spark.HBaseConnectionCacheStat;
import org.apache.hadoop.hbase.spark.HBaseConnectionKey;
import org.apache.hadoop.hbase.spark.SmartConnection;
import org.apache.hadoop.hbase.spark.SmartConnection$;
import org.apache.hadoop.hbase.spark.datasources.HBaseSparkConf$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;

public final class HBaseConnectionCache$
implements Logging {
    public static final HBaseConnectionCache$ MODULE$;
    private final HashMap<HBaseConnectionKey, SmartConnection> connectionMap;
    private final HBaseConnectionCacheStat cacheStat;
    private final long DEFAULT_TIME_OUT;
    private long org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout;
    private boolean org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed;
    private Thread housekeepingThread;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HBaseConnectionCache$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public HashMap<HBaseConnectionKey, SmartConnection> connectionMap() {
        return this.connectionMap;
    }

    public HBaseConnectionCacheStat cacheStat() {
        return this.cacheStat;
    }

    private final long DEFAULT_TIME_OUT() {
        return this.DEFAULT_TIME_OUT;
    }

    public long org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout() {
        return this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout;
    }

    private void org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout_$eq(long x$1) {
        this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout = x$1;
    }

    public boolean org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed() {
        return this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed;
    }

    private void org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed_$eq(boolean x$1) {
        this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed = x$1;
    }

    public Thread housekeepingThread() {
        return this.housekeepingThread;
    }

    public void housekeepingThread_$eq(Thread x$1) {
        this.housekeepingThread = x$1;
    }

    public HBaseConnectionCacheStat getStat() {
        HashMap<HBaseConnectionKey, SmartConnection> hashMap = this.connectionMap();
        synchronized (hashMap) {
            this.cacheStat().numActiveConnections_$eq(this.connectionMap().size());
            HBaseConnectionCacheStat hBaseConnectionCacheStat = this.cacheStat().copy(this.cacheStat().copy$default$1(), this.cacheStat().copy$default$2(), this.cacheStat().copy$default$3());
            return hBaseConnectionCacheStat;
        }
    }

    public void close() {
        try {
            HashMap<HBaseConnectionKey, SmartConnection> hashMap = this.connectionMap();
            synchronized (hashMap) {
                if (this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed()) {
                    return;
                }
                this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed_$eq(true);
                this.housekeepingThread().interrupt();
                this.housekeepingThread_$eq(null);
                this.performHousekeeping(true);
            }
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error in finalHouseKeeping";
                }
            }, exception);
        }
    }

    public void performHousekeeping(boolean forceClean) {
        long tsNow = System.currentTimeMillis();
        HashMap<HBaseConnectionKey, SmartConnection> hashMap = this.connectionMap();
        synchronized (hashMap) {
            this.connectionMap().foreach((Function1)new Serializable(forceClean, tsNow){
                public static final long serialVersionUID = 0L;
                private final boolean forceClean$1;
                private final long tsNow$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final Object apply(Tuple2<HBaseConnectionKey, SmartConnection> x) {
                    BoxedUnit boxedUnit;
                    if (((SmartConnection)x._2()).refCount() < 0) {
                        HBaseConnectionCache$.MODULE$.logError((Function0<String>)new Serializable(this, x){
                            public static final long serialVersionUID = 0L;
                            private final Tuple2 x$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bug to be fixed: negative refCount of connection ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x$1._2()}));
                            }
                            {
                                this.x$1 = x$1;
                            }
                        });
                    }
                    if (this.forceClean$1 || ((SmartConnection)x._2()).refCount() <= 0 && this.tsNow$1 - ((SmartConnection)x._2()).timestamp() > HBaseConnectionCache$.MODULE$.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout()) {
                        try {
                            ((SmartConnection)x._2()).connection().close();
                        }
                        catch (IOException iOException) {
                            HBaseConnectionCache$.MODULE$.logWarning((Function0<String>)new Serializable(this, x){
                                public static final long serialVersionUID = 0L;
                                private final Tuple2 x$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to close connection ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x$1._2()}));
                                }
                                {
                                    this.x$1 = x$1;
                                }
                            }, iOException);
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    boxedUnit = HBaseConnectionCache$.MODULE$.connectionMap().remove(x._1());
                    return boxedUnit;
                }
                {
                    this.forceClean$1 = forceClean$1;
                    this.tsNow$1 = tsNow$1;
                }
            });
            return;
        }
    }

    public SmartConnection getConnection(HBaseConnectionKey key, Function0<Connection> conn) {
        HashMap<HBaseConnectionKey, SmartConnection> hashMap = this.connectionMap();
        synchronized (hashMap) {
            if (this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed()) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var3_3
                return null;
            }
            this.cacheStat().numTotalRequests_$eq(this.cacheStat().numTotalRequests() + 1L);
            SmartConnection sc = (SmartConnection)this.connectionMap().getOrElseUpdate((Object)key, (Function0)new Serializable(conn){
                public static final long serialVersionUID = 0L;
                private final Function0 conn$1;

                public final SmartConnection apply() {
                    HBaseConnectionCache$.MODULE$.cacheStat().numActualConnectionsCreated_$eq(HBaseConnectionCache$.MODULE$.cacheStat().numActualConnectionsCreated() + 1L);
                    return new SmartConnection((Connection)this.conn$1.apply(), SmartConnection$.MODULE$.$lessinit$greater$default$2(), SmartConnection$.MODULE$.$lessinit$greater$default$3());
                }
                {
                    this.conn$1 = conn$1;
                }
            });
            sc.refCount_$eq(sc.refCount() + 1);
            SmartConnection smartConnection = sc;
            return smartConnection;
        }
    }

    public SmartConnection getConnection(Configuration conf) {
        return this.getConnection(new HBaseConnectionKey(conf), (Function0<Connection>)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final Connection apply() {
                return ConnectionFactory.createConnection((Configuration)this.conf$1);
            }
            {
                this.conf$1 = conf$1;
            }
        });
    }

    public void setTimeout(long to) {
        HashMap<HBaseConnectionKey, SmartConnection> hashMap = this.connectionMap();
        synchronized (hashMap) {
            if (this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed()) {
                return;
            }
            this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout_$eq(to);
            this.housekeepingThread().interrupt();
            return;
        }
    }

    private HBaseConnectionCache$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.connectionMap = new HashMap();
        this.cacheStat = new HBaseConnectionCacheStat(0L, 0L, 0L);
        this.DEFAULT_TIME_OUT = HBaseSparkConf$.MODULE$.DEFAULT_CONNECTION_CLOSE_DELAY();
        this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout = this.DEFAULT_TIME_OUT();
        this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed = false;
        this.housekeepingThread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(HBaseConnectionCache$.MODULE$.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (HBaseConnectionCache$.MODULE$.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed()) {
                        return;
                    }
                    HBaseConnectionCache$.MODULE$.performHousekeeping(false);
                }
            }
        });
        this.housekeepingThread().setDaemon(true);
        this.housekeepingThread().start();
    }
}

