/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.IdentityTableMapper;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.spark.HBaseConnectionCache$;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.spark.HBaseContext$$anonfun$bulkMutation$1$;
import org.apache.hadoop.hbase.spark.HBaseContext$$anonfun$bulkPut$1$;
import org.apache.hadoop.hbase.spark.LatestHBaseContextCache$;
import org.apache.hadoop.hbase.spark.NewHBaseRDD;
import org.apache.hadoop.hbase.spark.SmartConnection;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.spark.SerializableWritable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InterfaceAudience.Public
@ScalaSignature(bytes="\u0006\u0001\rMe\u0001B\u0001\u0003\u00015\u0011A\u0002\u0013\"bg\u0016\u001cuN\u001c;fqRT!a\u0001\u0003\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00151\u0011!\u00025cCN,'BA\u0004\t\u0003\u0019A\u0017\rZ8pa*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00159A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\u000e\u000e\u0003YQ!a\u0006\r\u0002\u0005%|'\"A\r\u0002\t)\fg/Y\u0005\u00037Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"!H\u0011\u000e\u0003yQ!a\b\u0011\u0002\u0011%tG/\u001a:oC2T!a\u0001\u0005\n\u0005\tr\"a\u0002'pO\u001eLgn\u001a\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u0005\u00111o\u0019\t\u0003M\u001dj\u0011\u0001I\u0005\u0003Q\u0001\u0012Ab\u00159be.\u001cuN\u001c;fqRD#a\t\u0016+\u0005-r\u0003CA\b-\u0013\ti\u0003CA\u0005ue\u0006t7/[3oi.\nq\u0006\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005!Q.\u001a;b\u0015\t!\u0004#\u0001\u0006b]:|G/\u0019;j_:L!AN\u0019\u0003\u000bA\f'/Y7\t\u0011a\u0002!Q1A\u0005\u0002e\naaY8oM&<W#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011\u0001B2p]\u001aL!a\u0010\u001f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011!\t\u0005A!A!\u0002\u0013Q\u0014aB2p]\u001aLw\r\t\u0005\t\u0007\u0002\u0011)\u0019!C\u0001\t\u0006\u0001B/\u001c9II\u001a\u001c8i\u001c8gO\u001aKG.Z\u000b\u0002\u000bB\u0011a)\u0013\b\u0003\u001f\u001dK!\u0001\u0013\t\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011BA\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006I!R\u0001\u0012i6\u0004\b\n\u001a4t\u0007>tgm\u001a$jY\u0016\u0004\u0003\"B(\u0001\t\u0003\u0001\u0016A\u0002\u001fj]&$h\b\u0006\u0003R'V;\u0006C\u0001*\u0001\u001b\u0005\u0011\u0001\"\u0002\u0013O\u0001\u0004)\u0003FA*+\u0011\u0015Ad\n1\u0001;Q\t)&\u0006C\u0004D\u001dB\u0005\t\u0019A#\t\u000fe\u0003\u0001\u0019!C\u0001s\u0005!B/\u001c9II\u001a\u001c8i\u001c8gS\u001e,(/\u0019;j_:Dqa\u0017\u0001A\u0002\u0013\u0005A,\u0001\ru[BDEMZ:D_:4\u0017nZ;sCRLwN\\0%KF$\"!\u00181\u0011\u0005=q\u0016BA0\u0011\u0005\u0011)f.\u001b;\t\u000f\u0005T\u0016\u0011!a\u0001u\u0005\u0019\u0001\u0010J\u0019\t\r\r\u0004\u0001\u0015)\u0003;\u0003U!X\u000e\u001d%eMN\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0002B#AY\u0016\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\u0006\u0011\u0012\r\u001d9mS\u0016$7I]3eK:$\u0018.\u00197t+\u0005A\u0007CA\bj\u0013\tQ\u0007CA\u0004C_>dW-\u00198\t\u000f1\u0004\u0001\u0019!C\u0001[\u00061\u0012\r\u001d9mS\u0016$7I]3eK:$\u0018.\u00197t?\u0012*\u0017\u000f\u0006\u0002^]\"9\u0011m[A\u0001\u0002\u0004A\u0007B\u00029\u0001A\u0003&\u0001.A\nbaBd\u0017.\u001a3De\u0016$WM\u001c;jC2\u001c\b\u0005\u000b\u0002pW!91\u000f\u0001b\u0001\n\u0003!\u0018a\u00016pEV\tQ\u000f\u0005\u0002ws6\tqO\u0003\u0002y\r\u0005IQ.\u00199sK\u0012,8-Z\u0005\u0003u^\u00141AS8c\u0011\u0019a\b\u0001)A\u0005k\u0006!!n\u001c2!Q\tY8\u0006\u0003\u0005\u0000\u0001\t\u0007I\u0011AA\u0001\u0003=\u0011'o\\1eG\u0006\u001cH/\u001a3D_:4WCAA\u0002!\u0019\t)!a\u0003\u0002\u00105\u0011\u0011q\u0001\u0006\u0004\u0003\u0013\u0001\u0013!\u00032s_\u0006$7-Y:u\u0013\u0011\ti!a\u0002\u0003\u0013\t\u0013x.\u00193dCN$\b\u0003\u0002\u0014\u0002\u0012iJ1!a\u0005!\u0005Q\u0019VM]5bY&T\u0018M\u00197f/JLG/\u00192mK\"A\u0011q\u0003\u0001!\u0002\u0013\t\u0019!\u0001\tce>\fGmY1ti\u0016$7i\u001c8gA!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0011\u0001\u00054pe\u0016\f7\r\u001b)beRLG/[8o+\u0011\ty\"a\r\u0015\u000bu\u000b\t#!\u0012\t\u0011\u0005\r\u0012\u0011\u0004a\u0001\u0003K\t1A\u001d3e!\u0019\t9#a\u000b\u000205\u0011\u0011\u0011\u0006\u0006\u0004\u0003G\u0001\u0013\u0002BA\u0017\u0003S\u00111A\u0015#E!\u0011\t\t$a\r\r\u0001\u0011A\u0011QGA\r\u0005\u0004\t9DA\u0001U#\u0011\tI$a\u0010\u0011\u0007=\tY$C\u0002\u0002>A\u0011qAT8uQ&tw\rE\u0002\u0010\u0003\u0003J1!a\u0011\u0011\u0005\r\te.\u001f\u0005\t\u0003\u000f\nI\u00021\u0001\u0002J\u0005\ta\r\u0005\u0005\u0010\u0003\u0017\ny%a\u001a^\u0013\r\ti\u0005\u0005\u0002\n\rVt7\r^5p]J\u0002b!!\u0015\u0002b\u0005=b\u0002BA*\u0003;rA!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033b\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\r\ty\u0006E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019'!\u001a\u0003\u0011%#XM]1u_JT1!a\u0018\u0011!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7\t\u000511\r\\5f]RLA!!\u001d\u0002l\tQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x\u0005iQ.\u00199QCJ$\u0018\u000e^5p]N,b!!\u001f\u0002\u001c\u0006\u0005ECBA>\u0003+\u000bi\n\u0006\u0003\u0002~\u0005\u0015\u0005CBA\u0014\u0003W\ty\b\u0005\u0003\u00022\u0005\u0005E\u0001CAB\u0003g\u0012\r!a\u000e\u0003\u0003IC!\"a\"\u0002t\u0005\u0005\t9AAE\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0003\u0017\u000b\t*a \u000e\u0005\u00055%bAAH!\u00059!/\u001a4mK\u000e$\u0018\u0002BAJ\u0003\u001b\u0013\u0001b\u00117bgN$\u0016m\u001a\u0005\t\u0003G\t\u0019\b1\u0001\u0002\u0018B1\u0011qEA\u0016\u00033\u0003B!!\r\u0002\u001c\u0012A\u0011QGA:\u0005\u0004\t9\u0004\u0003\u0005\u0002 \u0006M\u0004\u0019AAQ\u0003\ti\u0007\u000fE\u0005\u0010\u0003\u0017\n\u0019+a\u001a\u0002&B1\u0011\u0011KA1\u00033\u0003b!!\u0015\u0002b\u0005}\u0004bBAU\u0001\u0011\u0005\u00111V\u0001\bEVd7\u000eU;u+\u0011\ti+!.\u0015\u000fu\u000by+a.\u0002D\"A\u00111EAT\u0001\u0004\t\t\f\u0005\u0004\u0002(\u0005-\u00121\u0017\t\u0005\u0003c\t)\f\u0002\u0005\u00026\u0005\u001d&\u0019AA\u001c\u0011!\tI,a*A\u0002\u0005m\u0016!\u0003;bE2,g*Y7f!\u0011\ti,a0\u000e\u0003\u0011I1!!1\u0005\u0005%!\u0016M\u00197f\u001d\u0006lW\r\u0003\u0005\u0002H\u0005\u001d\u0006\u0019AAc!\u001dy\u0011qYAZ\u0003\u0017L1!!3\u0011\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002j\u00055\u0017\u0002BAh\u0003W\u00121\u0001U;u\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003+\f!\"\u00199qYf\u001c%/\u001a3t+\u0011\t9.!7\u0015\u0003u#\u0001\"!\u000e\u0002R\n\u0007\u0011q\u0007\u0005\b\u0003;\u0004A\u0011AAp\u0003)\u0011W\u000f\\6EK2,G/Z\u000b\u0005\u0003C\fI\u000fF\u0005^\u0003G\fY/!<\u0002x\"A\u00111EAn\u0001\u0004\t)\u000f\u0005\u0004\u0002(\u0005-\u0012q\u001d\t\u0005\u0003c\tI\u000f\u0002\u0005\u00026\u0005m'\u0019AA\u001c\u0011!\tI,a7A\u0002\u0005m\u0006\u0002CA$\u00037\u0004\r!a<\u0011\u000f=\t9-a:\u0002rB!\u0011\u0011NAz\u0013\u0011\t)0a\u001b\u0003\r\u0011+G.\u001a;f\u0011!\tI0a7A\u0002\u0005m\u0018!\u00032bi\u000eD7+\u001b>f!\u0011\tiPa\u0001\u000e\u0005\u0005}(b\u0001B\u00011\u0005!A.\u00198h\u0013\u0011\u0011)!a@\u0003\u000f%sG/Z4fe\"9!\u0011\u0002\u0001\u0005\n\t-\u0011\u0001\u00042vY.lU\u000f^1uS>tW\u0003\u0002B\u0007\u0005+!\u0012\"\u0018B\b\u0005/\u0011IBa\t\t\u0011\u0005\r\"q\u0001a\u0001\u0005#\u0001b!a\n\u0002,\tM\u0001\u0003BA\u0019\u0005+!\u0001\"!\u000e\u0003\b\t\u0007\u0011q\u0007\u0005\t\u0003s\u00139\u00011\u0001\u0002<\"A\u0011q\tB\u0004\u0001\u0004\u0011Y\u0002E\u0004\u0010\u0003\u000f\u0014\u0019B!\b\u0011\t\u0005%$qD\u0005\u0005\u0005C\tYG\u0001\u0005NkR\fG/[8o\u0011!\tIPa\u0002A\u0002\u0005m\bb\u0002B\u0014\u0001\u0011\u0005!\u0011F\u0001\bEVd7nR3u+\u0019\u0011YCa\u0012\u00034Qa!Q\u0006B\u001f\u0005\u007f\u0011\tE!\u0013\u0003VQ!!q\u0006B\u001c!\u0019\t9#a\u000b\u00032A!\u0011\u0011\u0007B\u001a\t!\u0011)D!\nC\u0002\u0005]\"!A+\t\u0015\te\"QEA\u0001\u0002\b\u0011Y$\u0001\u0006fm&$WM\\2fII\u0002b!a#\u0002\u0012\nE\u0002\u0002CA]\u0005K\u0001\r!a/\t\u0011\u0005e(Q\u0005a\u0001\u0003wD\u0001\"a\t\u0003&\u0001\u0007!1\t\t\u0007\u0003O\tYC!\u0012\u0011\t\u0005E\"q\t\u0003\t\u0003k\u0011)C1\u0001\u00028!A!1\nB\u0013\u0001\u0004\u0011i%A\u0004nC.,w)\u001a;\u0011\u000f=\t9M!\u0012\u0003PA!\u0011\u0011\u000eB)\u0013\u0011\u0011\u0019&a\u001b\u0003\u0007\u001d+G\u000f\u0003\u0005\u0003X\t\u0015\u0002\u0019\u0001B-\u00035\u0019wN\u001c<feR\u0014Vm];miB9q\"a2\u0003\\\tE\u0002\u0003BA5\u0005;JAAa\u0018\u0002l\t1!+Z:vYRDqAa\u0019\u0001\t\u0003\u0011)'\u0001\u0005iE\u0006\u001cXM\u0015#E+\u0011\u00119Ga\u001c\u0015\u0011\t%$q\u000fB=\u0005\u0007#BAa\u001b\u0003rA1\u0011qEA\u0016\u0005[\u0002B!!\r\u0003p\u0011A!Q\u0007B1\u0005\u0004\t9\u0004\u0003\u0006\u0003t\t\u0005\u0014\u0011!a\u0002\u0005k\n!\"\u001a<jI\u0016t7-\u001a\u00134!\u0019\tY)!%\u0003n!A\u0011\u0011\u0018B1\u0001\u0004\tY\f\u0003\u0005\u0003|\t\u0005\u0004\u0019\u0001B?\u0003\u0011\u00198-\u00198\u0011\t\u0005%$qP\u0005\u0005\u0005\u0003\u000bYG\u0001\u0003TG\u0006t\u0007\u0002CA$\u0005C\u0002\rA!\"\u0011\u000f=\t9Ma\"\u0003nA9qB!#\u0003\u000e\nm\u0013b\u0001BF!\t1A+\u001e9mKJ\u0002BAa$\u0003\u00146\u0011!\u0011\u0013\u0006\u0003/\u0011IAA!&\u0003\u0012\n1\u0012*\\7vi\u0006\u0014G.\u001a\"zi\u0016\u001cxK]5uC\ndW\rC\u0004\u0003d\u0001!\tA!'\u0015\r\tm%Q\u0014BP!\u0019\t9#a\u000b\u0003\b\"A\u0011\u0011\u0018BL\u0001\u0004\tY\f\u0003\u0005\u0003\"\n]\u0005\u0019\u0001B?\u0003\u0015\u00198-\u00198t\u0011\u001d\u0011)\u000b\u0001C\u0005\u0005O\u000bQ\u0003\u001b2bg\u00164uN]3bG\"\u0004\u0016M\u001d;ji&|g.\u0006\u0003\u0003*\n]FcB/\u0003,\n=&\u0011\u0018\u0005\t\u0005[\u0013\u0019\u000b1\u0001\u0002\u0004\u0005y1m\u001c8gS\u001e\u0014%o\\1eG\u0006\u001cH\u000f\u0003\u0005\u00032\n\r\u0006\u0019\u0001BZ\u0003\tIG\u000f\u0005\u0004\u0002R\u0005\u0005$Q\u0017\t\u0005\u0003c\u00119\f\u0002\u0005\u00026\t\r&\u0019AA\u001c\u0011!\t9Ea)A\u0002\tm\u0006\u0003C\b\u0002L\tM\u0016qM/\t\u000f\t}\u0006\u0001\"\u0003\u0003B\u00069q-\u001a;D_:4Gc\u0001\u001e\u0003D\"A!Q\u0016B_\u0001\u0004\t\u0019\u0001C\u0004\u0003H\u0002!\tA!3\u0002#!\u0014\u0017m]3NCB\u0004\u0016M\u001d;ji&|g.\u0006\u0004\u0003L\nm'\u0011\u001b\u000b\t\u0005\u001b\u0014\u0019N!6\u0003`B1\u0011\u0011KA1\u0005\u001f\u0004B!!\r\u0003R\u0012A!Q\u0007Bc\u0005\u0004\t9\u0004\u0003\u0005\u0003.\n\u0015\u0007\u0019AA\u0002\u0011!\u0011\tL!2A\u0002\t]\u0007CBA)\u0003C\u0012I\u000e\u0005\u0003\u00022\tmG\u0001\u0003Bo\u0005\u000b\u0014\r!a\u000e\u0003\u0003-C\u0001\"a(\u0003F\u0002\u0007!\u0011\u001d\t\n\u001f\u0005-#q[A4\u0005\u001b4aA!:\u0001\t\t\u001d(aD$fi6\u000b\u0007\u000fU1si&$\u0018n\u001c8\u0016\r\t%(Q\u001fB\u007f'\u0011\u0011\u0019O\u0004\u000b\t\u0017\u0005e&1\u001dB\u0001B\u0003%\u00111\u0018\u0005\f\u0003s\u0014\u0019O!A!\u0002\u0013\tY\u0010C\u0006\u0003L\t\r(\u0011!Q\u0001\n\tE\bcB\b\u0002H\nM(q\n\t\u0005\u0003c\u0011)\u0010\u0002\u0005\u00026\t\r(\u0019AA\u001c\u0011-\u00119Fa9\u0003\u0002\u0003\u0006IA!?\u0011\u000f=\t9Ma\u0017\u0003|B!\u0011\u0011\u0007B\u007f\t!\u0011)Da9C\u0002\u0005]\u0002bB(\u0003d\u0012\u00051\u0011\u0001\u000b\u000b\u0007\u0007\u00199a!\u0003\u0004\f\r5\u0001\u0003CB\u0003\u0005G\u0014\u0019Pa?\u000e\u0003\u0001A\u0001\"!/\u0003\u0000\u0002\u0007\u00111\u0018\u0005\t\u0003s\u0014y\u00101\u0001\u0002|\"A!1\nB\u0000\u0001\u0004\u0011\t\u0010\u0003\u0005\u0003X\t}\b\u0019\u0001B}\u0011)\u0019\tBa9C\u0002\u0013\u000511C\u0001\u0006i:\u000bW.Z\u000b\u0003\u0007+\u0001RaDB\f\u00077I1a!\u0007\u0011\u0005\u0015\t%O]1z!\ry1QD\u0005\u0004\u0007?\u0001\"\u0001\u0002\"zi\u0016D\u0011ba\t\u0003d\u0002\u0006Ia!\u0006\u0002\rQt\u0015-\\3!\u0011!\u00199Ca9\u0005\u0002\r%\u0012a\u0001:v]R111FB\u0017\u0007g\u0001b!!\u0015\u0002b\tm\b\u0002CB\u0018\u0007K\u0001\ra!\r\u0002\u0011%$XM]1u_J\u0004b!!\u0015\u0002b\tM\b\u0002CB\u001b\u0007K\u0001\r!a\u001a\u0002\u0015\r|gN\\3di&|g\u000eC\u0004\u0004:\u0001!\t!a6\u0002\u000b\rdwn]3\t\u0011\ru\u0002\u0001\"\u0001\u0003\u0007\u007f\tABZ1lK\u000ec\u0017m]:UC\u001e,Ba!\u0011\u0004HU\u001111\t\t\u0007\u0003\u0017\u000b\tj!\u0012\u0011\t\u0005E2q\t\u0003\t\u0003k\u0019YD1\u0001\u00028!\u001a\u0001aa\u0013\u0011\t\r53\u0011\f\b\u0005\u0007\u001f\u001a)&\u0004\u0002\u0004R)\u001911\u000b\u0004\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]&!1qKB)\u0003EIe\u000e^3sM\u0006\u001cW-Q;eS\u0016t7-Z\u0005\u0005\u00077\u001aiF\u0001\u0004Qk\nd\u0017n\u0019\u0006\u0005\u0007/\u001a\tfB\u0005\u0004b\t\t\t\u0011#\u0001\u0004d\u0005a\u0001JQ1tK\u000e{g\u000e^3yiB\u0019!k!\u001a\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0007O\u001aRa!\u001a\u000f\u0007S\u00022aDB6\u0013\tY\u0002\u0003C\u0004P\u0007K\"\taa\u001c\u0015\u0005\r\r\u0004BCB:\u0007K\n\n\u0011\"\u0001\u0004v\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"aa\u001e+\u0007\u0015\u001bIh\u000b\u0002\u0004|A!1QPBB\u001b\t\u0019yHC\u0002\u0004\u0002N\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\n\t\r\u00155q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCBE\u0007K\n\t\u0011\"\u0003\u0004\f\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019i\t\u0005\u0003\u0002~\u000e=\u0015\u0002BBI\u0003\u007f\u0014aa\u00142kK\u000e$\b")
public class HBaseContext
implements Serializable,
Logging {
    private final transient SparkContext sc;
    private final Configuration config;
    private final String tmpHdfsConfgFile;
    private transient Configuration tmpHdfsConfiguration;
    private transient boolean appliedCredentials;
    private final transient Job job;
    private final Broadcast<SerializableWritable<Configuration>> broadcastedConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String $lessinit$greater$default$3() {
        return HBaseContext$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Configuration config() {
        return this.config;
    }

    public String tmpHdfsConfgFile() {
        return this.tmpHdfsConfgFile;
    }

    public Configuration tmpHdfsConfiguration() {
        return this.tmpHdfsConfiguration;
    }

    public void tmpHdfsConfiguration_$eq(Configuration x$1) {
        this.tmpHdfsConfiguration = x$1;
    }

    public boolean appliedCredentials() {
        return this.appliedCredentials;
    }

    public void appliedCredentials_$eq(boolean x$1) {
        this.appliedCredentials = x$1;
    }

    public Job job() {
        return this.job;
    }

    public Broadcast<SerializableWritable<Configuration>> broadcastedConf() {
        return this.broadcastedConf;
    }

    public <T> void foreachPartition(RDD<T> rdd, Function2<Iterator<T>, Connection, BoxedUnit> f) {
        rdd.foreachPartition((Function1)new scala.Serializable(this, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseContext $outer;
            private final Function2 f$1;

            public final void apply(Iterator<T> it) {
                this.$outer.org$apache$hadoop$hbase$spark$HBaseContext$$hbaseForeachPartition(this.$outer.broadcastedConf(), it, this.f$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        });
    }

    public <T, R> RDD<R> mapPartitions(RDD<T> rdd, Function2<Iterator<T>, Connection, Iterator<R>> mp, ClassTag<R> evidence$1) {
        return rdd.mapPartitions((Function1)new scala.Serializable(this, mp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseContext $outer;
            private final Function2 mp$1;

            public final Iterator<R> apply(Iterator<T> it) {
                return this.$outer.hbaseMapPartition(this.$outer.broadcastedConf(), it, this.mp$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mp$1 = mp$1;
            }
        }, rdd.mapPartitions$default$2(), evidence$1);
    }

    public <T> void bulkPut(RDD<T> rdd, TableName tableName, Function1<T, Put> f) {
        byte[] tName = tableName.getName();
        rdd.foreachPartition((Function1)new scala.Serializable(this, f, tName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseContext $outer;
            public final Function1 f$2;
            public final byte[] tName$1;

            public final void apply(Iterator<T> it) {
                this.$outer.org$apache$hadoop$hbase$spark$HBaseContext$$hbaseForeachPartition(this.$outer.broadcastedConf(), it, new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$bulkPut$1 $outer;

                    public final void apply(Iterator<T> iterator, Connection connection) {
                        BufferedMutator m = connection.getBufferedMutator(TableName.valueOf((byte[])this.$outer.tName$1));
                        iterator.foreach((Function1)new scala.Serializable(this, m){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$bulkPut$1$$anonfun$apply$1 $outer;
                            private final BufferedMutator m$1;

                            public final void apply(T T) {
                                this.m$1.mutate((Mutation)this.$outer.org$apache$hadoop$hbase$spark$HBaseContext$$anonfun$$anonfun$$$outer().f$2.apply(T));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.m$1 = m$1;
                            }
                        });
                        m.flush();
                        m.close();
                    }

                    public /* synthetic */ $anonfun$bulkPut$1 org$apache$hadoop$hbase$spark$HBaseContext$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$2 = f$2;
                this.tName$1 = tName$1;
            }
        });
    }

    public <T> void applyCreds() {
        boolean close2 = Option$.MODULE$.apply((Object)System.getProperty("it.agilelab.bigdata.wasp.hbase.connection.close")).exists((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
            }
        });
        if (close2) {
            HBaseConnectionCache$.MODULE$.performHousekeeping(true);
        }
        String tokenInfo = (String)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(UserGroupInformation.getCurrentUser().getCredentials().getAllTokens()).asScala()).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TokenIdentifier apply(Token<? extends TokenIdentifier> x$2) {
                return x$2.decodeIdentifier();
            }
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TokenIdentifier x$3) {
                return x$3 instanceof AuthenticationTokenIdentifier;
            }
        })).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AuthenticationTokenIdentifier apply(TokenIdentifier x$4) {
                return (AuthenticationTokenIdentifier)x$4;
            }
        }, Iterable$.MODULE$.canBuildFrom())).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseContext $outer;

            public final String apply(AuthenticationTokenIdentifier tokenIdentifier) {
                return this.$outer.org$apache$hadoop$hbase$spark$HBaseContext$$stringifyToken$1(tokenIdentifier);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "NoTokenFound";
            }
        });
        this.logInfo((Function0<String>)new scala.Serializable(this, tokenInfo){
            public static final long serialVersionUID = 0L;
            private final String tokenInfo$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tokens -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenInfo$1}));
            }
            {
                this.tokenInfo$1 = tokenInfo$1;
            }
        });
    }

    public <T> void bulkDelete(RDD<T> rdd, TableName tableName, Function1<T, Delete> f, Integer batchSize) {
        this.bulkMutation(rdd, tableName, f, batchSize);
    }

    private <T> void bulkMutation(RDD<T> rdd, TableName tableName, Function1<T, Mutation> f, Integer batchSize) {
        byte[] tName = tableName.getName();
        rdd.foreachPartition((Function1)new scala.Serializable(this, f, batchSize, tName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseContext $outer;
            public final Function1 f$3;
            public final Integer batchSize$1;
            public final byte[] tName$2;

            public final void apply(Iterator<T> it) {
                this.$outer.org$apache$hadoop$hbase$spark$HBaseContext$$hbaseForeachPartition(this.$outer.broadcastedConf(), it, new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$bulkMutation$1 $outer;

                    public final void apply(Iterator<T> iterator, Connection connection) {
                        Table table = connection.getTable(TableName.valueOf((byte[])this.$outer.tName$2));
                        ArrayList<E> mutationList = new ArrayList<E>();
                        iterator.foreach((Function1)new scala.Serializable(this, table, mutationList){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$bulkMutation$1$$anonfun$apply$3 $outer;
                            private final Table table$1;
                            private final ArrayList mutationList$1;

                            public final void apply(T T) {
                                this.mutationList$1.add(this.$outer.org$apache$hadoop$hbase$spark$HBaseContext$$anonfun$$anonfun$$$outer().f$3.apply(T));
                                if (this.mutationList$1.size() >= Predef$.MODULE$.Integer2int(this.$outer.org$apache$hadoop$hbase$spark$HBaseContext$$anonfun$$anonfun$$$outer().batchSize$1)) {
                                    this.table$1.batch((java.util.List)this.mutationList$1, null);
                                    this.mutationList$1.clear();
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.table$1 = table$1;
                                this.mutationList$1 = mutationList$1;
                            }
                        });
                        if (mutationList.size() > 0) {
                            table.batch(mutationList, null);
                            mutationList.clear();
                        }
                        table.close();
                    }

                    public /* synthetic */ $anonfun$bulkMutation$1 org$apache$hadoop$hbase$spark$HBaseContext$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$3 = f$3;
                this.batchSize$1 = batchSize$1;
                this.tName$2 = tName$2;
            }
        });
    }

    public <T, U> RDD<U> bulkGet(TableName tableName, Integer batchSize, RDD<T> rdd, Function1<T, Get> makeGet, Function1<Result, U> convertResult, ClassTag<U> evidence$2) {
        GetMapPartition<T, U> getMapPartition = new GetMapPartition<T, U>(this, tableName, batchSize, makeGet, convertResult);
        return rdd.mapPartitions((Function1)new scala.Serializable(this, getMapPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseContext $outer;
            public final GetMapPartition getMapPartition$1;

            public final Iterator<U> apply(Iterator<T> it) {
                return this.$outer.hbaseMapPartition(this.$outer.broadcastedConf(), it, new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$bulkGet$1 $outer;

                    public final Iterator<U> apply(Iterator<T> iterator, Connection connection) {
                        return this.$outer.getMapPartition$1.run(iterator, connection);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.getMapPartition$1 = getMapPartition$1;
            }
        }, rdd.mapPartitions$default$2(), evidence$2);
    }

    public <U> RDD<U> hbaseRDD(TableName tableName, Scan scan, Function1<Tuple2<ImmutableBytesWritable, Result>, U> f, ClassTag<U> evidence$3) {
        Job job = Job.getInstance((Configuration)this.getConf(this.broadcastedConf()));
        TableMapReduceUtil.initCredentials((Job)job);
        TableMapReduceUtil.initTableMapperJob((TableName)tableName, (Scan)scan, IdentityTableMapper.class, null, null, (Job)job);
        JobConf jconf = new JobConf(job.getConfiguration());
        SparkHadoopUtil$.MODULE$.get().addCredentials(jconf);
        return new NewHBaseRDD<ImmutableBytesWritable, Result>(this.sc, TableInputFormat.class, ImmutableBytesWritable.class, Result.class, job.getConfiguration(), this).map(f, evidence$3);
    }

    public RDD<Tuple2<ImmutableBytesWritable, Result>> hbaseRDD(TableName tableName, Scan scans) {
        return this.hbaseRDD(tableName, scans, (Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ImmutableBytesWritable, Result> apply(Tuple2<ImmutableBytesWritable, Result> r) {
                return r;
            }
        }, (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <T> void org$apache$hadoop$hbase$spark$HBaseContext$$hbaseForeachPartition(Broadcast<SerializableWritable<Configuration>> configBroadcast, Iterator<T> it, Function2<Iterator<T>, Connection, BoxedUnit> f) {
        Configuration config = this.getConf(configBroadcast);
        this.applyCreds();
        SmartConnection smartConn = HBaseConnectionCache$.MODULE$.getConnection(config);
        f.apply(it, (Object)smartConn.connection());
        smartConn.close();
    }

    private Configuration getConf(Broadcast<SerializableWritable<Configuration>> configBroadcast) {
        if (this.tmpHdfsConfiguration() == null && this.tmpHdfsConfgFile() != null) {
            FileSystem fs = FileSystem.newInstance((Configuration)SparkHadoopUtil$.MODULE$.get().conf());
            FSDataInputStream inputStream = fs.open(new Path(this.tmpHdfsConfgFile()));
            this.tmpHdfsConfiguration_$eq(new Configuration(false));
            this.tmpHdfsConfiguration().readFields((DataInput)inputStream);
            inputStream.close();
        }
        if (this.tmpHdfsConfiguration() == null) {
            try {
                this.tmpHdfsConfiguration_$eq((Configuration)((SerializableWritable)configBroadcast.value()).value());
            }
            catch (Exception exception) {
                this.logError((Function0<String>)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Unable to getConfig from broadcast";
                    }
                }, exception);
            }
        }
        return this.tmpHdfsConfiguration();
    }

    public <K, U> Iterator<U> hbaseMapPartition(Broadcast<SerializableWritable<Configuration>> configBroadcast, Iterator<K> it, Function2<Iterator<K>, Connection, Iterator<U>> mp) {
        Configuration config = this.getConf(configBroadcast);
        this.applyCreds();
        SmartConnection smartConn = HBaseConnectionCache$.MODULE$.getConnection(config);
        Iterator res = (Iterator)mp.apply(it, (Object)smartConn.connection());
        smartConn.close();
        return res;
    }

    public void close() {
        HBaseConnectionCache$.MODULE$.close();
    }

    public <T> ClassTag<T> fakeClassTag() {
        return ClassTag$.MODULE$.AnyRef();
    }

    public final String org$apache$hadoop$hbase$spark$HBaseContext$$stringifyToken$1(AuthenticationTokenIdentifier tokenIdentifier) {
        return ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Username", (Object)tokenIdentifier.getUsername()), new Tuple2((Object)"SequenceNumber", (Object)BoxesRunTime.boxToLong((long)tokenIdentifier.getSequenceNumber())), new Tuple2((Object)"KeyId", (Object)BoxesRunTime.boxToInteger((int)tokenIdentifier.getKeyId())), new Tuple2((Object)"IssueDate", (Object)new Date(tokenIdentifier.getIssueDate())), new Tuple2((Object)"ExpirationDate", (Object)new Date(tokenIdentifier.getExpirationDate()))}))).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Object value = tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, value}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public HBaseContext(SparkContext sc, Configuration config, String tmpHdfsConfgFile) {
        this.sc = sc;
        this.config = config;
        this.tmpHdfsConfgFile = tmpHdfsConfgFile;
        Logging.class.$init$((Logging)this);
        this.tmpHdfsConfiguration = config;
        this.appliedCredentials = false;
        this.job = Job.getInstance((Configuration)config);
        this.broadcastedConf = sc.broadcast((Object)new SerializableWritable((Writable)config), ClassTag$.MODULE$.apply(SerializableWritable.class));
        LatestHBaseContextCache$.MODULE$.latest_$eq(this);
        if (tmpHdfsConfgFile != null && config != null) {
            Path tmpPath;
            FileSystem fs = FileSystem.newInstance((Configuration)config);
            if (fs.exists(tmpPath = new Path(tmpHdfsConfgFile))) {
                this.logWarning((Function0<String>)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseContext $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"tmpHdfsConfigDir ").append((Object)this.$outer.tmpHdfsConfgFile()).append((Object)" exist!!").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            } else {
                FSDataOutputStream outputStream = fs.create(tmpPath);
                config.write((DataOutput)outputStream);
                outputStream.close();
            }
        }
    }

    public class GetMapPartition<T, U>
    implements Serializable {
        private final Integer batchSize;
        private final Function1<T, Get> makeGet;
        private final Function1<Result, U> convertResult;
        private final byte[] tName;
        public final /* synthetic */ HBaseContext $outer;

        public byte[] tName() {
            return this.tName;
        }

        public Iterator<U> run(Iterator<T> iterator, Connection connection) {
            Table table = connection.getTable(TableName.valueOf((byte[])this.tName()));
            ArrayList<Object> gets = new ArrayList<Object>();
            Nil$ res = Nil$.MODULE$;
            while (iterator.hasNext()) {
                gets.add(this.makeGet.apply(iterator.next()));
                if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)gets.size()), (Object)this.batchSize)) continue;
                Result[] results = table.get(gets);
                res = (List)res.$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])results).map(this.convertResult, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), List$.MODULE$.canBuildFrom());
                gets.clear();
            }
            if (gets.size() > 0) {
                Result[] results = table.get(gets);
                res = (List)res.$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])results).map(this.convertResult, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), List$.MODULE$.canBuildFrom());
                gets.clear();
            }
            table.close();
            return res.iterator();
        }

        public /* synthetic */ HBaseContext org$apache$hadoop$hbase$spark$HBaseContext$GetMapPartition$$$outer() {
            return this.$outer;
        }

        public GetMapPartition(HBaseContext $outer, TableName tableName, Integer batchSize, Function1<T, Get> makeGet, Function1<Result, U> convertResult) {
            this.batchSize = batchSize;
            this.makeGet = makeGet;
            this.convertResult = convertResult;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.tName = tableName.getName();
        }
    }
}

